/**
 * Copyright (c) 2024 ASCON-Design Systems LLC. All rights reserved.
 * This sample is licensed under the MIT License.
 */

import { ITabs, ITabsBuilder, ObjectsViewContext } from '@pilotdev/pilot-web-sdk';

export const FileTabId = 'DocumentTabSample_FilesTab';

const filesIcon =
  'PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMjRweCIgdmlld0JveD0iMCAtOTYwIDk2MCA5NjAiIHdpZHRoPSIyNHB4IiBmaWxsPSIjNWY2MzY4Ij48cGF0aCBkPSJNNjAwLTQwcS0zMyAwLTU2LjUtMjMuNVQ1MjAtMTIwcTAtMjMgMTEtNDF0MjktMjl2LTIyMXEtMTgtMTEtMjktMjguNVQ1MjAtNDgwcTAtMzMgMjMuNS01Ni41VDYwMC01NjBxMzMgMCA1Ni41IDIzLjVUNjgwLTQ4MHEwIDIzLTExIDQwLjVUNjQwLTQxMXYxMTVsMTYwLTUzdi02MnEtMTgtMTEtMjktMjguNVQ3NjAtNDgwcTAtMzMgMjMuNS01Ni41VDg0MC01NjBxMzMgMCA1Ni41IDIzLjVUOTIwLTQ4MHEwIDIzLTExIDQwLjVUODgwLTQxMXYxMTlsLTI0MCA4MHYyMnExOCAxMSAyOSAyOXQxMSA0MXEwIDMzLTIzLjUgNTYuNVQ2MDAtNDBaTTE2MC0xNjB2LTU2MCA1NjBabTAgMHEtMzMgMC01Ni41LTIzLjVUODAtMjQwdi00ODBxMC0zMyAyMy41LTU2LjVUMTYwLTgwMGgyNDBsODAgODBoMzIwcTMzIDAgNTYuNSAyMy41VDg4MC02NDBINDQ3bC04MC04MEgxNjB2NDgwaDI4MHY4MEgxNjBaIi8+PC9zdmc+';

export class DocumentTabsExtensionSample implements ITabs<ObjectsViewContext> {
  build(builder: ITabsBuilder, context: ObjectsViewContext): void {
    if (context.selectedObjects[0].type.hasFiles)
      builder
        .addItem(FileTabId, 1)
        .withTitle('Files')
        .withIcon('file-tab', filesIcon)
        .withViewId(FileTabId);
  }
}
