﻿using System.Threading;
using System.Globalization;
using System.Windows.Controls;

namespace Ascon.Pilot.Bim.SDK.BottomPanelTabSample.Tools
{
    public class DoubleOnlyValidationRule : ValidationRule
    {
        public override ValidationResult Validate(object oValue, CultureInfo cultureInfo)
        {
            var value = oValue as string;

            if (string.IsNullOrEmpty(value))
                return ValidationResult.ValidResult;

            if (!IsValid(value))
                return new ValidationResult(false, "Not a double");

            return ValidationResult.ValidResult;
        }

        public static bool IsValid(string value)
        {
            return double.TryParse(value, NumberStyles.Number, Thread.CurrentThread.CurrentUICulture, out _);
        }
    }
}
