﻿/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;
using System.Linq;
using System.Threading;
using System.Windows.Threading;
using Ascon.Pilot.Bim.SDK.Model;
using Ascon.Pilot.Bim.SDK.ModelViewer;
using Ascon.Pilot.SDK;

namespace Ascon.Pilot.Bim.SDK.ModelListenerSample
{
    [Export(typeof(IDataPlugin))]
    public class ModelListenerSample : IDataPlugin
    {
        private PluginViewModel _pluginViewModel;

        [ImportingConstructor]
        public ModelListenerSample(IPilotServiceProvider pilotServiceProvider)
        {
            InitEvents(pilotServiceProvider);
            InitPlugin();
        }

        public void OnOpened(IModelViewer modelViewer)
        {
            _pluginViewModel.OnModelOpened(modelViewer);
        }

        public void OnLoaded(IModelViewer modelViewer)
        {
            _pluginViewModel.OnModelLoaded(modelViewer);
        }

        public void OnClosed(IModelViewer modelViewer)
        {
            _pluginViewModel.OnModelClosed(modelViewer);
        }

        private void InitEvents(IPilotServiceProvider pilotServiceProvider)
        {
            var modelManager = pilotServiceProvider.GetServices<IModelManager>().FirstOrDefault();

            if (modelManager == null)
                return;

            modelManager.ModelOpened += (sender, args) => OnOpened(args.Viewer);
            modelManager.ModelLoaded += (sender, args) => OnLoaded(args.Viewer);
            modelManager.ModelClosed += (sender, args) => OnClosed(args.Viewer);
        }

        private void InitPlugin()
        {
            var thread = new Thread(() =>
            {
                var pluginDispatcher = Dispatcher.CurrentDispatcher;
                _pluginViewModel = new PluginViewModel(pluginDispatcher);
                var pluginWindow = new PluginWindow(_pluginViewModel);
                pluginWindow.Closed += (s, e) =>
                {
                    pluginDispatcher.InvokeShutdown();
                    pluginDispatcher = null;
                };
                pluginWindow.Show();
                Dispatcher.Run();
            });
            thread.SetApartmentState(ApartmentState.STA);
            thread.IsBackground = true;
            thread.Start();
        }
    }
}
