﻿using System;
using System.Collections.ObjectModel;
using System.Windows.Threading;
using Ascon.Pilot.Bim.SDK.ModelViewer;

namespace Ascon.Pilot.Bim.SDK.ModelListenerSample
{
    public class PluginViewModel
    {
        private readonly Dispatcher _dispatcher;

        public PluginViewModel(Dispatcher dispatcher)
        {
            _dispatcher = dispatcher;
        }

        public ObservableCollection<string> Log { get; set; } = new ObservableCollection<string>();

        public void OnModelOpened(IModelViewer modelViewer)
        {
            _dispatcher.BeginInvoke((Action)(() =>
            {
                Log.Add(GetLogEntry("opened", modelViewer));
            }));
        }

        public void OnModelLoaded(IModelViewer modelViewer)
        {
            _dispatcher.BeginInvoke((Action)(() =>
            {
                Log.Add(GetLogEntry("loaded", modelViewer));
            }));
        }

        public void OnModelClosed(IModelViewer modelViewer)
        {
            _dispatcher.BeginInvoke((Action)(() =>
            {
                Log.Add(GetLogEntry("closed", modelViewer));
            }));
        }

        private string GetLogEntry(string eventName, IModelViewer modelViewer)
        {
            return $"Model {eventName}: {modelViewer.ModelId} (tab id: {modelViewer.TabId})";
        }
    }
}
