﻿/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;
using System.Threading;
using System.Windows.Threading;
using Ascon.Pilot.SDK;

namespace Ascon.Pilot.Bim.SDK.ModelStorageSample
{
    [Export(typeof(IDataPlugin))]
    public class ModelStorageSample : IDataPlugin
    {
        private readonly IPilotServiceProvider _pilotServiceProvider;
        private PluginViewModel _pluginViewModel;

        [ImportingConstructor]
        public ModelStorageSample(IPilotServiceProvider pilotServiceProvider)
        {
            _pilotServiceProvider = pilotServiceProvider;
            InitPlugin();
        }

        private void InitPlugin()
        {
            var thread = new Thread(() =>
            {
                var pluginDispatcher = Dispatcher.CurrentDispatcher;
                var pluginWindow = new PluginWindow();
                _pluginViewModel = new PluginViewModel(_pilotServiceProvider, pluginDispatcher, pluginWindow);
                pluginWindow.DataContext = _pluginViewModel;
                pluginWindow.Closed += (s, e) =>
                {
                    pluginDispatcher.InvokeShutdown();
                    pluginDispatcher = null;
                    _pluginViewModel.OnPluginWindowClosed();
                };
                pluginWindow.Show();
                Dispatcher.Run();
            });
            thread.SetApartmentState(ApartmentState.STA);
            thread.IsBackground = true;
            thread.Start();
        }
    }
}
