﻿using System;
using System.Globalization;
using System.Windows.Data;
using Ascon.Pilot.Bim.SDK.ModelViewerSample.Converters.Parameters;

namespace Ascon.Pilot.Bim.SDK.ModelViewerSample.Converters
{
    public class CameraCommandParametersConverter : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            var x = (string)values[0];
            var y = (string)values[1];
            var z = (string)values[2];
            var eyeX = (string)values[3];
            var eyeY = (string)values[4];
            var eyeZ = (string)values[5];
            var pivotX = (string)values[6];
            var pivotY = (string)values[7];
            var pivotZ = (string)values[8];
            var angle = (string)values[9];

            return new CameraCommandParameters(x, y, z, eyeX, eyeY, eyeZ, pivotX, pivotY, pivotZ, angle);
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
