﻿/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace Ascon.Pilot.Bim.SDK.RengaComAdapterSample
{
    public static class Adapter
    {
        private const string RENGA_MONIKER_DISPLAY_NAME = "RENGA";
        private const int SW_SHOW = 5;
        private const int SW_RESTORE = 9;

        [DllImport("ole32.dll")]
        private static extern void GetRunningObjectTable(int reserved, out IRunningObjectTable prot);

        [DllImport("ole32.dll")]
        private static extern int CreateBindCtx(uint reserved, out IBindCtx ppbc);

        [DllImport("user32.dll")]
        private static extern bool ShowWindowAsync(HandleRef hWnd, int nCmdShow);

        [DllImport("User32.dll")]
        private static extern bool SetForegroundWindow(IntPtr hWnd);

        [DllImport("User32.dll")]
        private static extern bool IsIconic(IntPtr handle);

        public static bool ShowObjectInRenga(Guid id)
        {
            var instances = GetRunningRengaInstances();

            foreach (var instance in instances)
            {
                var project = instance.Project;
                var model = project?.Model;

                if (model == null)
                    continue;

                var localId = model.GetIdFromUniqueId(id);

                if (localId <= 0)
                    continue;

                if (!(instance.ActiveView is Renga.IModelView modelView))
                    continue;

                BringRengaWindowToFront(instance);

                var ids = new[] { localId };
                modelView.SetObjectsVisibility(ids, true);
                modelView.ShowObjects(ids);
                instance.Selection.SetSelectedObjects(ids);

                return true;
            }

            return false;
        }

        private static IEnumerable<Renga.Application> GetRunningRengaInstances()
        {
            var instances = new List<Renga.Application>();

            GetRunningObjectTable(0, out var rot);

            if (rot == null)
                return instances;

            rot.EnumRunning(out var monikerEnumerator);

            if (monikerEnumerator == null)
                return instances;

            monikerEnumerator.Reset();

            var pNumFetched = new IntPtr();
            var monikers = new IMoniker[1];

            while (monikerEnumerator.Next(1, monikers, pNumFetched) == 0)
            {
                CreateBindCtx(0, out var bindCtx);

                if (bindCtx == null)
                    continue;

                monikers.First().GetDisplayName(bindCtx, null, out var displayName);

                if (!displayName.ToUpper().Contains(RENGA_MONIKER_DISPLAY_NAME))
                    continue;

                rot.GetObject(monikers.First(), out var comObject);

                if (comObject == null)
                    continue;

                try
                {
                    instances.Add((Renga.Application)comObject);
                }
                catch
                {
                    // ignored
                }
            }

            return instances;
        }

        private static void BringRengaWindowToFront(Renga.Application app)
        {
            var handle = new IntPtr(app.GetMainWindowHandle());
            ShowWindowAsync(new HandleRef(null, handle), IsIconic(handle) ? SW_RESTORE : SW_SHOW);
            SetForegroundWindow(handle);
        }
    }
}
