﻿using Ascon.Pilot.SDK;
using BcfApiService.DTOs;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System;

namespace BcfApiService.Services
{
    public class ProjectService : Service
    {
        public ProjectService(IObjectsRepository objectsRepository, ISearchService searchService) : base(objectsRepository, searchService) { }

        public async Task<IEnumerable<ProjectDTO>> GetProjects()
        {
            ISearchResult searchResult = await _objectIdsLoader.Load(_modelPartType.Id);

            if (!searchResult.Result.Any())
                return new List<ProjectDTO>();

            IEnumerable<ProjectDTO> resultList = (await Task.WhenAll(searchResult.Result
                .Select(async (modelPartId) => await _objectLoader.Load(modelPartId))))
                .OrderByDescending(modelPart => modelPart.Created)
                .Select(modelPart =>
                {
                    return new ProjectDTO
                    {
                        ProjectId = modelPart.Id.ToString().ToUpperInvariant(),
                        Name = modelPart.DisplayName,
                    };
                });

            return resultList;
        }

        public async Task<ProjectDTO> FindProjectById(Guid id)
        {
            ISearchResult searchResult = await _objectIdsLoader.Load(_modelPartType.Id);

            if (!searchResult.Result.Contains(id))
            {
                return null;
            }
            else
            {
                IDataObject modelPart = await _objectLoader.Load(id);
                return new ProjectDTO
                {
                    ProjectId = modelPart.Id.ToString().ToUpperInvariant(),
                    Name = modelPart.DisplayName,
                };
            }
        }
    }
}
