/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Windows;
using System.Windows.Input;

namespace Ascon.Pilot.SDK.BarcodeScannerSample
{
    /// <summary>
    /// Interaction logic for BarcodeScannerSettingsView.xaml
    /// </summary>
    public partial class BarcodeScannerSettingsView
    {
        public BarcodeScannerSettingsView()
        {
            InitializeComponent();
            Loaded += OnLoaded;
            Closed += OnClosed;
        }

        private void OnClosed(object sender, EventArgs eventArgs)
        {
            Closed -= OnClosed;
            var model = DataContext as BarcodeScannerSettingsModel;
            model.DisposeResources();
        }

        private void OnLoaded(object sender, RoutedEventArgs routedEventArgs)
        {
            var model = DataContext as BarcodeScannerSettingsModel;
            model.InitComPortsList();
            Loaded -= OnLoaded;
        }

        private void OnOkClick(object sender, RoutedEventArgs e)
        {
            var model = DataContext as BarcodeScannerSettingsModel;
            model.SaveSettings();
            Close();
        }

        private void OnCancelClick(object sender, RoutedEventArgs e)
        {
            Close();
        }
    }
}
