/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Ascon.Pilot.SDK.ClearCache;

namespace Ascon.Pilot.SDK.ClearCacheSample
{
    [Export(typeof(IClearCache))]
    public class ClearCacheProcedure : IClearCache
    {
        private int _filesOnDisk = 250;
        private volatile bool _isInProgress;
        public string Title => "TEST CLEAR CACHE PROCEDURE";

        public void GetInfo(ClearCacheInfo clearCacheInfo)
        {
            clearCacheInfo.FileCount = _filesOnDisk;
            clearCacheInfo.Size = _filesOnDisk * 100;
        }

        public void ExecuteClearCache()
        {
            _isInProgress = true;
            try
            {
                var initialFilesOnDisk = _filesOnDisk;
                var progress = 0;

                ClearCacheProgressChanged?.Invoke(this,
                    new ClearCacheProgressChangedEventArgs()
                    {
                        ProgressValue = progress,
                        ProgressTotal = initialFilesOnDisk
                    });
                
                while (_filesOnDisk > 0)
                {
                    if (!_isInProgress)
                        return;

                    //имитация выполнения работы по удалению файлов
                    Thread.Sleep(1000);
                    _filesOnDisk -= 50;
                    progress += 50;

                    //оповещение о прогрессе
                    ClearCacheProgressChanged?.Invoke(this,
                        new ClearCacheProgressChangedEventArgs()
                        {
                            ProgressValue = progress,
                            ProgressTotal = initialFilesOnDisk
                        });
                }
            }
            finally
            {
                _isInProgress = false;
            }

        }

        public void StopClearCache()
        {
            _isInProgress = false;
        }

        public event EventHandler<ClearCacheProgressChangedEventArgs> ClearCacheProgressChanged;
    }
}
