/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Globalization;
using System.Threading;
using System.Windows.Controls;

namespace Ascon.Pilot.SDK.Controls.ObjectCardView.ValidationRules
{
    public class DecimalOnlyValidationRule : ValidationRule
    {
        public override ValidationResult Validate(object oValue, CultureInfo cultureInfo)
        {
            var value = oValue as string;

            if (string.IsNullOrEmpty(value))
                return ValidationResult.ValidResult;

            if (!IsValid(value))
                return new ValidationResult(false, "Please input a correct decimal");

            return ValidationResult.ValidResult;
        }

        public static bool IsValid(string value)
        {
            return decimal.TryParse(value, NumberStyles.Number, Thread.CurrentThread.CurrentUICulture, out _);
        }
    }
}
