﻿using System.Globalization;
using System.Windows.Controls;

namespace Ascon.Pilot.SDK.Controls.ObjectCardView.ValidationRules
{
    public class PositiveIntegerValidationRule : ValidationRule
    {
        public override ValidationResult Validate(object value, CultureInfo cultureInfo)
        {
            if (value == null)
                return new ValidationResult(false, "Value cannot be null");

            if (!int.TryParse(value.ToString(), out var number))
                return new ValidationResult(false, "Value must be a valid integer");

            if (number < 0)
                return new ValidationResult(false, "Value must be positive");

            return ValidationResult.ValidResult;
        }
    }
}