/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel.Composition;
using System.Windows;

namespace Ascon.Pilot.SDK.CustomNotificationsSample
{
    [Export(typeof(IDataPlugin))]
    public class Receiver : IDataPlugin, IMessengerApi
    {
        private readonly IObjectsRepository _repository;

        [ImportingConstructor]
        public Receiver(IObjectsRepository repository)
        {
            _repository = repository;
            _repository.SubscribeCustomNotifications<IMessengerApi>(Const.NOTIFICATION_NAME, this);
        }

        public void Message(string author, string message, DateTime time)
        {
            Application.Current.Dispatcher.BeginInvoke(new Action(() =>
            {
                MessageBox.Show(message, $"Message from {author} at {time.ToLocalTime():G}");
            }));
        }
    }
}
