/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Windows;

namespace Ascon.Pilot.SDK.EventSample
{
    internal class EventSubscriber : IHandle<OpenTabEventArgs>,
        IHandle<CloseTabEventArgs>, IHandle<OfflineEventArgs>, IHandle<OnlineEventArgs>, 
        IHandle<UnloadedEventArgs>, IHandle<LoadedEventArgs>
    {
        private readonly IEventAggregator _eventAggregator;

        public EventSubscriber(IEventAggregator eventAggregator)
        {
            _eventAggregator = eventAggregator;
        }

        public void Handle(CloseTabEventArgs args)
        {
            if (args.TabTitle.Equals(Constants.PluginName, StringComparison.OrdinalIgnoreCase))
                MessageBox.Show("Handled close tab event", Constants.PluginName);
        }

        public void Handle(OfflineEventArgs args)
        {
            MessageBox.Show("Handled offline mode event", Constants.PluginName);
        }

        public void Handle(OnlineEventArgs args)
        {
            MessageBox.Show("Handled online mode event", Constants.PluginName);
        }

        public void Handle(OpenTabEventArgs args)
        {
            if (args.TabTitle.Equals(Constants.PluginName, StringComparison.OrdinalIgnoreCase))
                MessageBox.Show("Handled open tab event", Constants.PluginName);
        }

        public void Subscribe()
        {
            _eventAggregator.Subscribe(this);
        }

        public void Handle(UnloadedEventArgs message)
        {
            MessageBox.Show("Handled unloaded plugin event", Constants.PluginName);
        }

        public void Handle(LoadedEventArgs message)
        {
            MessageBox.Show("Handled loaded plugin event", Constants.PluginName);
        }
    }
}