/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel.Composition;
using System.IO;
using Ascon.Pilot.SDK.ObjectCard;

namespace Ascon.Pilot.SDK.FileAttachmentTracking
{
    /// <summary>
    /// File attachment event handler for tracking file additions
    /// </summary>
    [Export(typeof(IDocumentFileHandler))]
    public class DocumentFileHandler : IDocumentFileHandler
    {
        public bool OnAttached(string filePath, Guid objectId, ObjectCardContext context)
        {
            try
            {
                var fileName = Path.GetFileName(filePath);
                var objectType = context.Type?.Title ?? "Unknown type";
                var fileInfo = new FileInfo(filePath);
                var attachmentInfo = new FileAttachmentInfo
                {
                    FileName = fileName,
                    FilePath = filePath,
                    ObjectId = objectId,
                    ObjectType = objectType,
                    Extension = Path.GetExtension(filePath).ToUpperInvariant(),
                    AttachedTime = DateTime.Now,
                    FileSize = fileInfo.Exists ? fileInfo.Length : 0,
                    LastModified = fileInfo.Exists ? fileInfo.LastWriteTime : (DateTime?)null
                };

                FileAttachmentTrackingModule.AddFileInfo(attachmentInfo);

                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }
    }
}