/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;
using System.Windows.Threading;
using Ascon.Pilot.SDK.Controls;

namespace Ascon.Pilot.SDK.FileSnapshotSample
{
    class DocumentHistoryViewModel  : HistoryViewModel
    {
        public DocumentHistoryViewModel(Guid dataObjectId, IObjectsRepository repository, IObjectModifier modifier, Dispatcher dispatcher) 
            : base(dataObjectId, repository, modifier, dispatcher)
        {
        }

        public override string Title => "Document versions";

        protected override async void CreateVersion()
        {
            var filter = string.Empty;
            filter += "Supported files (*.xps;*.dwfx;*.pdf)|*.xps;*.dwfx;*.pdf|";
            filter += "XPS Documents (*.xps)|*.xps|";
            filter += "DWFx Documents (*.dwfx)|*.dwfx|";
            filter += "PDF Documents (*.pdf)|*.pdf";
            var title = "Open existing document";

            if (ShowOpenFileDialog(title, filter, false, null, out var filePaths) == true)
            {
                var filePath = filePaths[0];
                var loader = new ObjectLoader(_repository);
                var obj = await loader.Load(_dataObjectId);

                if (ShowReasonDialog(obj, out var reason) == false)
                    return;

                using (var stream = File.OpenRead(filePath))
                {
                    var name = Path.GetFileName(filePath);
                    _modifier.Edit(obj).CreateFileSnapshot(reason).AddFile(name, stream, DateTime.UtcNow, DateTime.UtcNow, DateTime.UtcNow);
                    _modifier.Apply();
                }
            }
        }
    }
}
