/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Windows.Threading;

namespace Ascon.Pilot.SDK.FileSnapshotSample
{
    class FileHistoryViewModel : HistoryViewModel
    {
        public FileHistoryViewModel(Guid dataObjectId, IObjectsRepository repository, IObjectModifier modifier, Dispatcher dispatcher) 
            : base(dataObjectId, repository, modifier, dispatcher)
        {
        }

        public override string Title
        {
            get { return "File versions"; }
        }

        protected override void CreateVersion()
        {
            var loader = new ObjectLoader(_repository);
            loader.Load(_dataObjectId, o =>
            {
                var ext = Path.GetExtension(o.DisplayName);
                var filter = string.Format("Supported files (*{0})|*{0}", ext);
                var title = "Open existing file";

                List<string> filePaths;
                if (ShowOpenFileDialog(title, filter, false, null, out filePaths) == true)
                {
                    var filePath = filePaths[0];
                    string reason;
                    if (ShowReasonDialog(o, out reason) == false)
                        return;

                    using (var stream = File.OpenRead(filePath))
                    {
                        var name = Path.GetFileName(filePath);
                        _modifier.Edit(o)
                            .CreateFileSnapshot(reason)
                            .AddFile(name, stream, DateTime.UtcNow, DateTime.UtcNow, DateTime.UtcNow);
                        _modifier.Apply();
                    }
                }
            });
        }
    }
}
