/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Threading.Tasks;

namespace Ascon.Pilot.SDK.LicenseSample
{
    public class LicenseInfoLoader : IObserver<ILicenseInfo>
    {
        private IDisposable _licenseInfoObserver;
        private TaskCompletionSource<ILicenseInfo> _taskCompletion;
        private readonly ILicenseManager _licenseManager;

        public LicenseInfoLoader(ILicenseManager licenseManager)
        {
            _licenseManager = licenseManager;
        }

        public Task<ILicenseInfo> LoadLicenseInfoAsync(int productId)
        {
            _taskCompletion = new TaskCompletionSource<ILicenseInfo>();
            _licenseInfoObserver = _licenseManager.LoadLicenseInfo(productId).Subscribe(this);
            return _taskCompletion.Task;
        }

        public void OnNext(ILicenseInfo licenseInfo)
        {
            _taskCompletion.TrySetResult(licenseInfo);
        }

        public void OnError(Exception error)
        {
            _taskCompletion.TrySetResult(null);
        }

        public void OnCompleted()
        {
            _licenseInfoObserver.Dispose();
        }
    }
}