/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Ascon.Pilot.SDK.Controls;

namespace Ascon.Pilot.SDK.ObjectsSample.NodeViewModel
{
    class TypeNodeViewModel : PropertyChangedBase, IObserver<IType>
    {
        private IType _type;
        private string _title;

        public TypeNodeViewModel(IType type, IObjectsRepository repository)
        {
            _type = type;
            _title = _type.Title;
            repository.SubscribeTypes().Subscribe(this);
        }

        public string Title
        {
            get => _title;
            set
            {
                _title = value;
                NotifyOfPropertyChange("Title");
            }
        }

        public void OnNext(IType value)
        {
            if (value.Id != _type.Id) 
                return;
            
            _type = value;
            Title = _type.Title;
        }

        public void OnError(Exception error)
        {
        }

        public void OnCompleted()
        {
        }
    }
}
