/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using Ascon.Pilot.SDK.Search;

namespace Ascon.Pilot.SDK.SearchSample
{
    class SearchResultsEventArgs : EventArgs
    {
        public SearchResultsEventArgs(SearchResultKind kind, List<Guid> ids, long total)
        {
            Kind = kind;
            Ids = ids;
            Total = total;
        }

        public SearchResultKind Kind { get; private set; }
        public List<Guid> Ids { get; private set; }
        public long Total { get; private set; }
    }

    class SearchResultsObserver : IObserver<ISearchResult>
    {
        public event EventHandler<SearchResultsEventArgs> SearchResultsLoaded;

        public void OnNext(ISearchResult value)
        {
            if (SearchResultsLoaded != null)
                SearchResultsLoaded(this, new SearchResultsEventArgs(value.Kind, value.Result.ToList(), value.Total));
        }

        public void OnError(Exception error)
        {
            throw new NotImplementedException();
        }

        public void OnCompleted()
        {
            throw new NotImplementedException();
        }
    }
}
