/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using Ascon.Pilot.SDK.Tabs;

namespace Ascon.Pilot.SDK.TabsExtensionSample
{
    [Export(typeof(ITabsExtension<DocumentExplorerDetailsTabsContext>))]
    public class DocumentExplorerTabsExtension : ITabsExtension<DocumentExplorerDetailsTabsContext>
    {
        private readonly IObjectsRepository _repository;
        private readonly Dictionary<Guid, FilesListView> _tabs = new Dictionary<Guid,FilesListView>();

        [ImportingConstructor]
        public DocumentExplorerTabsExtension(IObjectsRepository repository)
        {
            _repository = repository;
        }

        public void BuildTabs(ITabsBuilder builder, DocumentExplorerDetailsTabsContext context)
        {
            var sourceObject = context.SelectedObject;
            if(!sourceObject.Type.HasFiles)
                return;

            var view = new FilesListView
            {
                DataContext = new FilesListViewModel(sourceObject, context.SnapshotDateTime)
            };

            var tabId = Guid.NewGuid();
            _tabs.Add(tabId, view);

            builder.AddTab(tabId, "All Files", view);
        }

        public void OnIsActiveChanged(Guid tabId, bool isActive)
        {
            FilesListView view;
            if(!_tabs.TryGetValue(tabId, out view))
                return;
            
            view.Model.OnIsActiveChanged(isActive);
        }

        public void OnDisposed(Guid tabId)
        {
            FilesListView view;
            if (!_tabs.TryGetValue(tabId, out view))
                return;

            view.Model.Dispose();
            _tabs.Remove(tabId);
        }
    }
}
