/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.SDK.Controls.ObjectCardView;

namespace Ascon.Pilot.SDK.TaskSample.TaskEditView.ObjectCard
{
    class ExecutorCardControlViewModel : OrgUnitCardControlViewModel
    {
        public ExecutorCardControlViewModel(IAttribute attribute, IType type, object initValue, bool isReadOnly, 
            IPilotDialogService dialogService, IObjectsRepository repository, IObjectCardAutoComplete autoComplete, 
            IAttributeFormatParser attributeFormatParser, ITransitionManager transitionManager, bool editMode) 
            : base(attribute, type, initValue, isReadOnly, dialogService, repository, autoComplete, attributeFormatParser, transitionManager, editMode)
        {
        }

        protected override IPilotDialogOptions GetOrgUnitsSelectorDialogOptions()
        {
            return _dialogService.NewOptions()
                .WithParentWindow(GetActiveWindow())
                .WithCaption("Select executor")
                .WithOkButtonCaption("Select")
                .WithAllowMultiSelect(false);
        }
    }
}