/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.SDK.Controls.ObjectCardView;

namespace Ascon.Pilot.SDK.TaskSample.TaskEditView.ObjectCard
{
    sealed class TaskObjectCardViewModel : ObjectCardViewModel
    {
        public TaskObjectCardViewModel(IObjectsRepository repository, IPilotDialogService dialogService, IAttributeFormatParser attributeFormatParser, ITransitionManager transitionManager) 
            : base(repository, dialogService, attributeFormatParser, transitionManager)
        {
        }

        public override CardControlViewModel CreateCardControlViewModel(IAttribute attribute, IType type, object initValue, bool isEditMode, bool isReadOnlyAttribute)
        {
            switch (attribute.Type)
            {
                case AttributeType.OrgUnit:
                    if (attribute.Name == SystemTaskAttributes.EXECUTOR_POSITION)
                        return new ExecutorCardControlViewModel(attribute, type, initValue, isReadOnlyAttribute, _dialogService, _repository, this, _attributeFormatParser, _transitionManager, isEditMode);

                    return new OrgUnitCardControlViewModel(attribute, type, initValue, isReadOnlyAttribute, _dialogService, _repository, this, _attributeFormatParser, _transitionManager, isEditMode);

                default:
                    return new CardControlViewModel(attribute, type, initValue, isReadOnlyAttribute, _dialogService, _repository, this, _attributeFormatParser, _transitionManager, isEditMode);
            }
        }
    }
}
