/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Ascon.Pilot.SDK.Toolbar;
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;

namespace Ascon.Pilot.SDK.ToolbarSample
{
    [Export(typeof(IToolbar<DocumentAnnotationsListContext>))]
    public class DocumentAnnotationsListToolbar : IToolbar<DocumentAnnotationsListContext>
    {
        private const string MENU_ITEM_NAME = "miShowInfo";

        public void Build(IToolbarBuilder builder, DocumentAnnotationsListContext context)
        {
            builder.AddButtonItem(MENU_ITEM_NAME, 0)
                .WithHeader("Показать информацию");
        }

        public void OnToolbarItemClick(string name, DocumentAnnotationsListContext context)
        {
            if (name == MENU_ITEM_NAME)
            {
                MessageBox.Show($"Выбраны замечания: {string.Join(Environment.NewLine, context.SelectedAnnotations.Select(x => x.DisplayName))}");
            }
        }
    }
}
