/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Windows;
using Ascon.Pilot.SDK.Menu;
using Ascon.Pilot.SDK.Toolbar;

namespace Ascon.Pilot.SDK.ToolbarSample
{
    [Export(typeof(IToolbar<ObjectsViewContext>))]
    public class ObjectsToolbarSample : ToolbarItemSubmenuHandler, IToolbar<ObjectsViewContext>
    {
        public void Build(IToolbarBuilder builder, ObjectsViewContext context)
        {
            var count = builder.Count;
            var names = builder.ItemNames;
            if (names.Last() != "tbiSeparator")
            {
                builder.AddSeparator(count);
                count++;
            }

            builder.AddMenuButtonItem("tbsMenuButton", count)
                .WithMenu(this)
                .WithHeader("Menu button")
                .WithHint("Menu button");

            builder.AddButtonItem(ToolbarItemNames.BUTTON_NAME, ++count)
                .WithHeader("Count selected items")
                .WithIsEnabled(context.SelectedObjects.Any())
                .WithHint("Count selected items");

            var icon = IconLoader.GetIcon("icon.svg");
            builder.AddButtonItem(ToolbarItemNames.IMAGE_BUTTON_NAME, ++count)
                .WithHeader("Image button")
                .WithShowHeader(false)
                .WithIcon(icon)
                .WithHint("Image button");

            //Replace toolbar item and disable it
            if (context.SelectedObjects.Count() == 1)
            {
                builder.ReplaceButtonItem("miProperties").WithIsEnabled(false);
            }
        }

        public void OnToolbarItemClick(string name, ObjectsViewContext context)
        {
            if (name == ToolbarItemNames.MENU_ITEM_NAME1)
                MessageBox.Show(ToolbarItemNames.MENU_ITEM_NAME1 + " Clicked");
            if (name == ToolbarItemNames.MENU_ITEM_NAME2)
                MessageBox.Show(ToolbarItemNames.MENU_ITEM_NAME2 + " Clicked");
            if (name == ToolbarItemNames.SUBMENU_ITEM_NAME1)
                MessageBox.Show(ToolbarItemNames.SUBMENU_ITEM_NAME1 + " Clicked");
            if (name == ToolbarItemNames.BUTTON_NAME)
            {
                var selected = context.SelectedObjects.Count();
                MessageBox.Show("The number of selected elements " + selected);
            }
        }

        public override void OnSubmenuRequested(IToolbarBuilder builder)
        {
            builder.AddButtonItem(ToolbarItemNames.MENU_ITEM_NAME1, 0).WithHeader("Menu item 1");
            builder.AddButtonItem(ToolbarItemNames.MENU_ITEM_NAME2, 1).WithHeader("Menu item 2");
        }

        public void Build(IMenuBuilder builder, ObjectsViewContext context)
        {
            //Replace menu item and disable it
            if (context.SelectedObjects.Count() == 1)
            {
                builder.ReplaceItem("miProperties").WithIsEnabled(false);
            }
        }

        public void OnMenuItemClick(string name, ObjectsViewContext context)
        {
            
        }
    }

    [Export(typeof(IMenu<ObjectsViewContext>))]
    public class ContextMenu : IMenu<ObjectsViewContext>
    {
        public void Build(IMenuBuilder builder, ObjectsViewContext context)
        {
            //Replace menu item and disable it
            if (context.SelectedObjects.Count() == 1)
            {
                builder.ReplaceItem("miShowProperties").WithIsEnabled(false);
            }
        }

        public void OnMenuItemClick(string name, ObjectsViewContext context)
        {
        }
    }
}
