/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;

namespace Ascon.Pilot.SDK.WPFSample.Pages
{
    /// <summary>
    ///     Interaction logic for DataControls.xaml
    /// </summary>
    public partial class DataControls : UserControl
    {
        public DataControls()
        {
            InitializeComponent();
            Loaded += DataControlsLoaded;
        }

        public List<Project> Projects { get; private set; }

        private void DataControlsLoaded(object sender, RoutedEventArgs e)
        {
            Projects = new List<Project>();
            for (var i = 0; i < 5; i++)
            {
                Projects.Add(new Project
                {
                    Name = "Project #" + i,
                    IsVerifyed = i%2 == 0,
                    Created = DateTime.Now.AddDays(-i),
                    Subprojects = new List<Project>
                    {
                        new Project {Name = "Subproject"}
                    }
                });
            }
            DataContext = this;
        }
    }

    public class Project
    {
        public string Name { get; set; }
        public bool IsVerifyed { get; set; }
        public DateTime Created { get; set; }
        public List<Project> Subprojects { get; set; }
    }
}