/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Windows;
using System.Xml.Linq;

namespace Ascon.Pilot.SDK.XpsViewerSample
{
    public partial class EditDialogView
    {
        public EditDialogView()
        {
            InitializeComponent();
        }

        private void OnSaveButtonClicked(object sender, RoutedEventArgs e)
        {
            var viewModel = DataContext as EditDialogViewModel;
            try
            {
                XElement.Parse(viewModel.Text);
            }
            catch (System.Xml.XmlException)
            {
                MessageBox.Show(Properties.Resources.CannotParseXml);
                return;
            }
            DialogResult = true;
            Close();
        }

        private void OnCancelButtonClicked(object sender, RoutedEventArgs e)
        {
            DialogResult = false;
            Close();
        }
    }
}