﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Xml.Serialization;

namespace AttributeHistoryBot
{
    [XmlRoot("Rules")]
    public class Rules
    {
        [XmlElement("Rule")]
        public List<Rule> RulesList { get; set; } = new List<Rule>();
    }

    public class Rule
    {
        [XmlAttribute("Type")]
        public string Type { get; set; }

        [XmlIgnore]
        public List<string> Attributes { get; set; } = new List<string>();

        [XmlAttribute("Attrs")]
        public string AttributesCsv
        {
            get => string.Join(",", Attributes);
            set => Attributes = string.IsNullOrEmpty(value) 
                ? new List<string>() 
                : value.Split(',').ToList();
        }
    }

    public static class RulesSerializer
    {
        private static readonly XmlSerializer Serializer = new XmlSerializer(typeof(Rules));

        public static string Serialize(List<Rule> rules)
        {
            var rulesContainer = new Rules { RulesList = rules };
            using (var writer = new StringWriter())
            {
                Serializer.Serialize(writer, rulesContainer);
                return writer.ToString();
            }
        }

        public static List<Rule> Deserialize(string xml)
        {
            if (string.IsNullOrEmpty(xml))
                return new List<Rule>();

            using (var reader = new StringReader(xml))
            {
                var rulesContainer = (Rules)Serializer.Deserialize(reader);
                return rulesContainer?.RulesList ?? new List<Rule>();
            }
        }

        public static bool IsValid(string xml)
        {
            try
            {
                _ = Deserialize(xml);
                return true;
            }
            catch
            {
                return false;
            }
        }
    }
}