﻿using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Menu;
using Ascon.Pilot.SDK.Toolbar;
using BatchDigitalSigner.Properties;
using System.ComponentModel.Composition;
using System.Linq;

namespace BatchDigitalSigner
{
    [Export(typeof(IMenu<ObjectsViewContext>))]
    [Export(typeof(IToolbar<ObjectsViewContext>))]
    public class BatchDigitalSigner : IMenu<ObjectsViewContext>, IToolbar<ObjectsViewContext>
    {
        private const string COMMAND_NAME = "SignDocuments";
        private IObjectsRepository _repository;
        private IDigitalSigner _signer;
        private IFileProvider _fileProvider;

        [ImportingConstructor]
        public BatchDigitalSigner(IObjectsRepository repository, IDigitalSigner signer, IFileProvider fileProvider)
        {
            _repository = repository;
            _signer = signer;
            _fileProvider = fileProvider;
        }

        public void Build(IMenuBuilder builder, ObjectsViewContext context)
        {
            if (!CanAddCommand(context))
                return;

            var index = builder.Count - 3 >= 0 ? builder.Count - 3 : 0;
            builder.AddItem(COMMAND_NAME, index)
                   .WithHeader(Resources.SignDocumentsTitle)
                   .WithIcon(Icons.Instance.SignBatchDocs);
        }
        public void Build(IToolbarBuilder builder, ObjectsViewContext context)
        {
            if (!CanAddCommand(context))
                return;

            var index = builder.Count - 1 >= 0 ? builder.Count - 1 : 0;
            builder.AddButtonItem(COMMAND_NAME, index)
                  .WithHeader(Resources.SignDocumentsTitle)
                  .WithIcon(Icons.Instance.SignBatchDocs);
        }


        public void OnMenuItemClick(string name, ObjectsViewContext context)
        {
            RunSigning(context);
        }
        public void OnToolbarItemClick(string name, ObjectsViewContext context)
        {
            RunSigning(context);
        }
        private static bool CanAddCommand(ObjectsViewContext context)
        {
            if (context.IsContext || context.SelectedObjects == null || !context.SelectedObjects.Any())
                return false;

            if (!context.SelectedObjects.Any(x => x.ActualFileSnapshot.Files.Any()))
                return false;

            return true;
        }
        private void RunSigning(ObjectsViewContext context)
        {
            var certificate = _signer.GetCertificate();
            if (certificate == null)
                return;

            var positions = _repository.GetCurrentPerson().Positions.Select(p => p.Position).ToList();
            var model = new ProgressDialogModel(context.SelectedObjects.ToList(), _signer, _fileProvider, positions, certificate);
            model.Run();
        }

    }
}
