/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Collections.Generic;
using System.Linq;
using Ascon.Pilot.SDK;

namespace ChangeChildrenStateActivity
{
    public class AttributePermissionInfo
    {
        private const char ATTRIBUTE_NAME_MARKER = '&';
        public AttributePermissionInfo()
        {
            OrgUnits = new List<int>();
            OrgUnitAttributes = new List<string>();
        }

        public AttributePermissionInfo(IAttribute attribute)
        : this(attribute.EditableForPositionsSource())
        {
        }

        public AttributePermissionInfo(IEnumerable<string> editableForPositionsSource)
        : this()
        {
            if (editableForPositionsSource == null)
                return;

            foreach (var str in editableForPositionsSource)
            {
                if (str.Length > 0 && str[0] == ATTRIBUTE_NAME_MARKER)
                {
                    OrgUnitAttributes.Add(str.Substring(1));
                }
                else
                {
                    if (int.TryParse(str, out var orgUnit))
                    {
                        OrgUnits.Add(orgUnit);
                    }
                }
            }
        }

        public List<int> OrgUnits { get; }

        public List<string> OrgUnitAttributes { get; }

        public string[] PackToStringArray()
        {
            return OrgUnitAttributes.Select(x => $"{ATTRIBUTE_NAME_MARKER}{x}").Union(OrgUnits.Select(x => x.ToString())).ToArray();
        }

        public IEnumerable<int> ExtractAllOrgUnits(IDataObject obj)
        {
            return ExtractAllOrgUnits(obj.Attributes);
        }

        public IEnumerable<int> ExtractAllOrgUnits(IDictionary<string, object> attributes)
        {
            foreach (var orgUnit in OrgUnits)
            {
                yield return orgUnit;
            }

            if (OrgUnitAttributes == null || attributes == null)
                yield break;

            foreach (var permissionAttributeName in OrgUnitAttributes)
            {
                if (attributes.TryGetValue(permissionAttributeName, out var attr) && attr is int[] ints)
                {
                    foreach (var orgUnit in ints)
                    {
                        yield return orgUnit;
                    }
                }
            }
        }
    }
}
