/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Windows.Input;
using System.Windows.Media;
using Ascon.Pilot.SDK.Controls;
using Ascon.Pilot.SDK.Controls.Commands;
using Ascon.Pilot.Theme.Controls;

namespace ChangeFilesMonitor
{
    public class ToolbarButtonItem : PropertyChangedBase, IToolbarButtonItem
    {
        private string _name;
        private object _header;
        private object _hint;
        private ImageSource _icon;
        private ICommand _command;
        private object _commandParameter;
        private bool? _isEnabled = true;
        private bool _showCaption = true;

        public ToolbarButtonItem(string name)
        {
            Name = name;
        }

        public object Header
        {
            get => _header;
            set
            {
                _header = value;
                NotifyOfPropertyChange(nameof(Header));
            }
        }

        public object Hint
        {
            get => _hint;
            set
            {
                _hint = value;
                NotifyOfPropertyChange(nameof(Hint));
            }
        }

        public ImageSource Icon
        {
            get => _icon;
            set
            {
                _icon = value;
                NotifyOfPropertyChange(nameof(Icon));
            }
        }

        public ICommand Command
        {
            get => _command;
            set
            {
                _command = value;
                NotifyOfPropertyChange(nameof(Command));
            }
        }

        public object CommandParameter
        {
            get => _commandParameter;
            set
            {
                _commandParameter = value;
                NotifyOfPropertyChange(nameof(CommandParameter));
                var canExecute = Command as DelegateCommandBase;
                if (canExecute != null)
                    canExecute.RaiseCanExecuteChanged();
            }
        }

        public bool? IsEnabled
        {
            get => _isEnabled;
            private set
            {
                _isEnabled = value;
                NotifyOfPropertyChange(nameof(IsEnabled));
            }
        }

        public bool ShowCaption
        {
            get => _showCaption;
            private set
            {
                _showCaption = value;
                NotifyOfPropertyChange(nameof(ShowCaption));
            }
        }

        public string Name
        {
            get => _name;
            set
            {
                _name = value;
                NotifyOfPropertyChange(nameof(Name));
            }
        }
    }
}
