﻿using Ascon.Pilot.SDK;
using System;
using System.Security.Cryptography.X509Certificates;

namespace CryptoProvider.CryptoAPI
{
    internal class Certificate : ICertificate
    {

        public Certificate(X509Certificate2 certificate)
        {
            Thumbprint = certificate.Thumbprint;
            ValidFromDate = certificate.NotBefore;
            ValidToDate = certificate.NotAfter;
            Issuer = certificate.Issuer;
            Subject = certificate.Subject;
            PublicKeyOid = certificate.PublicKey.Oid.Value;
        }

        public string Thumbprint { get; }
        public DateTime ValidToDate { get; }
        public DateTime ValidFromDate { get; }
        public string Issuer { get; }
        public string Subject { get; }
        public string PublicKeyOid { get; }
}
}
