﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using PdfSharp.Fonts;

namespace PdfStamper.Resources
{
    internal class FontResolver : IFontResolver
    { 
        private const string RobotoRegularFontName = "Roboto#Regular";

        public byte[] GetFont(string faceName)
        {
            if (faceName != RobotoRegularFontName)
                throw new NotSupportedException($"Font '{faceName}' is not supported.");

            return EmbeddedResources.GetEmbeddedFont("Roboto-Regular.ttf");
        }

        public FontResolverInfo ResolveTypeface(string familyName, bool isBold, bool isItalic)
        {
            if (familyName.Equals(Constants.FONT_NAME, StringComparison.OrdinalIgnoreCase))
                return new FontResolverInfo(RobotoRegularFontName);

            return PlatformFontResolver.ResolveTypeface(familyName, isBold, isItalic);
        }
    }
}
