﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using PdfStamper.Models;

namespace PdfStamper.Serializing
{
    public class SettingsJsonConverter : JsonConverter<BaseSettingModel>
    {
        private static readonly JsonSerializer EmptySerializer = new JsonSerializer();

        public override void WriteJson(JsonWriter writer, BaseSettingModel value, JsonSerializer serializer)
        {
            var jo = JObject.FromObject(value, EmptySerializer);
            jo.WriteTo(writer);
        }

        public override BaseSettingModel ReadJson(JsonReader reader, Type objectType, BaseSettingModel existingValue, bool hasExistingValue, JsonSerializer serializer)
        {
            var jo = JObject.Load(reader);

            if (!jo.TryGetValue("SettingType", StringComparison.OrdinalIgnoreCase, out var typeProperty))
                throw new JsonException("Missing or invalid 'SettingType' property in BaseSettingModel JSON");
            
            var typePropertyValue = typeProperty.ToObject<SettingType>();

            BaseSettingModel result;
            switch (typePropertyValue)
            {
                case SettingType.Signature:
                    result = new SignatureSettingModel();
                    break;
                case SettingType.IntoProduction:
                    result = new IntoProductionSettingModel();
                    break;
                default:
                    throw new JsonException($"Unknown SettingType: {typePropertyValue}");
            }

            EmptySerializer.Populate(jo.CreateReader(), result);

            return result;
        }
    }
}