﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using PdfStamper.Models;

namespace PdfStamper.ViewModels
{
    public class IntoProductionSettingViewModel : BaseSettingViewModel
    {
        private readonly ISettingListener _settingListener;
        private string _productionRole;

        public IntoProductionSettingViewModel(ISettingListener settingListener, IntoProductionSettingModel model = null) : base(settingListener)
        {
            _settingListener = settingListener;

            if (model == null)
                SetDefaults();
            else
                FillWithData(model);
        }

        private void FillWithData(IntoProductionSettingModel model)
        {
            FillBaseWithData(model);
            _productionRole = model.ProductionRole;
        }

        private void SetDefaults()
        {
            var defaultModel = IntoProductionSettingModel.GetDefault();
            SetBaseDefaults(defaultModel);
            _productionRole = defaultModel.ProductionRole;
        }

        public string ProductionRole
        {
            get => _productionRole;
            set
            {
                _productionRole = value;
                NotifyOfPropertyChange(nameof(ProductionRole));
                _settingListener.OnSettingsChanged();
            }
        }

        public override string ToString()
        {
            return Properties.Resources.IntoProductionStampTabItemHeader;
        }
    }
}