/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Ascon.Pilot.SDK;
using DynamicData;

namespace ProjectCloneWizard.Data
{
    public interface IDataObjectService : IDisposable
    {
        IObservableCache<IDataObject, Guid> DataObjects { get; }
        void GetElementStructureAsync(Guid id, Action nothingLoaded, bool isAddParent = false);
        Task<IEnumerable<IDataObject>> GetElementStructureAsync(IDataObject parent);
        IType GetType(int typeId);
    }
}
