/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using System.Windows.Media;
using Ascon.Pilot.SDK.Controls.Commands;
using Ascon.Pilot.Theme.Controls;
using ProjectCloneWizard.ViewModels;

namespace ProjectCloneWizard.ObjectsTree
{
    public class ToolbarButtonItem : PropertyChangedBase, IToolbarButtonItem
    {
        private string _name;
        private object _header;

        private object _hint;
        private ImageSource _icon;
        private ICommand _command;
        private object _commandParameter;
        private bool? _isEnabled = true;
        private bool _showCaption = true;

        public ToolbarButtonItem(string name)
        {
            Name = name;
        }

        public object Header
        {
            get => _header;
            set
            {
                _header = value;
                NotifyOfPropertyChanged(() => Header);
            }
        }



        public object Hint
        {
            get { return _hint; }
            set
            {
                _hint = value;
                NotifyOfPropertyChanged(() => Hint);
            }
        }

        public ImageSource Icon
        {
            get => _icon;
            set
            {
                _icon = value;
                NotifyOfPropertyChanged(() => Icon);
            }
        }

        public ICommand Command
        {
            get => _command;
            set
            {
                _command = value;
                NotifyOfPropertyChanged(() => Command);
            }
        }

        public object CommandParameter
        {
            get => _commandParameter;
            set
            {
                _commandParameter = value;
                NotifyOfPropertyChanged(() => CommandParameter);
                if (Command is DelegateCommandBase canExecute)
                    canExecute.RaiseCanExecuteChanged();
            }
        }

        public bool? IsEnabled
        {
            get => _isEnabled;
            private set
            {
                _isEnabled = value;
                NotifyOfPropertyChanged(() => IsEnabled);
            }
        }

        public bool ShowCaption
        {
            get => _showCaption;
            private set
            {
                _showCaption = value;
                NotifyOfPropertyChanged(() => ShowCaption);
            }
        }

        public string Name
        {
            get => _name;
            set
            {
                _name = value;
                NotifyOfPropertyChanged(() => Name);
            }
        }
    }
}
