/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.SDK.Toolbar;
using Ascon.Pilot.Theme.Controls;

namespace ProjectCloneWizard.ObjectsTree
{
    public class ToolbarToggleButtonItem : ToolbarButtonItem, IToolbarToggleButtonItem
    {
        private bool _isChecked;
        public event EventHandler OnChecked;

        public ToolbarToggleButtonItem(string name) : base(name)
        {
        }

        public bool IsChecked
        {
            get { return _isChecked; }
            set
            {
                _isChecked = value;
                NotifyOfPropertyChanged(() => IsChecked);

                if (_isChecked && OnChecked != null)
                    OnChecked(this, EventArgs.Empty);
            }
        }
    }
}
