/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Controls.ObjectCardView;
using Ascon.Pilot.SDK.ObjectCard;
using DynamicData.Binding;
using ProjectCloneWizard.Common;
using ProjectCloneWizard.Wizard;
#pragma warning disable 67

namespace ProjectCloneWizard.ViewModels
{
    class ProjectCardPageViewModel : Ascon.Pilot.SDK.Controls.PropertyChangedBase, IWizardCaptionProvider, IWizardNavigationService
    {
        private readonly CreationInfo _creationInfo;
        private readonly IObjectCardControlProvider _cardControlProvider;
        private ObjectCardControl _cardControl;
        private bool _canGoNext;

        public ProjectCardPageViewModel(CreationInfo creationInfo, IObjectCardControlProvider cardControlProvider)
        {
            _creationInfo = creationInfo;
            _cardControlProvider = cardControlProvider;
        }

        public FrameworkElement View
        {
            get
            {
                return _cardControl?.View;
            }
        }

        public void LoadCard()
        {
            _cardControl = _cardControlProvider.GetObjectCardControl(_creationInfo.ObjectIdToShow, _creationInfo.Template.Type,
                _creationInfo.Parent.Id, new Dictionary<string, object>());
            _cardControl.Interaction.HideCreatedByInfo();
            _cardControl.Interaction.OnObjectCardUpdated += Interaction_OnObjectCardUpdated;

            UpdateState?.Invoke(this, EventArgs.Empty);
            InvalidateAttrs();
            NotifyOfPropertyChange("View");
        }

        private void Interaction_OnObjectCardUpdated(object sender, EventArgs e)
        {
            InvalidateAttrs();
            var attrs = new Dictionary<string, DValue>();
            foreach (var value in _cardControl.Interaction.GetValues())
            {
                attrs.Add(value.Key, DValue.GetDValue(value.Value.Value));  
            }

            _creationInfo.Attributes = attrs;
        }

        private void InvalidateAttrs()
        {
            var type = _creationInfo.Template.Type;
            var obligatoryAttrs = type.Attributes.Where(x => x.IsObligatory);
            var values = _cardControl.Interaction.GetValues();

            foreach (var obligatoryAttr in obligatoryAttrs)
            {
                if (!values.TryGetValue(obligatoryAttr.Name, out var value))
                {
                    _canGoNext = false;
                    UpdateState?.Invoke(this, EventArgs.Empty);
                    return;
                }
            }

            _canGoNext = true;
            UpdateState?.Invoke(this, EventArgs.Empty);
        }

        public string GetTitle()
        {
            return "Шаг 4 из 4. Заполните карточку нового элемента";
        }

        public string GetTemplateName()
        {
            return string.Empty;
        }

        public bool CanGoNext()
        {
            return _canGoNext;
        }

        public bool CanGoBack()
        {
            return true;
        }

        public string NextButtonCaption()
        {
            return "Создать";
        }

        public event EventHandler UpdateState;

        public event EventHandler NavigateNext;

        public void Cancel()
        {
            
        }

    }
}
