/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel;
using System.Linq.Expressions;

namespace ProjectCloneWizard.ViewModels
{
    public class PropertyChangedBase : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected void NotifyOfPropertyChanged<T>(Expression<Func<T>> propertyExpression)
        {
            this.NotifyOfPropertyChanged(propertyExpression, PropertyChanged);
        }
    }

    public static class PropertyExtensions
    {
        public static void NotifyOfPropertyChanged<T>(this INotifyPropertyChanged sender, Expression<Func<T>> propertyExpression, PropertyChangedEventHandler eventHandler)
        {
            if (eventHandler == null)
                return;

            var body = (MemberExpression)propertyExpression.Body;
            eventHandler(sender, new PropertyChangedEventArgs(body.Member.Name));
        }
    }
}
