/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Ascon.Pilot.SDK;
using ProjectCloneWizard.Common;
using ProjectCloneWizard.Data;
using ProjectCloneWizard.ObjectsTree;
using ProjectCloneWizard.Wizard;
#pragma warning disable 67

namespace ProjectCloneWizard.ViewModels
{
    class SelectProjectTemplatePageViewModel : IWizardCaptionProvider, IWizardNavigationService, IDisposable
    {
        private readonly CreationInfo _creationInfo;
        private readonly ObjectsTreeViewModel _objectsTreeViewModel;

        public SelectProjectTemplatePageViewModel(CreationInfo creationInfo, IDataObjectService dataObjectService)
        {
            _creationInfo = creationInfo;
            _objectsTreeViewModel = new ObjectsTreeViewModel(dataObjectService, false);
            _objectsTreeViewModel.SelectedItemChanged += OnSelectedItemChanged;
            _objectsTreeViewModel.ToolbarItemsSource.Add(new ToolbarButtonItem("CollapseAll")
            {
                Header = "Свернуть все",
                Icon = Icons.Instance.CollapseAllIcon,
                Command = _objectsTreeViewModel.CollapseAllCommand
            });
        }

        public ObjectsTreeViewModel ObjectsTreeViewModel => _objectsTreeViewModel;

        public void Load()
        {
            _objectsTreeViewModel.Load(SystemObjectIds.RootObjectId);
        }

        public string GetTitle()
        {
            return "Шаг 1 из 4. Выберите элемент для использования в качестве шаблона";
        }

        public string GetTemplateName()
        {
            return string.Empty;
        }

        public bool CanGoNext()
        {
            if (_objectsTreeViewModel.SelectedItem == null)
                return false;

            var parent = _creationInfo.Parent;
            var canGoNext = parent.Type.Children.Contains(_objectsTreeViewModel.SelectedItem.Type.Id);
            if (parent.Type.IsProject)
                canGoNext = parent.Type.Id == _objectsTreeViewModel.SelectedItem.Type.Id;
            return canGoNext;
        }

        public bool CanGoBack()
        {
            return false;
        }

        public string NextButtonCaption()
        {
            return null;
        }


        public event EventHandler UpdateState;
        public event EventHandler NavigateNext;

        private void OnSelectedItemChanged(object sender, EventArgs eventArgs)
        {
            UpdateState?.Invoke(this, EventArgs.Empty);
            _creationInfo.Template = _objectsTreeViewModel.SelectedItem?.Source;
        }

        public void Cancel()
        {
            
        }

        public void Dispose()
        {
            _objectsTreeViewModel?.Dispose();
        }
    }
}
