/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace ShowObjectsTree.DynamicData
{
    public class DataObject
    {
        public DataObject(Guid id, Guid parentId, string title, byte[] icon, int sort, IList<Guid> children)
        {
            Id = id;
            ParentId = parentId;
            Title = title;
            Icon = icon;
            Sort = sort;
            Children = new ReadOnlyCollection<Guid>(children);
        }

        public Guid Id { get; private set; }
        public Guid ParentId { get; private set; }
        public string Title { get; private set; }
        public byte[] Icon { get; private set; }
        public int Sort { get; private set; }
        public ReadOnlyCollection<Guid> Children { get; private set; }
    }
}