self.registry={"pages/server/server.html":{"title":"Pilot-Server SDK","content":"Общая информация\nPilot-Server SDK предназначен для создания автоматизаций и модулей расширений к Pilot-Server.","keywords":[]},"pages/server/extensions/extensions.html":{"title":"SDK для серверных модулей расширения","content":"Система расширений\nСистема расширений основана на стандартном механизме расширений приложений в.NET - Managed Extensibility Framework (MEF). SDK содержит ряд экспортируемых и импортируемых интерфейсов. К экспортируемым интерфейсам относятся интерфейсы, которые описывают тип расширения. К импортируемым интерфейсам относятся интерфейсы взаимодействия с клиентом и работы с данными.\nТребования\nДля создания серверных модулей расширения к Pilot-Server требуется один из следующих выпусков Visual Studio\nVisual Studio 2017 Professional Edition или старше\nСоздание и настройка проекта расширения\nЧтобы создать новое расширение для Pilot-Server выполните следующие действия:\nСоздайте проект типа Class Library (.NET Standard).\nВызовите диалог настройки проекта. В поле AssemblyName добавьте к названию сборки.servext Например PilotServerExtension.servext\nВызовите диалог редактирования информации о сборке. (Assembly Information…) Для этого нажмите на кнопку Assembly Information... и заполните необходимые поля.\nОбратите внимание\nОбязательно заполните поля Title, Product и Assembly version, т.к. Pilot-Server при загрузке вашего расширения будет искать информацию именно в этих полях.\nПодключите к проекту nuget пакеты System.ComponentModel.Composition и Ascon.Pilot.ServerExtensions.SDK.\nДля удобства отладки проекта серверного расширения, сборка может быть размещена в папке [path]\\Development, где [path] - это путь, по которому размещен исполняемый файл Pilot-Server, в данном случае установка серверного расширения через клиентское приложение не потребуется и расширение будет загружено при запуске Pilot-Server (папка Development по умолчанию отсутствует, ее необходимо создать).\nПодключение SDK к проекту расширения\nДля подключения SDK Pilot к проекту расширения можно воспользоваться встроенным в Visual Studio механизмом распространения пакетов - NuGet Packages Manager.\nДля того, чтобы подключить SDK с помощью Nuget Package Manager, выполните следующие шаги:\nВызовите Package Manager Console;\nВыполните команду:\nInstall-Package Ascon.Pilot.ServerExtensions.SDK\nЩелкните правой кнопкой мыши на проекте и вызовите команду Manage NuGet Packages;\nУстановите NuGet пакет Ascon.Pilot.ServerExtensions.SDK для вашего проекта.","keywords":[]},"pages/webserver/sborka/angular-nastroyka.html":{"title":"Настройка angular-расширения","content":"Чтобы создать angular-расширение, выполните следующие действия:\nСоздайте новый angular-проект командой:\nng new angular-ext\nВыполните команды в окружении проекта:\nnpm install @pilotdev/pilot-web-sdk\nnpm install @angular-architects/module-federation --save-dev\nесли произошла ошибка несовпадения версий зависимостей, то выполните команду:\nnpm config set legacy-peer-deps true\nСоздайте в корне проекта файл webpack.config.js с содержимым:\nconst ModuleFederationPlugin = require ( 'webpack/lib/container/ModuleFederationPlugin' ); module. exports = { output: { publicPath: 'auto', uniqueName: 'angular_ext', scriptType: 'text/javascript', }, optimization: { // fix a temporary bug runtimeChunk: false }, plugins: [ new ModuleFederationPlugin ({ name: 'angular_ext', library: { type: 'var', name: 'angular-ext' }, filename: '[name].js', exposes: { }, shared: { '@angular/core': { singleton: true, }, '@angular/common': { singleton: true, }, '@angular/forms': { singleton: true, }, '@pilotdev/pilot-web-sdk': { singleton: true, } } }) ]\n};\nи заполните поля uniqueName, name и library.name. Добавьте в секцию shared используемые библиотеки, чтобы их переиспользовать в хост-приложении. Подробнее: https://webpack.js.org/plugins/module-federation-plugin\nВыберите и установите пакет для кастомизации сборки angular-приложения. В примере будет показана установка c angular-builders/custom-webpack, но также можно выбрать и другие пакеты – например, ngx-build-plus.\nnpm install @angular-builders/custom-webpack --save-dev\nОткройте файл angular.json и найдите поле projects.angular-ext.architect.build.builder и замените его на @angular-builders/custom-webpack:browser а также удалите поле projects.angular-ext.architect.options.browser.\n{... \"sourceRoot\": \"src\", \"prefix\": \"app\", \"architect\": { \"build\": { + \"builder\": \"@angular-builders/custom-webpack:browser\", \"options\": { \"outputPath\": \"dist/angular-ext\", \"index\": \"src/index.html\", \"polyfills\": [ \"zone.js\" ],... }\nЗатем найдите блок projects.angular-ext.architect.build.options и добавьте поля customWebpackConfig и main:\n{ \"$schema\": \"./node_modules/@angular/cli/lib/config/schema.json\", \"version\": 1, \"newProjectRoot\": \"projects\", \"projects\": { \"angular-ext\": {... \"architect\": { \"build\": { \"builder\": \"@angular-builders/custom-webpack:browser\", \"options\": { \"outputPath\": \"dist/frontend\", \"index\": \"src/index.html\", + \"customWebpackConfig\": { + \"path\": \"webpack.config.js\" + }, + \"main\": \"src/main.ts\", \"polyfills\": [ \"zone.js\" ],... }\nЗамените поле projects.angular-ext.architect.serve.builder:\n{... \"defaultConfiguration\": \"production\" }, \"serve\": { + \"builder\": \"@angular-builders/custom-webpack:dev-server\", \"configurations\": { \"production\": { \"buildTarget\": \"angular-ext:build:production\" }, \"development\": { \"buildTarget\": \"angular-ext:build:development\" } }, \"defaultConfiguration\": \"development\"... }\nЗамените поле projects.angular-ext.architect.test.builder:\n{... \"options\": { \"buildTarget\": \"angular.sample:build\" } }, \"test\": { + \"builder\": \"@angular-builders/custom-webpack:karma\", \"options\": { \"polyfills\": [ \"zone.js\", \"zone.js/testing\" ], \"tsConfig\": \"tsconfig.spec.json\", \"assets\": [ \"src/favicon.ico\", \"src/assets\" ], \"styles\": [ \"src/styles.css\" ], \"scripts\": [] }... }\nПодробнее инструкцию настройки angular-builders/custom-webpack можно прочитать на https://www.npmjs.com/package/@angular-builders/custom-webpack\nВ файле angular.json найдите поле projects.angular-ext.architect.build.options.outputPath и замените его\n{... \"build\": { \"builder\": \"@angular-builders/custom-webpack:browser\", \"options\": { + \"outputPath\": \"dist/frontend\", \"index\": \"src/index.html\", \"customWebpackConfig\": { \"path\": \"webpack.config.js\" }, \"main\": \"src/main.ts\", \"polyfills\": [ \"zone.js\" ],... }\nСоздайте файл src\\config\\extensions.config.json с содержимым:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"angular_ext\", \"entry\": \"angular_ext.js\", \"modules\": [ ] } }\nи заполните поля author, license, title, version, name, a так же поле entry по шаблону [name].js, где [name] - значение поля name (например: angular_ext.js ). Значение поля name должно совпадать со значением name из webpack.config.js.\nИнтерактивные подсказки и валидация в IDE\nВ начале файла добавьте поле $schema со значением пути, указывающим на схему extensions.config.schema.json из пакета @pilotdev/pilot-web-sdk\n{ \"$schema\": \"../../../node_modules/@pilotdev/pilot-web-sdk/extensions.config.schema.json\",... }\nДобавьте в файл angular.json в блок projects.angular-ext.architect.build.options.assets запись о extensions.config.json:\n{... \"customWebpackConfig\": { \"path\": \"webpack.config.js\" }, \"main\": \"src/main.ts\", \"polyfills\": [ \"zone.js\" ], \"tsConfig\": \"tsconfig.app.json\", \"inlineStyleLanguage\": \"scss\", \"assets\": [ + { + \"glob\": \"extensions.config.json\", + \"input\": \"src/config\", + \"output\": \"./\" + } ],... }\nПример настроенного файла\nangular.json\n:\n{ \"$schema\": \"./node_modules/@angular/cli/lib/config/schema.json\", \"version\": 1, \"newProjectRoot\": \"projects\", \"projects\": { \"angular-ext\": { \"projectType\": \"application\", \"schematics\": { \"@schematics/angular:component\": { \"style\": \"scss\" } }, \"root\": \"\", \"sourceRoot\": \"src\", \"prefix\": \"app\", \"architect\": { \"build\": { \"builder\": \"@angular-builders/custom-webpack:browser\", \"options\": { \"outputPath\": \"dist/frontend\", \"index\": \"src/index.html\", \"customWebpackConfig\": { \"path\": \"webpack.config.js\" }, \"main\": \"src/main.ts\", \"polyfills\": [ \"zone.js\" ], \"tsConfig\": \"tsconfig.app.json\", \"inlineStyleLanguage\": \"scss\", \"assets\": [ { \"glob\": \"extensions.config.json\", \"input\": \"src/config\", \"output\": \"./\" } ], \"styles\": [ \"src/styles.scss\" ], \"scripts\": [ ] }, \"configurations\": { \"production\": { \"budgets\": [ { \"type\": \"initial\", \"maximumWarning\": \"500kb\", \"maximumError\": \"1mb\" }, { \"type\": \"anyComponentStyle\", \"maximumWarning\": \"2kb\", \"maximumError\": \"4kb\" } ], \"outputHashing\": \"all\" }, \"development\": { \"optimization\": false, \"extractLicenses\": false, \"sourceMap\": true } }, \"defaultConfiguration\": \"production\" }, \"serve\": { \"options\": { \"port\": 4300, \"publicHost\": \"http://localhost:4300\" }, \"builder\": \"@angular-builders/custom-webpack:dev-server\", \"configurations\": { \"production\": { \"buildTarget\": \"angular-ext:build:production\" }, \"development\": { \"buildTarget\": \"angular-ext:build:development\" } }, \"defaultConfiguration\": \"development\" }, \"extract-i18n\": { \"builder\": \"@angular-devkit/build-angular:extract-i18n\", \"options\": { \"buildTarget\": \"angular-ext:build\" } }, \"test\": { \"builder\": \"@angular-builders/custom-webpack:karma\", \"options\": { \"polyfills\": [ \"zone.js\", \"zone.js/testing\" ], \"tsConfig\": \"tsconfig.spec.json\", \"inlineStyleLanguage\": \"scss\", \"assets\": [ \"src/favicon.ico\", \"src/assets\" ], \"styles\": [ \"src/styles.scss\" ], \"scripts\": [ ] } } } } } }\nСоздайте файл extensionSample.ts, в котором будет содержаться логика расширения, например:\nimport { Inject, Injectable } from \"@angular/core\"; import { IMenu, IMenuBuilder, IObjectsRepository, ObjectsViewContext } from \"@pilotdev/pilot-web-sdk\" @Injectable ({ providedIn: \"root\" }) export class ExtensionSample implements IMenu < ObjectsViewContext > { constructor ( @Inject ( `IObjectsRepository` ) private _repository: IObjectsRepository ) { } build ( builder: IMenuBuilder, context: ObjectsViewContext ): void { builder. addItem ( \"SomeMenuItemName\", 1 ). withHeader ( \"Hello from angular extension\" ); } onMenuItemClick ( name: string, context: ObjectsViewContext ): void { alert ( `Angular extension works!` ); }\n}\nВ файлы webpack.config.js добавьте информацию о реализуемых интерфейсах из sdk в поле exposes конструктора плагина ModuleFederationPlugin в формате IMenu<ObjectsViewContext>:./src/app/extensionSample.ts:\nconst ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin'); module.exports = { output: { publicPath: 'auto', uniqueName: 'angular_ext', scriptType: 'text/javascript', }, optimization: { // fix a temporary bug runtimeChunk: false }, plugins: [ new ModuleFederationPlugin({ name: 'angular_ext', library: { type: 'var', name: 'angular_ext' }, filename: '[name].js', - exposes: {}, + exposes: { + 'IMenu<ObjectsViewContext>': './src/app/extensionSample.ts' //added + }, shared: { '@angular/core': { singleton: true, }, '@angular/common': { singleton: true, }, '@angular/forms': { singleton: true, }, '@pilotdev/pilot-web-sdk': { singleton: true, } } }) ] };\nТак же в файл extensions.config.json в блок extension.modules добавьте информацию о созданных классах в поля ngModuleName (имя класса) и exposedInterface (реализуемый интерфейс), например:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"angular_ext\", \"entry\": \"angular_ext.js\", - \"modules\": [], + \"modules\": [ + { \"ngModuleName\":\"ExtensionSample\", \"exposedInterface\":\"IMenu<ObjectsViewContext>\" } + ] } }\nВ файл main.ts добавьте запись о созданном файле через import, например:\nimport { bootstrapApplication } from '@angular/platform-browser'; import { appConfig } from './app/app.config'; import { AppComponent } from './app/app.component'; import * as ext from \"./app/extensionSample\" bootstrapApplication ( AppComponent, appConfig). catch ( ( err ) => console. error (err));","keywords":[]},"pages/webserver/interfaces/contexts/DocumentAnnotationsListContext.html":{"title":"DocumentAnnotationsListContext","content":"Используйте этот тип контекста для встраивания в Замечания к документу. Доступные для встраивания интерфейсы:\nКонтекстное меню ( IMenu )\nПанель инструментов ( IToolbar )\nimport { IMenu, IMenuBuilder, DocumentAnnotationsListContext } from \"@pilotdev/pilot-web-sdk\"; export class MenuSample extends IMenu < DocumentAnnotationsListContext > { build ( builder: IMenuBuilder, context: DocumentAnnotationsListContext ): void {... } onMenuItemClick ( name: string, context: DocumentAnnotationsListContext ): void {... }\n}","keywords":[]},"pages/server/extensions/IServerActivityContext.html":{"title":"Интерфейс IServerActivityContext","content":"Контекст запуска действия, позволяющий получить параметры запуска действия.\nDictionary<string, object> IServerActivityContext.Params { get; }\nСловарь параметров запуска действия, заданных в json скрипта автоматизации.\nList<string> IServerActivityContext.SourceTypes { get; }\nСписок типов, заданных в json скрипта автоматизации, для которых должно выполняться действие.\nTargetType? IServerActivityContext.Target { get; }\nОпределяет, должно ли действие быть применено к объекту-источнику события либо к связанным с ним объектам.\nRelationType? IServerActivityContext.RelationType { get; }\nОпределяет, к каким типам связанных объектов должно применяться действие (применимо только в случае IServerActivityContext.Target==TargetType.Relations).\nRelationFilterByChangeKind? IServerActivityContext.RelationFilterByChangeKind { get; } { get; }\nОпределяет, должно ли применяться действие ко всем связанным объектам, или же только к добавленным или удаленным.\nDictionary<string, string> IServerActivityContext.Errors { get; }\nСписок ошибок при разборе json действия.\nT GetService <T>() where T: class;\nПолучение дополнительных сервисов. В текущей версии доступно получение следующих сервисов:","keywords":[]},"pages/server/extensions/IServerActivity.html":{"title":"Интерфейс IServerActivity","content":"Данный интерфейс позволяет добавить новое действие, доступное в серверных скриптах автоматизаций.\nstring IServerActivity.Name { get; };\nИмя действия, используемое в скрипте автоматизации.\nTask IServerActivity. RunAsync (IModifierBase modifier, IModifierBackend backend, IServerActivityContext serverActivityContext, IAutomationEventContext automationEventContext);\nАсинхронный метод обработки запуска действия.\nгде:\nmodifier - модификатор, позволяющий вносить изменения в объекты;\nbackend - обеспечивает доступ к данным системы;\nserverActivityContext - контекст запуска действия, позволяющий получить параметры запуска действия;\nautomationEventContext - контекст события, позволяющий определить объект-источник события и другую дополнительную информацию.\nПример IServerActivity:\n[ Export ( typeof (IServerActivity))] public class SetLastWriteTimeActivity: IServerActivity\n{ public string Name => \"SetLastWriteTime\"; public Task RunAsync (IModifierBase modifier, IModifierBackend backend, IServerActivityContext serverActivityContext, IAutomationEventContext automationEventContext) { modifier. EditObject (automationEventContext.Source). SetAttribute ( \"LastWriteTime\", DateTime.UtcNow); return Task.CompletedTask; }\n}","keywords":[]},"pages/server/extensions/IAutomationNotifier.html":{"title":"Сервис IAutomationNotifier","content":"var notifier = serverActivityContext. GetService <IAutomationNotifier>();\nСервис IAutomationNotifier служит для отправки уведомлений пользователям.\nvoid Notify ( int personId, INObject obj, string message, string notificationName);\nгде:\npersonId - идентификатор пользователя, которому будет отправлено уведомление;\nobj - объект, по которому будет создано уведомление. При клике пользователем по всплывающему уведомлению будет осуществлен переход к данному объекту;\nmessage - текст сообщения уведомления;\nnotificationName - внутреннее имя канала уведомлений. Доступно для получения на стороне клиентского SDK обработки уведомлений;","keywords":[]},"pages/server/extensions/IAutomationFileProvider.html":{"title":"Сервис IAutomationFileProvider","content":"var fileHandler = serverActivityContext. GetService <IAutomationFileProvider>();\nСервис IAutomationFileProvider служит для получения файлов из файлового архива.\nМетод проверки существования файла в файловом архиве.\nbool Exists (Guid fileId);\nгде:\nfileId - идентификатор файла;\nАсинхронный метод открытия файла на чтение.\nTask<Stream> OpenReadAsync (Guid id);\nгде:\nfileId - идентификатор файла;","keywords":[]},"pages/server/extensions/IPositionChangedContext.html":{"title":"Интерфейс IPositionChangedContext","content":"Контекст записи об изменении/добавлении орагнизационной единицы\nEventKind EventKind { get; }\nТип события\nDateTime ServerDateTime { get; }\nСерверная дата записи изменения\nstring Login { get; }\nЛогин пользователя от имени которого произошло изменение\nstring IpAddress { get; }\nIP адрес ПК с котрого инициировалось изменение\nINOrganisationUnit IPositionChangedContext.Created { get; }\nСозданная организационная единица\nINOrganisationUnit IPositionChangedContext.Updated { get; }\nИзмененнная организационная единица","keywords":[]},"pages/server/extensions/IAutomationEventContext.html":{"title":"Интерфейс IAutomationEventContext","content":"Контекст события-триггера действия.\nINObject IAutomationEventContext.Source { get; }\nОбъект-источник события.\nIEnumerable<INChange> IAutomationEventContext.Changes { get; }\nНабор изменений, в результате которого сработал триггер. Включает в себя изменение по объекту-источнику события, если он был изменен.\nINPerson IAutomationEventContext.InitiatingPerson { get; }\nПользователь-инициатор события.\nDateTime IAutomationEventContext.EventDate { get; }\nВремя наступления события в формате UTC.","keywords":[]},"pages/server/extensions/IUserActionAppender.html":{"title":"Интерфейс IUserActionAppender","content":"Данный интерфейс позволяет добавить обработчик, добавляющий дополнительную информацию к записи журнала пользовательских действий\nstring ProcessEvent (IModifierBackend backend, IBaseEventContext context);\nМетод обработки новой записи журнала пользовательских действий\nгде:\nbackend - обеспечивает доступ к данным системы;\ncontext - контекст, дающий информацию о записи в журнал. Ниже перечислены возможные варианты контекстов.","keywords":[]},"pages/server/extensions/IPersonPositionChangedContext.html":{"title":"Интерфейс IPersonPositionChangedContext","content":"Контекст записи об изменении назначения или снятия пользователя с должности\nEventKind EventKind { get; }\nТип события\nDateTime ServerDateTime { get; }\nСерверная дата записи изменения\nstring Login { get; }\nЛогин пользователя от имени которого произошло изменение\nstring IpAddress { get; }\nIP адрес ПК с котрого инициировалось изменение\nINPersonOnPositionData IPersonPositionChangedContext.INPersonOnPositionData { get; }\nДанные об назначнии/ снятии пользователя с должности.","keywords":[]},"pages/server/extensions/IChangesetContext.html":{"title":"Интерфейс IChangesetContext","content":"Контекст записи об изменении объектов\nEventKind EventKind { get; }\nТип события.\nDateTime ServerDateTime { get; }\nСерверная дата записи изменения.\nstring Login { get; }\nЛогин пользователя, от имени которого произошло изменение.\nstring IpAddress { get; }\nIP адрес ПК, с котрого инициировалось изменение.\nGuid IChangesetContext.ObjectId { get; }\nИдентификатор объекта.\nIReadOnlyList<INChange> IChangesetContext.Changes { get; }\nИзменения, произведенные над объектом.\nstring IChangesetContext.ErrorString { get; }\nТекст ошибки, если изменение не было принято.","keywords":[]},"pages/server/extensions/IFileContext.html":{"title":"Интерфейс IFileContext","content":"Контекст файла\nEventKind EventKind { get; }\nТип события.\nDateTime ServerDateTime { get; }\nСерверная дата срабатывания события.\nstring Login { get; }\nЛогин пользователя.\nstring IpAddress { get; }\nIP адрес ПК пользователя.\nGuid ObjectId { get; }\nИдентификатор объекта.\nstring ObjectTitle { get; }\nОтображаемое наименование объекта.\nint TypeId { get; }\nИдентификатор типа.\nGuid FileId { get; }\nИдентификатор файла.\nint PersonId { get; }\nИдентификатор пользователя.","keywords":[]},"pages/client/ice/template/ITaskTemplateItem.html":{"title":"ITaskTemplateItem","content":"Этот интерфейс позволяет получить доступ к составляющим элементам шаблона задания или процесса.\nСвойства\nint TypeId { get; }\nИдентификатор типа элемента, который описывает данный элемент шаблона: это может быть идентификатор типа задания, типа этапа процесса или идентификатор типа процесса. Позволяет узнать, объект какого типа должен быть создан на основе этого элемента шаблона.\nIEnumerable<ITaskTemplateItem> Children { get; }\nСписок дочерних элементов шаблона. Шаблон обычного задания состоит только из одного элемента, его коллекция дочерних элементов всегда пуста. Шаблон процесса отличается тем, что его свойство Children содержит список элементов шаблона, описывающих этапы процесса. Каждый из элементов шаблона этапа в свою очередь содержит коллекцию дочерних элементов, которые описывают шаблоны заданий данного этапа. Метод MakeWorkflowFromTemplate примера Ascon.Pilot.SDK.TaskSample демонстрирует работу с шаблоном процесса и последовательным получением шаблонов этапов и шаблонов заданий каждого этапа.\nIDictionary< string, object > Attributes { get; }\nСписок атрибутов и их значений, которыми обладает элемент шаблона. Так, в нем могут хранится заголовок и описание задания или процесса, список исполнителей и аудиторов задания и т.д.\nIEnumerable<Guid> Attachments { get; }\nСписок идентификаторов объектов, которые являются вложениями данного элемента шаблона.","keywords":[]},"pages/client/ice/data/IChatMember.html":{"title":"Интерфейс IChatMember","content":"Интерфейс описывает данные участника чата.\nIChatMember.ChatId\nИдентификатор чата.\nGuid ChatId { get; }\nIChatMember.PersonId\nИдентификатор пользователя.\nint PersonId { get;}\nIChatMember.IsAdmin\nПризнак администратора чата.\nbool IsAdmin { get;}\nIChatMember.IsDeleted\nПризнак удаленного участника.\nbool IsDeleted { get; }\nIChatMember.IsNotifiable\nПризнак подписки на уведомления.\nbool IsNotifiable { get;}\nIChatMember.DateUpdatedUtc\nДата создания.\nDateTime DateUpdatedUtc { get; }\nIChatMember.IsViewerOnly\nПризнак пользователя, не являющегося участником чата, но просматривающего его.\nbool IsViewerOnly { get; }","keywords":[]},"pages/webserver/overview.html":{"title":"Pilot-Web-Server SDK","content":"Общая информация\nPilot-Web-Server SDK предназначен для создания frontend и backend модулей расширений к Pilot-Web-Server.\nРасширения для Pilot-Web-Server могут состоять из следующих компонентов:\nbackend-расширение (.NET)\nfrontend-расширение (angular, react, vue, js, ts)\nрасширения к компонентам Pilot-ComponentKit","keywords":[]},"pages/webserver/injection/injection-list.html":{"title":"Список инжектируемых интерфейсов","content":"IObjectsRepository\nIRenderContextProvider\nIModifierProvider\nIRepositoryEvents","keywords":[]},"pages/server/extensions/ILicenseContext.html":{"title":"Интерфейс ILicenseContext","content":"Контекст записи захвата/освобождения лицензии\nEventKind EventKind { get; }\nТип события.\nDateTime ServerDateTime { get; }\nСерверная дата срабатывания события.\nstring Login { get; }\nЛогин пользователя.\nstring IpAddress { get; }\nIP адрес ПК пользователя.\nint LicenseType { get; }\nТип лицензии.\nint PersonId { get; }\nИдентификатор пользователя.","keywords":[]},"pages/server/extensions/IAuthenticationContext.html":{"title":"Интерфейс IAuthenticationContext","content":"Контекст события аутентификации.\nEventKind EventKind { get; }\nТип события.\nDateTime ServerDateTime { get; }\nСерверная дата события.\nstring Login { get; }\nЛогин пользователя.\nstring IpAddress { get; }\nIP адрес ПК с котрого происходила аутентификация.\nstring Message { get; }\nСообщение обо ошибке при неудачной аутентификации.","keywords":[]},"pages/server/extensions/ISnapshotContext.html":{"title":"Интерфейс ISnapshotContext","content":"Контекст версии.\nEventKind EventKind { get; }\nТип события.\nDateTime ServerDateTime { get; }\nСерверная дата записи изменения.\nstring Login { get; }\nЛогин пользователя от имени которого произошло изменение.\nstring IpAddress { get; }\nIP адрес ПК с котрого инициировалось изменение.\nGuid ObjectId { get; }\nИдентификатор объекта.\nint DeletedSnapshotsCount { get; }\nКоличество удаленных версий.","keywords":[]},"pages/server/extensions/IMetadataContext.html":{"title":"Интерфейс IMetadataContext","content":"Контекст записи об изменении конфигурации базы данных (типы, атрибуты, состояния, автоматизации).\nEventKind EventKind { get; }\nТип события.\nDateTime ServerDateTime { get; }\nСерверная дата записи изменения.\nstring Login { get; }\nЛогин администратора, от имени которого произошло изменение.\nstring IpAddress { get; }\nIP адрес ПК, с котрого инициировалось изменение.","keywords":[]},"pages/server/extensions/IPersonChangedContext.html":{"title":"Интерфейс IPersonChangedContext","content":"Контекст записи об изменении учетных данных пользователя (поля интерфейса INPerson: Login, DisplayName, Comment, Sid, UidDn, Email, Phone, IsDeleted, IsAdmin, IsInactive ).\nEventKind EventKind { get; }\nТип события.\nDateTime ServerDateTime { get; }\nСерверная дата записи изменения.\nstring Login { get; }\nЛогин, от имени которого произошло изменение.\nstring IpAddress { get; }\nIP адрес ПК, с котрого инициировалось изменение.\nint PersonId { get; }\nИдентификатор изменяемого пользователя.\nIReadOnlyList<IPersonChangeData> PersonChangeData { get; }\nДанные об изменениях, содержащие наименование измененного поля, его старое и новое значения.","keywords":[]},"pages/webserver/sborka/react-nastroyka.html":{"title":"Настройка React-расширения","content":"Чтобы создать новое React-расширение для Pilot-Web-Server выполните следующие действия:\nУстановите Node.js.\nСоздайте проект с помощью пакетного менеджера npm командой\nnpm init\nМожно пользоваться и другими пакетными менеджерами (например, yarn ), однако примеры будут приведены для npm.\nОткройте терминал в окружении проекта и выполните команды для установки:\nnpm i react react-dom @pilotdev/pilot-web-sdk\nnpm i --save-dev webpack webpack-cli copy-webpack-plugin html-webpack-plugin\nnpm i --save-dev ts-loader style-loader css-loader\nnpm i --save-dev typescript typescript-plugin-css-modules @types/copy-webpack-plugin @types/node @types/react @types/react-dom\nДобавьте в корневую папку файл tsconfig.json командой\nnpx tsc --init\nИзмените содержание tsconfig.json на следующее:\n{ \"compilerOptions\": { \"jsx\": \"react-jsx\", \"allowSyntheticDefaultImports\": true, \"baseUrl\": \".\", \"outDir\": \"./dist/out-tsc\", \"sourceMap\": true, \"declaration\": false, \"downlevelIteration\": true, \"experimentalDecorators\": true, \"module\": \"esnext\", \"moduleResolution\": \"node\", \"importHelpers\": true, \"target\": \"ES2022\", \"typeRoots\": [ \"node_modules/@types\" ], \"lib\": [ \"es2020\", \"dom\" ], \"allowJs\": true, \"strict\": true, \"plugins\": [ { \"name\": \"typescript-plugin-css-modules\" } ] }, \"include\": [ \"**/*.ts\", \"**/*.tsx\" ] }\nДобавьте в package.json в блок scripts строчки:\n{ \"scripts\": {..., + \"dev\": \"webpack serve\", + \"build-prod\": \"webpack --config webpack.prod.config.js\", }, \"dependencies\": {... },... }\nСоздайте файл src\\extension\\extensions.config.json с содержимым:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"react-ext\", \"entry\": \"react-ext.js\", \"modules\": [ ] } }\nи заполните поля author, license, title, version, name, a так же поле entry по шаблону [name].js, где [name] - значение поля name. Например: react-ext.js.\nИнтерактивные подсказки и валидация в IDE\nВ начале файла добавьте поле $schema со значением пути, указывающим на схему extensions.config.schema.json из пакета @pilotdev/pilot-web-sdk\n{ \"$schema\": \"../../../node_modules/@pilotdev/pilot-web-sdk/extensions.config.schema.json\",... }\nДобавьте в корневую папку файл webpack.config.js с содержимым:\nconst ModuleFederationPlugin = require ( 'webpack/lib/container/ModuleFederationPlugin' ); const CopyPlugin = require ( 'copy-webpack-plugin' ); const HtmlWebpackPlugin = require ( 'html-webpack-plugin' ); module. exports =\n{ mode: 'development', entry: { main: './src/index.tsx' }, module: { rules: [ { test: /\\.tsx?$/, use: 'ts-loader', exclude: /node_modules/, }, { test: /\\.css$/i, use: [ 'style-loader', { loader: 'css-loader', options: { modules: true } }, ], }, ], }, resolve: { extensions: [ '.tsx', '.ts', '.jsx', '.js', '.json' ], }, output: { publicPath: 'auto', uniqueName: 'react-ext', scriptType: 'text/javascript', filename: '[name].js', clean: true, }, optimization: { // fix a temporary bug runtimeChunk: false, }, plugins: [ new HtmlWebpackPlugin ({ template: './src/index.html', }), new ModuleFederationPlugin ({ name: 'react-ext', library: { type: 'var', name: 'react-ext', }, filename: '[name].js', exposes: [ ], shared: { '@pilotdev/pilot-web-sdk': { singleton: true, }, }, }), new CopyPlugin ({ patterns: [ { from: './src/extension/extensions.config.json', to: 'extensions.config.json', }, ], }), ], devServer: { port: 4300, allowedHosts: 'auto', headers: { 'Access-Control-Allow-Origin': '*', }, },\n};\nи заполните поле uniqueName в блоке output и поле name в параметре конструктора ModuleFederationPlugin. Значения должны совпадать со значением name из extensions.config.json.\nДобавьте в корневую папку файл webpack.prod.config.js с содержимым:\nconst { merge } = require ( \"webpack-merge\" ); const dev = require ( \"./webpack.config.js\" ); module. exports = merge (dev, { mode: \"production\",\n});\nСоздайте файл src\\extension\\reactView.ts, в котором будет содержаться логика расширения, например:\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; export class ReactView implements IOpenspaceView < PageContext > { getViewId (): string { } getView (): HTMLElement | undefined { }\n}\nВ файлы webpack.config.js и webpack.prod.config.js добавьте информацию о реализуемых интерфейсах из sdk в поле exposes конструктора плагина ModuleFederationPlugin в формате [интерфейс]:[путь к файлу].\nconst ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin'); const CopyPlugin = require('copy-webpack-plugin'); const HtmlWebpackPlugin = require('html-webpack-plugin'); module.exports = { mode: 'development', entry: { main: './src/index.tsx' }, module: { rules: [ { test: /\\.tsx?$/, use: 'ts-loader', exclude: /node_modules/, }, { test: /\\.css$/i, use: [ 'style-loader', { loader: 'css-loader', options: { modules: true } }, ], }, ], }, resolve: { extensions: ['.tsx', '.ts', '.jsx', '.js', '.json'], }, output: { publicPath: 'auto', uniqueName: 'react-ext', scriptType: 'text/javascript', filename: '[name].js', clean: true, }, optimization: { // fix a temporary bug runtimeChunk: false, }, plugins: [ new HtmlWebpackPlugin({ template: './src/index.html', }), new ModuleFederationPlugin({ name: 'react-ext', library: { type: 'var', name: 'react-ext', }, filename: '[name].js', - exposes: [], + exposes: [ + {'IOpenspaceView<PageContext>': './src/extension/reactView.ts'} + ], shared: { '@pilotdev/pilot-web-sdk': { singleton: true, }, }, }), new CopyPlugin({ patterns: [ { from: './src/extension/extensions.config.json', to: 'extensions.config.json', }, ], }), ], devServer: { port: 4300, allowedHosts: 'auto', headers: { 'Access-Control-Allow-Origin': '*', }, }, };\nТак же в файл extensions.config.json в блок extension.modules добавьте информацию о созданных классах в поля ngModuleName (имя класса) и exposedInterface (реализуемый интерфейс), например:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"react-ext\", \"entry\": \"react-ext.js\", - \"modules\": [], + \"modules\": [ + { \"ngModuleName\":\"ReactView\", \"exposedInterface\":\"IOpenspaceView<PageContext>\" } + ] } }","keywords":[]},"pages/webserver/sborka/react-ui.html":{"title":"Встраивание React в UI","content":"Для встраивания React в приложение, реализуйте интерфейс IOpenspaceView с необходимым контекстом, например:\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; export class ReactView implements IOpenspaceView < PageContext > { getViewId (): string { } getView (): HTMLElement | undefined { }\n}\nРеализуйте метод getViewId() для идентификации отображения:\ngetViewId (): string { return \"ReactViewId\";\n}\nРеализуйте метод getView():\nСоздайте корневой HTML элемент отображения, используя document.createElement\nСоздайте экземпляр приложения React при помощи функции createRoot, передав ему корневой HTML элемент отображения\nСоздайте экземпляр компонента при помощи функции createElement, для отладки воспользуйтесь компонентом StrictMode\nВызовите метод root.render экземпляра приложения React, передав ему экземпляр компонента\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; import { StrictMode, createElement } from 'react'; import { createRoot, Root } from 'react-dom/client'; import { ReactViewComponent } from '../../components/ReactView'; export class ReactView implements IOpenspaceView < PageContext > { private _rootElement: HTMLElement | undefined; private _reactRoot: Root | undefined;... getView (): HTMLElement | undefined { if (! this. _rootElement ) { this. _rootElement = document. createElement ( \"div\" ); } if (! this. _reactRoot ) { this. _reactRoot = createRoot ( this. _rootElement ); } const element = createElement ( ReactViewComponent ); const strictModeElement = createElement ( StrictMode, { children: element }); if ( this. _reactRoot ) { this. _reactRoot. render (strictModeElement); } return this. _rootElement; }\n}\nДля освобождения ресурсов, необходимо реализовать интерфейс поведения IDisposable и его метод IDisposable.dispose():\nВызовите метод root.unmount экземпляра приложения React\nОчистите корневой HTML элемент отображения\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; import { StrictMode, createElement } from 'react'; import { createRoot, Root } from 'react-dom/client'; import { ReactViewComponent } from '../../components/ReactView'; export class ReactView implements IOpenspaceView < PageContext > { private _rootElement: HTMLElement | undefined; private _reactRoot: Root | undefined;... dispose (): void { if ( this. _reactRoot ) { this. _reactRoot. unmount (); this. _reactRoot = undefined; } if ( this. _rootElement ) { this. _rootElement = undefined; } }\n}","keywords":[]},"pages/webserver/sborka/react-zapusk.html":{"title":"Запуск React-расширения","content":"Debug\nДля того чтобы собрать расширение в отладочном режиме, запустите скрипт dev:\nnpm run dev\nЗатем запустите контейнер с Pilot-Web-Server с ключом -e AppSettings:Mode=Development\ndocker run -d -p 80:80 -e PilotServer:Url=http://0.1.5.100:5545 -e PilotServer:Database=demo -e AppSettings:Mode=Development --name pilot-web-server pilotdev/pilot-web-server:latest\nProduction\nДля того чтобы собрать и запустить production-расширение, запустите скрипт build-prod:\nnpm run build-prod\nЗатем в папке dist создайте zip архив с папкой frontend (сама папка должна попасть в архив). В клиентском приложении Pilot создайте объект с типом Веб-расширение (WebExtension) и прикрепите архив. Подробнее на help.pilotems.com","keywords":[]},"pages/webserver/sborka/vue-nastroyka.html":{"title":"Настройка Vue-расширения","content":"Чтобы создать Vue-расширение, выполните следующие действия:\nУстановите утилиту vue-cli командой:\nnpm install -g @vue/cli\nСоздайте новый Vue-проект командой:\nvue create vue-ext\nВыполните команды в окружении проекта:\nnpm install @pilotdev/pilot-web-sdk\nесли произошла ошибка несовпадения версий зависимостей, то выполните команду:\nnpm config set legacy-peer-deps true\nДобавьте в package.json в блок scripts строчки:\n{ \"scripts\": {..., + \"serve\": \"vue-cli-service serve\", + \"build-prod\": \"vue-cli-service build\",... }, \"dependencies\": {... },... }\nСоздайте файл src\\assets\\extensions.config.json с содержимым:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"vue-ext\", \"entry\": \"vue-ext.js\", \"modules\": [ ] } }\nи заполните поля author, license, title, version, name, a так же поле entry по шаблону [name].js, где [name] - значение поля name. Например: vue-ext.js.\nИнтерактивные подсказки и валидация в IDE\nВ начале файла добавьте поле $schema со значением пути, указывающим на схему extensions.config.schema.json из пакета @pilotdev/pilot-web-sdk\n{ \"$schema\": \"../../../node_modules/@pilotdev/pilot-web-sdk/extensions.config.schema.json\",... }\nВ корне проекта измените содержимое файла vue.config.js на следующее:\nconst { defineConfig } = require ( \"@vue/cli-service\" ); const ModuleFederationPlugin = require ( \"webpack/lib/container/ModuleFederationPlugin\" ); const CopyPlugin = require ( \"copy-webpack-plugin\" ); const isProduction = process. env. NODE_ENV === \"production\"; module. exports = defineConfig ({ transpileDependencies: true, publicPath: \"auto\", outputDir: isProduction? \"./dist/frontend\": undefined, configureWebpack: () => { return { entry: \"./src/main.ts\", output: { uniqueName: \"vue-ext\", scriptType: \"text/javascript\", filename: \"[name].js\", clean: true, }, optimization: { // fix a temporary bug runtimeChunk: false, splitChunks: isProduction? undefined: false, }, plugins: [ new ModuleFederationPlugin ({ name: \"vue-ext\", library: { type: \"var\", name: \"vue-ext\", }, filename: \"[name].js\", exposes: [ ], shared: { \"@pilotdev/pilot-web-sdk\": { singleton: true, }, }, }), new CopyPlugin ({ patterns: [ { from: \"./src/extension/extensions.config.json\", to: `extensions.config.json`, }, ], }), ], devServer: isProduction? undefined: { port: 4300, allowedHosts: \"auto\", headers: { \"Access-Control-Allow-Origin\": \"*\" }, }, }; },\n});\nи заполните поля uniqueName, name и library.name. Добавьте в секцию shared используемые библиотеки, чтобы их переиспользовать в хост-приложении. Подробнее: https://webpack.js.org/plugins/module-federation-plugin\nСоздайте файл src\\extension\\vueView.ts, в котором будет содержаться логика расширения, например:\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; export class VueView implements IOpenspaceView < PageContext > { getViewId (): string { } getView (): HTMLElement | undefined { }\n}\nВ файл vue.config.js добавьте информацию о реализуемых интерфейсах из sdk в поле exposes конструктора плагина ModuleFederationPlugin в формате [интерфейс]:[путь к файлу].\nconst { defineConfig } = require(\"@vue/cli-service\"); const ModuleFederationPlugin = require(\"webpack/lib/container/ModuleFederationPlugin\"); const CopyPlugin = require(\"copy-webpack-plugin\"); const isProduction = process.env.NODE_ENV === \"production\"; module.exports = defineConfig({ transpileDependencies: true, publicPath: \"auto\", outputDir: isProduction? \"./dist/frontend\": undefined, configureWebpack: () => { return { entry: \"./src/main.ts\", output: { uniqueName: \"vue-ext\", scriptType: \"text/javascript\", filename: \"[name].js\", clean: true, }, optimization: { // fix a temporary bug runtimeChunk: false, splitChunks: isProduction? undefined: false, }, plugins: [ new ModuleFederationPlugin({ name: \"vue-ext\", library: { type: \"var\", name: \"vue-ext\", }, filename: \"[name].js\", - exposes: [], + exposes: [ + {'IOpenspaceView<PageContext>': './src/extension/vueView.ts'} + ], shared: { \"@pilotdev/pilot-web-sdk\": { singleton: true, }, }, }), new CopyPlugin({ patterns: [ { from: \"./src/extension/extensions.config.json\", to: `extensions.config.json`, }, ], }), ], devServer: isProduction? undefined: { port: 4300, allowedHosts: \"auto\", headers: { \"Access-Control-Allow-Origin\": \"*\" }, }, }; }, });\nТак же в файл extensions.config.json в блок extension.modules добавьте информацию о созданных классах в поля ngModuleName (имя класса) и exposedInterface (реализуемый интерфейс), например:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"vue-ext\", \"entry\": \"vue-ext.js\", - \"modules\": [], + \"modules\": [ + { \"ngModuleName\":\"VueView\", \"exposedInterface\":\"IOpenspaceView<PageContext>\" } + ] } }","keywords":[]},"pages/webserver/sborka/vue-zapusk.html":{"title":"Запуск Vue-расширения","content":"Debug\nДля того чтобы собрать расширение в отладочном режиме, запустите скрипт serve:\nnpm run serve\nЗатем запустите контейнер с Pilot-Web-Server с ключом -e AppSettings:Mode=Development\ndocker run -d -p 80:80 -e PilotServer:Url=http://0.1.5.100:5545 -e PilotServer:Database=demo -e AppSettings:Mode=Development --name pilot-web-server pilotdev/pilot-web-server:latest\nProduction\nДля того чтобы собрать и запустить production-расширение, запустите скрипт build-prod:\nnpm run build-prod\nЗатем в папке dist создайте zip архив с папкой frontend (сама папка должна попасть в архив). В клиентском приложении Pilot создайте объект с типом Веб-расширение (WebExtension) и прикрепите архив. Подробнее на help.pilotems.com","keywords":[]},"pages/webserver/sborka/vue-ui.html":{"title":"Встраивание Vue в UI","content":"Для встраивания Vue в приложение, реализуйте интерфейс IOpenspaceView с необходимым контекстом, например:\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; export class VueView implements IOpenspaceView < PageContext > { getViewId (): string { } getView (): HTMLElement | undefined { }\n}\nРеализуйте метод getViewId() для идентификации отображения:\ngetViewId (): string { return \"VueViewId\";\n}\nРеализуйте метод getView():\nСоздайте корневой HTML элемент отображения, используя document.createElement\nСоздайте экземпляр приложения Vue при помощи функции createApp\nВызовите метод app.mount экземпляра приложения Vue, передав ему корневой HTML элемент отображения\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; import { createApp, type App as AppType } from \"vue\"; import App from \"../../App.vue\"; export class VueView implements IOpenspaceView < PageContext > { private _rootElement: HTMLElement | undefined; private _vueApp: AppType < Element > | undefined;... getView (): HTMLElement | undefined { if (! this. _rootElement ) { this. _rootElement = document. createElement ( \"div\" ); this. _rootElement. setAttribute ( \"id\", \"app\" ); } if (! this. _vueApp ) { this. _vueApp = createApp ( App ); } this. _vueApp. mount ( this. _rootElement ); return this. _rootElement; }\n}\nДля освобождения ресурсов, необходимо реализовать интерфейс поведения IDisposable и его метод IDisposable.dispose():\nВызовите метод app.unmount экземпляра приложения Vue\nОчистите корневой HTML элемент отображения\nimport { IDisposable, IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; import { createApp, type App as AppType } from \"vue\"; export class VueView implements IOpenspaceView < PageContext >, IDisposable { private _rootElement: HTMLElement | undefined; private _vueApp: AppType < Element > | undefined;... dispose (): void { if ( this. _vueApp ) { this. _vueApp. unmount (); this. _vueApp = undefined; } if ( this. _rootElement ) { this. _rootElement = undefined; } }\n}","keywords":[]},"pages/webserver/sborka/plugin-add.html":{"title":"Добавление в проект расширения к компонентам PilotWeb2D и PilotWeb3D","content":"Чтобы добавить расширение к компонентам Pilot-ComponentKit, выполните следующие действия:\nДобавьте файл src\\app\\web2d.component.extension.ts, в котором будет содержаться логика расширения, например:\n/// <reference types=\"@pilotdev/pilot-web-2d\" /> export class Web2DExtension extends PilotWeb2D.Extension { static readonly EXTENSION_NAME = \"ProductName.Web2DExtension\"; constructor ( _viewer: PilotWeb2D. GuiViewer2D ) { super (_viewer); } override getName ( ) { return Web2DExtension. EXTENSION_NAME; } override load (): boolean | Promise < boolean > { super. activate (); return super. load (); } override unload (): boolean { super. deactivate (); return super. unload (); }\n} PilotWeb2D. theExtensionManager. registerExtensionType ( Web2DExtension. EXTENSION_NAME, Web2DExtension );\nДобавьте в файлах webpack.config.js и webpack.prod.config.js информацию о созданном файле: в поле entry добавьте ключ-значение [key]:[path to ext file].\nconst ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin'); const CopyPlugin = require(\"copy-webpack-plugin\"); module.exports = [{ mode: \"development\", - entry: './src/index.ts', + entry: { + main: './src/index.ts', + web2d: './src/app/web2d.component.extension.ts', + }, module: { rules: [{ test: /\\.tsx?$/, use: 'ts-loader', exclude: /node_modules/ }] }, resolve: { extensions: [\".tsx\", \".ts\", \".jsx\", \".js\", \".json\"], }, output: { publicPath: 'auto', uniqueName: 'ext_name', scriptType: 'text/javascript', filename: '[name].js', clean: true }, optimization: { // fix a temporary bug runtimeChunk: false }, plugins: [ new ModuleFederationPlugin({ name: 'ext_name', library: { type: 'var', name: '[name]' }, filename: '[name].js', exposes: [{'IMenu<ObjectsViewContext>': './src/app/extensionSample.ts'}], //implemented interfaces shared: { '@pilotdev/pilot-web-sdk': { singleton: true, } } }), new CopyPlugin({ patterns: [ { from: \"./src/assets/extensions.config.json\", to: \"extensions.config.json\" } ], }), ] }]\nДобавьте в файл extensions.config.json блок с ключом pilotWeb2D или pilotWeb3D с описанием расширения:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"ext_name\", \"description\": \"\", \"entry\": \"ext_name.js\", \"modules\": [ { \"ngModuleName\":\"ExtensionSample\", \"exposedInterface\":\"IMenu<ObjectsViewContext>\" } ] }, + \"pilotWeb2D\": [ + { + \"name\": \"Web2DExtension\", + \"description\": \"\", + \"entry\": \"web2d.js\" + } + ], + \"pilotWeb3D\": [ + { + \"name\": \"Web3DExtension\", + \"description\": \"\", + \"entry\": \"web3d.js\" + } + ] }\nи заполните поля name, description, a так же поле entry по шаблону [key].js, где [key] - ключ из предыдущего шага. Например, web2d.js. Значение поля name должно совпадать с именем расширения, указанного в файле с логикой расширения (EXTENSION_NAME):\nPilotWeb2D. theExtensionManager. registerExtensionType ( EXTENSION_NAME, Web2DExtension );\nПример настройки клиентского расширения и расширения к компоненту и их взаимодействия – annotation.page.changer","keywords":[]},"pages/webserver/interfaces/IInitializable.html":{"title":"Интерфейс IInitializable","content":"Интерфейс используется для инжектирования зависимостей в расширение.\nimport { IMenu, IMenuBuilder, ObjectsViewContext, IModifierProvider, IObjectsRepository, ObjectsViewContext, IInitializable, InjectionSource } from \"@pilotdev/pilot-web-sdk\"; export class InitializeSample extends IMenu < ObjectsViewContext > implements IInitializable { private _objectsRepository!: IObjectsRepository; private _modifierProvider!: IModifierProvider; initialize ( injectionSource: InjectionSource ) { this. _objectsRepository = injectionSource. objectsRepository; this. _modifierProvider = injectionSource. modifierProvider; } build ( builder: IMenuBuilder, context: ObjectsViewContext ): void {... } onMenuItemClick ( name: string, context: ObjectsViewContext ): void {... }\n}\nIInitializable.initialize\nМетод вызывается для инжектирования зависимостей\ninitialize ( injectionSource: InjectionSource ): void\nгде:\ninjectionSource - класс, позволяющий получить доступ к экземплярам инжектируемых интерфейсов.\nInjectionSource\nКласс, содержащий экземпляры инжектируемых интерфейсов. Подробнее: Инжектирование зависимостей в typescript-расширение.","keywords":[]},"pages/webserver/injection/ts-injection.html":{"title":"Инжектирование зависимостей в typescript-расширение","content":"Для инжектирования зависимостей имплементируйте интерфейс IInitializable: в метод initialize будет передан класс InjectionSource, позволяющий получить экземпляры IObjectsRepository, IRenderContextProvider, IModifierProvider, IRepositoryEvents.\nimport { IDataPlugin, IModifierProvider, IObjectsRepository, IRenderContextProvider, IRepositoryEvents, IInitializable, InjectionSource } from \"@pilotdev/pilot-web-sdk\"; export class InitializeSample extends IDataPlugin implements IInitializable { private _objectsRepository!: IObjectsRepository; private _renderContextProvider!: IRenderContextProvider; private _modifierProvider!: IModifierProvider; private _repositoryEvents!: IRepositoryEvents; initialize ( injectionSource: InjectionSource ) { this. _objectsRepository = injectionSource. objectsRepository; this. _renderContextProvider = injectionSource. renderContextProvider; this. _modifierProvider = injectionSource. modifierProvider; this. _repositoryEvents = injectionSource. repositoryEvents; }\n}","keywords":[]},"pages/webserver/interfaces/IDisposable.html":{"title":"Интерфейс IDisposable","content":"Интерфейс используется для реализации поведения расширения при его выгрузке.\nimport { IMenu, IMenuBuilder, ObjectsViewContext, IDisposable } from \"@pilotdev/pilot-web-sdk\"; export class DisposeSample extends IMenu < ObjectsViewContext > implements IDisposable { dispose ( ) { console. log ( \"DisposeSample disposed!\" ); } build ( builder: IMenuBuilder, context: ObjectsViewContext ): void {... } onMenuItemClick ( name: string, context: ObjectsViewContext ): void {... }\n}\nIDisposable.dispose\nМетод будет вызван при выгрузке объекта расширения из рабочей области: например при выполнении выхода из профиля или переключения элемента в IOpenspaceView.\ndispose (): void","keywords":[]},"pages/webserver/interfaces/IToolbar.html":{"title":"Интерфейс IToolbar&lt;TToolbarContext&gt;","content":"Интерфейс встраивает новые команды в панель инструментов.\nimport { IToolbar, IToolbarBuilder, ObjectsViewContext } from \"@pilotdev/pilot-web-sdk\"; export class ToolbarSample extends IToolbar < ObjectsViewContext > { build ( builder: IToolbarBuilder, context: ObjectsViewContext ): void {... } onMenuItemClick ( name: string, context: ObjectsViewContext ): void {... }\n}\nIToolbar<TMenuContext>.build\nМетод вызывается перед построением панели инструментов.\nbuild ( builder: IToolbarBuilder, context: TToolbarContext ): void\nгде:\nbuilder - интерфейс, позволяющий добавлять различные элементы в меню.\ncontext - контекст, позволяющий получить дополнительные сведения о селектированных элементах.\nIToolbar<TMenuContext>.onToolbarItemClick\nМетод вызывается при нажатии на элемент панели инструментов.\nonToolbarItemClick ( name: string, context: TToolbarContext ): void\nгде:\nname - уникальное внутреннее имя элемента панели инструментов.\ncontext - контекст выполнения команды.","keywords":[]},"pages/webserver/injection/angular-injection.html":{"title":"Инжектирование зависимостей в angular-расширение","content":"Для инжектирования зависимостей в angular-расширение укажите интерфейсы с использованием декоратора Inject в конструкторе класса, в котором содержится логика расширения, а также пометьте класс декоратором Injectable, например:\nimport { Inject, Injectable } from \"@angular/core\"; import { IMenu, IMenuBuilder, IModifierProvider, IObjectsRepository, IRenderContextProvider, IRepositoryEvents, ObjectsViewContext } from \"@pilotdev/pilot-web-sdk\" @Injectable ({ providedIn: \"root\" }) export class ObjectsContextMenuExtension implements IMenu < ObjectsViewContext > { constructor ( @Inject ( `IObjectsRepository` ) private _repository: IObjectsRepository, @Inject ( `IRenderContextProvider` ) private _renderContextProvider: IRenderContextProvider, @Inject ( `IModifierProvider` ) private _modifierProvider: IModifierProvider, @Inject ( `IRepositoryEvents` ) private _repositoryEvents: IRepositoryEvents ) { } build ( builder: IMenuBuilder, context: ObjectsViewContext ): void { builder. addItem ( \"SomeMenuItemName\", 1 ). withHeader ( \"Hello from angular extension\" ); } onMenuItemClick ( name: string, context: ObjectsViewContext ): void { alert ( `Angular extension works!` ); }\n}","keywords":[]},"pages/webserver/interfaces/IToolbarToggleButtonItemBuilder.html":{"title":"IToolbarToggleButtonItemBuilder","content":"Добавляет свойства к кнопке-переключателю панели инструментов. Этот интерфейс является наследником IToolbarButtonItemBuilder.\nIToolbarToggleButtonItemBuilder.withIsChecked\nМетод задаёт состояние кнопки-переключателя.\nwithIsChecked ( value: boolean ): IToolbarToggleButtonItemBuilder\nгде:\nvalue - значение.\nreturns - экземпляр IToolbarToggleButtonItemBuilder.","keywords":[]},"pages/webserver/interfaces/IToolbarButtonItemBuilder.html":{"title":"IToolbarButtonItemBuilder","content":"Интерфейс добавляет свойства к элементу панели инструментов.\nIToolbarButtonItemBuilder.withHeader\nМетод добавляет отображаемое в UI название.\nwithHeader ( header: string ): IToolbarButtonItemBuilder\nгде:\nheader - отображаемое в UI название пункта меню.\nIToolbarButtonItemBuilder.withIcon\nМетод добавляет иконку в формате SVG. Входные данные: строка в формате base64 или url.\nwithIcon ( name: string, svg: string ): IToolbarButtonItemBuilder\nгде:\nname - внутреннее имя иконки.\nsvg - иконка в формате url или base64.\nreturns - экземпляр IToolbarButtonItemBuilder.\nbuild ( builder: IToolbarBuilder, context: ObjectsViewContext ): void { builder. addItem ( \"new_item\", 1 ). withHeader ( \"ext command\" ). withIcon ( `ext_icon`, `http://localhost:4300/icon.svg` ); //url format } build2 ( builder: IToolbarBuilder, context: ObjectsViewContext ): void { builder. addItem ( \"new_item2\", 2 ). withHeader ( \"ext command 2\" ). withIcon ( `ext_icon`, `PD94bWwgdmVyc2lvbj0iMS4wIiB...` ); //base64 format }\nIToolbarButtonItemBuilder.withIsEnabled\nМетод задаёт значение доступности элемента.\nwithIsEnabled ( value: boolean ): IToolbarButtonItemBuilder\nгде:\nvalue - значение.\nreturns - экземпляр IToolbarButtonItemBuilder.\nIToolbarButtonItemBuilder.withHint\nМетод добавляет подсказку к элементу панели инструментов.\nwithHint ( hint: string ): IToolbarButtonItemBuilder\nгде:\nhint - текст подсказки.\nreturns - экземпляр IToolbarButtonItemBuilder.","keywords":[]},"pages/webserver/interfaces/IToolbarBuilder.html":{"title":"IToolbarBuilder","content":"Управляет элементами панели инструментов.\nIToolbarBuilder.itemNames\nСвойство возвращает список уникальных имен элементов панели инструментов.\nget itemNames (): string []\nIToolbarBuilder.count\nСвойство возвращает количество элементов панели инструментов.\nget count (): number\nIToolbarBuilder.addSeparator\nМетод добавляет разделитель в панель инструментов.\naddSeparator ( index: number ): void\nгде:\nindex - индекс, куда вставить разделитель.\nIToolbarBuilder.addButtonItem\nМетод добавляет кнопку в панель инструментов.\naddButtonItem ( name: string, index: number ): IToolbarButtonItemBuilder\nгде:\nname - уникальное внутреннее имя кнопки.\nindex - индекс, куда вставить кнопку.\nreturns - экземпляр IToolbarButtonItemBuilder.\nIToolbarBuilder.addMenuButtonItem\nМетод добавляет кнопку с выпадающим меню в панель инструментов.\naddButtonItem ( name: string, index: number ): IToolbarButtonItemBuilder\nгде:\nname - уникальное внутреннее имя кнопки.\nindex - индекс, куда вставить кнопку.\nreturns - экземпляр IToolbarButtonItemBuilder.\nIToolbarBuilder.addToggleButtonItem\nМетод добавляет кнопку-переключатель в панель инструментов.\naddToggleButtonItem ( name: string, index: number ): IToolbarToggleButtonItemBuilder\nгде:\nname - уникальное внутреннее имя кнопки.\nindex - индекс, куда вставить кнопку.\nreturns - экземпляр IToolbarButtonItemBuilder.\nIToolbarBuilder.replaceButtonItem\nМетод заменяет любой элемент панели инструментов на кнопку.\nreplaceButtonItem ( name: string ): IToolbarButtonItemBuilder\nгде:\nname - уникальное внутреннее имя элемента, который будет заменен.\nreturns - экземпляр IToolbarButtonItemBuilder.\nIToolbarBuilder.replaceMenuButtonItem\nМетод заменяет любой элемент панели инструментов на кнопку с выпадающим меню.\nreplaceMenuButtonItem ( name: string ): IToolbarMenuButtonItemBuilder\nгде:\nname - уникальное внутреннее имя элемента, который будет заменен.\nreturns - экземпляр IToolbarButtonItemBuilder.\nIToolbarBuilder.replaceToggleButtonItem\nМетод заменяет любой элемент панели инструментов на кнопку-переключатель.\nreplaceToggleButtonItem ( name: string ): IToolbarToggleButtonItemBuilder\nгде:\nname - уникальное внутреннее имя элемента, который будет заменен.\nreturns - экземпляр IToolbarButtonItemBuilder.\nIToolbarBuilder.handleMenuButtonItemSubmenu\nМетод добавляет обработчик построения подменю. Прямой доступ к элементам подменю невозможно получить в произвольный момент времени, так как подменю строится \"лениво\" при его открытии.\nhandleMenuButtonItemSubmenu ( name: string, itemSubmenuHandler: IToolbarItemSubmenuHandler ): void\nгде:\nname - имя элемента меню, в который будет встраиваться обработчик.\nitemSubmenuHandler - обработчик построения подменю (реализуется на стороне модуля расширения).\nIToolbarBuilder.removeItem\nМетод удаляет элемент панели инструментов.\nremoveItem ( itemName: string ): void\nгде:\nitemName - уникальное внутреннее имя.","keywords":[]},"pages/webserver/interfaces/IToolbarMenuButtonItemBuilder.html":{"title":"IToolbarMenuButtonItemBuilder","content":"Добавляет свойства к кнопке с выпадающим меню панели инструментов. Этот интерфейс является наследником IToolbarButtonItemBuilder.\nIToolbarMenuButtonItemBuilder.withMenu\nМетод добавляет контекстное меню к кнопке.\nwithMenu ( itemSubmenuHandler: IToolbarItemSubmenuHandler ): IToolbarMenuButtonItemBuilder\nгде:\nvalue - значение.\nreturns - экземпляр IToolbarMenuButtonItemBuilder.","keywords":[]},"pages/webserver/interfaces/IMenuBuilder.html":{"title":"Интерфейс IMenuBuilder","content":"Интерфейс управляет элементами меню.\nIMenuBuilder.itemNames\nСвойство возвращает список уникальных имен меню.\nget itemNames (): string []\nIMenuBuilder.count\nСвойство возвращает количество элементов меню.\nget count (): number\nIMenuBuilder.addSeparator\nМетод добавляет разделитель в меню.\naddSeparator ( index: number ): void\nгде:\nindex - индекс, куда вставить разделитель.\nIMenuBuilder.addItem\nМетод добавляет пункт меню.\naddItem ( name: string, index: number ): IMenuItemBuilder\nгде:\nname - уникальное внутреннее имя пункта меню.\nindex - индекс, куда вставить пункт меню.\nreturns - экземпляр IMenuItemBuilder.\nIMenuBuilder.addCheckableItem\nМетод добавляет пункт меню типа кнопка-переключатель.\naddCheckableItem ( name: string, index: number ): ICheckableMenuItemBuilder\nгде:\nname - уникальное внутреннее имя пункта меню.\nindex - индекс, куда вставить пункт меню.\nreturns - экземпляр ICheckableMenuItemBuilder.\nIMenuBuilder.replaceItem\nМетод заменяет любой пункт меню.\nreplaceItem ( name: string ): IMenuItemBuilder\nгде:\nname - уникальное внутреннее имя.\nreturns - экземпляр IMenuItemBuilder.\nIMenuBuilder.removeItem\nМетод удаляет пункт меню.\nremoveItem ( name: string ): void\nгде:\nname - уникальное внутреннее имя.\nIMenuBuilder.getItem\nМетод получает конструктор пункта меню.\ngetItem ( name: string ): IMenuBuilder\nгде:\nname - уникальное внутреннее имя.\nreturns - экземпляр IMenuBuilder.","keywords":[]},"pages/webserver/interfaces/ITabs.html":{"title":"Интерфейс ITabs&lt;TTabsContext&gt;","content":"Интерфейс позволяет встраивать/изменять элементы в различных группах вкладок приложения в зависимости от контекста.\nimport { ITabs, ITabsBuilder, ObjectsViewContext } from \"@pilotdev/pilot-web-sdk\"; export class TabsSample extends ITabs < ObjectsViewContext > { build ( builder: ITabsBuilder, context: ObjectsViewContext ): void {... }\n}\nITabs<TTabsContext>.build\nМетод вызывается перед построением группы вкладок.\nbuild ( builder: ITabsBuilder, context: TTabsContext ): void\nгде:\nbuilder - интерфейс, добавляющий различные элементы в группу вкладок.\ncontext - контекст с дополнительными сведениями о селектированных элементах.","keywords":[]},"pages/webserver/interfaces/IMenuItemBuilder.html":{"title":"IMenuItemBuilder","content":"Интерфейс добавляет свойства пункту меню.\nIMenuItemBuilder.withHeader\nМетод добавляет отображаемое в UI название.\nwithHeader ( header: string ): IMenuItemBuilder\nгде:\nheader - отображаемое в UI название пункта меню.\nreturns - экземпляр IMenuItemBuilder.\nIMenuItemBuilder.withIcon\nМетод добавляет иконку в формате SVG. Входные данные: строка в формате base64 или url.\nwithIcon ( name: string, svg: string ): IMenuItemBuilder\nгде:\nname - внутреннее имя иконки.\nsvg - иконка в формате url или base64.\nreturns - экземпляр IToolbarButtonItemBuilder.\nbuild ( builder: IMenuBuilder, context: ObjectsViewContext ): void { builder. addItem ( \"new_item\", 1 ). withHeader ( \"ext command\" ). withIcon ( `ext_icon`, `http://localhost:4300/icon.svg` ); //url format } build2 ( builder: IMenuBuilder, context: ObjectsViewContext ): void { builder. addItem ( \"new_item2\", 2 ). withHeader ( \"ext command 2\" ). withIcon ( `ext_icon`, `PD94bWwgdmVyc2lvbj0iMS4wIiB...` ); //base64 format }\nIMenuItemBuilder.withIsEnabled\nМетод задаёт значение доступности элемента.\nwithIsEnabled ( value: boolean ): IMenuItemBuilder\nгде:\nvalue - значение.\nreturns - экземпляр IMenuItemBuilder.\nIMenuItemBuilder.withSubmenu\nМетод добавляет подменю к текущему пункту меню.\nwithSubmenu (): IMenuBuilder\nгде:\nreturns - экземпляр IMenuItemBuilder.","keywords":[]},"pages/webserver/interfaces/ITabsBuilder.html":{"title":"Интерфейс ITabsBuilder","content":"Интерфейс управляет элементами группы вкладок.\nITabsBuilder.itemNames\nСвойство возвращает список уникальных имен вкладок.\nget itemNames (): string []\nITabsBuilder.count\nСвойство возвращает количество элементов группы вкладок.\nget count (): number\nITabsBuilder.addItem\nМетод добавляет вкладку в группу.\naddItem ( id: string, index: number ): ITabItemBuilder\nгде:\nid - уникальное внутреннее имя пункта меню.\nindex - индекс, куда вставить пункт меню.\nreturns - экземпляр ITabItemBuilder.\nITabsBuilder.replaceItem\nМетод заменяет любую вкладку в группе.\nreplaceItem ( id: string ): ITabItemBuilder\nгде:\nid - уникальное внутреннее имя.\nreturns - экземпляр ITabItemBuilder.","keywords":[]},"pages/webserver/interfaces/ITabItemBuilder.html":{"title":"ITabItemBuilder","content":"Интерфейс добавляет свойства вкладке.\nITabItemBuilder.withTitle\nМетод добавляет отображаемое в UI название.\nwithTitle ( title: string ): ITabItemBuilder\nгде:\ntitle - отображаемое в UI название пункта меню.\nreturns - экземпляр ITabItemBuilder.\nITabItemBuilder.withIcon\nМетод добавляет иконку в формате SVG. Входные данные: строка в формате base64 или url.\nwithIcon ( name: string, iconSvg: string ): ITabItemBuilder\nгде:\nname - внутреннее имя иконки.\nsvg - иконка в формате url или base64.\nreturns - экземпляр ITabItemBuilder.\nbuild ( builder: ITabItemBuilder, context: ObjectsViewContext ): void { builder. addItem ( \"new_item\", 1 ). withTitle ( \"ext command\" ). withIcon ( `ext_icon`, `http://localhost:4300/icon.svg` ); //url format } build2 ( builder: ITabItemBuilder, context: ObjectsViewContext ): void { builder. addItem ( \"new_item2\", 2 ). withTitle ( \"ext command 2\" ). withIcon ( `ext_icon`, `PD94bWwgdmVyc2lvbj0iMS4wIiB...` ); //base64 format }\nITabItemBuilder.withViewId\nМетод создает Openspace контейнер в теле вкладки с указанным id.\nId сопоставляется с соответствующим отображением IOpenspaceView.getViewId\nwithViewId ( value: string ): ITabItemBuilder\nгде:\nvalue - значение.\nreturns - экземпляр ITabItemBuilder.","keywords":[]},"pages/webserver/interfaces/IPageNavigation.html":{"title":"Интерфейс IPageNavigation","content":"Интерфейс управляет секциями и элементами Окна навигации пространств.\nimport { IPageNavigation, IPageNavigationBuilder } from \"@pilotdev/pilot-web-sdk\"; export class PageNavigationSample extends IPageNavigation { build ( builder: IPageNavigationBuilder ): void {... }\n}\nIPageNavigation.build\nМетод вызывается перед построением окна навигации.\nbuild ( builder: IPageNavigationBuilder ): void\nгде:\nbuilder - интерфейс, управляющий секциями окна навигации.","keywords":[]},"pages/webserver/interfaces/IPageNavigationSectionBuilder.html":{"title":"IPageNavigationSectionBuilder","content":"Интерфейс добавляет свойства секции и управляет её элементами.\nIPageNavigationSectionBuilder.withTitle\nМетод добавляет отображаемое в UI название секции.\nwithTitle ( title: string ): IPageNavigationSectionBuilder\nгде:\ntitle - отображаемое в UI название секции.\nreturns - экземпляр IPageNavigationSectionBuilder.\nIPageNavigationSectionBuilder.elementIds\nСвойство возвращает список уникальных id элементов секции.\nget elementIds (): string []\nIPageNavigationSectionBuilder.count\nСвойство возвращает количество элементов секции.\nget count (): number\nIPageNavigationSectionBuilder.addElement\nМетод добавляет элемент в секцию окна навигации.\naddItem ( id: string, index: number ): IPageNavigationSectionElementBuilder\nгде:\nid - уникальный внутренний id элемента.\nindex - индекс, куда вставить элемент.\nreturns - экземпляр IPageNavigationSectionElementBuilder.\nIPageNavigationSectionBuilder.replaceElement\nМетод заменяет любой элемент в секции окна навигации.\nreplaceItem ( id: string ): IPageNavigationSectionElementBuilder\nгде:\nid - уникальный внутренний id элемента.\nreturns - экземпляр IPageNavigationSectionElementBuilder.","keywords":[]},"pages/webserver/interfaces/IPageNavigationBuilder.html":{"title":"IPageNavigationBuilder","content":"Интерфейс управляет секциями окна навигации.\nIPageNavigationBuilder.sectionIds\nСвойство возвращает список уникальных id секций.\nget sectionIds (): string []\nIPageNavigationBuilder.count\nСвойство возвращает количество секций окна навигации.\nget count (): number\nIPageNavigationBuilder.addSection\nМетод добавляет секцию в окно навигации.\naddItem ( id: string, index: number ): IPageNavigationSectionBuilder\nгде:\nid - уникальный внутренний id секции.\nindex - индекс, куда вставить секцию.\nreturns - экземпляр IPageNavigationSectionBuilder.\nIPageNavigationBuilder.replaceSection\nМетод заменяет любую секцию в окне навигации.\nreplaceItem ( id: string ): IPageNavigationSectionBuilder\nгде:\nid - уникальный внутренний id секции.\nreturns - экземпляр IPageNavigationSectionBuilder.","keywords":[]},"pages/webserver/interfaces/IPageNavigationSectionElementBuilder.html":{"title":"IPageNavigationSectionElementBuilder","content":"Интерфейс добавляет свойства элементу секции.\nIPageNavigationSectionElementBuilder.withTitle\nМетод добавляет отображаемое в UI название элемента.\nwithTitle ( title: string ): IPageNavigationSectionElementBuilder\nгде:\ntitle - отображаемое в UI название элемента.\nreturns - экземпляр IPageNavigationSectionElementBuilder.\nIPageNavigationSectionElementBuilder.withDescription\nМетод добавляет отображаемое в UI описание элемента.\nwithDescription ( description: string ): IPageNavigationSectionElementBuilder\nгде:\ndescription - отображаемое в UI описание элемента.\nreturns - экземпляр IPageNavigationSectionElementBuilder.\nIPageNavigationSectionElementBuilder.withIcon\nМетод добавляет иконку в формате SVG. Входные данные: строка в формате base64 или url.\nwithIcon ( name: string, iconSvg: string ): IPageNavigationSectionElementBuilder\nгде:\nname - внутреннее имя иконки.\nsvg - иконка в формате url или base64.\nreturns - экземпляр IPageNavigationSectionElementBuilder.\nIPageNavigationSectionElementBuilder.withViewId\nМетод создает Openspace контейнер в теле страницы с указанным id.\nId сопоставляется с соответствующим отображением IOpenspaceView.getViewId\nwithViewId ( value: string ): IPageNavigationSectionElementBuilder\nгде:\nvalue - значение.\nreturns - экземпляр IPageNavigationSectionElementBuilder.","keywords":[]},"pages/webserver/interfaces/IDialogService.html":{"title":"Сервис IDialogService","content":"Сервис, который позволяет открывать диалог с произвольным контентом.\nIDialogService.openDialogWithExit\nМетод создает диалог с Openspace контейнером в теле страницы с указанным id.\nId сопоставляется с соответствующим отображением IOpenspaceView.getViewId\nopenDialogWithExit ( viewId: string, context: DialogContext, title: string ): Observable < unknown >;\nгде:\nviewId - id Openspace-контейнера.\ncontext - экземпляр контекста диалога DialogContext.\ntitle - заголовок диалога.\nreturns - экземпляр Observable, который позволяет подписаться на закрытие диалога.","keywords":[]},"pages/webserver/interfaces/IOpenspaceView.html":{"title":"Интерфейс IOpenspaceView&lt;TOpenspaceViewContext&gt;","content":"Интерфейс позволяет встраивать HTML элемент в различные части интерфейса приложения (Openspace слоты/контейнеры) в зависимости от контекста.\nДля реализации логики освобождения ресурсов, используйте наследование от класса IDisposable: метод dispose() будет вызван перед уничтожением Openspace контейнера и перед выгрузкой расширения.\nimport { IOpenspaceView, ObjectsViewContext } from \"@pilotdev/pilot-web-sdk\"; export class OpenspaceViewSample implements IOpenspaceView < ObjectsViewContext >, IDisposable { getViewId (): string {... } getView ( context: ObjectsViewContext ): void {... } dispose (): void {... }\n}\nIOpenspaceView<TOpenspaceViewContext>.getViewId\nМетод вызывается для сопоставления экземпляра интерфейса IOpenspaceView c Openspace контейнером.\ngetViewId (): string\nIOpenspaceView<TOpenspaceViewContext>.getView\nМетод вызывается для встраивания HTML элемента в Openspace контейнер\ngetView ( context: TOpenspaceViewContext ): HTMLElement | undefined\nгде:\ncontext - контекст с дополнительными сведениями.","keywords":[]},"pages/webserver/interfaces/IMenu.html":{"title":"Интерфейс IMenu&lt;TMenuContext&gt;","content":"Интерфейс встраивает новые команды в различные меню приложения в зависимости от контекста.\nimport { IMenu, IMenuBuilder, ObjectsViewContext } from \"@pilotdev/pilot-web-sdk\"; export class MenuSample extends IMenu < ObjectsViewContext > { build ( builder: IMenuBuilder, context: ObjectsViewContext ): void {... } onMenuItemClick ( name: string, context: ObjectsViewContext ): void {... }\n}\nIMenu<TMenuContext>.build\nМетод вызывается перед построением контекстного меню.\nbuild ( builder: IMenuBuilder, context: TMenuContext ): void\nгде:\nbuilder - интерфейс, добавляющий различные элементы в меню.\ncontext - контекст с дополнительными сведениями о селектированных элементах.\nIMenu<TMenuContext>.onMenuItemClick\nМетод вызывается при нажатии на элемент меню.\nonMenuItemClick ( name: string, context: TMenuContext ): void\nгде:\nname - уникальное внутреннее имя элемента меню.\ncontext - контекст выполнения команды.","keywords":[]},"pages/webserver/interfaces/contexts/ObjectsViewContext.html":{"title":"ObjectsViewContext","content":"Используйте этот тип контекста для встраивания в Обозреватель элементов. Доступные для встраивания интерфейсы:\nКонтекстное меню ( IMenu )\nПанель инструментов ( IToolbar )\nГруппа вкладок ( ITabs )\nСодержимое вкладки ( IOpenspaceView )\nimport { IMenu, IMenuBuilder, ObjectsViewContext } from \"@pilotdev/pilot-web-sdk\"; export class MenuSample extends IMenu < ObjectsViewContext > { build ( builder: IMenuBuilder, context: ObjectsViewContext ): void {... } onMenuItemClick ( name: string, context: ObjectsViewContext ): void {... }\n}","keywords":[]},"pages/webserver/interfaces/contexts/PageContext.html":{"title":"PageContext","content":"Используйте этот тип контекста для встраивания в Страницу пространства. Доступные для встраивания интерфейсы:\nСодержимое страницы ( IOpenspaceView )\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; export class OpenspaceViewSample implements IOpenspaceView < PageContext > { getViewId (): string {... } getView ( context: PageContext ): void {... }\n}","keywords":[]},"pages/webserver/interfaces/IToolbarItemSubmenuHandler.html":{"title":"IToolbarItemSubmenuHandler","content":"Интерфейс построения меню для кнопки панели инструментов. Для того, чтобы построить меню, необходимо реализовать этот интерфейс и передать экземпляр в IToolbarBuilder.handleMenuButtonItemSubmenu.\nIToolbarItemSubmenuHandler.onSubmenuRequested\nМетод вызывается перед тем, как появится меню у кнопки панели инструментов.\nonSubmenuRequested ( builder: IToolbarBuilder ): void\nгде:\nbuilder - интерфейс построения меню.","keywords":[]},"pages/webserver/interfaces/ICertificate.html":{"title":"Интерфейс ICertificate","content":"Представляет сертификат с датами действия, информацией об издателе и субъекте.\nСвойства ICertificate.validToDate\nСвойство возвращает дату окончания действия сертификата.\nget validToDate (): string\nICertificate.validFromDate\nСвойство возвращает дату начала действия сертификата.\nget validFromDate (): string\nICertificate.issuer\nСвойство возвращает издателя сертификата.\nget issuer (): string\nICertificate.subject\nСвойство возвращает субъект сертификата.\nget subject (): string","keywords":[]},"pages/webserver/interfaces/contexts/DialogContext.html":{"title":"DialogContext","content":"Используйте этот тип контекста для встраивания в диалог, который может быть вызван в UI через IDialogService.\nНа данном примере описан вызов диалога по кнопке из контекстного меню:\nexport class ExampleObjectExtension implements IMenu < ObjectsViewContext >, IInitializable { private readonly EXAMPLE_VIEW_ITEM_NAME = \"ExampleViewItemName\"; private _objectsRepository!: IObjectsRepository; private _dialogService!: IDialogService; initialize ( injectionSource: InjectionSource ): void { this. _objectsRepository = injectionSource. objectsRepository; this. _dialogService = injectionSource. dialogService; } build ( builder: IMenuBuilder, context: ObjectsViewContext ) {... builder. addItem ( this. EXAMPLE_VIEW_ITEM_NAME, 0 ). withHeader ( \"Это диалог\" ); } onMenuItemClick ( name: string, context: ObjectsViewContext ) { this. _dialogService. openDialogWithExit ( ExtensionViewId, new DialogContext (context), \"Dialog title\" ); }\n}","keywords":[]},"pages/webserver/interfaces/contexts/BimElementPanelContext.html":{"title":"BimElementPanelContext","content":"Используйте этот тип контекста для встраивания в левую панель (панель элемента) пространства \"Информационного моделирования (BIM)\". Доступные для встраивания интерфейсы:\nГруппа вкладок ( ITabs )\nСодержимое вкладки ( IOpenspaceView )\nimport { ITabs, ITabsBuilder, BimElementPanelContext } from \"@pilotdev/pilot-web-sdk\"; export class TabsSample extends ITabs < BimElementPanelContext > { build ( builder: ITabsBuilder, context: BimElementPanelContext ): void {... }\n}\nimport { IOpenspaceView, BimElementPanelContext } from \"@pilotdev/pilot-web-sdk\"; export class OpenspaceViewSample implements IOpenspaceView < BimElementPanelContext > { getViewId (): string {... } getView ( context: BimElementPanelContext ): void {... }\n}","keywords":[]},"pages/webserver/interfaces/contexts/BimRightPanelContext.html":{"title":"BimRightPanelContext","content":"Используйте этот тип контекста для встраивания в правую панель пространства \"Информационного моделирования (BIM)\". Доступные для встраивания интерфейсы:\nГруппа вкладок ( ITabs )\nСодержимое вкладки ( IOpenspaceView )\nimport { ITabs, ITabsBuilder, BimRightPanelContext } from \"@pilotdev/pilot-web-sdk\"; export class TabsSample extends ITabs < BimRightPanelContext > { build ( builder: ITabsBuilder, context: BimRightPanelContext ): void {... }\n}\nimport { IOpenspaceView, BimRightPanelContext } from \"@pilotdev/pilot-web-sdk\"; export class OpenspaceViewSample implements IOpenspaceView < BimRightPanelContext > { getViewId (): string {... } getView ( context: BimRightPanelContext ): void {... }\n}","keywords":[]},"pages/webserver/interfaces/contexts/ObjectCardContext.html":{"title":"Контекст карточки ObjectCardContext","content":"Контекст отображения карточки.\nObjectCardContext.currentObjectId\nПоле содержит идетификатор объекта, для которого показана карточка. Если карточка показана для создания нового объекта, то поле содержит идентификатор, который будет присвоен новому объекту при создании.\nget currentObjectId (): string\nObjectCardContext.displayAttributes\nПоле содержит список отображаемых в карточке атрибутов. В этот список не входят сервисные атрибуты.\nget displayAttributes (): IAttribute []\nObjectCardContext.attributeValues\nСловарь текущих значений атрибутов карточки объекта, где ключ это имя атрибута, а значение - это значение атрибута.\nget attributesValues (): Map < string, unknown >\nObjectCardContext.type\nПоле содержит описание типа элемента, для которого показана карточка.\nget type (): IType;\nObjectCardContext.editiedObject\nТекущий редактируемый объект, для которого показана карточка. null, если карточка показана для создания нового объекта.\nget editedObject (): IDataObject | null\nObjectCardContext.parent\nПоле содержит ID родительского элемента.\nget parentId (): string;\nObjectCardContext.isReadOnly\nTrue, если карточка в режиме только для чтения, и атрибуты недоступны для изменения.\nget isReadOnly (): boolean;","keywords":[]},"pages/webserver/interfaces/ICryptoProvider.html":{"title":"Интерфейс ICryptoProvider","content":"Представляет криптографический провайдер для подписания, проверки и получения сертификатов.\nМетоды ICryptoProvider.sign\nМетод подписывает файл цифровой подписью с использованием предоставленного сертификата.\nsign ( documentId: string, actualFile: IFile, arrayBuffer: ArrayBuffer, certificate: ICertificate, signatureRequestIds: string []): Observable < string >\nгде:\ndocumentId - ID документа.\nactualFile - объект файла для дополнительной информации.\narrayBuffer - файл для подписания.\ncertificate - цифровой сертификат для использования при подписании.\nsignatureRequestIds - массив ID запросов на подпись.\nreturns - наблюдаемый объект, который возвращает цифровую подпись в виде строки.\nICryptoProvider.verify\nМетод проверяет цифровую подпись файла.\nverify ( file: ArrayBuffer, sign: ArrayBuffer, signatureRequest: ISignatureRequest ): Observable < ISignatureVerificationResult >\nгде:\nfile - файл для проверки.\nsign - цифровая подпись для проверки.\nsignatureRequest - проверяемый запрос на подпись.\nreturns - стуктура, описывающая результат проверки.\nICryptoProvider.verifyImportedSignature\nМетод проверяет импортируемую цифровую подпись.\nverifyImportedSignature ( file: ArrayBuffer, sign: ArrayBuffer ): Observable < IImportedSignatureVerificationResult >\nгде:\nfile - файл для проверки.\nsign - цифровая подпись для проверки.\nreturns - стуктура, описывающая результат проверки.\nICryptoProvider.getCertificates\nМетод получает список цифровых сертификатов.\ngetCertificates (): Observable < ICertificate []>\nгде:\nreturns - наблюдаемый объект, который возвращает массив объектов ICertificate.\nICryptoProvider.canProcessAlgorithms\nМетод определяет, может ли провайдер обрабатывать указанный алгоритм.\ncanProcessAlgorithms ( publicKeyOid: string ): boolean;\nгде:\npublicKeyOid - oid публичного ключа сертификата. Например 1.2.840.113549.1.1.1\nreturns - результат проверки.\nICryptoProvider.canProcessSignature\nМетод определяет, может ли провайдер проверить подпись. Метод необходим во время импорта подписи, когда алгоритм подписания неизвестен.\ncanProcessSignature ( signatureFile: ArrayBuffer ): boolean\nгде:\nsignatureFile - подпись.\nreturns - результат проверки.\nCadesType\nПеречисление типа подписи.\nexport enum CadesType { CadesBes = 0, CadesT = 1, CadesC = 2, CadesXLong = 3, CadesXLongType1 = 4 }","keywords":[]},"pages/webserver/interfaces/ISettingsFeature.html":{"title":"Интерфейс ISettingsFeature","content":"Интерфейс позволяет регистрировать представление в диалоге настроек.\nISettingsFeature\nИнтерфейс для работы с элементами диалога настроек.\nkey\nМетод для получения уникального идентификатора элемента настроек.\nget key (): string;\ntitle\nМетод для получения заголовка элемента настроек.\nget title (): string;\neditor\nМетод для получения редактора значений элемента настроек.\nget editor (): HTMLElement;\nsetValueProvider\nМетод для установки поставщика значения настройки.\nsetValueProvider ( settingValueProvider: ISettingValueProvider ): void;\nгде:\nsettingValueProvider - поставщик значения настройки.","keywords":[]},"pages/webserver/interfaces/ISettingValueProvider.html":{"title":"Интерфейс ISettingValueProvider","content":"Интерфейс для поставщика значения личной настройки.\nISettingValueProvider\nИнтерфейс для работы со значениями личных настроек.\ngetValue\nМетод для получения текущего значения настройки.\ngetValue (): string;\nгде:\nreturns - текущее значение настройки.\nsetValue\nМетод для установки значения настройки.\nsetValue ( value: string ): void;\nгде:\nvalue - новое значение настройки.","keywords":[]},"pages/webserver/interfaces/IThemeService.html":{"title":"IThemeService","content":"Интерфейс позваляет получить значение выбранной цветовой схемы клиента (светлая или тёмная).\nIThemeService.themes\nПозволяет получить текущую цветовую схему клиента.\nget themes (): Themes;\nIThemeService.change\nПозволяет подписаться на событие изменение цветовой схемы клиента.\nget change (): Observable < Themes >;","keywords":[]},"pages/webserver/interfaces/IModifierProvider.html":{"title":"Интерфейс IModifierProvider","content":"Интерфейс отдаёт объект IModifier. Получить интерфейс можно с помощью инжектирования.\nIModifierProvider.newModifier\nМетод получает новый экземпляр класса, реализующий интерфейс IModifier.\nnewModifier (): IModifier\nгде:\nreturns - экземпляр IModifier.","keywords":[]},"pages/webserver/interfaces/IRepositoryEvents.html":{"title":"Интерфейс IRepositoryEvents","content":"Интерфейс подписывается на изменения в элементах, типах элементов и организационной структуре. Получить интерфейс можно с помощью инжектирования. Подписка – Hot Observable и срабатывает только на изменение данных.\nIRepositoryEvents.subscribeObjects\nМетод подписывается на изменения элементов по идентификаторам.\nsubscribeObjects ( ids: string []): Observable < IDataObject >\nгде:\nids - список идентификаторов элементов.\nreturns - подписка.\nIRepositoryEvents.subscribePeople\nМетод подписывается на изменения в пользователях.\nsubscribePeople (): Observable < IPerson >\nгде:\nreturns - подписка.\nIRepositoryEvents.subscribeTypes\nМетод подписывается на изменения в типах.\nsubscribeTypes (): Observable < IType >\nгде:\nreturns - подписка.\nIRepositoryEvents.subscribeOrganisationUnits\nМетод подписывается на изменения в организационных единицах (должностях и подразделениях).\nsubscribeOrganisationUnits (): Observable < IOrganizationUnit >\nгде:\nreturns - подписка.","keywords":[]},"pages/webserver/interfaces/IObjectsRepository.html":{"title":"Интерфейс IObjectsRepository","content":"Интерфейс даёт доступ к элементам, типам элементов и организационной структуре. Получить интерфейс можно с помощью инжектирования. Для подписки на изменения данных смотри IRepositoryEvents.\nIObjectsRepository.getObjects\nМетод получает элементы по их идентификаторам.\ngetObjects ( ids: string []): Observable < IDataObject []>\nгде:\nids - список идентификаторов элементов.\nreturns - список объектов, обёрнутый в Cold Observable.\nIObjectsRepository.getCurrentAccess\nМетод получает информацию о доступе пользователя к определенному объекту.\ngetCurrentAccess ( objectId: string, personId: number ): Observable < AccessLevel >\nгде:\nobjectId - идентификатор объекта.\npersonId - идентификатор пользователя.\nreturns - информация о доступе, обёрнутая в Cold Observable.\nIObjectsRepository.getPerson\nМетод позволяет получить информацию о пользователе по идентификатору.\ngetPerson ( id: number ): IPerson\nгде:\nid - идентификатор пользователя.\nreturns - пользователь.\nIObjectsRepository.getCurrentPerson\nМетод возвращает текущего пользователя.\ngetCurrentPerson (): IPerson\nгде:\nreturns - пользователь.\nIObjectsRepository.getPeople\nМетод получает список всех пользователей.\ngetPeople (): IPerson []\nгде:\nreturns - пользователи.\nIObjectsRepository.getType\nМетод получает информацию о типе элемента по идентификатору.\ngetType ( id: number ): IType\nгде:\nid - идентификатор типа элемента.\nreturns - тип.\nIObjectsRepository.getTypeByName\nМетод получает информацию о типе элемента по имени.\ngetTypeByName ( name: string ): IType\nгде:\nname - идентификатор типа элемента.\nreturns - имя типа элемента.\nIObjectsRepository.getTypes\nМетод получает список всех типов.\ngetTypes (): IType []\nгде:\nreturns - типы.\nIObjectsRepository.getOrganisationUnit\nМетод получает информацию об организационной единице.\ngetOrganisationUnit ( id: number ): IOrganizationUnit\nгде:\nid - идентификатор должности или подразделения.\nreturns - организационная единица.\nIObjectsRepository.getOrganisationUnits\nМетод получает список организационных единиц.\ngetOrganisationUnits (): IOrganizationUnit []\nгде:\nreturns - список организационных единиц.\nIObjectsRepository.getUserStateMachines\nМетод получает список машин состояния.\ngetUserStateMachines (): Map < string, IUserStateMachine []>\nгде:\nreturns - список машин состояния.","keywords":[]},"pages/webserver/interfaces/IAttributeModifier.html":{"title":"Редактирование атрибутов в карточке IAttributeModifier","content":"Интерфейс позволяет установить новое значения для атрибутов элемента перед тем, как они будут показаны в карточке объекта.\nIAttributeModifier.setValue\nМетод позволяет задать новое значение атрибуту.\nsetValue ( name: string, value: unknown ): void\nгде:\nname - уникальное наименование атрибута типа.\nvalue - новое значение атрибута.","keywords":[]},"pages/webserver/interfaces/IModifier.html":{"title":"Интерфейс IModifier","content":"Интерфейс предназначен для создания и изменения элементов. Получить интерфейс можно через IModifierProvider.\nIModifier.create\nМетод создаёт новый элемент заданного типа.\ncreate ( id: string, parentId: string, typeId: number ): IObjectBuilder\nгде:\nid - идентификатор нового элемента.\nparentId - идентификатор родителя нового элемента.\ntypeId - идентификатор типа нового элемента.\nreturns - экземпляр IObjectBuilder.\nIModifier.edit\nМетод редактирует заданный элемент.\nedit ( id: string ): IObjectBuilder\nгде:\nid - идентификатор редактируемого элемента.\nIModifier.apply\nМетод применяет все сделанные над элементами изменения. Без вызова этого метода изменения не будут применены.\napply (): Observable < IDataObject []>;\nгде:\nreturns - созданные и измененные объекты, обёрнутые в Cold Observable.","keywords":[]},"pages/webserver/interfaces/ISignatureBuilder.html":{"title":"Интерфейс ISignatureBuilder","content":"Интерфейс для изменения запроса на подпись.\nISignatureBuilder.withPositionId\nМетод задает идентификатор должности пользователя, который должен будет подписать этот запрос на подпись.\nwithPositionId ( positionId: number ): ISignatureBuilder;\nгде:\npositionId - идентифкатор должности.\nreturns - экземпляр ISignatureBuilder.\nISignatureBuilder.withRole\nМетод задает роль пользователя, под который пользователь должен будет подписать этот запрос на подпись.\nwithRole ( role: string ): ISignatureBuilder;\nгде:\nrole - роль пользователя.\nreturns - экземпляр ISignatureBuilder.\nISignatureBuilder.withSign\nМетод задает флаг, подписан ли запрос на подпись или нет.\nwithSign ( sign: string ): ISignatureBuilder\nгде:\nsign - любая не пустая строка, если запрос подписан.\nreturns - экземпляр ISignatureBuilder.\nISignatureBuilder.withRequestSigner\nМетод задает имя пользователя запроса на подпись.\nwithRequestSigner ( requestSigner: string ): ISignatureBuilder;\nгде:\nrequestSigner - имя пользователя в запросе на подпись.\nreturns - экземпляр ISignatureBuilder.\nISignatureBuilder.withObjectId\nМетод задает идентификатор связанного объекта с запросом на подпись. Например идентифкатор задания на согласование.\nwithObjectId ( objectId: string ): ISignatureBuilder;\nгде:\nobjectId - идентификатор связанного объекта.\nreturns - экземпляр ISignatureBuilder.","keywords":[]},"pages/webserver/interfaces/ISignatureModifier.html":{"title":"Интерфейс ISignatureModifier","content":"Интерфейс для создания и изменения запросов на подпись.\nISignatureModifier.create\nМетод создает новый запрос на подпись для указанного файла.\nadd ( signatureRequestId: string ): ISignatureBuilder;\nгде:\nsignatureRequestId - новый идентифкатор запроса на подпись.\nreturns - экземпляр ISignatureBuilder.\nISignatureModifier.edit\nМетод редактирует запрос на подпись для указанного файла.\nedit ( signatureRequest: ISignatureRequest ): ISignatureBuilder;\nгде:\nsignatureRequest - запроса на подпись для редактирования.\nreturns - экземпляр ISignatureBuilder.\nISignatureModifier.remove\nМетод удаляет запрос на подпись.\nremove ( signatureRequestId: string ): void;\nгде:\nsignatureRequest - запроса на подпись для удаления.","keywords":[]},"pages/webserver/interfaces/IBimFeatures.html":{"title":"Интерфейс IBimFeatures","content":"Интерфейс предназначен для работы с инструментами информационного моделирования моделей.\nПозволяет получать экземпляры сервисов.\nIBimFeatures.searchSetService\nПолучение экземпляра сервиса IBimSearchSetService для работы с поисковыми наборами и выполнению поиска по BIM‑модели.\nget searchSetService (): IBimSearchSetService;\nгде:\nreturns - Экземпляр сервиса IBimSearchSetService.\nИнтерфейс IBimSearchSetService\nИнтерфейс предназначен для работы с поисковыми наборами и выполнению поиска по BIM‑модели.\nIBimSearchSetService.getFromModel\nПолучение списка поисковых наборов верхнего уровня, расположенных непосредственно в корневой (скрытой) папке модели. Не выполняет обход подкаталогов, возвращает только элементы первого уровня.\ngetFromModel ( id: string ): Observable < IBimSearchSetData []>;\nгде:\nid - идентификатор модели, для которой запрашиваются поисковые наборы верхнего уровня.\nreturns - Подписка, возвращающая массив IBimSearchSetData.\nIBimSearchSetService.getRecursivelyFromModel\nПолучение полного списка всех элементов из корневой (скрытой) папки модели с рекурсивным обходом всех вложенных папок.\ngetRecursivelyFromModel ( id: string ): Observable < IBimSearchSetData []>;\nгде:\nid - идентификатор модели, для которой рекурсивно считываются все поисковые наборы.\nreturns - Подписка, возвращающая массив IBimSearchSetData.\nIBimSearchSetService.getFromFolder\nПолучение списка поисковых наборов, находящихся непосредственно в указанной папке поисковых наборов. Вложенные папки не обходятся.\ngetFromFolder ( id: string ): Observable < IBimSearchSetData []>;\nгде:\nid - идентификатор папки поисковых наборов, из которой нужно получить элементы.\nreturns - Подписка, возвращающая массив IBimSearchSetData.\nIBimSearchSetService.executeSearchSet\nВыполнение сохранённого поискового набора по указанным частям модели.\nexecuteSearchSet ( id: string, modelPartIds: string []): Observable < IBimModelSearchResult []>;\nгде:\nid - идентификатор поискового набора, который необходимо выполнить.\nmodelPartIds - массив идентификаторов частей модели, по которым будет выполняться поиск.\nreturns - Подписка, возвращающая массив IBimModelSearchResult.\nIBimSearchSetService.executeStringQuery\nВыполнение строкового поискового запроса по указанным частям модели.\nexecuteStringQuery ( query: string, modelPartIds: string []): Observable < IBimModelSearchResult []>;\nгде:\nquery - строковое выражение запроса.\nmodelPartIds - массив идентификаторов частей модели, по которым будет выполняться поиск.\nreturns - Подписка, возвращающая массив IBimModelSearchResult.\nIBimFeatures.compareDisplayParamsService\nВозвращает экземпляр сервиса IBimCompareDiffService для работы с режимом сравнения версий BIM‑модели.\nИнтерфейс:\nget compareDisplayParamsService (): IBimCompareDiffService;\nгде:\nreturns - Экземпляр сервиса IBimCompareDiffService.\nПример:\n@Injectable () export class ExtensionsCompareDiffService { private readonly _bimFeatures: IBimFeatures; constructor ( ) { this. _bimFeatures = inject ( BIM_FEATURES ); } public get compareDisplayParamsService (): IBimCompareDiffService { return this. _bimFeatures. compareDisplayParamsService (); }\n}\nИнтерфейс IBimCompareDiffService\nИнтерфейс предоставляет методы для работы с BIM-моделью в режиме сравнения версий.\nIBimCompareDiffService.updateDiffDisplayParams\nПозволяет изменяеть типа сравнения цвет на панели сравнения версий:\nupdateDiffDisplayParams ( type: CompareResultType, func: ( old: IDisplayParam ) => IDisplayParam ): void\nгде:\ntype: CompareResultType - тип сравнения двух версий модели: добавлено, изменена геометрия, изменены атрибуты, удалено и без изменений.\nenum CompareResultType { Added = \"added\", Modified = \"modified\", AttributesModified = \"attributesModified\", Deleted = \"deleted\", Unchanged = \"unchanged\" }\nfunc: (old: IDisplayParam) => IDisplayParam - устанавливает параметры отображения в формате rgba\ninterface IDisplayParam { visible: boolean; highlight: boolean; r: number; g: number; b: number; a: number;\n}\nПример:\nonModelPartColorChange (): void { this. _bimFeatures. compareDisplayParamsService. updateDiffDisplayParams ( CompareResultType. Unchanged, ( params ) => ({...params, r: 171, g: 48, b: 144, a: 1 }) );\n}","keywords":[]},"pages/webserver/interfaces/IRenderContextProvider.html":{"title":"Интерфейс IRenderContextProvider","content":"Отдаёт экземпляр класса RenderContex. Получить интерфейс можно с помощью инжектирования.\ngetRenderContext (): RenderContext\nгде:\nreturns - экземпляр RenderContext.\nRenderContext\nИспользуйте этот тип контекста, чтобы узнать версию и элемент отображаемого документа. Получить объект можно через интерфейс IRenderContextProvider.\nRenderContext.dataObject\nОтдаёт элемент отображаемого документа.\nget dataObject (): IDataObject\nRenderContext.selectedVersion\nПолучает версию отображаемого документа.\nget selectedVersion (): string","keywords":[]},"pages/webserver/interfaces/IObjectBuilder.html":{"title":"Интерфейс IObjectBuilder","content":"Интерфейс редактирует элементы.\nIObjectBuilder.setAttribute\nМетод задает или изменяет атрибут с заданным именем.\nsetAttribute ( name: string, value: any, type: AttributeType ): IObjectBuilder\nгде:\nname - имя атрибута.\ntype - тип атрибута.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.setAccess\nМетод добавляет права доступа на элемент.\nsetAccess ( record: IAccessRecord ): IObjectBuilder\nгде:\nrecord - структура, описывающая права доступа.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.removeAccess\nМетод удаляет права доступа на элемент.\nremoveAccess ( record: IAccessRecord ): IObjectBuilder\nгде:\nrecord - структура, описывающая права доступа.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.addRelation\nМетод добавляет новую связь к элементу.\naddRelation ( relation: IRelation ): IObjectBuilder\nгде:\nrelation - структура, описывающая связь.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.removeRelation\nМетод удаляет связь.\nremoveRelation ( relationId: string ): IObjectBuilder\nгде:\nrelationId - идентификатор связи.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.setTypeId\nМетод задаёт элементу тип.\nВнимание\nРекомендуется использовать этот метод только для восстановления безвозвратно удаленных объектов. В остальных случаях это может привести к неработоспособности системы.\nsetTypeId ( typeId: number ): IObjectBuilder\nгде:\ntypeId - идентификатор типа.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.setParentId\nМетод задаёт элементу нового родителя.\nsetParentId ( parentId: string ): IObjectBuilder\nгде:\nparentId - идентификатор элемента.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.createSnapshot\nМетод создаёт снимок файлов и указывает причину. Текущие файлы будут сохранены в предыдущей версии документа.\ncreateSnapshot ( reason: string ): IObjectBuilder\nгде:\nreason - причина создания снимка файлов.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.createSnapshotFrom\nМетод делает выбранный снимок файлов текущим.\ncreateSnapshotFrom ( version: string, reason: string ): IObjectBuilder\nгде:\nversion - дата создания снимка, который нужно сделать актуальным.\nreason - причина создания снимка файлов.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.addFile\nМетод добавляет новый файл в текущий снимок файлов.\naddFile ( fileId: string, file: File, creationTime: Date, lastAccessTime: Date, lastWriteTime: Date ): IObjectBuilder;\nгде:\nfileId - новый идентификатор файла. Для генерации уникальных идентификаторов используйте метод Guid.newGuid();\nfile - добавляемый файл.\ncreationTime - дата создания файла.\nlastAccessTime - дата последнего доступа к файлу.\nlastWriteTime - дата последнего доступа на запись в файл.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.removeFile\nМетод удаляет файл из текущего снимка файлов.\nremoveFile ( fileId: string ): IObjectBuilder;\nгде:\nfileId - идентификатор файла.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.setIsDeleted\nМетод задаёт элементу состояние удалено безвозвратно.\nsetIsDeleted ( isDeleted: boolean ): IObjectBuilder\nгде:\nisDeleted - значение флага.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.setIsInRecycleBin\nМетод задаёт элементу состояние удалено в корзину.\nsetIsInRecycleBin ( isInRecycleBin: boolean ): IObjectBuilder\nгде:\nisInRecycleBin - значение флага.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.setIsFreezed\nМетод задаёт элементу состояние заморозки.\nsetIsFreezed ( isFreezed: boolean ): IObjectBuilder\nгде:\nisFreezed - значение флага.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.setIsSecret\nМетод делает элемент скрытым или общедоступным.\nsetIsSecret ( isSecret: boolean ): IObjectBuilder\nгде:\nisSecret - значение флага.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.addAnnotationContainer\nМетод создаёт или изменяет замечание.\naddAnnotationContainer ( container: IAnnotationContainer, attrbutes: any ): IObjectBuilder\nгде:\ncontainer - структура, описывающая замечание.\nattrbutes - дополнительная информация по замечанию.\nreturns - экземпляр IObjectBuilder.\nIObjectBuilder.setSignatures\nМетод создаёт модификатор запросов на подпись для указанного файла.\nsetSignatures ( fileId: string ): ISignatureModifier;\nгде:\nfileId - идентифкатор файла, для которого надо добавить запрос на подпись.\nreturns - экземпляр ISignatureModifier.","keywords":[]},"pages/webserver/interfaces/IPersonalSettings.html":{"title":"Интерфейс IPersonalSettings","content":"Интерфейс предназначен для работы с персональными и общими настройками пользователя.\nПозволяет получать текущие значения настроек, подписываться на их изменения и изменять значения.\nIPersonalSettings.getPersonalSettingValue\nПолучение значения персональной настройки для текущего пользователя по ключу.\ngetPersonalSettingValue ( key: string ): Observable < string | undefined >;\nгде:\nkey - ключ настройки, значение которой необходимо получить.\nreturns - Подписка, возвращающая строковое значение настройки для текущего пользователя или undefined, если настройка не установлена.\nIPersonalSettings.subscribePersonalSettingValueChange\nПодписка на значение персональной настройки по передаваемому ключу.\nsubscribePersonalSettingValueChange ( key: string ): Observable < string | undefined >;\nгде:\nkey - ключ персональной настройки, изменения которой необходимо отслеживать.\nreturns - Подписка, предоставляющая актуальное значение персональной настройки при изменении.\nIPersonalSettings.getCommonSettingValue\nПолучение по ключу списка значений настройки для всех элементов организационной структуры, в которые входит текущий пользователь.\ngetCommonSettingValue ( key: string ): Observable < string []>;\nгде:\nkey - ключ общей настройки.\nreturns - Подписка, возвращающая массив строковых значений настройки.\nIPersonalSettings.subscribeCommonSettingValueChange\nПодписка на изменения значения общей настройки по ключу.\nsubscribeCommonSettingValueChange ( key: string ): Observable < string []>;\nгде:\nkey - ключ общей настройки.\nreturns - Подписка, предоставляющая актуальный массив строковых значений настройки при изменении.\nIPersonalSettings.changeSettingValue\nИзменение значения персональной настройки по ключу.\nchangeSettingValue ( key: string, value: string ): Observable < void >;\nгде:\nkey - ключ настройки, значение которой требуется изменить.\nvalue - новое значение настройки.\nreturns - Observable, без возвращаемого значения.","keywords":[]},"pages/webserver/interfaces/BimRightPanelContext.html":{"title":"BimRightPanelContext","content":"Используйте этот тип контекста, для встраивания в правую панель пространства \"Информационного моделирования (BIM)\" и чтобы узнать идентификатор модели и экземпляр PilotWeb3D.Viewer3D - обозревателя модели.\nget modelId (): string\nгде:\nreturns - GUID модели.\nget viewer (): PilotWeb3D. Viewer3D\nгде:\nreturns - экземпляр обозревателя модели PilotWeb3D.Viewer3D.","keywords":[]},"pages/webserver/interfaces/ExpectedError.html":{"title":"Ошибка ExpectedError","content":"Класс ожидаемой ошибки. При ее обработке диалог ошибки отображается без дополнительных деталей (callstack, url),\nлибо вообще не отображается.\nisSilent\nОпределяет, отображается ли диалог ошибки.\nisSilent (): boolean = false","keywords":[]},"pages/webserver/interfaces/BimElementPanelContext.html":{"title":"BimElementPanelContext","content":"Используйте этот тип контекста, для встраивания в левую панель (панель элемента) пространства \"Информационного моделирования (BIM)\" и чтобы узнать идентификатор модели и экземпляр PilotWeb3D.Viewer3D - обозревателя модели.\nget modelId (): string\nгде:\nreturns - GUID модели.\nget viewer (): PilotWeb3D. Viewer3D\nгде:\nreturns - экземпляр обозревателя модели PilotWeb3D.Viewer3D.","keywords":[]},"pages/client/client.html":{"title":"Pilot Client  SDK","content":"Описание клиентского SDK для создания модулей расширения к продуктам:\nPilot-BIM\nPilot-ICE Enterprise\nPilot-ICE\nPilot-ECM\n3D-Storage\nРекомендации\nДля создания расширений рекомендуется использовать Visual Studio 2019 или выше.\nСоздание и настройка проекта расширения\nСистема расширений Pilot основана на стандартном механизме расширений приложений.NET — Managed Extensibility Framework (MEF). Чтобы создать новое расширение для системы Pilot выполните следующие действия:\nСоздайте проект типа ClassLibrary.\nВызовите диалог настройки проекта. В поле AssemblyName добавьте к названию сборки.ext2 Например WPFExtension.ext2\nУстановите целевую платформу (Target Framework) в.NET Framework 4.7.2 или выше.\nВызовите диалог редактирования информации о сборке. (Assembly Information...) Для этого нажмите на кнопку Assembly Information... и заполните необходимые поля.\nВажно\nОбязательно заполните поля Title, Product и Assembly version. Т.к. клиент при загрузке вашего расширения будет искать информацию именно в этих полях.\nПодключите к проекту ссылку на.NET сборку System.ComponentModel.Composition.\nДля удобства отладки проекта расширения выполните следующие шаги:\nнастройте сборку проекта в следующую папку C:\\Users\\<current_user>\\AppData\\Local\\ASCON\\Pilot-ICE Enterprise\\Development\nна вкладке Debug выберите пункт Start external program и введите путь до установленного клиента. Например, путь для Pilot-ICE Enterprise C:\\Program Files\\ASCON\\Pilot-ICE Enterprise\\Ascon.Pilot.PilotEnterprise.exe\nсохраните изменения и запустите проект на исполнение.\nВажно\nПапка Development по умолчанию отсутствует. Ее необходимо создать.\nСовет\nПри разработке множества разных расширений для удобства каждое расширение можно поместить в отдельную папку. Например, для расширения WPFExtension можно создать папку: C:\\Users\\<current_user>\\AppData\\Local\\ASCON\\Pilot-ICE Enterprise\\Development\\WPFExtension\\.\nТакже вместо устарешего Packages.config, рекомендуется использовать PackageReference формат управления зависимостями nuget пакетов. Для этого перед созданием проекта, убедитесь, что в настройке Visual Studio Tools>Options>NuGet Package Manager>General>Default package management format выбрано значение PackageReference.\nДля миграции уже созданных проектов в контестном меню файла Packages.config выберете команду Migrate from packages.config to PackageReference.\nПодключение SDK к проекту расширения\nДля подключения SDK Pilot к проекту расширения можно воспользоваться встроенным в Visual Studio механизмом распространения пакетов — NuGet Packages Manager. Для того, чтобы подключить SDK с помощью Nuget Package Manager выполните следующие шаги:\nВызовите Package Manager Console;\nВыполните команду:\nInstall-Package Ascon.Pilot.SDK\nЩёлкните правой кнопкой мыши на проекте и вызовите команду Manage NuGet Packages;\nУстановите NuGet пакет Ascon.Pilot.SDK для вашего проекта.\nДля того, чтобы подключить SDK вручную выполните следующие шаги:\nСкачайте примеры использования SDK из центра загрузок Pilot;\nРаспакуйте загруженный архив в любую папку.\nНастройте NuGet Package Manager на работу с папкой SDK из загруженного архива.\nУстановите NuGet пакет Ascon.Pilot.SDK для вашего проекта.\nAscon Pilot-BIM SDK\nРаздел рассматривает только типы и интерфейсы специфичные для расширений к Pilot-BIM.\nДля получения общей информации по разработке расширений для Pilot-BIM необходимо обращаться к документации Ascon Pilot SDK.\nДля разработки расширений к Pilot-BIM в проекте расширения должен быть установлен NuGet-пакет Ascon.Pilot.Bim.SDK, содержащий необходимые типы и интерфейсы, описанные в данной документации.\nРеализация интерфейсов, связанных с встраиванием в контекстное меню, должна быть зарегистрирована через IPilotServiceProvider (данный интерфейс также описан в документации Ascon Pilot SDK) перед началом использования.","keywords":[]},"pages/webserver/interfaces/IObjectCardHandler.html":{"title":"Интерфейс IObjectCardHandler","content":"Интерфейс позволяет реализовать работу с атрибутами, отображаемыми в карточке объекта.\nimport { AttributeValueChangedEventArgs, IAttribute, IAttributeModifier, IObjectCardHandler, ObjectCardContext } from \"@pilotdev/pilot-web-sdk\"; export class ObjectCardHandlerSample implements IObjectCardHandler { handle ( modifier: IAttributeModifier, context: ObjectCardContext ): void {... } onValueChanged ( sender: IAttribute, args: AttributeValueChangedEventArgs, modifier: IAttributeModifier ): void {... }\n}\nIObjectCardHandler.handle\nМетод handle вызывается при каждом построении карточки объекта: при показе диалогов создания и редактирования объекта, при выборе объектов, для которых отображается карточка, в Обозревателе документов. В случае, если карточка находится в режиме редактирования существующего объекта, свойство editingObject аргумента context возвращает сам объект, атрибуты которого показаны в карточке; и null, если карточка показана для создания нового объекта.\nhandle ( modifier: IAttributeModifier, context: ObjectCardContext ): void\nгде:\nmodifier - интерфейс, позволяющий задавать новые значения для атрибутов.\ncontext - контекст отображения карточки.\nIObjectCardHandler.onValueChanged\nМетод onValueChanged вызывается при изменении пользователем значения какого-либо из отображаемых атрибутов в карточке объекта. Аргумент sender возвращает атрибут, значение которого было изменено. Аргумент args позволяет получить доступ к аргументам события: предыдущему и новому значению атрибута, а также контексту карточки объекта. modifier позволяет отреагировать на изменения и установить новое значение дополнительно одному или нескольким атрибутам. Изменения в значениях атрибутов, которые были сделаны с помощью modifier, не приводят к вызовам метода onValueChanged.\nonValueChanged ( sender: IAttribute, args: AttributeValueChangedEventArgs, modifier: IAttributeModifier ): void\nгде:\nsender - интерфейс, позволяющий добавлять различные элементы в меню.\nargs - контекст, позволяющий получить дополнительные сведения о селектированных элементах.\nmodifier - контекст, позволяющий получить дополнительные сведения о селектированных элементах.","keywords":[]},"pages/client/ice/template/ITaskTemplateParser.html":{"title":"ITaskTemplateParser","content":"Шаблоны заданий и процессов сохраняются как дочерние объекты корневого объекта шаблонов заданий, который можно получить по его системному идентификатору SystemObjectIds.TaskTemplateRootObjectId. Он может включать объекты двух типов: непосредсвенно шаблоны заданий и процессов - объекты системного типа SystemTypeNames.TASK_TEMPLATE; и папки шаблонов - объекты системного типа SystemTypeNames.TASK_TEMPLATE_FOLDER. Таким образом можно организовать древовидную систему хранения шаблонов.\nОбъекты шаблонов заданий и процессов хранят содержимое в сериализованном виде как строковое значение системного атрибута SystemAttributeNames.TASK_TEMPLATE_VALUE. Для десериализации шаблона задания и получения доступа к его составляющим используется интерфейс ITaskTemplateParser. Пример Ascon.Pilot.SDK.TaskSample включает в себя демонстрацию получения шаблонов заданий и использования этого интерфейса для выдачи заданий и процессов на основе этих шалонов.\nДля получения доступа к интерфейсу поиска его необходимо передать в конструктор. При этом конструктор необходимо пометить атрибутом ImportingConstructor.\nITaskTemplateItem Parse(string stringTemplateValue)\nМетод используется для получения составляющих шаблона задания или процесса из сериализованного в строку значения шаблона.\nvar template = _taskTemplateParser. Parse (templateStr);\nгде:\ntemplate - десериализованное представление шаблона, объект типа ITaskTemplateItem;\n_taskTemplateParser - экземпляр объекта, реализующего интерфейс ITaskTemplateParser;\ntemplateStr - исходное сериализованное строковое представление шаблона, которое было получено из атрибута объекта шаблона;","keywords":[]},"pages/webserver/sborka/ts-nastroyka.html":{"title":"Настройка TypeScript-расширения","content":"Чтобы создать новое TypeScript-расширение для Pilot-Web-Server выполните следующие действия:\nУстановите Node.js.\nСоздайте проект с помощью пакетного менеджера npm командой\nnpm init\nМожно пользоваться и другими пакетными менеджерами (например, yarn ), однако примеры будут приведены для npm.\nОткройте терминал в окружении проекта и выполните команды:\nnpm i @pilotdev/pilot-web-sdk\nnpm i --save-dev typescript ts-loader webpack webpack-cli copy-webpack-plugin\nДобавьте в package.json в блок scripts строчки:\n{ \"scripts\": {..., + \"build\": \"webpack\", + \"build-prod\": \"webpack --config webpack.prod.config.js\" }, \"dependencies\": {... },... }\nСоздайте файл src\\assets\\extensions.config.json с содержимым:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"ext_name\", \"entry\": \"ext_name.js\", \"modules\": [ ] } }\nи заполните поля author, license, title, version, name, a так же поле entry по шаблону [name].js, где [name] - значение поля name. Например: ext_name.js.\nИнтерактивные подсказки и валидация в IDE\nВ начале файла добавьте поле $schema со значением пути, указывающим на схему extensions.config.schema.json из пакета @pilotdev/pilot-web-sdk\n{ \"$schema\": \"../../../node_modules/@pilotdev/pilot-web-sdk/extensions.config.schema.json\",... }\nДобавьте в корневую папку файл tsconfig.json командой\nnpx tsc --init\nДобавьте в корневую папку файл webpack.config.js с содержимым:\nconst ModuleFederationPlugin = require ( 'webpack/lib/container/ModuleFederationPlugin' ); const CopyPlugin = require ( \"copy-webpack-plugin\" ); module. exports = [{ mode: \"development\", entry: { main: './src/index.ts' }, module: { rules: [{ test: /\\.tsx?$/, use: 'ts-loader', exclude: /node_modules/ }] }, resolve: { extensions: [ \".tsx\", \".ts\", \".jsx\", \".js\", \".json\" ], }, output: { publicPath: 'auto', uniqueName: 'ext_name', scriptType: 'text/javascript', filename: '[name].js', clean: true }, optimization: { // fix a temporary bug runtimeChunk: false }, plugins: [ new ModuleFederationPlugin ({ name: 'ext_name', library: { type: 'var', name: '[name]' }, filename: '[name].js', exposes: [], shared: { '@pilotdev/pilot-web-sdk': { singleton: true, } } }), new CopyPlugin ({ patterns: [ { from: \"./src/assets/extensions.config.json\", to: \"extensions.config.json\" } ], }), ]\n}]\nи заполните поле uniqueName в блоке output и поле name в параметре конструктора ModuleFederationPlugin. Значения должны совпадать со значением name из extensions.config.json.\nДобавьте в корневую папку файл webpack.prod.config.js с содержимым:\nconst { merge } = require ( \"webpack-merge\" ); const dev = require ( \"./webpack.config.js\" ); module. exports = merge (dev, { mode: \"production\",\n});\nСоздайте файл src\\app\\extensionSample.ts, в котором будет содержаться логика расширения, например:\nimport { IMenu, IMenuBuilder, ObjectsViewContext } from \"@pilotdev/pilot-web-sdk\"; export class ExtensionSample extends IMenu < ObjectsViewContext > { build ( builder: IMenuBuilder, context: ObjectsViewContext ): void { } onMenuItemClick ( name: string, context: ObjectsViewContext ): void { }\n}\nВ файлы webpack.config.js и webpack.prod.config.js добавьте информацию о реализуемых интерфейсах из sdk в поле exposes конструктора плагина ModuleFederationPlugin в формате [интерфейс]:[путь к файлу].\nconst ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');\nconst CopyPlugin = require(\"copy-webpack-plugin\");\nmodule.exports = [{ mode: \"development\", entry: {main: './src/index.ts'}, module: { rules: [{ test: /\\.tsx?$/, use: 'ts-loader', exclude: /node_modules/ }] }, resolve: { extensions: [\".tsx\", \".ts\", \".jsx\", \".js\", \".json\"], }, output: { publicPath: 'auto', uniqueName: 'ext_name', scriptType: 'text/javascript', filename: '[name].js', clean: true }, optimization: { // fix a temporary bug runtimeChunk: false }, plugins: [ new ModuleFederationPlugin({ name: 'ext_name', library: { type: 'var', name: '[name]' }, filename: '[name].js', - exposes: [], + exposes: [ + {'IMenu<ObjectsViewContext>': './src/app/extensionSample.ts'} + ], shared: { '@pilotdev/pilot-web-sdk': { singleton: true, } } }), new CopyPlugin({ patterns: [ { from: \"./src/assets/extensions.config.json\", to: \"extensions.config.json\" } ], }), ]\n}]\nТак же в файл extensions.config.json в блок extension.modules добавьте информацию о созданных классах в поля ngModuleName (имя класса) и exposedInterface (реализуемый интерфейс), например:\n{ \"manifestVersion\": 1, \"author\": \"\", \"license\": \"\", \"title\": \"\", \"version\": \"\", \"extension\": { \"name\": \"ext_name\", \"entry\": \"ext_name.js\", - \"modules\": [], + \"modules\": [ + { \"ngModuleName\":\"ExtensionSample\", \"exposedInterface\":\"IMenu<ObjectsViewContext>\" } + ] } }","keywords":[]},"pages/client/ice/crypto/crypto.html":{"title":"Интерфейсы для реализации подписания документов сторонними криптоалгоритмами","content":"С помощью интерфейсов подписания можно реализовать свою логику подписания и валидации ЭП документов.","keywords":[]},"pages/client/ice/pdf/IPdfStamper.html":{"title":"Интерфейс IPdfStamper","content":"Интерфейс позволяет реализовать логику наложения штампов на PDF документы. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IPdfStamper и обязательно пометить класс, реализующий интерфейс атрибутом [Export] (см. пример PdfStamper из комплекта SDK).\nМетод вызывается при загрузке документа для отображения в интерфейсе Pilot. Возвращаемое значение учитывается при добавлении кнопки \"Отобразить штампы\" в панель инструментов просмотрщика документов: в случае возвращения true - кнопка будет добавлена, в противном случае нет. Подробнее см. PdfDocumentContext.\nbool CanAddStamps (PdfDocumentContext context);\nгде:\ncontext - контекст отображаемого документа, подробнее см. PdfDocumentContext.\nМетод вызывается при нажатии кнопки \"Отобразить штампы\", при отправке документа на печать, а также при выгрузке на диск и экспорте.\nvoid AddStamps (Stream stream, PdfStamperMode mode, PdfDocumentContext context);\nгде:\nstream - поток файла;\nmode - режим при добавлении штампов, подробнее см. PdfStamperMode;\ncontext - контекст документа;\nМетод вызывается при перемещении штампа на документе.\nvoid OnStampPositionChanged (StampPositionArgs args);\nгде:\nargs - аргументы события перемещения штампа, подробнее см. StampPositionArgs.","keywords":[]},"pages/client/ice/calendar/calendar.html":{"title":"Интерфейсы и данные для работы с календарём рабочих дней","content":"Чтобы добавить свой тип события рабочего календаря, нужно добавить в конфигурацию тип с префиксом calendar_exception_ в названии.","keywords":[]},"pages/client/bim/IModelTab.html":{"title":"Интерфейс IModelTab","content":"Интерфейс для работы с вкладкой Информационная модель, позволяет получать интерфейсы для работы с главной панелью инструментов и боковой панелью. Наследует интерфейс ITab.\nСвойства IModelTab.IModelViewer\nИнтерфейс сцены модели, позволяет работать с представлением модели. Значение null означает, что модель не загружена.\nIModelViewer ModelViewer { get; }\nМетоды IModelTab.GetToolbarManager\nМетод позволяет получить интерфейс для работы с панелью инструментов.\nIToolbarManager GetToolbarManager ()\nIModelTab.GetSidebarManager\nМетод позволяет получить интерфейс для работы с боковой панелью.\nISidebarManager GetSidebarManager ();\nСобытия IModelTab.Disposed\nСобытие оповещает о закрытии вкладки.\nevent EventHandler Disposed","keywords":[]},"pages/client/ice/ui/INewTabPage.html":{"title":"Интерфейс INewTabPage","content":"Для того, чтобы встроить расширение в новую вкладку главного окна клиента Pilot необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK INewTabPage. Обязательно пометить класс, реализующий интерфейс INewTabPage, атрибутом [Export]\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace WpfExtension\n{ [ Export ( typeof (INewTabPage))] public class MainModule: INewTabPage { public void BuildNewTabPage (INewTabPageHost host) { } public void OnButtonClick (string name) { } }\n}\nINewTabPage.BuildNewTabPage\nМетод вызывается перед тем, как будет построена вкладка Новая вкладка.\nvoid INewTabPage. BuildNewTabPage (INewTabPageHost host);\nгде:\nhost - интерфейс, позволяющий добавлять кнопки.\nИнтерфейс содержит методы для добавления кнопок и групп на главную страницу Pilot: Метод SetGroup создаёт или обновляет группу кнопок с указанным заголовком\nvoid INewTabPageHost. SetGroup (string title, Guid groupId)\nгде:\ntitle локализованный заголовок группы\ngroupId идентификатор группы для использования в методе AddButtonToGroup\nМетод AddButtonToGroup служит для добавления кнопки в ранее созданную группу\nvoid INewTabPageHost. AddButtonToGroup (string title, string name, string toolTip, byte[] svgIcon, Guid groupId);\nгде:\ntitle - локализованное название кнопки;\nname - уникальное имя кнопки в пределах расширения;\ntoolTip - локализованная подсказка, расположенная под названием кнопки;\nsvgIcon - массив байт SVG иконки. Клиент поддерживает иконки только в svg формате.\ngroupId - идентификатор группы кнопок.\nМетод AddButton используется для добавления кнопки в группу по умолчанию, имеющую название \"Модули расширения\". Обеспечивает обратную совместимость.\nvoid INewTabPageHost. AddButton (string title, string name, string toolTip, byte[] svgIcon);\nгде:\ntitle - локализованное название кнопки;\nname - уникальное имя кнопки в пределах расширения;\ntoolTip - локализованная подсказка, расположенная под названием кнопки;\nsvgIcon - массив байт SVG иконки. Клиент поддерживает иконки только в svg формате.\nNewTabPage.OnButtonClick\nМетод вызывается при нажатии на кнопку, созданную расширением в методе BuildNewTabPage.\nvoid INewTabPage. OnButtonClick (string name);\nгде:\nname - уникальное имя кнопки, по которой произошло нажатие.","keywords":[]},"pages/client/ice/crypto/IDocumentCryptoProvider.html":{"title":"IDocumentCryptoProvider","content":"Внимание\nЭтот интерфейс является устаревшим. Используйте ICryptoProvider\nИнтерфейс позволяет зарегистрировать в Pilot свою логику подписания и валидации ЭП документов. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IDocumentCryptoProvider и обязательно пометить класс, реализующий интерфейс IDocumentCryptoProvider атрибутом [Export].\nВ системе Pilot может быть только один зарегистрированный экземпляр IDocumentCryptoProvider.\n[ Export ( typeof (IDocumentCryptoProvider))] public class DocumentCryptoProvider: IDocumentCryptoProvider\n{...\n}\nbool IsKnownSignature(IDataObject document, IFilesSnapshot snapshot, ISignatureRequest signatureRequest);\nМетод вызывается только для подписанных запросов на подпись и служит для определения, готов ли IDocumentCryptoProvider прочитать информацию из подписи. Если метод вернет false, для чтения информации об электронной подписи будут использованы базовые алгоритмы Pilot.\nАргументы:\ndocument - документ;\nsnapshot - версия документа, для которой происходит чтение данных;\nsignatureRequest - подписанный запрос на подпись, для которого необходимо будет прочитать информацию;\nvoid Sign(IDataObject document, Stream xpsStream, IEnumerable signatureRequests);\nМетод вызывается для подписания документа.\nАргументы:\ndocument - документ;\nxpsStream - поток XPS документа со встроенными графическими слоями. Соответствует содержимому XPS документа при сохранении на диск.\nsignatureRequests - запросы на подпись для подписания;\nvoid ShowCertificate(IDataObject document, IFilesSnapshot snapshot, ISignatureRequest signatureRequest);\nМетод вызывается при вызове команды \"Показать сертификат\".\nАргументы:\ndocument - документ;\nsnapshot - версия документа, для которой происходит чтение данных.\nsignatureRequest - подписанный запрос на подпись, для которого необходимо показать сертификат;\nvoid ReadSignature(IDataObject document, Stream xpsStream, IFilesSnapshot snapshot, ISignatureRequest signatureRequest, IReadSignatureListener listener);\nМетод вызывается для получения информации о подписанном запросе на подпись.\nАргументы:\ndocument - документ;\nxpsStream - поток XPS документа со встроенными графическими слоями. Соответствует содержимому XPS документа при сохранении на диск.\nsnapshot - версия документа, для которой происходит чтение данных.\nsignatureRequest - запрос на подпись, для которого будет выполнено чтение;\nlistener - используется для заполнения информации о прочитанной электронной подписи;","keywords":[]},"pages/client/ice/template/template.html":{"title":"Интерфейсы для работы с шаблонами","content":"Шаблоны хранятся в сериализованном виде как строковое значение специальных системных атрибутов. Для того чтобы получить содержимое шаблона необходимо десериализовать это строковое значение.","keywords":[]},"pages/client/ice/crypto/ICertificateSelector.html":{"title":"Интерфейс ICertificateSelector","content":"Интерфейс ICertificateSelector используется для выбора сертификата для подписания через API. По умолчанию, если плагин, реализующий интерфейс ICryptoProvider, при подписании вернёт несколько сертификатов, будет показан диалог выбора сертификата.\nОбъявление экспортного типа ICertificateSelector в модуле расширения перекрывает базовое поведение и позволяет реализовать свою логику выбора сертификата.\nВ системе Pilot может быть только один зарегистрированный экземпляр ICertificateSelector.\n[ Export ( typeof (ICertificateSelector))] public class CustomCertificateSelector: ICertificateSelector\n{...\n}","keywords":[]},"pages/client/ice/crypto/ICryptoProvider.html":{"title":"ICryptoProvider","content":"Интерфейс позволяет зарегистрировать в Pilot свою логику подписания и валидации ЭП документов. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK ICryptoProvider и обязательно пометить класс, реализующий интерфейс ICryptoProvider атрибутом [Export].\nВ системе Pilot может быть несколько экземпляров ICryptoProvider.\n[ Export ( typeof (ICryptoProvider))] public class CryptoProvider: ICryptoProvider\n{...\n}\nМетоды\nIEnumerable<ICertificate> GetCertificates ();\nМетод возвращает список сертификатов, поддерживаемых расширением. Подробнее см ICertificate\nvoid Sign ( Guid documentId, IFile file, Stream stream, ICertificate cert, IEnumerable<ISignatureRequest> signatureRequests );\nМетод подписывает документ. Подпись должна быть создана в формате base64 а также файлу подписи должно быть присвоено расширение.sig.\nгде:\ndocumentId - идентификатор документа;\nfile - подписываемый файл;\nstream - последовательность байт подписываемого файла;\ncert - сертификат для подписания;\nsignatureRequests - список запросов на подпись;\nbool IsAlgorithmSupported ( string algorithmOid );\nОпределяет, поддерживается ли криптоалгоритм расширением.\nгде:\nalgorithmOid - идентификатор алгоритма;\nbool IsAlgorithmSupported ( byte [] sigBase64 );\nОпределяет, поддерживается ли сертификат подписи расширением. Проверка необходима при импорте подписи, когда криптоалгоритм неизвестен.\nгде:\nsigBase64 - подпись в формате base64;\nvoid ReadSignature ( IDataObject document, Stream xpsStream, IFilesSnapshot snapshot, ISignatureRequest signatureRequest, IReadSignatureListener listener );\nМетод вызывается для получения информации о подписанном запросе на подпись.\nАргументы:\ndocument - документ;\nxpsStream - поток документа;\nsnapshot - версия документа, для которой происходит чтение данных;\nsignatureRequest - запрос на подпись, для которого будет выполнено чтение;\nlistener - используется для заполнения информации о прочитанной электронной подписи;\nvoid ReadImportedSignature ( Stream file, byte [] sigBase64, IImportedSignatureListener importedSignatureListener );\nМетод вызывается для получения информации об импортируемой подписи.\nАргументы:\nfile - поток документа;\nsigBase64 - импортируемая подпись в формате base64;\nimportedSignatureListener - используется для заполнения информации об импортируемой электронной подписи;\nИнтерфейс IReadSignatureListener\nЭтот интерфейс используется для заполнения информации о прочитанной электронной подписи.\nvoid CertificateIsValid ();\nВызовите этот метод, если сертификат, использованный для подписания, корректен.\nvoid CertificateIsInvalid (string message);\nВызовите этот метод, если сертификат, использованный для подписания, некорректен.\nvoid SignatureIsValid ();\nВызовите этот метод, если подпись соответствует подписанному содержимому.\nvoid SignatureIsInvalid (string message);\nВызовите этот метод, если подпись не соответствует подписанному содержимому.\nvoid SetSignerName (string name);\nВызовите этот метод для вывода имени подписанта.\nvoid SetSignDate (string signDate);\nВызовите этот метод для вывода времени подписания.\nvoid SetCustomState (ImageSource icon, string title, string description);\nВызовите этот метод для установки пользовательского состояния запроса на подпись (иконка и тултип).\nvoid SetSignerNameForeground (Color color);\nВызовите этот метод для установки цвета текста имени подписанта.\nvoid ReadCompleted ();\nВызовите этот метод для окончания чтения информации из электронной подписи.\nИнтерфейс IImportedSignatureListener\nЭтот интерфейс используется для заполнения информации об импортируемой электронной подписи.\nvoid CertificateIsValid ();\nВызовите этот метод, если сертификат, использованный для подписания, корректен.\nvoid CertificateIsInvalid (string message);\nВызовите этот метод, если сертификат, использованный для подписания, некорректен.\nvoid SignatureIsValid ();\nВызовите этот метод, если подпись соответствует подписанному содержимому.\nvoid SignatureIsInvalid (string message);\nВызовите этот метод, если подпись не соответствует подписанному содержимому.\nvoid SetPublicKeyOid (string oid);\nВызовите этот метод для того, чтобы установить идентификатор криптоалгоритма.\nvoid SetCadesType (CadesType cadesType);\nВызовите этот метод для того, чтобы установить тип CadesType импортируемой подписи.\nvoid ReadCompleted ();\nВызовите этот метод для окончания чтения информации из электронной подписи.","keywords":[]},"pages/client/ice/pdf/PdfDocumentContext.html":{"title":"PdfDocumentContext","content":"Класс, описывающий контекст отображаемого документа.\nСвойства\nIDataObject Document { get; }\nОбъект документа\nDateTime Version { get; }\nВерсия","keywords":[]},"pages/client/ice/pdf/StampPositionArgs.html":{"title":"StampPositionArgs","content":"Класс, описывающий аргументы события перемещения штампа на документе.\nСвойства\nstring StampId { get; }\nИдентификатор штампа\ndouble X { get; }\nКоордината X после перемещения\ndouble Y { get; }\nКоордината Y после перемещения\nPdfDocumentContext Context { get; }\nКонтекст документа","keywords":[]},"pages/client/ice/crypto/IAutomationSigner.html":{"title":"Интерфейс IAutomationSigner","content":"Интерфейс IAutomationSigner используется для подписания документа в контексте выполнения скрипта автоматизации (интерфейс IAutomationActivity ). Доступ к плагину, реализующего интерфейс IAutomationSigner, можно получить через IDigitalSigner.\n[ Export ( typeof (IAutomationSigner))] public class AutomationSigner: IAutomationSigner\n{...\n}\nМетоды\nIEnumerable<ICertificate> GetCertificates ();\nМетод возвращает список сертификатов, поддерживаемых расширением. Подробнее см ICertificate\nvoid Sign ( IObjectModifier modifier, Guid documentId, IFile file, Stream stream, ICertificate cert, IEnumerable<ISignatureRequest> signatureRequests );\nМетод подписывает документ. Подпись должна быть создана в формате base64 а также файлу подписи должно быть присвоено расширение.sig.\nгде:\nmodifier - объект модификатора с изменениями, созданными автоматизацией.\ndocumentId - идентификатор документа;\nfile - подписываемый файл;\nstream - последовательность байт подписываемого файла;\ncert - сертификат для подписания;\nsignatureRequests - список запросов на подпись;\nbool IsAlgorithmSupported ( string algorithmOid );\nОпределяет, поддерживается ли криптоалгоритм расширением.\nгде:\nalgorithmOid - идентификатор алгоритма;","keywords":[]},"pages/client/ice/calendar/IWorkCalendarObject.html":{"title":"IWorkCalendarObject","content":"Обёртка над WorkCalendar\nGuid ObjectId { get; }\nИдентификатор объекта рабочего календаря.\nWorkCalendar Schedule { get; }\nРабочий календарь.","keywords":[]},"pages/client/ice/calendar/IWorkCalendarExceptionObject.html":{"title":"IWorkCalendarExceptionObject","content":"Обёртка над WorkCalendarException\nGuid ObjectId { get; }\nИдентификатор объекта события рабочего календаря.\nWorkCalendar Schedule { get; }\nСобытие рабочего календаря.","keywords":[]},"pages/client/ice/calendar/WorkCalendar.html":{"title":"WorkCalendar","content":"Рабочий календарь.\nList< int > OrgUnits { get; set; }\nСписок организационных единиц, к которым относиться рабочий календарь.\nList< int > People { get; set; }\nСписок пользователей, к которым относиться рабочий календарь.\nDateTime? FromDate { get; set; }\nДата, с которой начинает действовать рабочий календарь. Действие неограниченно, если значение не указано.\nDateTime? ToDate { get; set; }\nДата, до которой действует рабочий календарь. Действие неограниченно, если значение не указано.\nWeekdays Weekdays { get; set; }\nОписывает часы работы на каждый день недели.","keywords":[]},"pages/client/ice/calendar/Weekdays.html":{"title":"Weekdays","content":"Описывает часы работы на каждый день недели. День считается выходным, если коллекция пустая.\nList<WorkingHours> Mon { get; set; }\nРабочие часы для понедельника.\nList<WorkingHours> Tue { get; set; }\nРабочие часы для вторника.\nList<WorkingHours> Wed { get; set; }\nРабочие часы для среды.\nList<WorkingHours> Thur { get; set; }\nРабочие часы для четверга.\nList<WorkingHours> Fri { get; set; }\nРабочие часы для пятницы.\nList<WorkingHours> Sat { get; set; }\nРабочие часы для субботы.\nList<WorkingHours> Sun { get; set; }\nРабочие часы для воскресенья.","keywords":[]},"pages/client/ice/calendar/WorkCalendarException.html":{"title":"WorkCalendarException","content":"Рабочий календарь.\nList< int > OrgUnits { get; set; }\nСписок организационных единиц, к которым относиться рабочий календарь.\nList< int > People { get; set; }\nСписок пользователей, к которым относиться рабочий календарь.\nDateTime? FromDate { get; set; }\nДата, с которой начинает действовать рабочий календарь. Действие неограниченно, если значение не указано.\nDateTime? ToDate { get; set; }\nДата, до которой действует рабочий календарь. Действие неограниченно, если значение не указано.\nList<WorkingHours> WorkingHours { get; set; }\nОписывает рабочие часы текущего дня. Выходной, если коллекция пустая. Переписывает рабочие часы календаря рабочих дней и менее приоритетных событий.","keywords":[]},"pages/client/ice/calendar/IWorkingCalendarService.html":{"title":"IWorkingCalendarService","content":"Базовый класс, позволяющий получить описание для конкретного рабочего дня. Пример того, как полученные данные можно пересчитать в локальное времся выбранного пользователя, можно найти в расширении Ascon.Pilot.SDK.CalendarSample.\nМетоды и события\nevent EventHandler<CalendarChangedEventArgs> OnChanged;\nСоздаёт слабую подписку на изменение рабочего графика и событий календаря.\nTask<ICalendarDay> GetPersonCalendarDayAsync ( int personId, DateTime date );\nВозвращает описание рабочего дня для заданного пользователя,\nгде:\npersonId - идентификатор пользователя;\ndate - локальная дата описываемого дня;\nTask<ICalendarDay> GetOrgUnitCalendarDayAsync ( int orgunitId, DateTime date );\nВозвращает описание рабочего дня для заданной должности или подразделения,\nгде:\norgunitId - идентификатор должности или подразделения;\ndate - локальная дата описываемого дня;","keywords":[]},"pages/client/ice/crypto/IDigitalSigner.html":{"title":"Интерфейс IDigitalSigner","content":"Интерфейс позволяет получить управление над экземпляром плаигна, реализующего интерфейсы ICryptoProvider и IAutomationSigner, и с их помощью подписывать запросы на подпись в документах. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIDigitalSigner.Sign\nМетод подписывает документ выбранным сертификатом. Вызовов метода делегирует работу ICryptoProvider\nvoid Sign (Guid documentId, IFile file, Stream stream, ICertificate cert, IEnumerable<ISignatureRequest> signatureRequests);\nгде:\ndocumentId - идентификатор документа.\nfile - подписываемый файл.\nstream - стрим подписываемого файла.\ncert - сертификат, с помощью которого будет выполнено подписание.\nsignatureRequests - подписываемые запросы на подпись.\nIDigitalSigner.SignByAutomation\nМетод подписывает документ выбранным сертификатом при работе скриптов автоматизации. Вызовов метода делегирует работу IAutomationSigner.\nvoid SignByAutomation (IObjectModifier modifier, Guid documentId, IFile file, Stream stream, ICertificate cert, IEnumerable<ISignatureRequest> signatureRequests);\nгде:\nmodifier - объект модификатора с изменениями, созданными автоматизацией.\ndocumentId - идентификатор документа.\nfile - подписываемый файл.\nstream - стрим подписываемого файла.\ncert - сертификат, с помощью которого будет выполнено подписание.\nsignatureRequests - подписываемые запросы на подпись.\nIDigitalSigner.GetCertificate\nМетод позволяет получить серитфикат для подписания. Вызовов метода делегирует работу ICryptoProvider\nICertificate GetCertificate ();\nIDigitalSigner.GetAutomationCertificate\nМетод позволяет получить серитфикат для подписания при работе скриптов автоматизации. Вызовов метода делегирует работу IAutomationSigner.\nICertificate GetAutomationCertificate ();","keywords":[]},"pages/client/ice/calendar/TimeOnly.html":{"title":"TimeOnly","content":"Описывает время в часах и минутах.\nbyte Hour { get; set; }\nЧасы.\nbyte Minute { get; set; }\nМинуты.","keywords":[]},"pages/client/bim/IModelManager.html":{"title":"Интерфейс IModelManager","content":"Интерфейс для работы с моделями, позволяет получать интерфейсы сцены для моделей и включает в себя события, которые оповещают о состоянии моделей.\nМетоды IModelManager.GetViewers\nМетод позволяет получить интерфейсы сцены для модели.\nIEnumerable<IModelViewer> GetViewers ( Guid modelId )\nгде:\nmodelId - идентификатор модели.\nСобытия IModelManager.ModelOpened\nСобытие оповещает об открытии модели на сцене.\nevent EventHandler<ModelEventArgs> ModelOpened\nIModelManager.ModelLoaded\nСобытие оповещает об окончании загрузки модели на сцене.\nevent EventHandler<ModelEventArgs> ModelLoaded\nIModelManager.ModelClosed\nСобытие оповещает о закрытии модели на сцене.\nevent EventHandler<ModelEventArgs> ModelClosed","keywords":[]},"pages/client/bim/ITab.html":{"title":"Интерфейс ITab","content":"Общий интерфейс вкладок IModelTab и IServerManagerTab\nСвойства ITab.Id\nИдентификатор вкладки.\nGuid Id { get; }","keywords":[]},"pages/client/bim/IServerManagerTab.html":{"title":"Интерфейс IServerManagerTab","content":"Интерфейс представляющий вкладку \"Диспетчер сервреных операций\". Наследует интерфейс ITab.","keywords":[]},"pages/client/bim/IModelStorage.html":{"title":"Интерфейс IModelStorage","content":"Интерфейс для работы с данными модели, позволяет получать версии модели, элементы модели, их свойства и геометрию.\nСвойства IModelStorage.IsLoaded\nФлаг состояния готовности к обработке вызовов пользователя.\nbool IsLoaded { get; }\nIModelStorage.ModelId\nИдетификатор модели.\nGuid ModelId { get; }\nМетоды IModelStorage.GetVersions\nМетод позволяет получить все версии модели.\nIEnumerable<DateTime> GetVersions ()\nIModelStorage.GetModelPartsIds\nМетод позволяет получить все идентификаторы частей модели.\nIEnumerable<Guid> GetModelPartsIds ()\nIModelStorage.LoadRootElements\nМетод позволяет получить корневые элементы модели.\nIEnumerable<IModelElement> LoadRootElements ( DateTime version )\nгде:\nversion - версия модели.\nIModelStorage.LoadElements\nМетод позволяет получить все элементы для части модели.\nIEnumerable<IModelElement> LoadElements ( Guid modelPartId, DateTime version )\nгде:\nmodelPartId - идентификатор части модели.\nversion - версия модели.\nIModelStorage.LoadElement\nМетод позволяет получить элемент.\nIModelElement LoadElement ( IModelElementId id, DateTime version )\nгде:\nid - идентификатор элемента.\nversion - версия модели.\nIModelStorage.LoadChildElements\nМетод позволяет получить дочерние элементы для элемента.\nIEnumerable<IModelElement> LoadChildElements ( IModelElementId parentId, DateTime version )\nгде:\nparentId - идентификатор родительского элемента.\nversion - версия модели.\nIModelStorage.LoadElementProperties\nМетод позволяет получить свойства для элемента.\nIEnumerable<IPropertySet> LoadElementProperties ( IModelElementId id, DateTime version )\nгде:\nid - идентификатор элемента.\nversion - версия модели.\nIModelStorage.LoadElementMeshInstances\nМетод позволяет получить перечисление геометрий для элемента.\nIEnumerable<IMeshInstance> LoadElementMeshInstances ( IModelElementId id, DateTime version )\nгде:\nid - идентификатор элемента.\nversion - версия модели.\nIModelStorage.LoadMeshDefinition\nМетод позволяет получить определение геометрии (полигональную сетку).\nIMeshDefinition LoadMeshDefinition ( IMeshDefinitionId id )\nгде:\nid - идентификатор геометрии.\nСобытия IModelStorage.Loaded\nСобытие оповещает о готовности к обработке вызовов пользователя.\nevent EventHandler Loaded","keywords":[]},"pages/client/bim/IModelViewer.html":{"title":"Интерфейс IModelViewer","content":"Интерфейс сцены модели, позволяет работать с представлением модели.\nСвойства IModelViewer.ModelId\nИдентификатор модели.\nGuid ModelId { get; }\nIModelViewer.TabId\nИдентификатор вкладки.\nGuid TabId { get; }\nIModelViewer.ModelVersion\nТекущая версия модели.\nDateTime ModelVersion { get; }\nМетоды IModelViewer.IsModelPartLoaded\nМетод позволяет получить флаг состояния загрузки части модели.\nbool IsModelPartLoaded ( Guid modelPartId )\nгде:\nmodelPartId - идентификатор части модели.\nIModelViewer.GetSelection\nМетод позволяет получить идентификаторы выбранных элементов.\nIEnumerable<IModelElementId> GetSelection ()\nIModelViewer.Select\nМетод позволяет добавить элементы к уже выбранным.\nvoid Select ( IEnumerable<IModelElementId> ids )\nгде:\nids - идентификаторы элементов.\nIModelViewer.IsolateSelection\nМетод позволяет изолировать выбранные элементы (скрыть все, кроме выбранных элементов).\nvoid IsolateSelection ()\nIModelViewer.ClearSelection\nМетод позволяет сбросить выбор элементов.\nvoid ClearSelection ()\nIModelViewer.GetVisibleElements\nМетод позволяет получить идентификаторы видимых элементов.\nIEnumerable<IModelElementId> GetVisibleElements ()\nIModelViewer.GetHiddenElements\nМетод позволяет получить идентификаторы скрытых элементов.\nIEnumerable<IModelElementId> GetHiddenElements ()\nIModelViewer.IsVisible\nМетод позволяет получить видимость элемента.\nbool IsVisible ( IModelElementId id )\nгде:\nid - идентификатор элемента.\nIModelViewer.Show\nМетод позволяет сделать элементы видимыми.\nvoid Show ( IEnumerable<IModelElementId> ids )\nгде:\nids - идентификаторы элементов.\nМетод позволяет сделать часть модели видимой.\nvoid Show ( Guid modelPartId )\nгде:\nmodelPartId - идентификатор части модели.\nIModelViewer.Hide\nМетод позволяет скрыть элементы.\nvoid Hide ( IEnumerable<IModelElementId> ids )\nгде:\nids - идентификаторы элементов.\nМетод позволяет скрыть часть модели.\nvoid Hide ( Guid modelPartId )\nгде:\nmodelPartId - идентификатор части модели.\nIModelViewer.ExpandTreeNode\nМетод позволяет раскрыть элемент в дереве.\nvoid ExpandTreeNode ( IModelElementId id, int levels )\nгде:\nid - идентификатор элемента.\nlevels - количество вложенных уровней элемента для раскрытия (0 - раскрывается только сам элемент).\nIModelViewer.CollapseTreeNode\nМетод позволяет свернуть элемент в дереве.\nvoid CollapseTreeNode ( IModelElementId id, int levels )\nгде:\nid - идентификатор элемента.\nlevels - количество вложенных уровней элемента для сворачивания (0 - сворачивается только сам элемент).\nIModelViewer.SetColor\nМетод позволяет задать цвет для элементов.\nvoid SetColor ( IEnumerable<IModelElementId> ids, Color color )\nгде:\nids - идентификаторы элементов.\ncolor - цвет.\nМетод позволяет задать цвет для части модели.\nvoid SetColor ( Guid modelPartId, Color color )\nгде:\nmodelPartId - идентификатор части модели.\ncolor - цвет.\nIModelViewer.ClearColors\nМетод позволяет сбросить цвета для элементов.\nvoid ClearColors ( IEnumerable<IModelElementId> ids )\nгде:\nids - идентификаторы элементов.\nМетод позволяет сбросить цвета для части модели.\nvoid ClearColors ( Guid modelPartId )\nгде:\nmodelPartId - идентификатор части модели.\nIModelViewer.FitToView\nМетод позволяет масштабировать сцену по всем элементам.\nvoid FitToView ()\nМетод позволяет масштабировать сцену по заданным элементам.\nvoid FitToView ( IEnumerable<IModelElementId> ids )\nгде:\nids - идентификаторы элементов.\nМетод позволяет масштабировать сцену по части модели.\nvoid FitToView ( Guid modelPartId )\nгде:\nmodelPartId - идентификатор части модели.\nIModelViewer.GetCameraPosition\nМетод позволяет получить текущее положение камеры.\nICameraPosition GetCameraPosition ()\nIModelViewer.SetCameraPosition\nМетод позволяет задать положение камеры.\nvoid SetCameraPosition ( ICameraPosition cameraPosition )\nгде:\ncameraPosition - положение камеры.\nIModelViewer.GetClipPlanes\nМетод позволяет получить секущие плоскости.\nIEnumerable<IClipPlane> GetClipPlanes ()\nIModelViewer.AddClipPlane\nМетод позволяет добавить секущую плоскость, возвращает идентификатор созданной плоскости.\nuint AddClipPlane ( IClipPlaneProperties clipPlaneProperties )\nгде:\nclipPlaneProperties - свойства секущей плоскости.\nIModelViewer.InvertClipPlane\nМетод позволяет инвертировать секущую плоскость.\nvoid InvertClipPlane ( uint clipPlaneId )\nгде:\nclipPlaneId - идентификатор секущей плоскости.\nIModelViewer.RemoveClipPlane\nМетод позволяет удалить секущую плоскость.\nvoid RemoveClipPlane ( uint clipPlaneId )\nгде:\nclipPlaneId - идентификатор секущей плоскости.\nIModelViewer.MakeScreenshot\nМетод позволяет сделать скриншот, возвращает массив байтов (формат - png).\nbyte [] MakeScreenshot ( int width, int height )\nгде:\nwidth - ширина.\nheight - высота.\nIModelViewer.GetDisplaySettings\nМетод позволяет получить текущие настройки отображения.\nIModelViewerDisplaySettings GetDisplaySettings ()\nIModelViewer.SetDisplaySettings\nМетод позволяет установить настройки отображения.\nvoid SetDisplaySettings ( IModelViewerDisplaySettings displaySettings )\nгде:\ndisplaySettings - настройки отображения.\nСобытия IModelViewer.ModelVersionAdded\nСобытие оповещает о добавлении новой версии модели.\nevent EventHandler<ModelVersionEventArgs> ModelVersionAdded\nIModelViewer.ModelVersionChanged\nСобытие оповещает об изменении текущей версии модели.\nevent EventHandler<ModelVersionEventArgs> ModelVersionChanged\nIModelViewer.SelectionChanged\nСобытие оповещает об изменении выбора элементов.\nevent EventHandler<SelectionChangedEventArgs> SelectionChanged\nIModelViewer.TreeNodeExpanded\nСобытие оповещает о раскрытии элемента в дереве.\nevent EventHandler<TreeNodeEventArgs> TreeNodeExpanded\nIModelViewer.TreeNodeCollapsed\nСобытие оповещает о сворачивании элемента в дереве.\nevent EventHandler<TreeNodeEventArgs> TreeNodeCollapsed\nIModelViewer.ModelPartLoadingRequested\nСобытие оповещает о выполнение команды загрузки части модели пользователем.\nevent EventHandler<ModelPartEventArgs> ModelPartLoadingRequested\nIModelViewer.ModelPartUnloadingRequested\nСобытие оповещает о выполнение команды выгрузки части модели пользователем.\nevent EventHandler<ModelPartEventArgs> ModelPartUnloadingRequested\nIModelViewer.Disposed\nСобытие оповещает о закрытии сцены.\nevent EventHandler Disposed","keywords":[]},"pages/client/bim/IToolbarManager.html":{"title":"Интерфейс IToolbarManager","content":"Интерфейс позволяет встраивать команды в панель инструментов.\nМетоды IToolbarManager.AddSeparator\nМетод позволяет добавить разделитель.\nvoid AddSeparator ( int index )\nгде:\nindex - индекс позиции вставки разделителя.\nIToolbarManager.AddToolbarButtonItem\nМетод позволяет добавить кнопку.\nIToolbarButtonItem AddToolbarButtonItem ( int index )\nгде:\nindex - индекс позиции вставки кнопки.\nIToolbarManager.AddToolbarToggleItem\nМетод позволяет добавить кнопку-переключатель.\nIToolbarToggleItem AddToolbarToggleItem ( int index )\nгде:\nindex - индекс позиции вставки кнопки-переключателя.\nIToolbarManager.AddToolbarMenuItem\nМетод позволяет добавить пункт меню.\nIToolbarMenuItem AddToolbarMenuItem ( int index )\nгде:\nindex - индекс позиции вставки пункта меню.\nIToolbarManager.AddToolbarMenuItem\nМетод позволяет получить все элементы панели инструментов.\nIEnumerable<IToolbarItem> GetItems ()\nIToolbarManager.RemoveToolbarItem\nМетод позволяет удалить команду из панели инструментов.\nvoid RemoveToolbarItem ( int index )\nгде:\nindex - индекс позиции удаляемой команды.","keywords":[]},"pages/client/bim/IMenu.html":{"title":"Контекстное меню","content":"Обращаем внимание, что при загрузке и подготовке данных, для добавляемых команд (которые сопряжены с ожиданием), необходимо придерживаться одной из следующих практик для быстрого открытия меню и своевременной обратной связи для пользователя:\nВстроить отключенную команду (с последующим ее включением, при выполнении заданных условий);\nВстроить подменю, с последующим наполнением его соответствующими командами;\nВстроить команду с замещающим текстом (например, \"Загрузка\") на время обработки данных.\nИнтерфейсы IMenu<IModelElementId> и IMenu<ModelContext>\nИнтерфейсы позволяют встраивать команды в контекстное меню объектов (в дереве объектов и на сцене).\nЗа подробным описанием интерфейса IMenu необходимо обращаться к документации Ascon Pilot SDK.","keywords":[]},"pages/client/ice/calendar/WorkingHours.html":{"title":"WorkingHours","content":"Описывает рабочие часы для конкретного дня.\nTimeOnly From { get; set; }\nНачало рабочего промежутка.\nTimeOnly To { get; set; }\nКонец рабочего промежутка.","keywords":[]},"pages/client/bim/ICollisionJournal.html":{"title":"Интерфейс ICollisionJournal","content":"Интерфейс для работы с данными журнала коллизий.\nСвойства ICollisionJournal.IsLoaded\nФлаг состояния готовности к обработке вызовов пользователя.\nbool IsLoaded { get; }\nICollisionJournal.JournalId\nИдентификатор журнала.\nGuid JournalId { get; }\nМетоды ICollisionJournal.LoadCollisions\nМетод позволяет получить все коллизии журнала.\nIReadOnlyCollection<ICollision> LoadCollisions ()\nСобытия ICollisionJournal.Loaded\nСобытие оповещает о готовности к обработке вызовов пользователя.\nevent EventHandler Loaded","keywords":[]},"pages/client/bim/IModelSearchService.html":{"title":"Интерфейс IModelSearchService","content":"Интерфейс для выполнения поиска, данный интерфейс наследует интерфейс IDisposable.\nМетоды IModelSearchService.AddModelPartAsync\nМетод асинхроного добавления части модели в поисковый индекс.\nTask AddModelPartAsync ( Guid modelPartId )\nгде:\nmodelPartId - идентификатор части модели.\nIModelSearchService.RemoveModelPart\nМетод удаления части модели из поискового индекса.\nvoid RemoveModelPart ( Guid modelPartId )\nгде:\nmodelPartId - идентификатор части модели.\nIModelSearchService.GetSearchProperties\nМетод получения коллекции свойств типа ModelSearchProperty.\nIReadOnlyCollection<ModelSearchProperty> GetSearchProperties ()\nIModelSearchService.GetSearchPropertiesByModelParts\nМетод получения свойств частей модели, возвращает словарь, где ключ - идентификатор части модели, значение - свойства типа ModelSearchProperty этой части модели.\nIReadOnlyDictionary<Guid, IEnumerable<ModelSearchProperty>> GetSearchPropertiesByModelParts(IEnumerable<Guid> modelPartIds)\nгде:\nmodelPartIds - идентификаторы частей модели.\nIModelSearchService.Search\nМетод для запуска поиска, возвращает коллекцию подходящих под условие поиска элементов IModelElementId.\nIEnumerable<IModelElementId> Search ( SearchSetState searchSetState, int searchResultCount )\nгде:\nsearchSetState - поисковый запрос, сформированный с помощью построителя IModelSearchSetBuilder.\nsearchResultCount - максимальное количество найденых возвращаемых элементов.\nIModelSearchService.Search\nМетод для запуска поиска в определенных частях модели, возвращает коллекцию подходящих под условие поиска элементов IModelElementId.\nIEnumerable<IModelElementId> Search ( SearchSetState searchSetState, IEnumerable<Guid> modelPartIdsToSearchIn, int searchResultCount )\nгде:\nsearchSetState - поисковый запрос, сформированный с помощью построителя IModelSearchSetBuilder.\nmodelPartIdsToSearchIn - коллекция идентификаторов частей модели, по которым необходимо выполнить поиск. Если коллекция принимает значние null, поиск будет выполнен по всей модели.\nsearchResultCount - максимальное количество найденых возвращаемых элементов.","keywords":[]},"pages/client/bim/IModelSearchSetBuilder.html":{"title":"Интерфейс IModelSearchSetBuilder","content":"Интерфейс для конструирования поискового запроса. Для получения данного интерфейса необходимо воспользоваться статическим методом IModelSearchSetBuilder ModelSearchSetBuilder.CreateBuilder(SearchSetLogicalOperator.And), где:\nгде SearchSetLogicalOperator логический оператор запроса.\nМетоды IModelSearchSetBuilder.AddExpressions\nМетод добавления условий поиска, сформированных с помощью построителя выражений IModelSearchExpressionsBuilder\nIModelSearchSetBuilder IModelSearchSetBuilder.AddExpressions(IModelSearchExpressionsBuilder expressionBuilder)\nгде:\nexpressionBuilder - сформированный построитель выражений для поиска.\nIModelSearchSetBuilder.NewGroup\nМетод добавления новой пустой группы для добавления в нее условий поиска. Возвращает экземпляр построителя выражений IModelSearchGroupBuilder.\nIModelSearchGroupBuilder NewGroup ( SearchSetLogicalOperator logicalOperator )\nгде:\nlogicalOperator - логический оператор для группы.\nIModelSearchSetBuilder.Build\nМетод получения результирующего поискового запроса для передачи в качестве аргумента в метод IModelSearchService.Search.\nSearchSetState Build ()","keywords":[]},"pages/client/bim/IModelSearchManager.html":{"title":"Интерфейс IModelSearchManager","content":"Интерфейс для получения сервиса поиска.\nМетоды IModelSearchManager.GetModelSearchServiceAsync\nМетод асинхроного получения интерфейса IModelSearchService для поиска по модели.\nTask<IModelSearchService> GetModelSearchServiceAsync ( Guid modelId )\nгде:\nmodelId - идентификатор модели.\nIModelSearchManager.GetModelPartsSearchServiceAsync\nМетод асинхроного получения интерфейса IModelSearchService для поиска по коллекции частей модели.\nTask<IModelSearchService> GetModelPartsSearchServiceAsync ( IEnumerable<Guid> modelPartsIds )\nгде:\nmodelPartsIds - коллекция идентификаторов частей модели.","keywords":[]},"pages/client/bim/IBottomPanelManager.html":{"title":"Интерфейс IBottomPanelManager","content":"Интерфейс позволяет встраивать вкладки в нижнюю панель.\nМетоды IBottomPanelManager.AddBottomTab\nМетод позволяет добавить новую вкладку.\nIBottomPanelTab AddBottomTab ( int index, string title, object view );\nгде:\nindex - индекс позиции вставки вкладки;\ntitle - заголовок вкладки;\nview - контент типа FrameworkElement, который будет отображаться в качестве содержимого вкладки\nIBottomPanelManager.SelectBottomTab\nМетод позволяет выбрать вкладку.\nvoid SelectBottomTab ( int index )\nгде:\nindex - индекс позиции выбираемой вкладки;\nIBottomPanelManager.RemoveBottomTab\nМетод позволяет удалить вкладку.\nvoid RemoveBottomTab ( int index )\nгде:\nindex - индекс позиции удаляемой вкладки;\nIBottomPanelManager.GetBottomTabs\nМетод позволяет получить все вкладки.\nIEnumerable<IBottomPanelTab> GetBottomTabs ()\nСобытия IBottomPanelManager.BottomPanelTabSelectionChanged\nСобытие оповещает об изменении активной вкладки.\nevent EventHandler<BottomTabSelectionChangedEventArgs> BottomPanelTabSelectionChanged","keywords":[]},"pages/client/bim/IModelSearchGroupBuilder.html":{"title":"Интерфейс IModelSearchGroupBuilder","content":"Интерфейс конструирования поисковых запросов для группы.\nМетоды IModelSearchGroupBuilder.AddExpressions\nМетод добавления условий поиска, сформированных с помощью построителя выражений IModelSearchExpressionsBuilder\nIModelSearchGroupBuilder IModelSearchGroupBuilder.AddExpressions(IModelSearchExpressionsBuilder expressionBuilder)\nгде:\nexpressionBuilder - сформированный построитель выражений для поиска.\nIModelSearchSetBuilder.NewGroup\nМетод добавления новой пустой группы для добавления в нее условий поиска. Возвращает экземпляр построителя выражений IModelSearchGroupBuilder.\nIModelSearchGroupBuilder NewGroup ( SearchSetLogicalOperator logicalOperator )\nгде:\nlogicalOperator - логический оператор для группы.","keywords":[]},"pages/client/bim/DataInterfaces.html":{"title":"Типы данных","content":"Интерфейс IModelElementId\nИнтерфейс идентификатора элемента.\nОписание свойств интерфейса:\nGuid ElementId { get; } - идентификатор элемента;\nGuid ModelPartId { get; } - идентификатор части модели.\nИнтерфейс IModelElement\nИнтерфейс элемента.\nОписание свойств интерфейса:\nIModelElementId Id { get; } - интерфейс идентификатора элемента;\nIModelElementId ParentId { get; } - интерфейс идентификатора родительского элемента;\nstring Name { get; } - имя элемента;\nstring Type { get; } - тип элемента;\nDateTime Version { get; } - версия элемента.\nИнтерфейс ICameraPosition\nИнтерфейс положения камеры.\nОписание свойств интерфейса:\nfloat X { get; } - координата X положения камеры;\nfloat Y { get; } - координата Y положения камеры;\nfloat Z { get; } - координата Z положения камеры;\nfloat EyeX { get; } - координата X точки взгляда камеры;\nfloat EyeY { get; } - координата Y точки взгляда камеры;\nfloat EyeZ { get; } - координата Z точки взгляда камеры;\nfloat PivotX { get; } - координата X опорной точки вращения камеры;\nfloat PivotY { get; } - координата Y опорной точки вращения камеры;\nfloat PivotZ { get; } - координата Z опорной точки вращения камеры;\nfloat Angle { get; } - угол обзора камеры (в радианах).\nИнтерфейс IClipPlaneProperties\nИнтерфейс свойств секущей плоскости.\nОписание свойств интерфейса:\nfloat X { get; } - координата X положения секущей плоскости;\nfloat Y { get; } - координата Y положения секущей плоскости;\nfloat Z { get; } - координата Z положения секущей плоскости;\nfloat NormalX { get; } - координата X нормализованного вектора нормали;\nfloat NormalY { get; } - координата Y нормализованного вектора нормали;\nfloat NormalZ { get; } - координата Z нормализованного вектора нормали.\nИнтерфейс IClipPlane\nИнтерфейс секущей плоскости.\nОписание свойств интерфейса:\nuint Id { get; } - идентификатор секущей плоскости;\nIClipPlaneProperties Properties { get; } - интерфейс свойств секущей плоскости.\nИнтерфейс IProperty\nИнтерфейс свойства элемента.\nОписание свойств интерфейса:\nstring Name { get; } - имя свойства;\nstring Unit { get; } - единицы измерения свойства;\nobject Value { get; } - значение свойства.\nИнтерфейс IPropertySet\nИнтерфейс группы свойств элемента.\nОписание свойств интерфейса:\nstring Name { get; } - имя группы свойств;\nIEnumerable<IProperty> Properties { get; } - перечисление интерфейсов свойств;\nstring Type { get; } - тип группы свойств.\nИнтерфейс IMeshInstance\nИнтерфейс геометрии элемента.\nОписание свойств интерфейса:\nIMeshDefinitionId MeshDefinitionId { get; } - интерфейс идентификатора определения геометрии;\nColor Color { get; } - цвет геометрии;\nMatrix4x4 Placement { get; } - положение геометрии.\nИнтерфейс IMeshDefinitionId\nИнтерфейс идентификатора определения геометрии.\nОписание свойств интерфейса:\nGuid MeshId { get; } - идентификатор геометрии;\nGuid ModelPartId { get; } - идентификатор части модели.\nИнтерфейс IMeshDefinition\nИнтерфейс определения геометрии (полигональная сетка).\nОписание свойств интерфейса:\nIEnumerable<float> Vertices { get; } - перечисление вершин геометрии;\nIEnumerable<float> Normals { get; } - перечисление нормалей геометрии;\nIEnumerable<uint> Indices { get; } - перечисление индексов геометрии;\nIEnumerable<uint> EdgeIndices { get; } - перечисление индексов ребер геометрии.\nИнтерфейс ICollision\nИнтерфейс определения коллизии.\nОписание свойств интерфейса:\nGuid Id { get; } - идентификатор коллизии;\nIModelElementId FirstElementId { get; } - идентификатор первого элемента коллизии;\nIModelElementId SecondElementId { get; } - идентификатор второго элемента коллизии;\nDateTime FoundDateTime { get; } - дата и время обнаружения коллизии;\nIMeshDefinition MeshDefinition { get; } - определение геометрии (полигональной сетки) тела пересечения;\ndouble[] Transformation { get; } - матрица трансформации тела пересечения;\nGuid StateId { get; } - идентификатор состояния коллизии;\nstring Name { get; } - имя коллизии;\ndouble Volume { get; } - объем тела пересечения. Объем может быть равен -1, если его не удалось посчитать.\nИнтерфейс IToolbarItem\nБазовый интерфейс элемента панели инструментов.\nОписание свойств интерфейса:\nstring Id { get; } - уникальный идентификатор элемента.\nИнтерфейс IToolbarSeparator\nИнтерфейс идентификации элемента типа \"Разделитель\" панели инструментов. Наследует интерфейс IToolbarItem.\nИнтерфейс IToolbarCommandItem\nИнтерфейс, описывающий элемент панели инструментов. Наследует интерфейс IToolbarItem.\nОписание свойств интерфейса:\nstring Title { get; set; } - наименование элемента;\nbyte[] Icon { set; } - иконка в формате svg;\nbool IsEnabled { get; set; } - значение доступности элемента;\nbool IsTitleVisible { get; set; } - флаг отображения наименования;\nstring Tooltip { get; set; } - всплывающая подсказка.\nИнтерфейс IToolbarButtonItem\nИнтерфейс, описывающий кнопку панели инструментов. Наследует интерфейс IToolbarCommandItem\nОписание свойств интерфейса:\nAction OnClick { set; } - делегат, который вызывается при нажатии на кнопку.\nИнтерфейс IToolbarToggleItem\nИнтерфейс, описывающий кнопку-переключатель панели инструментов. Наследует интерфейс IToolbarCommandItem.\nОписание свойств интерфейса:\nbool IsChecked { get; set; } - значение состояния;\nAction<bool> OnClick { set; } - делегат, который вызывается при нажатии на кнопку.\nИнтерфейс IToolbarMenuItem\nИнтерфейс, описывающий пункт меню панели инструментов. Наследует интерфейсы IToolbarCommandItem и IToolbarManager.\nИнтерфейс ISidebarTab\nИнтерфейс, описывающий вкладку боковой панели.\nОписание свойств интерфейса:\nstring Id { get; } - уникальный идентификатор вкладки;\nstring Title { get; } - наименование вкладки;\nbool IsSelected { get; } - флаг, указывающий на состояние: выбрана вкладка или нет;\nbool IsVisible { get; set; } - флаг, управляющий видимостью вкладки на боковой панели.\nИнтерфейс IBottomPanelTab\nИнтерфейс, описывающий вкладку нижней панели.\nОписание свойств интерфейса:\nstring Id { get; } - уникальный идентификатор вкладки;\nstring Title { get; } - наименование вкладки;\nbool IsSelected { get; } - флаг, указывающий на состояние: выбрана вкладка или нет;\nbool IsVisible { get; set; } - флаг, управляющий видимостью вкладки нижней панели.\nПеречисление PropertyKind\nПеречисление типов данных свойств модели.\nОписание:\nPropertyKind.String - строка;\nPropertyKind.Double - число с плавающей запятой;\nPropertyKind.DateTime - время;\nPropertyKind.Bool - логическое значение.\nИнтерфейс IModelViewerDisplaySettings\nИнтерфейс настроек отображения модели.\nОписание свойств интерфейса:\nIModelViewerCommonSettings ModelViewerCommonSettings { get; } - общие настройки;\nИнтерфейс IModelViewerCommonSettings\nИнтерфейс общих настроек.\nОписание свойств интерфейса:\nbool ShowTelemetry { get; set; } - отображать телеметрию;\nbool ShowAxes { get; set; } - отображать оси;\nbool UseCameraAnimation { get; set; } - использовать анимацию камеры;\nbool ShowViewCube { get; set; } - отображать видивой куб;\nbool HideSmallObjects { get; set; } - скрывать меленькие объекты;\nint SmallObjectPixelsSize { get; set; } - размер маленького объекта в пикселях;\nfloat GridLineProjectionLength { get; set; } - длина выступа метки линии сетки в мм;\nModelDisplayMode ModelDisplayMode { get; set; } - режим отображения модели;\nbool HideEdgesWithMouseNavigation { get; set; } - скрывать ребра при навигации;\nbool AmbientOcclusion { get; set; } - глобальное освещение;\nbool LightSources { get; set; } - источники света;\nbool MultisampleAntiAliasing { get; set; } - сглаживание граней и ребер;\nbool HideSmallObjectsWithMouseNavigation { get; set; } - скрывать маленькие объекты при навигации.\nПеречисление ModelDisplayMode\nПеречисление режимов отображения модели.\nОписание:\nModelDisplayMode.FacesAndEdges - грани и ребра;\nModelDisplayMode.FacesOnly - только грани;\nModelDisplayMode.EdgesOnly - только ребра (недоступно при установке HideEdgesWithMouseNavigation = true ).\nКласс ModelContext\nКонтекст построения контестного меню дерева объектов и сцены.\nОписание свойств класса:\nIEnumerable<IModelElementId> SelectedElements { get; } - выбранные элементы;\nIModelViewer ModelViewer { get; } - интерфейс IModelViewer.","keywords":[]},"pages/client/bim/SearchExpressions.html":{"title":"Построение поисковых выражений","content":"Свойство ModelProperty ModelProperty.GlobalIdReadable\nИспользуйте это свойство, чтобы задать поиск по определенному идентификатору элемента.\nНапример:\nvar id = new Guid( \"27f622ac-13af-4037-916b-f1116d69697d\" ); var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.GlobalIdReadable.EqualTo(id));\nModelProperty.Name\nИспользуйте это свойство, чтобы задать поиск по определенному имени элемента.\nНапример:\nvar searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.Name.EqualTo( \"Базовая стена:Типовой - 200мм:284316\" ));\nModelProperty.Type\nИспользуйте это свойство, чтобы задать поиск по определенному типу элемента.\nНапример:\nvar searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.Type.EqualTo( \"IfcWindow\" ));\nModelProperty.ModelPartId\nИспользуйте это свойство, чтобы задать поиск по определенному идентификатору части модели.\nНапример:\nvar id = new Guid( \"79f4b1fd-ba99-429f-9d67-31959ddec6ab\" ); var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.ModelPartId.EqualTo(id));\nModelProperty.ModelPartName\nИспользуйте это свойство, чтобы задать поиск с использованием наименования части модели.\nНапример:\nvar searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.ModelPartName.Contains( \"Проект_\" ));\nModelProperty.PartOf\nИспользуйте это свойство, чтобы найти все дочерние элементы.\nНапример:\nvar id = new Guid( \"79f4b1fd-ba99-429f-9d67-31959ddec6ab\" ); // Идентификатор элемента \"Этаж 1\" var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.PartOf.EqualTo(id));\nModelProperty.WithName(string name, string categoryName, PropertyDataType kind)\nгде:\nname - наименование свойства,\ncategoryName - наименование категории; в качастве наименования категории возможно передать значение null, тогда поиск выполнится с условием <Все категории>,\nkind - тип данных свойства.\nИспользуйте этот метод для составления выражения, по свойству:\nvar searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.WithName( \"Width\", \"Qto_WallBaseQuantities\", PropertyDataType.Double).GreaterThanOrEqual( 200 d));\nИли свойству полученному с помощью метода IModelSearchService.GetSearchProperties():\nvar doubleProperty = searchService.GetSearchProperties().First(x => x.CategoryName.Equals( \"Qto_WallBaseQuantities\", StringComparison.OrdinalIgnoreCase) && x.Name.Equals( \"Width\", StringComparison.OrdinalIgnoreCase, StringComparison.OrdinalIgnoreCase)); var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(doubleProperty.GreaterThanOrEqual( 200 d));\nУсловия поиска Условия Defined и NotDefined\nDefined - для поиска элементов с заданным свойством;\nNotDefined - для поиска элементов с не заданным свойством.\nIModelSearchExpression Defined (); IModelSearchExpression NotDefined ();\nНапример:\nvar tagProperty = ModelProperty.WithName(searchService.GetSearchProperties().First(x => x.CategoryName.Equals( \"Pset_ElementInformation\", StringComparison.OrdinalIgnoreCase) && x.Name.Equals( \"Tag\", StringComparison.OrdinalIgnoreCase, StringComparison.OrdinalIgnoreCase), null, PropertyDataType.String); var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(tagProperty.Defined());\nУсловия EqualTo и NotEqualTo\nEqualTo - равно;\nNotEqualTo - не равно.\nДанное условие доступно для типов данных Guid, string, double, bool, DateTime и long.\nIModelSearchExpression EqualTo ( T value ); IModelSearchExpression NotEqualTo ( T value );\nНапример:\nvar searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.Type.EqualTo( \"IfcProject\" ));\nУсловия Contains и NotContains\nContains - содержит;\nNotContains - не содержит.\nДанное условие доступно для типа данных string.\nIModelSearchExpression Contains ( T value ); IModelSearchExpression NotContains ( T value );\nНапример:\nvar searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.Type.Contains( \"Project\" ));\nУсловия GreaterThanOrEqual, LessThanOrEqual, GreaterThan, LessThan\nGreaterThanOrEqual - больше или равно;\nLessThanOrEqual - меньше или равно;\nGreaterThan - больше;\nLessThan - меньше;\nДанное условие доступно для типов данных double, DateTime и long.\nIModelSearchExpression GreaterThanOrEqual ( T value ); IModelSearchExpression LessThanOrEqual ( T value ); IModelSearchExpression GreaterThan ( T value ); IModelSearchExpression LessThan ( T value );\nНапример:\nvar doubleProperty = searchService.GetSearchProperties().First(x =>\nx.CategoryName.Equals( \"Qto_WallBaseQuantities\", StringComparison.OrdinalIgnoreCase) && x.Name.Equals( \"Width\", StringComparison.OrdinalIgnoreCase, StringComparison.OrdinalIgnoreCase)); var searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nsearchExpressionsBuilder.AddExpression(ModelProperty.Type.EqualTo( \"IfcWall\" )).AddExpression(doubleProperty.GreaterThanOrEqual( 200 d));\nУсловие Wildcard\nПоиск значений соответствующих шаблону, поддерживает одиночный(?) и многократный (*) подстановочные символы. Данное условие доступно для типа данных string.\nIModelSearchExpression Wildcard ( string pattern );\nНапример:\nvar searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nexpressionsBuilder.AddExpression(ModelProperty.Type.Wildcard( \"*cWa??\" ));\nУсловие Regexp\nПоиск значений соответствующих шаблону регулярного выражения. Данное условие доступно для типа данных string.\nIModelSearchExpression Regexp ( string regexpPattern );\nНапример:\nvar searchExpressionsBuilder = ModelSearchExpressionsBuilder.CreateBuilder();\nexpressionsBuilder.AddExpression(ModelProperty.Type.Regexp( \"^Ifc(Wall|Window)$\" ));","keywords":[]},"pages/client/bim/Constants.html":{"title":"Константы","content":"Имена типов\nТип Консолидированная BIM-модель.\npublic static string CoordinationModel = \"bim_coordinationModel\";\nТип Часть консолидированной модели.\npublic static string ModelPart = \"bim_modelPart\";\nТип Папка замечаний к модели.\npublic static string RemarksFolder = \"bim_modelRemarksFolder\";\nТип Папка точек взгляда модели.\npublic static string ViewPointsFolder = \"bim_viewPointsFolder\";\nТип Папка поисковых наборов.\npublic static string SearchSetFolder = \"bim_searchSetsFolder\";\nТип Точка взгляда модели.\npublic static string ViewPoint = \"bim_viewPoint\";\nТип Поисковый набор.\npublic static string SearchSet = \"bim_searchSet\";\nИмена атрибутов\nАтрибут Имя.\npublic static string Name = \"name\";\nАтрибут Поисковый запрос объекта типа Поисковый набор.\npublic static string SearchRequest = \"searchRequest\";\nИдентификаторы элементов панели инструментов сцены\nИдентификатор элемента Открыть проект.\npublic static string OpenProject = \"tbiOpenProject\";\nИдентификатор элемента Настройки отображения.\npublic static string ViewerOptions = \"tbiOptions\";\nИдентификатор элемента Масштабировать по всем объектам.\npublic static string ZoomToFit = \"tbiZoomToFit\";\nИдентификатор элемента Отображать скрытые объекты.\npublic static string ToggleHiddenNodesVisibilityMode = \"tbiToggleHiddenNodesVisibilityMode\";\nИдентификатор элемента Отображать замечания.\npublic static string ToggleRemarksVisibility = \"tbiToggleRemarksVisibility\";\nБазовый идентификатор элементов добавления замечаний разных типов.\npublic static string AddRemarkBase = \"tbiAddRemark\";\nИдентификатор элемента Создать новую секущую плоскость.\npublic static string AddClipPlane = \"tbiAddClipPlane\";\nИдентификатор элемента Инвертировать выбраную секущую плоскость.\npublic static string InvertSelectedClipPlane = \"tbiInvertSelectedClipPlane\";\nИдентификатор элемента Инструменты измерений.\npublic static string MeasurementTools = \"tbiMeasurementTools\";\nИдентификатор элемента измерения По двум точкам.\npublic static string TwoPointsMeasure = \"tbiTwoPointsMeasure\";\nИдентификатор элемента измерения Длина ребра.\npublic static string EdgesMeasure = \"tbiEdgesMeasure\";\nИдентификатор элемента измерения Между точкой и плоскостью.\npublic static string PointAndPlaneMeasure = \"tbiPointAndPlaneMeasure\";\nИдентификатор элемента Настройки инструментов измерения.\npublic static string MeasurementToolsOptions = \"tbiMeasurementToolsOptions\";\nИдентификатор элемента Удалить выбранные элементы.\npublic static string DeleteSelectedElement = \"tbiDeleteSelected\";\nИдентификатор элемента Фото Pilot-BIM Camera.\npublic static string BimCameraMenu = \"tbiRealViewMenu\";\nИдентификатор элемента Изменить связь с папкой фото на диске....\npublic static string BimCameraChangeRootFolder = \"tbiRealViewChangeRootFolder\";\nИдентификатор элемента Удалить связь с папкой фото на диске....\npublic static string BimCameraUnlinkRootFolder = \"tbiRealViewUnlinkRootFolder\";\nИдентификатор элемента Связать с папкой фото на диске....\npublic static string BimCameraLinkRootFolder = \"tbiRealViewLinkRootFolder\";\nИдентификатор элемента Источник виртуального начала координат.\npublic static string VirtualOriginSourceMenu = \"tbiVirtualOriginSourceMenu\";\nБазовый идентификатор для элемента источника виртального начала координат.\npublic static string SetVirtualOriginSourceBase = \"tbiSetVirtualOriginSource_\";\nИдентификатор элемента Удалить связь.\npublic static string UnlinkVirtualOriginSource = \"tbiUnlinkVirtualOriginSource\";\nИдентификатор элемента Нет доступных источников виртуального начала координат.\npublic static string NoAvailableVirtualOriginSources = \"tbiNoVirtualOriginSources\";\nИдентификаторы команд контекстного меню сцены\nИдентификатор команды Масштабировать по всем объектам.\npublic static string ZoomToFitCommand = \"miZoomToFitCommand\";\nИдентификатор команды Сбросить скрытие всех объектов.\npublic static string ResetHiddenNodesCommand = \"miResetHiddenNodesCommand\";\nИдентификатор команды Построить отчёт по выбранным объектам.\npublic static string BuildReportBaseCommand = \"miBuildReportCommand\";\nИдентификатор команды Масштабировать по выбранным объектам.\npublic static string ZoomToFitSelectedCommand = \"miZoomToFitSelectedCommand\";\nИдентификатор команды Скрыть выбранное.\npublic static string HideSelectedNodesCommand = \"miHideSelectedNodesCommand\";\nИдентификатор команды Скрыть все кроме выбранного.\npublic static string HideAllButSelectedNodeCommand = \"miHideAllButSelectedNodeCommand\";\nИдентификатор команды Копировать ссылку.\npublic static string CopyLinkCommand = \"miCopyLinkCommand\";\nИдентификатор команды Инвертировать выбранную секущую плоскость.\npublic static string InvertSelectedClipPlaneCommand = \"miInvertSelectedClipPlaneCommand\";\nИдентификатор команды Показать в журнале проблем.\npublic static string ShowIssueItemCommandBase = \"miShowIssueItemCommandBase\";\nИдентификатор команд перехода к определнному пересечеию в журнале проблем.\npublic static string SubShowIssueItemCommand = \"misubShowIssueItemCommand\";\nИдентификаторы команд контекстного меню дерева\nИдентификатор команды Масштабировать по всем объектам.\npublic static string ZoomToFitCommand = \"miZoomToFitCommand\";\nИдентификатор команды Масштабировать по выбранным объектам.\npublic static string ZoomToFitSelectedCommand = \"miZoomToFitSelectedCommand\";\nИдентификатор команды Скрыть выбранное.\npublic static string HideSelectedNodesCommand = \"miHideSelectedNodesCommand\";\nИдентификатор команды Сбросить скрытие всех объектов.\npublic static string ResetHiddenNodesCommand = \"miResetHiddenNodesCommand\";\nИдентификатор команды Копировать ссылку.\npublic static string CopyLinkCommand = \"miCopyLinkCommand\";\nИдентификатор команды Перейти к исходному файлу на диске.\npublic static string OpenSourceFileLocationCommand = \"miOpenSourceFileLocationCommand\";\nИдентификатор команды Построить отчёт по выбранным объектам.\npublic static string BuildReportBaseCommand = \"miBuildReportCommand\";\nИдентификатор команды Полное перестроение.\npublic static string RebuildModelPartCommand = \"miRebuildModelPartCommand\";\nИдентификатор команды Выгрузить часть модели.\npublic static string UnloadSelectedNodesCommand = \"miUnloadSelectedNodesCommand\";\nИдентификатор команды Скрыть все кроме выбранного.\npublic static string IsolateSelectedCommand = \"miIsolateSelectedCommand\";\nИдентификатор команды Показать выбранное.\npublic static string ShowSelectedNodesCommand = \"miShowSelectedNodesCommand\";\nИдентификатор команды Загрузить часть модели.\npublic static string LoadSelectedNodesCommand = \"miLoadSelectedNodesCommand\";\nИдентификаторы вкладок боковой панели\nИдентификатор вкладки Замечания.\npublic static string RemarksTab = \"remarksTab\";\nИдентификатор вкладки Чаты.\npublic static string ModelChatTab = \"modelChatTab\";\nИдентификатор вкладки Точки взгляда.\npublic static string ViewPointsTab = \"viewPointsTab\";\nИдентификатор вкладки Проверки модели.\npublic static string CollisionsDetectorTab = \"collisionsDetectorTab\";\nИдентификатор вкладки Фото Pilot-BIM Camera.\npublic static string BimCameraTab = \"bimCameraTab\";","keywords":[]},"pages/client/bim/EventArgs.html":{"title":"Аргументы событий","content":"Аргументы ModelEventArgs\nАргументы событий изменения состояния модели.\nОписание свойств аргументов:\nIModelViewer Viewer { get; } - интерфейс сцены модели.\nАргументы ModelVersionEventArgs\nАргументы событий изменения версий модели.\nОписание свойств аргументов:\nDateTime Version { get; } - версия модели.\nАргументы SelectionChangedEventArgs\nАргументы событий изменения выбранных элементов.\nОписание свойств аргументов:\nIEnumerable<IModelElementId> SelectedIds { get; } - перечисление интерфейсов идентификаторов выбранных элементов.\nАргументы TreeNodeEventArgs\nАргументы событий изменения состояния элемента в дереве элементов.\nОписание свойств аргументов:\nIModelElementId Id { get; } - интерфейс идентификатора элемента.\nАргументы ModelPartEventArgs\nАргументы событий загрузки/выгрузки частей модели.\nОписание свойств аргументов:\nGuid Id { get; } - идентификатор части модели.\nАргументы SidebarTabSelectionChangedEventArgs\nАргументы событий изменения выбранной вкладки боковой панели.\nОписание свойств аргументов:\nISidebarTab SelectedTab { get; } - выбранная вкладка.\nISidebarTab UnselectedTab { get; } - предыдущая выбранная вкладка.\nАргументы BottomPanelTabSelectionChangedEventArgs\nАргументы событий изменения выбранной вкладки нижней панели.\nОписание свойств аргументов:\nIBottomPanelTab SelectedTab { get; } - выбранная вкладка.\nIBottomPanelTab UnselectedTab { get; } - предыдущая выбранная вкладка","keywords":[]},"pages/client/bim/IModelSearchExpressionsBuilder.html":{"title":"Интерфейс IModelSearchExpressionsBuilder","content":"Интерфейс для конструирования поискового выражения. Для получения данного интерфейса необходимо воспользоваться статическим методом ModelSearchExpressionsBuilder.CreateBuilder().\nМетоды IModelSearchExpressionsBuilder.AddExpression\nМетод добавления условия поиска.\nIModelSearchExpressionsBuilder IModelSearchExpressionsBuilder.AddExpression(IModelSearchExpression expression)\nгде:\nexpression - сформированное с помощью статического класса ModelProperty поисковое выражение.","keywords":[]},"pages/client/ice/calendar/ICalendarDay.html":{"title":"ICalendarDay","content":"Описывает рабочий день для пользователя или подразделения.\nIReadOnlyList<IWorkCalendarObject> WorkCalendars { get; }\nСвойство содержит список рабочих календарей, которые актуальны для пользователя или подразделения. Отсортированы в порядке приоритетности -- последний элемент самый приоритетный.\nIReadOnlyList<IWorkCalendarExceptionObject> WorkCalendarExceptions { get; }\nСвойство содержит список событий календаря, которые актуальны для пользователя или подразделения. Отсортированы в порядке приоритетности -- последний элемент самый приоритетный.\nIReadOnlyList<WorkingHours> WorkingHours { get; }\nСодержит рабочие часы выбранного дня, посчитанных из WorkCalendars и WorkCalendarExceptions. День является выходным, если коллекция пустая.","keywords":[]},"pages/client/ice/calendar/IWorkingCalendarManager.html":{"title":"IWorkingCalendarManager","content":"Позволяет получить данные на временном промежутке с учётом календаря рабочих дней. Результат аналогичен тому, что видит пользователь в карточке, редактируя контрол Дата и время.\nTask<DateTime> GetPersonWorkingDateAsync ( DateTime start, int workingDays, int personId );\nВозвращает дату окончания заданного количество рабочих дней для пользователя. Дата пересчитана в локальное время пользователя,\nгде:\nstart - стартовая точка;\nworkingDays - количество рабочих дней;\npersonId - идентификатор пользователя;\nTask<DateTime> GetOrgUnitWorkingDateAsync ( DateTime start, int workingDays, int personId );\nВозвращает дату окончания заданного количество рабочих дней для должности или подразделения. Дата пересчитана в локальное время пользователя, который привязан к должности,\nгде:\nstart - стартовая точка;\nworkingDays - количество рабочих дней;\norgunitId - идентификатор должности или подразделения;\nTask< int > GetPersonWorkingDaysCountAsync ( DateTime start, DateTime end, int personId );\nВозвращает количество рабочих дней на временном промежутке для пользователя,\nгде:\nstart - стартовая точка;\nend - конечная точка;\npersonId - идентификатор должности или подразделения;\nTask< int > GetOrgUnitWorkingDaysCountAsync ( DateTime start, DateTime end, int orgunitId );\nВозвращает количество рабочих дней на временном промежутке для должности или подразделения,\nгде:\nstart - стартовая точка;\nend - конечная точка;\norgunitId - идентификатор должности или подразделения;","keywords":[]},"pages/client/bim/ISidebarManager.html":{"title":"Интерфейс ISidebarManager","content":"Интерфейс позволяет встраивать вкладки в боковую панель.\nМетоды ISidebarManager.AddTab\nМетод позволяет добавить новую вкладку.\nISidebarTab AddTab ( int index, string title, byte [] icon, object view )\nгде:\nindex - индекс позиции вставки вкладки;\ntitle - заголовок вкладки (отображается в всплывающей подсказке);\nbyte[] - иконка в формате svg;\nview - контент типа FrameworkElement, который будет отображаться в качестве содержимого вкладки\nISidebarManager.SelectTab\nМетод позволяет выбрать вкладку.\nvoid SelectTab ( int index )\nгде:\nindex - индекс позиции выбираемой вкладки;\nISidebarManager.RemoveTab\nМетод позволяет удалить вкладку.\nvoid RemoveTab ( int index )\nгде:\nindex - индекс позиции удаляемой вкладки;\nISidebarManager.GetTabs\nМетод позволяет получить все вкладки.\nIEnumerable<ISidebarTab> GetTabs ()\nСобытия ISidebarManager.TabSelectionChanged\nСобытие оповещает об изменении активной вкладки.\nevent EventHandler<SidebarTabSelectionChangedEventArgs> TabSelectionChanged","keywords":[]},"pages/client/ice/events/IAutoimportHandler.html":{"title":"Интерфейс IAutoimportHandler","content":"Интерфейс позволяет реализовать обработку автоимпорта документов (печать на Pilot XPS принтер, загрузка документов в папку автоимпорта). Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IAutoimportHandler и обязательно пометить класс, реализующий интерфейс IAutoimportHandler атрибутом [Export]\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace AutoimportHandlingSample\n{ [ Export ( typeof (IAutoimportHandler))] public class AutoimportHandlingSample: IAutoimportHandler { public bool Handle (string filePath, string sourceFilePath, AutoimportSource autoimportSource) { } }\n}","keywords":[]},"pages/client/ice/automation/TriggerType.html":{"title":"Перечисление  TriggerType","content":"Перечисление описывает тип возможных триггеров в системе.\nЗначения\nNone = 0\nЗначение по умолчанию\nClient = 1\nТриггер срабатывает только на клиенте\nServer = 2\nТриггер срабатывает только на сервере\nServerAndClient = Client | Server\nТриггер срабатывает и на клиенте и на сервере","keywords":[]},"pages/client/ice/xps/IXpsRender.html":{"title":"Интерфейс IXpsRender","content":"Интерфейс позволяет рендерить XPS документы в растровое изображение. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIXpsRender.RenderXpsToBitmap\nМетод возвращает список отрендеренных страниц в формате Stream.\nIEnumerable<Stream> IFileProvider. RenderXpsToBitmap (Stream xpsStream, double quality = 1.0 );\nгде:\nxpsStream - поток XPS документы.\nquality - качество, в котором будет рэндериться (от 0 до 6).","keywords":[]},"pages/client/ice/dataconstructor/dataconstructor.html":{"title":"Интерфейсы управления данными","content":"Для получения доступа к интерфейсам их необходимо передать в конструктор. Можно передавать любые из перечисленных ниже интерфейсов. При этом, конструктор обязательно необходимо пометить атрибутом [ImportingConstructor].\n[ Export ( typeof (IObjectContextMenu))] public class ModifyObjectsPlugin: IObjectContextMenu\n{ private readonly IObjectModifier _modifier; private readonly Repository _repository; [ImportingConstructor] public ModifyObjectsPlugin (IObjectModifier modifier, IObjectsRepository repository) { _modifier = modifier; _repository = repository; }\n}","keywords":[]},"pages/client/ice/conf/atrconf.html":{"title":"Интерфейсы для работы с конфигурацией атрибутов: форматирование, нумераторы, справочники","content":"Каждый из пользовательских атрибутов может быть дополнен конфигурацией. Конфигурация представляет собой текстовое поле, с помощью которого могут быть заданы специальные настройки атрибута:\nспособ форматирования атрибутов объекта при отображении;\nописание нумератора;\nописание справочника;\nДля работы с конфигурацией атрибута можно использовать интерфейс IAttributeFormatParser, который предоставляет методы для десериализации настроек, хранящихся в строке конфигурации атрибута. Более полную информацию о форматировании атрибутов, нумераторах и справочниках смотри в документации к системе Pilot.\nПример Ascon.Pilot.SDK.ObjectsSample использует этот интерфейс для построения карточки объекта, включающей в себя отображение атрибутов, которым назначен нумератор, и атрибутов типа справочник; а так же для построения отоброжаемого имени объектов.","keywords":[]},"pages/client/ice/settings/IPersonalSettings.html":{"title":"Интерфейс IPersonalSettings","content":"Импортируемый интерфейс, позволяющий получать значение настроек и менять значения настроек текущего пользователя.\nIObservable<KeyValuePair<string, string>> SubscribeSetting(string key)\nПодписка на значение настройки по передаваемому ключу.\nvoid ChangeSettingValue(string key, string value)\nИзменение значения настройки по ключу.\nstring GetPersonalSettingValue(string key)\nПолучение значения персональной настройки для текущего пользователя по ключу.\nIReadOnlyCollection GetCommonSettingValue(string key)\nПолучение по ключу списка значений настройки для всех элементов оргструктуры, в которые входит текущий пользователь.","keywords":[]},"pages/client/ice/search/search.html":{"title":"Поиск","content":"Поисковая система Pilot предоставляет богатый язык запросов. Построение запросов осуществляется с помощью конструкторов запросов (IQueryBuilder). Поиск можно осуществлять как по полям объектов так и по ключевому слову или части слова (фразы). Основными элементами языка запросов являются так называемые \" условия поиска \".\nЧтобы осуществить поиск необходимо:\nполучить конструктор поисковых запросов из интерфейса ISearchService.\nпостроить запрос с помощью полученного конструктора поисковых запросов с использованием \"условий поиска\".\nвыполнить поиск вызвав метод Search и передать конструктор поисковых запросов в качестве параметра.\nКонструкторы запросов имеют три ключевых метода для построения поисковых запросов:\nMust - заданное условие обязательно должно выполниться.\nMustAnyOf - должно выполняться одно из заданных условий.\nMustNot - заданное условие не должно выполниться.\nЧтобы задать поиск по определенному полю объекта используйте условия поиска для объектов ObjectFields и конструктор запросов для объектов (см GetObjectQueryBuilder )\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.TypeId.BeAnyOf( 16, 17 ));\nДля любых объектов в базе Pilot предусмотрен поиск по ключевым словам. Такой поиск осуществляется с помощью \"условия поиска AllText\".\nПоиск по ключевому слову:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.AllText.Be( \"Проект*\" ));\nПоиск по ключевым словам поддерживает одиночный (?) и многократный (*) подстановочные символы.\nДля поиска с использованием одного символа подстановки используется служебный символ?. Например, чтобы найти слова \"test\" и \"text\" вы можете использовать следующую запись:\nObjectFields.AllText.Be( \"te?t\" )\nДля поиска с использованием многократного символа подстановки используется служебный символ *. Например, чтобы найти слова \"test\", \"tests\" или \"tester\" вы можете использовать следующую запись:\nObjectFields.AllText.Be( \"test*\" )\nТакже есть возможность использования символа многократной подстановки в середине или в начале слова. Например:\nObjectFields.AllText.Be( \"te*t\" )\nВажно\nНе рекомендуется использовать подстановочные символы в начале слова. Это приведет к полному перебору поисковых индексов, что может привести к сильным задержкам выдачи результата.","keywords":[]},"pages/client/ice/extensions/extensions.html":{"title":"Команды расширений","content":"Внимание\nУстаревший, использовать IPilotServiceProvider.\nВ клиенте Pilot предусмотрена возможность взаимодействия расширений между собой. Т.е. любое расширение может вызвать команду другого расширения и использовать результат работы вызванной команды. Для того, чтобы разработчики смогли воспользоваться командой мы рекомендуем добавить описание входящих и исходящих параметров. Как сериализовать и десериализовать параметры и результат работы команды.","keywords":[]},"pages/client/ice/ux/ITabServiceProvider.html":{"title":"ITabServiceProvider","content":"Интерфейс обеспечивает работу с вкладками главного окна клиентского приложения Pilot. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nМетоды\nIEnumerable<string> GetTabPageTitles ();\nМетод возвращает список заголовков открытых вкладок.\nstring ITabServiceProvider. GetActiveTabPageTitle ();\nМетод возвращает заголовок активной вкладки.\nvoid ITabServiceProvider. ActivateTabPage (string title);\nВызов метода активирует вкладку с заданным заголовком.\nгде:\ntitle - заголовок вкладки для активации.\nvoid ITabServiceProvider. OpenNewTabPage ( bool isInOtherPane = false );\nМетод открывает вкладку Новая вкладка в текущей панели вкладок или в новой.\nгде:\nisInOtherPane - флаг, указывающий где открыть новую вкладку:\ntrue - открыть вкладку в новой панели вкладок;\nfalse - открыть вкладку в текущей панели вкладок. Значение по умолчанию.\nvoid ITabServiceProvider. OpenStandardTab (StandardTabType tabType);\nМетод открывает новую стандартную вкладку в текущей панели вкладок.\nгде:\ntabType - тип стандартной вкладки:\nDocs - обозреватель документов;\nReports - отчеты;\nChats - переписка;\nXpsMerger - компоновщик документов;\nTasks - задания.\nvoid ITabServiceProvider. OpenTabPage (string title, FrameworkElement view, bool isInOtherPane = false );\nМетод открывает новую вкладку с заданным контентом в текущей панели вкладок или в новой.\nгде:\ntitle - локализованный заголовок открываемой вкладки;\nview - контент, который будет отображаться в открываемой вкладке;\nisInOtherPane - флаг, указывающий где открыть новую вкладку:\ntrue - открыть вкладку в новой панели вкладок.\nfalse - открыть вкладку в текущей панели вкладок. Значение по умолчанию.\nvoid ITabServiceProvider. CloseTabPage (string title);\nМетод закрывает первую открытую вкладку с заданным заголовком.\nгде:\ntitle - локализованный заголовок закрываемой вкладки.\nvoid ITabServiceProvider. UpdateTabPageContent (string oldTitle, string newTitle, FrameworkElement view);\nМетод обновляет контент в открытой вкладке с заданным заголовком.\nгде:\noldTitle - локализованный заголовок вкладки, в которой меняется контент;\nnewTitle - новый локализованный заголовок вкладки;\nview - новый контент, который будет отображаться во вкладке.\nvoid ITabServiceProvider. UpdateTabPageContent (Guid tabId, string title, FrameworkElement view);\nМетод обновляет контент и заголовок вкладки, которая определяется ее идентификатором.\nгде:\ntabId - идентификатор вкладки, в которой меняется заголовок и контент;\ntitle - новый локализованный заголовок вкладки;\nview - новый контент, который будет отображаться во вкладке.\nvoid ITabServiceProvider. UpdateActiveTabPageContent (FrameworkElement view);\nМетод обновляет контент в текущей открытой вкладке.\nгде:\nview - новый контент, который будет отображаться во вкладке.\nvoid ITabServiceProvider. ShowElement (Guid id);\nМетод открывает вкладку (или использует существующую) и переходит к указаному объекту\nгде:\nid - идентификатор объекта для навигации.\nvoid ITabServiceProvider. ShowElement (Guid id, bool openNewTab);\nМетод открывает вкладку (или использует существующую) и переходит к указаному объекту\nгде:\nid - идентификатор объекта для навигации;\nopenNewTab - флаг, указывающий на необходимость открытия новой вкладки.\nvoid ITabServiceProvider. ShowElement (Guid id, DateTime version);\nМетод открывает вкладку (или использует существующую) и переходит к указаной версии объекта\nгде:\nid - идентификатор объекта для навигации;\nversion - дата создания версии.\nvoid ITabServiceProvider. ShowElement (Guid id, DateTime version, object[] args);\nПерегруженый вариант метода для перехода к объекту, принимающий список аргументов для навигации. Используется для перехода к объекту отчёта в случае, если необходимо не только открыть указанный объект, но и передать значения параметров построения отчёта.\nгде:\nid - идентификатор объекта отчёта;\nversion - дата создания версии, не применимо для отчётов, заполняется DateTime.MinValue;\nargs - параметры навигации. Для передачи определенных объектов в качестве параметров построения отчёта нужно заполнить массив идентификаторамми данных объектов типа Guid;\nvoid ITabServiceProvider. UpdateActiveTabPageTitle (string title);\nМетод позволяет обновить заголовок активной вкладки.\nгде:\ntitle - старый заголовок вкладки;","keywords":[]},"pages/webserver/sborka/ts-zapusk.html":{"title":"Запуск TypeScript-расширения","content":"Debug\nДля того чтобы собрать расширение в отладочном режиме, запустите скрипт build:\nnpm run build\nЗатем запустите контейнер с Pilot-Web-Server с ключом -e AppSettings:Mode=Development\ndocker run -d -p 80:80 -e PilotServer:Url=http://0.1.5.100:5545 -e PilotServer:Database=demo -e AppSettings:Mode=Development --name pilot-web-server pilotdev/pilot-web-server:latest\nДалее предоставьте доступ к папке dist по порту 4300 - это можно сделать, например, запустив плагин Live Server для Visual Studio Code с конфигурационным файлом \\.vscode\\settings.json\n{ \"liveServer.settings.root\": \"./dist\", \"liveServer.settings.port\": 4300 }\nProduction\nДля того чтобы собрать и запустить production-расширение, запустите скрипт build-prod:\nnpm run build-prod\nЗатем в папке dist создайте zip архив с папкой frontend (сама папка должна попасть в архив). В клиентском приложении Pilot создайте объект с типом Веб-расширение (WebExtension) и прикрепите архив. Подробнее на help.pilotems.com","keywords":[]},"pages/webserver/sborka/angular-ui.html":{"title":"Встраивание Angular в UI","content":"Для встраивания Angular в приложение, реализуйте интерфейс IOpenspaceView с необходимым контекстом, например:\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; export class AngularView implements IOpenspaceView < PageContext > { getViewId (): string { } getView (): HTMLElement | undefined { }\n}\nРеализуйте метод getViewId() для идентификации отображения:\ngetViewId (): string { return \"AngularViewId\";\n}\nРеализуйте метод getView():\nСоздайте корневой HTML элемент отображения, используя document.createElement\nСоздайте экземпляр приложения Angular при помощи функции createApplication(), при надобности передав в аргумент объект с требуемыми провайжерами и получите ссылку ApplicationRef на приложение.\nПолучите зону Angular NgZone при помощи метода ApplicationRef.injector.get(), передав в аргумент класс NgZone.\nВ контексте метода NgZone.run():\nПолучите ссылку на экземпляр компонента ComponentRef при помощи функции createComponent(), передав в аргумент класс компонента и объект с инжектором экземпляра приложения AppRef.injector и корневым HTML элементом отображения.\nВызовите метод ApplicationRef.attachView(), передав ему ComponentRef.hostView.\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; import { ApplicationRef, ComponentRef, createComponent, Injectable, NgZone } from '@angular/core'; import { createApplication } from '@angular/platform-browser'; import { AppComponent } from '../../app.component'; export class AngularView implements IOpenspaceView < PageContext > { private _rootElement: HTMLElement | undefined; private _appRef: ApplicationRef | undefined; private _componentRef: ComponentRef < AppComponent > | undefined;... getView (): HTMLElement | undefined { if (! this. _rootElement ) { this. _rootElement = document. createElement ( \"div\" ); } if (! this. _appRef ) { createApplication ({ providers: [], }). then ( ( appRef: ApplicationRef ) => { this. _appRef = appRef; const zone = appRef. injector. get ( NgZone ); zone. run ( () => { this. _componentRef = createComponent ( AppComponent, { environmentInjector: appRef. injector, hostElement: this. _rootElement, }); appRef. attachView ( this. _componentRef. hostView ); }); }); } return this. _rootElement; }\n}\nДля освобождения ресурсов, необходимо реализовать интерфейс поведения IDisposable и его метод IDisposable.dispose():\nВызовите метод ComponentRef.destroy экземпляра компонента Angular\nВызовите метод ApplicationRef.destroy экземпляра приложения Angular\nОчистите корневой HTML элемент отображения\nimport { IOpenspaceView, PageContext } from \"@pilotdev/pilot-web-sdk\"; import { ApplicationRef, ComponentRef } from '@angular/core'; import { AppComponent } from '../../app.component'; export class AngularView implements IOpenspaceView < PageContext > { private _rootElement: HTMLElement | undefined; private _appRef: ApplicationRef | undefined; private _componentRef: ComponentRef < AppComponent > | undefined;... dispose (): void { if ( this. _componentRef ) { this. _componentRef. destroy (); this. _componentRef = undefined; } if ( this. _appRef ) { this. _appRef. destroy (); this. _appRef = undefined; } if ( this. _rootElement ) { this. _rootElement = undefined; } }\n}","keywords":[]},"pages/webserver/sborka/angular-zapusk.html":{"title":"Запуск angular-расширения","content":"Debug\nДля того чтобы собрать расширение в отладочном режиме, настройте запуск на порту 4300. Для этого добавьте в angular.json в projects.angular-ext.architect.serve поле options:\n{... \"defaultConfiguration\": \"production\" }, \"serve\": { + \"options\": { + \"port\": 4300, + \"publicHost\": \"http://localhost:4300\" + }, \"builder\": \"@angular-builders/custom-webpack:dev-server\", \"configurations\": { \"production\": { \"buildTarget\": \"angular-ext:build:production\" }, \"development\": { \"buildTarget\": \"angular-ext:build:development\" }... }\nПосле этого можно запустить скрипт start:\nnpm run start\nЗатем запустите запустите контейнер с Pilot-Web-Server с ключом -e AppSettings:Mode=Development\ndocker run -d -p 80:80 -e PilotServer:Url=http://0.1.5.100:5545 -e PilotServer:Database=demo -e AppSettings:Mode=Development --name pilot-web-server pilotdev/pilot-web-server:latest\nProduction\nДля того чтобы собрать и запустить production-расширение, добавьте в файл package.json скрипт build-prod:\n{... \"scripts\": {..., \"start\": \"ng serve\", \"build\": \"ng build\", + \"build-prod\": \"webpack --config webpack.prod.config.js\",... }, \"private\": true, \"dependencies\": {... },... }\nИ запустите его:\nnpm run build-prod\nЗатем в папке dist создайте zip-архив с папкой frontend (сама папка должна попасть в архив). В клиентском приложении Pilot создайте объект с типом Веб-расширение (WebExtension) и прикрепите архив. Подробнее на help.pilotems.com","keywords":[]},"pages/client/ice/ui/IToolbar.html":{"title":"Интерфейс IToolbar&lt;TToolbarContext&gt;","content":"Интерфейс позволяет встраивать новые команды в панель инструментов. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IToolbar<TToolbarContext> и обязательно пометить класс, реализующий интерфейс IToolbar< TToolbarContext>, атрибутом [Export].\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ContextMenuSample\n{ [ Export ( typeof (IToolbar<TasksViewContext2>))] public class ToolbarSample: IToolbar<TasksViewContext2> { public void Build (IToolbarBuilder builder, TasksViewContext2 context) { //... } public void OnToolbarItemClick (string name, TasksViewContext2 context) { //... } }\n}\nЧтобы встроить новые команды в панель инструментов вкладки Задания, необходимо реализовать интерфейc IToolbar<TasksViewContext2>.\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ContextMenuSample\n{ [ Export ( typeof (IToolbar<TasksViewContext2>))] public class ToolbarSample: IToolbar<TasksViewContext2> {... }\n}\nЧтобы встроить новые команды в панель инструментов Обозревателя документов, необходимо реализовать интерфейc IToolbar<ObjectsViewContext>\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ContextMenuSample\n{ [ Export ( typeof (IToolbar<ObjectsViewContext>))] public class ToolbarSample: IToolbar<ObjectsViewContext> {... }\n}\nIToolbar<TToolbarContext>.Build\nМетод вызывается перед построением панели инструментов.\nvoid IToolbar<TToolbarContext>. Build (IToolbarBuilder builder, TToolbarContext context);\nгде:\nbuilder - интерфейс, позволяющий добавлять различные элементы в панель инструментов;\ncontext - контекст, позволяющий получить дополнительные сведения о селектированных элементах.\nIToolbar<TToolbarContext>.OnToolbarItemClick\nМетод вызывается при нажатии на элемент панели инструментов.\nvoid IToolbar<TToolbarContext>. OnToolbarItemClick (string name, TToolbarContext context);\nгде:\nname - уникальное внутреннее имя элемента панели инструментов;\ncontext - контекст выполнения комманды.","keywords":[]},"pages/client/ice/ui/IToolbarBuilder.html":{"title":"Интерфейс IToolbarBuilder","content":"Интерфейс позволяет управлять элементами панели инструментов.\nIToolbarBuilder.ItemNames\nСвойство возвращает список уникальных имен элементов панели инструментов.\nIEnumerable<string> IToolbarBuilder.ItemNames { get; }\nIToolbarBuilder.Count\nСвойство возвращает количество элементов панели инструментов.\nint IToolbarBuilder.Count { get; }\nIToolbarBuilder.AddSeparator\nМетод позволяет добавить разделитель в панель инструментов.\nvoid IToolbarBuilder. AddSeparator ( int index);\nгде:\nindex - индекс, куда вставить разделитель.\nIToolbarBuilder.AddButtonItem\nМетод позволяет добавить кнопку в панель инструментов.\nIToolbarButtonItemBuilder AddButtonItem (string name, int index);\nгде:\nname - уникальное внутреннее имя кнопки;\nindex - индекс, куда вставить кнопку.\nВозвращает интерфейс добавления свойств кнопки IToolbarButtonItemBuilder.\nIToolbarBuilder.AddMenuButtonItem\nМетод позволяет добавить кнопку с выпадающим меню в панель инструментов.\nIToolbarMenuButtonItemBuilder AddMenuButtonItem (string name, int index);\nгде:\nname - уникальное внутреннее имя кнопки;\nindex - индекс, куда вставить кнопку.\nВозвращает интерфейс добавления свойств кнопки IToolbarMenuButtonItemBuilder.\nIToolbarBuilder.AddToggleButtonItem\nМетод позволяет добавить кнопку-переключатель в панель инструментов.\nIToolbarToggleButtonItemBuilder AddToggleButtonItem (string name, int index);\nгде:\nname - уникальное внутреннее имя кнопки;\nindex - индекс, куда вставить кнопку.\nВозвращает интерфейс добавления свойств кнопки IToolbarToggleButtonItemBuilder.\nIToolbarBuilder.ReplaceButtonItem\nМетод позволяет заменить любой элемент панели инструментов на кнопку.\nIToolbarButtonItemBuilder ReplaceButtonItem (string name);\nгде:\nname - уникальное внутреннее имя элемента, который будет заменен.\nВозвращает интерфейс добавления свойств кнопки IToolbarButtonItemBuilder.\nIToolbarBuilder.ReplaceMenuButtonItem\nМетод позволяет заменить любой элемент панели инструментов на кнопку с выпадающим меню.\nIToolbarMenuButtonItemBuilder ReplaceMenuButtonItem (string name);\nгде:\nname - уникальное внутреннее имя элемента, который будет заменен.\nВозвращает интерфейс добавления свойств кнопки IToolbarMenuButtonItemBuilder.\nIToolbarBuilder.HandleMenuButtonItemSubmenu\nМетод позволяет добавить обработчик построения подменю. Прямой доступ к элементам подменю невозможно получить в произвольный момент времени, так как подменю строится \"лениво\" при его открытии.\nvoid HandleMenuButtonItemSubmenu (string name, IToolbarItemSubmenuHandler itemSubmenuHandler);\nгде:\nname - имя элемента меню, в который будет встраиваться обработчик;\nitemSubmenuHandler - обработчик построения подменю (реализуется на стороне модуля расширения).\nIToolbarBuilder.ReplaceToggleButtonItem\nМетод позволяет заменить любой элемент панели инструментов на кнопку-переключатель.\nIToolbarToggleButtonItemBuilder ReplaceToggleButtonItem (string name);\nгде:\nname - уникальное внутреннее имя элемента, который будет заменен.\nВозвращает интерфейс добавления свойств кнопки IToolbarToggleButtonItemBuilder.\nIToolbarBuilder.RemoveItem\nМетод позволяет удалить элемент панели инструментов.\nvoid RemoveItem (string name);\nгде:\nname - уникальное внутреннее имя.","keywords":[]},"pages/client/ice/ui/IToolbarItemSubmenuHandler.html":{"title":"Интерфейс IToolbarItemSubmenuHandler","content":"Интерфейс построения меню для кнопки панели инструментов. В пакет SDK уже поставляется класс, реализующий данный интерфейс - ToolbarItemSubmenuHandler. Для того, чтобы построить меню, необходимо унаследоваться от этого класса.\nIToolbarItemSubmenuHandler.OnSubmenuRequested\nМетод вызывается перед тем как появится меню у кнопки панели инструментов.\nvoid OnSubmenuRequested (IToolbarBuilder builder);\nгде:\nbuilder - интерфейс построения меню.\nПример построения меню для кнопки в панели инструментов:\n[ Export ( typeof (IToolbar<TasksViewContext2>))] public class ToolbarSample: IToolbar<TasksViewContext2>\n{ public void Build (IToolbarBuilder builder, TasksViewContext2 context) { builder. AddMenuButtonItem ( \"tbsMenuButton\", 0 ). WithMenu ( new MenuHandler ()). WithHeader ( \"Menu button\" ). WithHint ( \"Menu button\" ); } public void OnToolbarItemClick (string name, TasksViewContext2 context) { if (name == \"MenuName\" ) { //do somethig } }\n} public class MenuHandler: ToolbarItemSubmenuHandler\n{ public override void OnSubmenuRequested (IToolbarBuilder builder) { builder. AddButtonItem ( \"MenuName\", 0 ). WithHeader ( \"item\" ); }\n}\nПодробнее можно посмотреть в примере Ascon.Pilot.SDK.ToolbarSample, поставляемом вместе с пакетом SDK.","keywords":[]},"pages/client/ice/ui/IToolbarToggleButtonItemBuilder.html":{"title":"Интерфейс IToolbarToggleButtonItemBuilder","content":"Интерфейс позволяет добавить свойства к кнопке-переключателю панели инструменотов. Этот интерфейс является наследником IToolbarButtonItemBuilder.\nIToolbarToggleButtonItemBuilder.WithIsChecked\nМетод позволяет задать состояние кнопки-переключателя.\nIToolbarToggleButtonItemBuilder WithIsChecked ( bool value);","keywords":[]},"pages/client/ice/ui/IToolbarMenuButtonItemBuilder.html":{"title":"Интерфейс IToolbarMenuButtonItemBuilder","content":"Интерфейс позволяет добавить свойства к кнопке с выпадающим меню панели инструменотов. Этот интерфейс является наследником IToolbarButtonItemBuilder.\nIToolbarMenuButtonItemBuilder.WithMenu\nМетод позволяет добавить контекстное меню к кнопке.\nIToolbarMenuButtonItemBuilder WithMenu (IToolbarItemSubmenuHandler itemSubmenuHandler);\nгде:\nitemSubmenuHandler - класс, описывающий построение выпадающего меню.","keywords":[]},"pages/client/ice/ui/IMenuItemBuilder.html":{"title":"Интерфейс IMenuItemBuilder","content":"Интерфейс позволяет добавлять свойства пункту меню.\nIMenuItemBuilder.WithHeader\nМетод позволяет добавить отображаемое в UI название.\nIMenuItemBuilder WithHeader (string header);\nгде:\nheader - отображаемое в UI название пункта меню.\nIMenuItemBuilder.WithIcon\nМетод позволяет добавить иконку. Обратите внимание, иконка должна быть в формате SVG для всех меню кроме IMenu<StorageContext>. Иконки для меню Pilot-Storage дожны быть в формате PNG.\nIMenuItemBuilder WithIcon (byte[] icon);\nгде:\nicon - иконка.\nIMenuItemBuilder.WithIsEnabled\nМетод позволяет задать значение доступности элемента.\nIMenuItemBuilder WithIsEnabled ( bool value);\nIMenuItemBuilder.WithSubmenu\nМетод позволяет добавить подменю к текущему пункту меню.\nIMenuBuilder WithSubmenu ();","keywords":[]},"pages/client/ice/ui/IMenu.html":{"title":"Интерфейс IMenu&lt;TMenuContext&gt;","content":"Интерфейс позволяет встраивать новые команды в различные меню приложения в зависимости от контекста. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IMenu<TMenuContext> и обязательно пометить класс, реализующий интерфейс IMenu<TMenuContext>, атрибутом [Export].\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ContextMenuSample\n{ [ Export ( typeof (IMenu<TasksViewContext2>))] public class ToolbarSample: IMenu<TasksViewContext2> { public void Build (IMenuBuilder builder, TasksViewContext2 context) { //... } public void OnMenuItemClick (string name, TasksViewContext2 context) { //... } }\n}\nЧтобы встроить новые команды в контекстное меню вкладки Задания, необходимо реализовать интерфейc IMenu<TasksViewContext2>.\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ContextMenuSample\n{ [ Export ( typeof (IMenu<TasksViewContext2>))] public class TasksContextMenuSample: IMenu<TasksViewContext2> {... }\n}\nЧтобы встроить новые команды в контекстное меню Обозревателя документов, необходимо реализовать интерфейc IMenu<ObjectsViewContext>\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ContextMenuSample\n{ [ Export ( typeof (IMenu<ObjectsViewContext>))] public class ObjectsContextMenuSample: IMenu<ObjectsViewContext> {... }\n}\nIMenu<TMenuContext>.Build\nМетод вызывается перед построением контекстного меню.\nvoid IMenu<TMenuContext>. Build (IMenuBuilder builder, TMenuContext context);\nгде:\nbuilder - интерфейс, позволяющий добавлять различные элементы в меню;\ncontext - контекст, позволяющий получить дополнительные сведения о селектированных элементах.\nIMenu<TMenuContext>.OnMenuItemClick\nМетод вызывается при нажатии на элемент меню.\nvoid IMenu<TMenuContext>. OnMenuItemClick (string name, TMenuContext context);\nгде:\nname - уникальное внутреннее имя элемента меню;\ncontext - контекст выполнения комманды.","keywords":[]},"pages/client/ice/ui/IMenuBuilder.html":{"title":"Интерфейс IMenuBuilder","content":"Интерфейс позволяет управлять элементами меню.\nIMenuBuilder.ItemNames\nСвойство возвращает список уникальных имен элементов меню.\nIEnumerable<string> IMenuBuilder.ItemNames { get; }\nIMenuBuilder.Count\nСвойство возвращает количество элементов меню.\nint IMenuBuilder.Count { get; }\nIMenuBuilder.AddSeparator\nМетод позволяет добавить разделитель в меню.\nvoid IMenuBuilder. AddSeparator ( int index);\nгде:\nindex - индекс, куда вставить разделитель.\nIMenuBuilder.AddItem\nМетод позволяет добавить пункт меню.\nIMenuItemBuilder AddItem (string name, int index);\nгде:\nname - уникальное внутреннее имя пункта меню;\nindex - индекс, куда вставить пункт меню.\nВозвращает интерфейс добавления свойств пункта меню IMenuItemBuilder.\nImenuBuilder.AddCheckableItem\nМетод позволяет добавить пункт меню типа кнопка-переключатель.\nICheckableMenuItemBuilder AddCheckableItem (string name, int index);\nгде:\nname - уникальное внутреннее имя пункта меню;\nindex - индекс, куда вставить пункт меню.\nВозвращает интерфейс установки состояния кнопки-переключателя.\nIMenuBuilder.ReplaceItem\nМетод позволяет заменить любой пункт меню.\nIMenuItemBuilder ReplaceItem (string name);\nгде:\nname - уникальное внутреннее имя;\nIMenuBuilder.RemoveItem\nМетод позволяет удалить пункт меню.\nvoid RemoveItem (string name);\nгде:\nname - уникальное внутреннее имя.\nIMenuBuilder.GetItem\nМетод позволяет получить построитель пункта меню.\nIMenuBuilder GetItem (string name);\nгде:\nname - уникальное внутреннее имя;\nВозвращает интерфейс добавления пунктов меню IMenuBuilder.","keywords":[]},"pages/client/ice/ui/ObjectsViewContext.html":{"title":"ObjectsViewContext","content":"Чтобы встроить расширение в контекстное меню или панель инструментов Обозревателя элементов, используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<ObjectsViewContext>))] public class ContextMenuSample: IMenu<ObjectsViewContext> {... }\n}\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IToolbar<ObjectsViewContext>))] public class ToolbarSample: IToolbar<ObjectsViewContext> {... }\n}","keywords":[]},"pages/client/ice/ui/IHotKeyCollection.html":{"title":"Интерфейс IHotKeyCollection","content":"Интерфейс коллекции для добавления горячих клавиш.\nIHotKeyCollection.Add\nМетод позволяет добавить разделитель новую горячую клавишу. Если для данного контектса уже была задана такая же горячая клавиша, добавление новой перезапишет ранее добавленную команду. Таким образом, можно переопределить поведение стандартных горячих клавиш в используемом контексте.\nvoid IMenuBuilder. Add (Key key, ModifierKeys modifierKeys, string commandId;\nгде:\nkey - горячая клавиша;\nmodifierKeys - модификатор корячей клавиши, позволяющий задать сочетания горячих клавиш с Ctrl, Alt и Shift;\ncommandId - уникальный идентификатор команды, который используется в методе OnHotKeyPressed для определения того, какую команду нежно выполнить;","keywords":[]},"pages/client/ice/ui/TasksViewContext2.html":{"title":"TasksViewContext2","content":"Чтобы встроить расширение в контекстное меню или панель инструментов вкладки Задания, используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<TasksViewContext2>))] public class ContextMenuSample: IMenu<TasksViewContext2> {... }\n}\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IToolbar<TasksViewContext2>))] public class ToolbarSample: IToolbar<TasksViewContext2> {... }\n}","keywords":[]},"pages/client/ice/ui/IHotKey.html":{"title":"Интерфейс IHotKey&lt;THotKeyContext&gt;","content":"Интерфейс позволяет назначать горячие клавиши частей приложения в зависимости от контекста. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IHotKey<THotKeyContext> и обязательно пометить класс, реализующий интерфейс IHotKey<THotKeyContext> атрибутом [Export]. Чтобы назначить горячие клавиши, которые будут активны в Обозревателя документов, необходимо реализовать интерфейc IHotKey<ObjectsViewContext>. На данный момент это единственный тип контекста, который поддерживает добавление горячих клавиш.\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ExtensionHotKeySample\n{ [ Export ( typeof (IHotKey<ObjectsViewContext>))] public class HotKeySample: IHotKey<ObjectsViewContext> { public void AssignHotKeys (IHotKeyCollection hotKeyCollection) { //... } public void OnHotKeyPressed (string commandId, ObjectsViewContext context) { //... } }\n}\nIHotKey<THotKeyContext>.AssignHotKeys\nМетод AssignHotKeys вызывается при загрузке интерфейса, который соответсвует указанному контексту. Например, метод расширения для контекста ObjectsViewContext будет вызван при открытии вкладки с Обозревателем документов.\nvoid IHotKey<THotKeyContext>. AssignHotKeys (IHotKeyCollection hotKeyCollection);\nгде:\nhotKeyCollection - интерфейс коллекции горячих клавиш, который непосредственно добавляет горячие клавиши в интерфейс приложения;\nIHotKey<THotKeyContext>.OnHotKeyPressed\nМетод вызывается, когда была нажата одна из комбинаций горячих клавиш, добавленных с помощью расширения.\nvoid IHotKey<THotKeyContext>. OnHotKeyPressed (string commandId, ObjectsViewContext context);\nгде:\ncommandId - уникальный идентификатор команды, который должен быть задан при добавлении горячей клавиши в методе AssignHotKeys;\ncontext - контекст, в котором горячая клавиша была нажата.","keywords":[]},"pages/client/ice/ui/DocumentAnnotationsListContext.html":{"title":"DocumentAnnotationsListContext","content":"Используйте этот тип контекста, чтобы встроить расширение в панель инструментов и контекстное меню списка замечаний к документу:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IToolbar<DocumentAnnotationsListContext>))] public class DocumentAnnotationsListToolbarSample: IToolbar<DocumentAnnotationsListContext> {... } [ Export ( typeof (IMenu<DocumentAnnotationsListContext>))] public class DocumentAnnotationsListContextMenuSample: IMenu<DocumentAnnotationsListContext> {... }\n}","keywords":[]},"pages/client/ice/ui/StorageContext.html":{"title":"StorageContext","content":"Чтобы встроить расширение в контекстное меню Pilot-Storage, используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<StorageContext>))] public class MenuSample: IMenu<StorageContext> {... }\n}","keywords":[]},"pages/client/ice/ui/XpsMergerContext.html":{"title":"XpsMergerContext","content":"Чтобы встроить расширение в панель инструментов компоновщика XPS, используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IToolbar<XpsMergerContext>))] public class XpsMergerToolbarSample: IToolbar<XpsMergerContext> {... }\n}","keywords":[]},"pages/client/ice/ui/SystemTrayContext.html":{"title":"SystemTrayContext","content":"Чтобы встроить расширение в системное меню, используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<SystemTrayContext>))] public class MenuSample: IMenu<SystemTrayContext> {... }\n}","keywords":[]},"pages/client/ice/ui/XpsRenderContext.html":{"title":"XpsRenderContext","content":"XpsRenderContext содержит информацию об открытом в просмотрщике документе. Чтобы встроить расширение в панель инструментов просмотрщика документов, используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IToolbar<XpsRenderContext>))] public class XpsRenderToolbarSample: IToolbar<XpsRenderContext> {... }\n}","keywords":[]},"pages/client/ice/ui/DocumentFilesContext.html":{"title":"DocumentFilesContext","content":"Чтобы встроить расширение в контекстное меню панели файлов ECM, документа используйте данный вид контекста. Описание свойств контекста:\nIEnumerable<IDataObject> EcmDocument { get; } - ECM документ, для которого была показана панель файлов\nIEnumerable<IStorageDataObject> SelectedObjects { get; } - список выбранных файлов\nbool IsContext { get; } - флаг, показывающий, в каком месте был сделан вызов меню\nbool IsMounted { get; } - флаг, определяющий, был ли смонтирован на Pilot-Storage ECM документ в момент вызова меню\nDocumentFilesUsage Usage { get; } - определяет, в каком UI используется панель файлов\nПеречисление `DocumentFilesUsage\nПеречисление UI использующих панель файлов\nDocumentFilesUsage.CreateNew\nUI создания нового ECM документа\nDocumentFilesUsage.ObjectsExplorer\nUI обозревателя документов\nDocumentFilesUsage.CardView\nUI карточки документа\nDocumentFilesUsage.TemplatesManager\nUI менеджера шаблонов документов\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<DocumentFilesContext>))] public class MenuSample: IMenu<DocumentFilesContext> {... }\n}","keywords":[]},"pages/client/ice/ui/XpsRenderClickPointContext.html":{"title":"XpsRenderClickPointContext","content":"XpsRenderClickPointContext содержит информацию об открытом в просмотрщике документе и о точке вызова контестного меню, а именно о координатах и номере страницы. Чтобы встроить расширение в контестное меню просмотрщика документов, используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<XpsRenderClickPointContext>))] public class XpsRenderContextMenuSample: IMenu<XpsRenderClickPointContext> {... }\n}","keywords":[]},"pages/client/ice/ui/GraphicLayerElementContext.html":{"title":"GraphicLayerElementContext","content":"Графический слой позволяет встраивать через SDK растровые изображения и блоки XAML разметки в XPS документ (см. Ascon.Pilot.SDK.GraphicLayerSample). Добавленные элементы графического слоя можно перемещать по документу и вызывать контекстное меню с командами, добавленными из плагина. Графический слой не является частью XPS документа и доступен для просмотра только в Pilot. Элементы графического слоя, помеченные как IsFloating = false, вшиваются в XPS документ во время печати или при создании запроса на подпись. Чтобы получить XPS с вшитым графическим слоем, необходимо отправить документ на печать в виртуальный принтер Pilot XPS или создать запросы на подпись. После этого элементы графического слоя будет невозможно перемещать по документу, вызывать контекстное меню и менять содержимое через плагин. Чтобы встроить расширение в контекстное меню графического элемента используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<GraphicLayerElementContext>))] public class GraphicLayerContextMenuSample: IMenu<GraphicLayerElementContext> {... }\n}","keywords":[]},"pages/client/ice/ui/LinkedTasksContext2.html":{"title":"LinkedTasksContext2","content":"Чтобы встроить расширение в контекстное меню связанных заданий, используйте данный вид контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<LinkedTasksContext2>))] public class MenuSample: IMenu<LinkedTasksContext2> {... }\n}","keywords":[]},"pages/client/ice/ui/SignatureRequestsContext.html":{"title":"SignatureRequestsContext","content":"Чтобы встроить расширение в контекстное меню панели запросов на подпись документа, используйте данный вид контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<SignatureRequestsContext>))] public class MenuSample: IMenu<SignatureRequestsContext> {... }\n}","keywords":[]},"pages/client/ice/ui/AttachmentManagerContext.html":{"title":"AttachmentManagerContext","content":"Чтобы встроить расширение в контекстное меню менеджера вложений (например, вложений в задание), используйте данный вид контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<AttachmentManagerContext>))] public class MenuSample: IMenu<AttachmentManagerContext> {... }\n}","keywords":[]},"pages/client/ice/ui/LinkedObjectsContext.html":{"title":"LinkedObjectsContext","content":"Чтобы встроить расширение в контекстное меню вкладки Связи, используйте данный вид контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<LinkedObjectsContext>))] public class MenuSample: IMenu<LinkedObjectsContext> {... }\n}","keywords":[]},"pages/client/ice/ui/MainViewContext.html":{"title":"MainViewContext","content":"Чтобы встроить расширение в главное меню приложения используйте этот тип контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<MainViewContext>))] public class MenuSample: IMenu<MainViewContext> {... }\n}","keywords":[]},"pages/client/ice/ui/ITabsExtension.html":{"title":"Интерфейс ITabsExtension&lt;TTabsContext&gt;","content":"Интерфейс для добавления новых вкладок в различные места приложения, использующие коллекции вкладок для отображения определенного контекста. Для создания расширения, добавляющего новые вкладки в коллекцию, необходимо реализовать в расширении интерфейс Ascon.Pilot.SDK ITabsExtension<TTabsContext> и обязательно пометить класс, реализующий интерфейс ITabsExtension<TTabsContext>, атрибутом [Export].\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace DocumentExplorerTabsSample\n{ [ Export ( typeof (ITabsExtension<DocumentExplorerDetailsTabsContext>))] public class DocumentExplorerTabsSample: ITabsExtension<DocumentExplorerDetailsTabsContext> { public void BuildTabs (ITabsBuilder builder, DocumentExplorerDetailsTabsContext context) { //Put new tabs building logic here... } public void OnIsActiveChanged (Guid tabId, bool isActive) { //Put tabs activation and deactivation logic here... } public void OnDisposed (Guid tabId, bool isActive) { //Put disposing and clearing tabs logic here to free resources when associated tabs collection is no longer displayed... } }\n}\nЧтобы добавить новые вкладки в коллекцию вкладок связанных элементов Обозревателя документов, необходимо реализовать в расширении интерфейс ITabsExtension<DocumentExplorerDetailsTabsContext>.\nnamespace DocumentExplorerTabsSample\n{ [ Export ( typeof (ITabsExtension<DocumentExplorerDetailsTabsContext>))] public class DocumentExplorerTabsSample: ITabsExtension<DocumentExplorerDetailsTabsContext> {... }\n}\nITabsExtension<TTabsContext>.BuildTabs\nМетод BuildTabs вызывается при построении коллекции вкладок и позволяет добавить в коллекцию новые вкладки.\nvoid ITabsExtension<TTabsContext>. BuildTabs (ITabsBuilder builder, TTabsContext context);\nгде:\nbuilder - интерфейс построителя вкладок, который непосредственно позволяет добавить новые вкладки;\ncontext - контекст коллекции вкладок, который позволяет получить информацию о том, для каких элементов строится коллекция вкладок.\nITabsExtension<TTabsContext>.OnIsActiveChanged\nМетод вызывается при изменении активности вкладки, которая была добавлена с помощью расширения.\nvoid ITabsExtension<TTabsContext>. OnIsActiveChanged (Guid tabId, bool isActive);\nгде:\ntabId - уникальный идентификатор вкладки;\nisActive - флаг, указывающий новое состояние вкладки.\nITabsExtension<TTabsContext>.OnDisposed\nМетод вызывается при очистке коллекции вкладок, в которую были добавлены вкладки расширений. Например, перед перестроением вкладок при смене их контекста или при закрытии пользователем окна, содержащего коллекцию вкладок. Метод позволяет отменить длительные операции или освободить ресурсы, принадлежащие вкладкам расширения, которые больше не будут использоваться.\nvoid ITabsExtension<TTabsContext>. OnDisposed (Guid tabId);\nгде:\ntabId - уникальный идентификатор вкладки;","keywords":[]},"pages/client/ice/ui/TasksTemplatesViewContext.html":{"title":"TasksTemplatesViewContext","content":"Используйте реализацию интерфейса IMenu для этого типа контекста, чтобы дать возможность вашему расширению встраиваться в контекстное меню списка шаблонов заданий:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<TasksTemplatesViewContext>))] public class MenuSample: IMenu<TasksTemplatesViewContext> {... }\n}","keywords":[]},"pages/client/ice/ui/ITabsBuilder.html":{"title":"Интерфейс ITabsBuilder","content":"Интерфейс построителя вкладок расширения, передается в качестве аргумента метода BuildTabs и позволяет добавить новые вкладки в коллекцию.\nITabsBuilder.AddTab\nМетод, добавляющий новую вкладку. Обратите внимание, что в коллекцию вкладок может быть добавлено более одной вкладки расширения. Для того, чтобы корректно обрабатывать события изменения активности вкладки и освобождения её ресурсов, при добавлении новой вкладки расширение должно назначить ей уникальный идентификатор, и впоследствии отличать эту вкладку с помощью этого идентификатора. Для примера работы с идентификаторами вкладок обратитесь к примеру Ascon.Pilot.SDK.TabsExtensionSample.\nvoid ITabsExtension<TTabsContext>. AddTab (Guid id, string title, FrameworkElement view);\nгде:\ntabId - уникальный идентификатор вкладки, который должен быть сгенерирован расширением и впоследствии использован для идентификации вкладок при вызове методов OnIsActiveChanged и OnDisposed;\ntitle - заголовок вкладки;\nview - контент, который будет отображаться в качестве содержимого вкладки.","keywords":[]},"pages/client/ice/ui/IClearCache.html":{"title":"Добавление новых опций очистки кеша в диалог \"Управление кешем\"","content":"Для того, чтобы добавить новую опцию очистки кеша в диалог \"Управление кешем\", предусмотрен интерфейс IClearCache.\nИнтерфейс IClearCache\nИнтерфейс позволяет добавить новую опцию очистки кеша в диалог Управление кешем. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IClearCache и обязательно пометить класс, реализующий интерфейс IClearCache атрибутом [Export]\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ClearCacheSample\n{ [ Export ( typeof (IClearCache))] public class ClearCacheProcedure: IClearCache {... }\n}\nСвойства\nstring Title { get; }\nСвойство должно возвращать название процедуры очистки кеша для модуля расширения, которое будет отображаться в диалоге Управление кешем.\nМетоды\nvoid GetInfo ( ClearCacheInfo clearCacheInfo );\nМетод должен давать информацию о количестве и общем размере файлов кеша, которые могут быть удалены в данный момент. Для этого в данном методе должны задаваться соответсвующие значения свойств объекта класса ClearCacheInfo, передаваемого как аргумент метода.\nvoid ExecuteClearCache ();\nМетод должен выполнять процедуру очистки кеша для модуля расширения. Следует учитывать возможность отмены этой процедуры с помощью метода StopClearCache. Данный метод работает на специальном рабочем потоке (worker thread) и не блокирует GUI.\nvoid StopClearCache ();\nМетод должен отменять выполнение метода ExecuteClearCache. Данный метод работает на UI потоке (UI thread).\nСобытия\nevent EventHandler<ClearCacheProgressChangedEventArgs> ClearCacheProgressChanged;\nСобытие должно оповещать об изменении прогресса при выполнеии ExecuteClearCache.","keywords":[]},"pages/client/ice/ui/DocumentExplorer.html":{"title":"DocumentExplorerDetailsTabsContext","content":"Класс, описывающий контекст вкладок области связей Обозревателя элементов. Расширение должно использовать этот тип контекста, чтобы добавить свои вкладки эту область (в дополнение к стандартным вкладкам Задания, Связи и Чат ):\npublic class DocumentExplorerTabsExtension: ITabsExtension<DocumentExplorerDetailsTabsContext>\n{...\n}\nDocumentExplorerDetailsTabsContext.SelectedObject\nСвойство, которое возвращает выбранный в данный момент элемент в Обозревателе элементов, для которого строится коллекция вкладок.\npublic IDataObject SelectedObject { get; }\nDocumentExplorerDetailsTabsContext.SnapshotDateTime\nСвойство, которое возвращает время создания выбранной версии документа, выбранного в Обозревателе элементов. Возвращает null, если выбрана актуальная версия документа.\npublic DateTime? SnapshotDateTime { get; }\nОтображения информации для выбранного элемента в Обозревателе элементов\nДля того, чтобы заменить стандартную карточку элемента в Обозревателе элементов предусмотрен интерфейс IDocumentsExplorerDetailsViewProvide\nИнтерфейс IDocumentsExplorerDetailsViewProvider\nИнтерфейс позволяет заменить карточку элемента в Обозревателе элементов на свою собственную. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IDocumentsExplorerDetailsViewProvider и обязательно пометить класс, реализующий интерфейс IDocumentsExplorerDetailsViewProvider атрибутом [Export]\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ContextMenuSample\n{ [ Export ( typeof (IDocumentsExplorerDetailsViewProvider))] public class DetailsViewProvider: IDocumentsExplorerDetailsViewProvider {... }\n}\nМетоды\nFrameworkElement GetDetailsView ( ObjectsViewContext context );\nМетод должен возвращать UI елемент, который будет отображаться у выбранного элемента в Обозревателе элементов.\nIType Type { get; }\nСвойство должно возвращать тип элемента, для которого будет показываться UI елемент.\nПример использования:\n[ Export(typeof(IDocumentsExplorerDetailsViewProvider)) ] public class DetailsViewProvider: IDocumentsExplorerDetailsViewProvider { [ ImportingConstructor ] public DetailsViewProvider ( IObjectsRepository repository ) { Type = repository.GetType( \"section\" ); } public FrameworkElement GetDetailsView ( ObjectsViewContext context ) { var obj = context.SelectedObjects.FirstOrDefault(); if (obj == null ) return null; var viewModel = new TypeDetailsViewModel(obj.Type); var view = new TypeDetailsView { DataContext = viewModel }; return view; } public IType Type { get; }\n}","keywords":[]},"pages/client/ice/events/IPrintHandler.html":{"title":"Интерфейс IPrintHandler","content":"Интерфейс позволяет реализовать обработку печати документов с помощью принтера. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK IPrintHandler и обязательно пометить класс, реализующий интерфейс IPrintHandler атрибутом [Export]\nВ слуачае перхвата печати из Компоновщика XPS, IPrintedDocumentInfo.DocumentId равно Guid.Empty, а в IPrintedDocumentInfo.PrinterSettings.PrintJobName вместо имени, для скомпонованного документа, записывается строка формата \"Наименование документа#номер страницы|\". Например: MultipageXps.xps#2|1 - План на отметке 0,000 - Рабочий чертеж#1\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace PrintHandlingSample\n{ [ Export ( typeof (IPrintHandler))] public class PrintHandlingSample: IPrintHandler { public bool Handle (IPrintedDocumentInfo printTicket) { } }\n}","keywords":[]},"pages/client/ice/ui/CalendarObjectsViewContext.html":{"title":"CalendarObjectsViewContext","content":"Чтобы встроить расширение в контекстное меню объекта на вкладке Календарь рабочих дней, используйте данный вид контекста:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IMenu<CalendarObjectsViewContext>))] public class MenuSample: IMenu<CalendarObjectsViewContext> {... }\n}","keywords":[]},"pages/client/ice/events/INotificationsHandler.html":{"title":"Интерфейс INotificationsHandler","content":"Интерфейс позволяет реализовать обработку уведомлений из диспетчера уведомлений. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK.INotificationsHandler и обязательно пометить класс, реализующий интерфейс INotificationsHandler, атрибутом [Export].\nМетод Handle вызывается перед каждым показом нового уведомления. Если метод вернет true, то уведомление не будет показано в стандартном диспетчере уведомлений.\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace NotificationsHandlerSample\n{ [ Export ( typeof (INotificationsHandler))] public class NotificationsHandler: INotificationsHandler { public bool Handle (INotification notification) { } }\n}\nИнтерфейс INotification\nИнтефейс INotification описывает уведомление и содержит следующие члены:\nINotification.ObjectId\nИдентификатор элемента, по которому пришло уведомление.\nGuid ObjectId { get; }\nINotification.Title\nОтображаемое имя элемента, по которому пришло уведомление.\nstring Title { get; }\nINotification.Message\nТекст уведомления\nstring Message { get; }\nINotification.UserId\nИдентификатор пользователя, изменение которого привело к уведомлению. Значение null означает, что уведомление было сгенерировано серверной логикой без команды пользователя.\nint? UserId { get; }\nINotification.DateTime\nСодержит дату и время создания уведомления в формате UTC.\nDateTime DateTime { get; }\nINotification.TypeId\nИдентификатор типа элемента, по которому пришло уведомление.\nint TypeId { get; }\nINotification.ChangesetId\nМетод расширения, возвращающий инкрементальный идентификатор набора изменений, приведшего к созданию уведомления. Получение уведомления по элементу не гарантирует того, что обновленное состояние элемента уже было получено клиентом. Для того, чтобы получить обновленный элемент, подпишитесь на изменения по элементу и дождитесь значения IDataObject.LastChange, большего или равного ChangesetId уведомления. Пример:\n[ Export ( typeof (IDataPlugin))] public class Main: IDataPlugin, IObserver<INotification>\n{ private readonly IObjectsRepository _repository; [ImportingConstructor] public Main (IObjectsRepository repository) { _repository = repository; repository. SubscribeNotification (NotificationKind.StorageObjectRenamed). Subscribe ( this ); } public async void OnNext (INotification value) { var loader = new ObjectLoader (_repository); var obj = await loader. Load (value.ObjectId, value. ChangesetId ()); var message = string. Format ( \"Storage object renamed to {0}\", obj.DisplayName); MessageBox. Show (message, \"Ascon.Pilot.SDK.NotificationsSample\" ); } public void OnError (Exception error) { } public void OnCompleted () { }\n} public class ObjectLoader: IObserver<IDataObject>\n{ private readonly IObjectsRepository _repository; private IDisposable _subscription; private TaskCompletionSource<IDataObject> _tcs; private long _changesetId; public ObjectLoader (IObjectsRepository repository) { _repository = repository; } public Task<IDataObject> Load (Guid id, long changesetId = 0 ) { _changesetId = changesetId; _tcs = new TaskCompletionSource <IDataObject>(); _subscription = _repository. SubscribeObjects ( new [] {id}). Subscribe ( this ); return _tcs.Task; } public void OnNext (IDataObject value) { if (value.State!= DataState.Loaded) return; if (value. LastChange () < _changesetId) return; _tcs. TrySetResult (value); _subscription. Dispose (); } public void OnError (Exception error) { } public void OnCompleted () { }\n}","keywords":[]},"pages/client/ice/events/IObjectChangeHandler.html":{"title":"IObjectChangeHandler","content":"Интерфейс IObjectChangeHandler позволяет подписаться на изменения, сделанные пользователем.\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace Sample\n{ [ Export ( typeof (IObjectChangeHandler))] public class AnnulHandler: IObjectChangeHandler { private readonly string _annuledUserStateId; [ImportingConstructor] public AnnulHandler (IObjectsRepository repository) { var userStates = repository. GetUserStates (); var annuledUserState = userStates. FirstOrDefault (x => x.Name == Const.AnnuledUserState); if (annuledUserState!= null) _annuledUserStateId = annuledUserState.Id. ToString (); } public void OnChanged (IEnumerable<DataObjectChange> changes) { if (string. IsNullOrEmpty (_annuledUserStateId)) return; foreach (var change in changes) { foreach (var attribute in change.New.Attributes) { if ( Equals (attribute.Value, _annuledUserStateId)) { object oldValue = null; change.Old?.Attributes. TryGetValue (attribute.Key, out oldValue); if (! Equals (oldValue, _annuledUserStateId)) OnAnnuled (change.New); } } } } private void OnAnnuled (IDataObject obj) {... } }\n}\nIObjectChangeHandler.OnChanged\nДанный метод вызывается после того, как пользователь делает какое-либо изменение. В метод OnChanged параметром передается список произошедших изменений.","keywords":[]},"pages/client/ice/events/IObjectCardHandler.html":{"title":"Интерфейс IObjectCardHandler","content":"Интерфейс позволяет реализовать работу с атрибутами, отображаемыми в карточке объекта. Для этого необходимо реализовать интерфейс из пакета Ascon.Pilot.SDK.IObjectCardHandler и обязательно пометить класс, реализующий интерфейс IObjectCardHandler, атрибутом [Export].\nМетод Handle вызывается при каждом построении карточки объекта: при показе диалогов создания и редактирования объекта, при выборе объектов, для которых отображается карточка, в Обозревателе документов, а так же в диалоге автоимпорта при выборе нового родителя для создаваемого документа или селектировании документа для замены файла. В случае, если карточка находится в режиме редактирования существующего объекта, свойство EditingObject аргумента context возвращает сам объект, атрибуты которого показаны в карточке; и null, если карточка показана для создания нового объекта. Возвращаемое значение типа boolean никак не используется в реализации метода на стороне приложения Pilot и может быть любым.\nМетод OnValueChanged вызывается при изменении пользователем значения какого-либо из отображаемых атрибутов в карточке объекта. Аргумент sender возвращает атрибут, значение которого было изменено. Аргумент args позволяет получить доступ к аргументам события: предыдущему и новому значению атрибута, а также контексту карточки объекта. modifier позволяет отреагировать на изменения и установить новое значение дополнительно одному или нескольким атрибутам. Изменения в значениях атрибутов, которые были сделаны с помощью modifier, не приводят к вызовам метода OnValueChanged. Возвращаемое значение типа boolean никак не используется в реализации метода на стороне приложения Pilot и может быть любым.\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ObjectCardHandlerSample\n{ [ Export ( typeof (IObjectCardHandler))] public class ObjectCardHandler: IObjectCardHandler { public bool Handle (IAttributeModifier modifier, ObjectCardContext context) { var isObjectModification = context.EditiedObject!= null; } public bool OnValueChanged (IAttribute sender, AttributeValueChangedEventArgs args, IAttributeModifier modifier) { } }\n}","keywords":[]},"pages/client/ice/events/ObjectCardContext.html":{"title":"Контекст карточки ObjectCardContext","content":"Контекст отображения карточки.\nObjectCardContext.CurrentObjectId\nПоле содержит идетификатор объекта, для которого показана карточка. Если карточка показана для создания нового объекта, то поле содержит идентификатор, который будет присвоен новому объекту при создании.\nGuid ObjectCardContext.CurrentObjectId { get; }\nObjectCardContext.DisplayAttributes\nПоле содержит список отображаемых в карточке атрибутов. В этот список не входят сервисные атрибуты.\nIEnumerable<IAttribute> ObjectCardContext.DisplayAttributes { get; }\nObjectCardContext.AttributeValues\nСловарь текущих значений атрибутов карточки объекта, где ключ это имя атрибута, а значение - это значение атрибута.\nIDictionary<string, object> ObjectCardContext.AttributeValues { get; }\nObjectCardContext.Type\nПоле содержит описание типа элемента, для которого показана карточка.\nIType ObjectCardContext.Type { get; }\nObjectCardContext.EditiedObject\nТекущий редактируемый объект, для которого показана карточка. Null, если карточка показана для создания нового объекта.\nIDataObject ObjectCardContext.EditiedObject { get; }\nObjectCardContext.Parent\nПоле содержит описание родительского элемента.\nIDataObject ObjectCardContext.Parent { get; }\nObjectCardContext.IsReadOnly\nTrue, если карточка в режиме только для чтения, и атрибуты недоступны для изменения.\nbool ObjectCardContext.IsReadOnly { get; }","keywords":[]},"pages/client/ice/events/IAttributeModifier.html":{"title":"Редактирование атрибутов в карточке IAttributeModifier","content":"Интерфейс позволяет установить новое значения для атрибутов элемента перед тем, как они будут показаны в карточке объекта.\nIAttributeModifier.SetValue\nМетод позволяет задать новое значение атрибуту.\nvoid IAttributeModifier. SetValue (string name, string value);\nгде:\nname - уникальное наименование атрибута типа.\nvalue - новое значение атрибута.\nМетод имеет несколько перегрузок:\nvoid IAttributeModifier. SetValue (string name, string value); void IAttributeModifier. SetValue (string name, long value); void IAttributeModifier. SetValue (string name, double value); void IAttributeModifier. SetValue (string name, DateTime value); void IAttributeModifier. SetValue (string name, decimal value); void IAttributeModifier. SetValue (string name, Guid value); void IAttributeModifier. SetValue (string name, int [] value); void IAttributeModifier. SetValue (string name, Guid[] value); void IAttributeModifier. SetValue (string name, string[] value);","keywords":[]},"pages/client/ice/events/IObjectChangeProcessor.html":{"title":"IObjectChangeProcessor","content":"Интерфейс IObjectChangeProcessor позволяет редактировать и отменять изменения, сделанные пользователем. Примеры использования данного интерфейса можно найти в проекте SubtreeUserStateAnuller.\nusing System.Collections.Generic; using System.ComponentModel.Composition; using System.Linq; using Ascon.Pilot.SDK; namespace SubtreeUserStateAnuller\n{ [ Export ( typeof (IObjectChangeProcessor))] public class ChangeProcessor: IObjectChangeProcessor { public bool ProcessChanges (IEnumerable<DataObjectChange> changes, IObjectModifier modifier) { //проверяем первое изменение var change = changes. First (); //получаем pdf документы из изменения var newPdfs = change.New.ActualFileSnapshot.Files. Select (f => f.Name). Where (f => f. EndsWith ( \"pdf\" )); var oldPdfs = change.Old.ActualFileSnapshot.Files. Select (f => f.Name). Where (f => f. EndsWith ( \"pdf\" )); //если для объекта приложен pdf файл - отменяем изменения, иначе применяем if (newPdfs. Except (oldPdfs). Any ()) return false; return true; } }\n}\nusing System; using System.Collections.Generic; using System.ComponentModel.Composition; using System.IO; using System.Linq; using System.Windows; using System.Xml.Serialization; using Ascon.Pilot.SDK; using IDataObject = Ascon.Pilot.SDK.IDataObject; namespace SubtreeUserStateAnuller\n{ [ Export ( typeof (IObjectChangeProcessor))] public class AnnulHandler: IObjectChangeProcessor { public const string Xaml = \"<TextBlock Foreground=\\\"Red\\\" FontSize=\\\"20\\\">АННУЛИРОВАНО</TextBlock>\"; private readonly string _annuledUserStateId; [ImportingConstructor] public AnnulHandler (IObjectsRepository repository) { var userStates = repository. GetUserStates (); var annuledUserState = userStates. FirstOrDefault (x => x.Name == Const.AnnuledUserState); if (annuledUserState!= null) _annuledUserStateId = annuledUserState.Id. ToString (); } public bool ProcessChanges (IEnumerable<DataObjectChange> changes, IObjectModifier modifier) { if (string. IsNullOrEmpty (_annuledUserStateId)) return true; foreach (var change in changes) { foreach (var attribute in change.New.Attributes) { if ( Equals (attribute.Value. ToString (), _annuledUserStateId)) { object oldValue = null; change.Old?.Attributes. TryGetValue (attribute.Key, out oldValue); if (! Equals (oldValue, _annuledUserStateId)) AddGraphicLayer (change.New, modifier); } } } return true; } private void AddGraphicLayer (IDataObject dataObject, IObjectModifier modifier) {... } }\n}\nМетоды\nbool ProcessChanges (IEnumerable<DataObjectChange> changes, IObjectModifier modifier);\nДанный метод вызывается после того, как пользователь делает какое-либо изменение.\nгде:\nchanges - список изменений. Подробнее см. DataObjectChange;\nmodifier - объект модификатора, с помощью которого можно вносить изменения в объект. Подробнее см. IObjectModifier;\nМетод возвращает флаг, который показывает, следует ли применять изменения.","keywords":[]},"pages/client/ice/events/DataObjectChange.html":{"title":"Класс DataObjectChange","content":"Представляет собой изменение над одним объектом\nDataObjectChange.Old\nСостояние объекта до изменения. Равно null в случае создания объекта.\nDataObjectChange.New\nСостояние объекта после изменения.","keywords":[]},"pages/client/ice/events/IWorkflowObjectCardValidationBeforeSubmitHandler.html":{"title":"Интерфейс IWorkflowObjectCardValidationBeforeSubmitHandler","content":"Интерфейс позволяет произвести валидацию изменений в диалоге создания или редактировании процесса перед их применением. Для этого интерфейс из пакета Ascon.Pilot.SDK.IWorkflowObjectCardValidationBeforeSubmitHandler необходимо реализовать в одном из классов расширения и обязательно пометить этот класс атрибутом [Export].\nМетоды\nTask< bool > ValidateWorkflowObjectCardBeforeSubmitAsync (ObjectCardContext workflowCardContext, ObjectCardContext[][] stagesTaskCardContexts, CancellationToken token);\nгде:\nworkflowCardContext - контекст карточки процесса, предоставляющий доступ к самому редактируемому объекту процесса и текущим значениям атрибутов;\nstagesTaskCardContexts - коллекция контекстов объектов заданий, входящих в процесс. Коллекция представляет собой двумерный массив: первый уровень соответствует этапам текущего процесса, второй уровень представляет контекст каждой задачи, входящий в соответствующий этап.\ntoken - токен асинхронной операции в контексте которой расширением выполняется валидация значений карточки. Может использоваться для того, чтобы отменить задачу валидации атрибутов, если соответствующий запрос пришёл от пользователя;\nМетод ValidateWorkflowObjectCardBeforeSubmitAsync вызывается, когда пользователь нажимает кнопку ОК в диалоге создания или редактирования процесса, перед тем, как изменения будут непосредственно применены, и позволяет расширению проверить значения атрибутов в карточке процесса и заданий, входящих в этот процесс, в асинхронном режиме. Если в результате выполнения валидации проблем со значениями атрибутов не найдено, результатом задачи валидации должно быть значение true. В этом случае применение изменений продолжится как обычно. В противном случае, задача валидации должна вернуть значение false, что приведет к тому, что применение изменений не произойдёт и диалог изменения процесса останется в режиме редактирования.\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; using Ascon.Pilot.SDK.ObjectCard; using System.Threading; using System.Threading.Tasks; using System.Linq; namespace ObjectCardHandlerSample\n{ [ Export ( typeof (IWorkflowObjectCardValidationBeforeSubmitHandler))] public class ObjectValidationSample: IWorkflowObjectCardValidationBeforeSubmitHandler { Task< bool > ValidateWorkflowObjectCardBeforeSubmitAsync (ObjectCardContext workflowCardContext, ObjectCardContext[][] stagesTaskCardContexts, CancellationToken token) { return Task< bool >.Factory. StartNew (() => { var invalidValues = workflowCardContext.AttributesValues. Where (x => x.Value as string == \"invalid_value\" ). ToList (); if (invalidValues. Any ()) { ShowInvalidAttrsMessage (invalidValues); return false; } var stage = 0; foreach (var stageContexts in stagesTaskCardContexts) { stage++; var task = 0; foreach (var taskCardContext in stageContexts) { task++; var taskInvalidValues = taskCardContext.AttributesValues. Where (x => x.Value as string == \"invalid_value\" ). ToList (); if (taskInvalidValues. Any ()) { ShowInvalidAttrsMessage (taskInvalidValues); return false; } } } return true; }, token); } }\n}","keywords":[]},"pages/client/ice/events/IObjectCardValidationBeforeSubmitHandler.html":{"title":"Интерфейс IObjectCardValidationBeforeSubmitHandler","content":"Интерфейс позволяет произвести валидацию изменений в карточке объекта перед их применением: созданием нового объекта или сохранением изменений в существующем объекте. Для этого интерфейс из пакета Ascon.Pilot.SDK.IObjectCardValidationBeforeSubmitHandler необходимо реализовать в одном из классов расширения и обязательно пометить этот класс атрибутом [Export].\nМетоды\nTask< bool > ValidateObjectCardBeforeSubmitAsync (ObjectCardContext context, CancellationToken token);\nгде:\ncontext - контекст карточки объекта, предоставляющий доступ к самому редактируемому объекту, его типу и текущим значениям атрибутов;\ntoken - токен асинхронной операции в контексте которой расширением выполняется валиадация значений карточки. Может использоваться для того, чтобы отменить задачу валидации атрибутов, если соответствующий запрос пришёл от пользователя;\nМетод ValidateObjectCardBeforeSubmitAsync вызывается, когда пользователь нажимает кнопку Создать или Сохранить в карточке объекта или кнопку Выдать в карточке задания, перед тем, как изменения будут непосредственно применены, и позволяет расширению проверить значения атрибутов в карточке объекта или задания в асинхронном режиме. Если в результате выполнения валидации проблем со значениями атрибутов не найдено, результатом задачи валидации должно быть значение true. В этом случае применение изменений продолжится как обычно. В противном случае, задача валидации должна вернуть значение false, что приведет к тому, что применение изменений не произойдёт и карточка объекта останется в режиме редактирования.\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; using Ascon.Pilot.SDK.ObjectCard; using System.Threading; using System.Threading.Tasks; using System.Linq; namespace ObjectCardHandlerSample\n{ [ Export ( typeof (IObjectCardValidationBeforeSubmitHandler))] public class ObjectValidationSample: IObjectCardValidationBeforeSubmitHandler { public Task< bool > ValidateObjectCardBeforeSubmitAsync (ObjectCardContext context, CancellationToken token) { return Task< bool >.Factory. StartNew (() => { var invalidValues = context.AttributesValues. Where (x => x.Value as string == \"invalid_value\" ). ToList (); if (invalidValues. Any ()) { ShowInvalidAttrsMessage (invalidValues); return false; } return true; }, token); } }\n}","keywords":[]},"pages/client/ice/events/IDocumentFileHandler.html":{"title":"Интерфейс IDocumentFileHandler","content":"Интерфейс позволяет перехватывать события прикрепления файлов к объектам в карточке создания или редактирования объекта. Для этого необходимо реализовать интерфейс Ascon.Pilot.SDK.IDocumentFileHandler и пометить класс, реализующий интерфейс, атрибутом [Export].\nМетоды\nbool OnAttached (string filePath, Guid objectId, ObjectCardContext context);\nМетод вызывается после успешного выбора файла через диалог \"Открыть файл\" в карточке создания или редактирования объекта.\nгде:\nfilePath - полный путь к прикрепляемому файлу;\nobjectId - идентификатор объекта, к которому прикрепляется файл;\ncontext - контекст карточки объекта, содержащий информацию о типе, атрибутах и других свойствах. Подробнее см. ObjectCardContext.\nМетод возвращает флаг, который показывает, успешно ли обработано событие прикрепления файла.","keywords":[]},"pages/client/ice/events/IFileHandler.html":{"title":"Интерфейс IFileHandler","content":"Интерфейс позволяет перхватить обработку файлов прикладываемых к документу. Для этого необходимо реализовать интерфейс Ascon.Pilot.SDK.IFileHandler и пометить класс, реализующий интерфейс, атрибутом [Export]\nМетоды\nbool Handle (string inputFile, out List<string> outputFiles, FileHandlerSource source);\nгде:\ninputFile - путь к обрабатываему файлу;\noutputFiles - колекция путей к новым файлам после обработки;\nsource - контекст срабатывания метода Handle:\nFileHandlerSource.ObjectCreation диалог создания нового объекта;\nFileHandlerSourc.Publication публикация документа;\nFileHandlerSource.AutoImport диалог автоимпорта.\nМетод возвращает флаг, который показывает, следует ли применять результат обработки файлов.\nusing System; using System.Collections.Generic; using System.ComponentModel.Composition; using System.IO; namespace Ascon.Pilot.SDK.FileHandlerSample\n{ [ Export ( typeof (IFileHandler))] class FileHandler: IFileHandler { public bool Handle (string inputFile, out List<string> outputFiles, FileHandlerSource source) { outputFiles = new List <string>(); if (!File. Exists (inputFile)) return false; if (!string. Equals (Path. GetExtension (inputFile), \".pdf\", StringComparison.OrdinalIgnoreCase)) return false; //some logic for pdf format as example return true; } }\n}","keywords":[]},"pages/client/ice/automation/TargetType.html":{"title":"Перечисление  TargetType","content":"Перечисление описывает типы, на которые должно срабатывать действие (activity)\nЗначения\nSelf\nЕсли в описании автоматизации указан тип Self, то действие (activity) должно срабатывать над элементом, инициировавшем изменения.\nRelations\nЕсли в описании автоматизации указан тип Relations, то действие (activity) должно срабатывать над элементами, которые связаны с инициировавшем изменения по типу связи указанному в свойстве RelationType действия (activity). Подробнее ObjectRelationType","keywords":[]},"pages/client/ice/automation/RelationFilterByChangeKind.html":{"title":"Перечисление  RelationFilterByChangeKind","content":"Перечисление описывает типы возможных изменений связей у инициирующего элемента.\nЗначения\nAdded\nЕсли в описании автоматизации указан тип Added, то действие (activity) должно срабатывать при добавлении связей.\nRemoved\nЕсли в описании автоматизации указан тип Removed, то действие (activity) должно срабатывать при удалении связей.","keywords":[]},"pages/client/ice/automation/IAutomationActivity.html":{"title":"Интерфейс IAutomationActivity","content":"Интерфейс IAutomationActivity позволяет встроится в процесс автоматизации и обработать полученные изменения. Пример использования данного интерфейса можно найти в проекте SignMeAsActivity.\nПример встраивания в процесс автоматизации:\n... using System.ComponentModel.Composition; using Ascon.Pilot.SDK; using Ascon.Pilot.SDK.Automation; namespace SignMeAsActivity\n{ [ Export ( typeof (IAutomationActivity))] public class SignMeAsActivity: AutomationActivity { private readonly IDigitalSigner _digitalSigner; [ImportingConstructor] public SignMeAsActivity (IDigitalSigner digitalSigner) { _digitalSigner = digitalSigner; } // Имя activity должно совпадать с именем указанным в настройках автоматизации в myAdmin public override string Name => nameof (SignMeAsActivity); // Переопределим метод public override async Task RunAsync (IObjectModifier modifier, IAutomationBackend backend, IAutomationEventContext context, TriggerType triggerType) { // Код действия здесь...... }... } }\nAutomationActivity - класс реализующий интерфейс IAutomationActivity. Устанавливает стандартные настройки действия по умолчанию. Например такие свойства как: SourceTypes, Target, RelationType и д.р.\nВ классе действия (activity) также можно воспользоваться импортированием зависимостей в конструктор с помощью атрибута ImportingConstructor.\nСвойства\nstring Name { get; }\nСвойство возвращает имя действия (activity).\nВажно\nВозвращаемое имя должно совпадать с именем, указанным в скрипте автоматизации (json), задаваемом в настройках автоматизации в Pilot-myAdmin.\nDictionary<string, object> Params { get; }\nСвойство возвращает набор параметров, заданных в настройках атоматизации в myAdmin для этого действия (activity).\nList<string> SourceTypes { get; }\nСвойство возвращает набор типов для которых сработает действие. Типы задаются в настройках атоматизации в myAdmin при описании этого действия (activity).\nTargetType? Target { get; }\nСвойство возвращает значение на каго распространяется дейтсвие. Подробнее смотри TargetType\nObjectRelationType? RelationType { get; }\nСвойство возвращает значение связи, на которые распространяется это действие (activity). Подробнее смотри ObjectRelationType\nDictionary<string, string> Errors { get; }\nСвойство возвращает список ошибок при вызове действия (activity).\nRelationFilterByChangeKind? RelationFilterByChangeKind { get; }\nСвойство возвращает значение, указывающее на какой тип изменения связей реагирует действие (activity). Значение заполняется в myAdmin.\nМетоды\nTask RunAsync (IObjectModifier modifier, IAutomationBackend backend, IAutomationEventContext context, TriggerType triggerType);\nМетод вызывается когда срабатывает действие.\nгде:\nmodifier - объект модификатора, с помощью которого можно вносить изменения в объект. Подробнее см. IObjectModifier;\nbackend - объект доступа к различным типам или объектам в системе. Подробнее см. IAutomationBackend;\ncontext - объект доступа к инициирующему изменению и его свойствам Подробнее см. IAutomationEventContext;\ntriggerType - тип триггера. Подробнее см. TriggerType;","keywords":[]},"pages/client/ice/automation/ActivityExtensions.html":{"title":"Вспомогательный класс ActivityExtensions","content":"Методы\npublic static IEnumerable<IDataObject> GetObjectsToExecute (IAutomationEventContext context, IAutomationBackend backend, IAutomationActivity sourceActivity)\nМетод возвращает элементы в зависимости от настроек RelationFilterByChangeKind, TargetTypes и OjectRelationType в описании действия в Pilot-myAdmin.","keywords":[]},"pages/client/ice/dataconstructor/IObjectsRepository.html":{"title":"Интерфейс IObjectsRepository","content":"Интерфейс позволяет получить доступ к элементам, типам элементов и организационной структуре. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIObjectsRepository.GetCurrentPerson\nМетод позволяет получить информацию о текущем пользователе, вошедшем в систему.\nIPerson IObjectsRepository. GetCurrentPerson ();\nВозвращает объект типа IPerson.\nIObjectsRepository.GetOrganisationUnit\nМетод позволяет получить информацию об организационной единице.\nIOrganisationUnit IObjectsRepository. GetOrganisationUnit ( int id);\nгде:\nid - идентификатор должности или подразделения.\nВозвращает объект типа IOrganisationUnit.\nIObjectsRepository.GetOrganisationUnits\nМетод позволяет получить список организационных единиц.\nIEnumerable<IOrganisationUnit> IObjectsRepository. GetOrganisationUnits ();\nгде:\nid - идентификатор должности или подразделения.\nIObjectsRepository.GetPeople\nМетод позволяет получить список всех пользователей.\nIEnumerable<IPerson> IObjectsRepository. GetPeople ();\nIObjectsRepository.GetPerson\nМетод позволяет получить информацию о пользователе по идентификатору.\nIPerson IObjectsRepository. GetPerson ( int id);\nгде:\nid - идентификатор пользователя.\nIObjectsRepository.GetType\nМетод позволяет получить информацию о типе элемента по идентификатору или по имени.\nIType IObjectsRepository. GetType ( int id);\nгде:\nid - идентификатор типа элемента.\nIType IObjectsRepository. GetType (string name);\nгде:\nname - имя типа элемента.\nIObjectsRepository.GetTypes\nМетод позволяет получить список всех типов.\nIEnumerable<IType> IObjectsRepository. GetTypes ();\nIObjectsRepository.SubscribeObjects\nМетод предназначен для получения элементов по их идентификаторам. Метод работает асинхронно. Возвращает стандартный интерфейс IObservable, который позволяет подписаться на изменения запрошенных элементов. Все запрошенные элементы будут загружены в методе OnNext.\nIObservable<IDataObject> IObjectsRepository. SubscribeObjects (IEnumerable<Guid> ids);\nгде:\nids - список идентификаторов элементов.\nПример:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ObjectsSample\n{ [ Export ( typeof (IDataPlugin))] public class ObjectsSamplePlugin: IDataPlugin, IObserver<IDataObject> { private readonly IObjectsRepository _repository; private readonly List<IDataObject> _elements; [ImportingConstructor] public ObjectsSamplePlugin (IObjectsRepository repository) { _repository = repository; _elements = new List <IDataObject>(); //Получить корневой элемент _repository. SubscribeObjects ( new [] { SystemObjectIds.RootObjectId }). Subscribe ( this ); } public void OnNext (IDataObject value) { _elements. Clear (); if (!_elements. Exists (e => e.Id == value.Id)) _elements. Add (value); } public void OnError (Exception error) { } public void OnCompleted () { } }\n}\nВ данном примере описан сценарий получения элементов асинхронно с использованием метода SubscribeObjects. В данном подходе при реализации интерфейса IObserver<IDataObject> необходимо оставить пустой реализацию методов OnError и OnCompleted во избежании ошибок в будущем. В методе OnNext реализовано сохранение запрошенных элементов для дальнейшего использования.\nIObjectsRepository.SubscribeOrganisationUnits\nМетод предназначен для подписки на изменения организационных единиц (должности и подразделения). Метод возвращает стандартный интерфейс IObservable, который позволяет подписаться на изменения запрошенных объектов. Все запрошенные объекты будут загружены в методе OnNext.\nIObservable<IOrganisationUnit> IObjectsRepository. SubscribeOrganisationUnits ();\nПример:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ObjectsSample\n{IOrganisationUnit.Title [ Export ( typeof (IDataPlugin))] public class ObjectsSamplePlugin: IDataPlugin, IObserver<IOrganisationUnit> { [ImportingConstructor] public ObjectsSamplePlugin (IObjectsRepository repository) { repository. SubscribeOrganisationUnits (). Subscribe ( this ); } public void OnNext (IOrganisationUnit value) { //TODO update organization unit } public void OnError (Exception error) { } public void OnCompleted () { } }\n}\nВ данном примере описан сценарий обновления организационной единицы с использованием метода SubscribeOrganisationUnits. В данном подходе при реализации интерфейса IObserver<IOrganisationUnit> необходимо оставить пустой реализацию методов OnError и OnCompleted во избежании ошибок в будущем. В методе OnNext необходимо реализовать обновление организационной единицы.\nIObjectsRepository.SubscribePeople\nМетод предназначен для подписки на изменения информации о пользователях. Метод возвращает стандартный интерфейс IObservable, который позволяет подписаться на изменения запрошенных объектов. Все запрошенные объекты будут загружены в методе OnNext.\nIObservable<IPerson> IObjectsRepository. SubscribePeople ();\nПример:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ObjectsSample\n{ [ Export ( typeof (IDataPlugin))] public class ObjectsSamplePlugin: IDataPlugin, IObserver<IPerson> { [ImportingConstructor] public ObjectsSamplePlugin (IObjectsRepository repository) { repository. SubscribePeople (). Subscribe ( this ); } public void OnNext (IPerson value) { //TODO update person info } public void OnError (Exception error) { } public void OnCompleted () { } }\n}\nВ данном примере описан сценарий обновления информации о пользователе с использованием метода SubscribePeople. В данном подходе при реализации интерфейса IObserver<IPerson> необходимо оставить пустой реализацию методов OnError и OnCompleted во избежании ошибок в будущем. В методе OnNext необходимо реализовать обновление организационной единицы.\nIObjectsRepository.SubscribeTypes\nМетод предназначен для подписки на изменения описания типов элементов. Метод возвращает стандартный интерфейс IObservable, который позволяет подписаться на изменения запрошенных типов. Все запрошенные типы будут загружены в методе OnNext.\nIObservable<IType> IObjectsRepository. SubscribeTypes ();\nПример:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ObjectsSample\n{ [ Export ( typeof (IDataPlugin))] public class ObjectsSamplePlugin: IDataPlugin, IObserver<IType> { [ImportingConstructor] public ObjectsSamplePlugin (IObjectsRepository repository) { repository. SubscribeTypes (). Subscribe ( this ); } public void OnNext (IType value) { //TODO update element type info } public void OnError (Exception error) { } public void OnCompleted () { } }\n}\nВ данном примере описан сценарий обновления информации о типе элемента с использованием метода SubscribeTypes. В данном подходе при реализации интерфейса IObserver<IType> необходимо оставить пустой реализацию методов OnError и OnCompleted во избежании ошибок в будущем. В методе OnNext необходимо реализовать обновление описания типа.\nIObjectsRepository.SubscribeNotification\nМетод предназначен для получения уведомлений выбранного типа. Метод работает асинхронно. Возвращает стандартный интерфейс IObservable, который позволяет подписаться на получения уведомлений. Полученные уведомление будут передаваться в метод OnNext.\nIObservable<INotification> SubscribeNotification (NotificationKind kind);\nгде:\nkind - тип уведомлений для подписки.\nIObjectsRepository.SubscribeChats\nМетод предназначен для подписки на изменения информации о чатах. Метод возвращает стандартный интерфейс IObservable, который позволяет подписаться на изменения запрошенных объектов. Все запрошенные объекты будут загружены в методе OnNext.\nIObservable<IChatInfo> IObjectsRepository. SubscribeChats ();\nПример:\nusing System.ComponentModel.Composition; using Ascon.Pilot.SDK; namespace ObjectsSample\n{ [ Export ( typeof (IDataPlugin))] public class ObjectsSamplePlugin: IDataPlugin, IObserver<IChatInfo> { [ImportingConstructor] public ObjectsSamplePlugin (IObjectsRepository repository) { repository. SubscribeChats (). Subscribe ( this ); } public void OnNext (IChatInfo value) { //TODO update chat info } public void OnError (Exception error) { } public void OnCompleted () { } }\n}\nВ данном примере описан сценарий обновления информации о чате с использованием метода SubscribeChats. В данном подходе при реализации интерфейса IObserver<IChatInfo> необходимо оставить пустой реализацию методов OnError и OnCompleted во избежании ошибок в будущем. В методе OnNext необходимо реализовать обновление чата.\nIObjectsRepository.GetUserStates\nМетод предназначен для получения списка всех пользовательских состояний, зарегистрированных в базе.\nIObjectsRepository.GetUserStateMachines\nМетод предназначен для получения списка всех машин состояний, зарегистрированных в базе.\nIObjectsRepository.GetReportItems\nМетод предназначен для получения списка всех доступных текущему пользователю отчетов.\nIObjectsRepository.GetCurrentAccess\nМетод предназначен для получения информации о доступе пользователя к определенному объекту.\nAccessLevel GetCurrentAccess (Guid objectId, int personId);\nгде:\nobjectId - идентификатор объекта\npersonId - идентификатор пользователя\nIObjectsRepository.GetStoragePath\nМетод возвращает путь к файлу или папке, смонтированной на Pilot-Storage\nstring GetStoragePath (Guid objId);\nIObjectsRepository.GetStorageObjects\nПредоставляет информацию о файлах и папках на Pilot-Storage, находящихся по запрошенному абсолютному пути.\nIEnumerable<IStorageDataObject> GetStorageObjects (IEnumerable<string> paths);\nIObjectsRepository.Mount\nМонтирует элемент на Pilot-Storage. На Pilot-Storage могут быть смонтированы только элементы типов, помеченных флагом \"Может монтироваться на диск\". Т.к. метод выполняется асинхронно, смонтированный элемент может быть недоступен на Pilot-Storage сразу после вызова метода.\nvoid Mount (Guid objId);\nIObjectsRepository.MountAsync\nМонтирует элемент на Pilot-Storage. На Pilot-Storage могут быть смонтированы только элементы типов, помеченных флагом \"Может монтироваться на диск\".\nTask MountAsync (Guid objId);\nIObjectsRepository.GetHistoryItems\nМетод предназначен для получения элементов истории объекта. Метод работает асинхронно. Возвращает стандартный интерфейс IObservable, который позволяет подписаться на получения элементов истории по одному объекту. Полученные элементы будут передаваться в метод OnNext.\nIObservable<IHistoryItem> GetHistoryItems (IEnumerable<Guid> ids);\nгде:\nids - список идентификаторов элементов истории по одному объекту\nIObjectsRepository.LoadCleanableFileIds\nМетод предназначен для получения списка файлов, содержимое которых может быть безопасно удалено для освобождения места в локальном файловом хранилище. Использование данного метода демонстрируется в примере Ascon.Pilot.SDK.ClearCacheDaemon.\nTask<IEnumerable<Guid>> LoadCleanableFileIds ();","keywords":[]},"pages/client/ice/dataconstructor/ISignatureModifier.html":{"title":"Интерфейс ISignatureModifier","content":"Интерфейс прадназначен для изменения запросов на подпись в объекте.\nМетоды ISignatureBuilder Add\nISignatureBuilder Add (Guid id);\nгде:\nid - идентификатор новго запроса на подпись.\nМетод добавляет новый запрос на подпись. Возвращаемое значение ISignatureBuilder.\nRemove\nISignatureModifier Remove (Predicate<ISignatureRequest> findSignature);\nгде:\nfindSignature - фильтр;\nМетод метод удаляет запросы на подпись согласно заданному фильтру.\nSetSign\nvoid SetSign (Guid id, string sign);\nгде:\nid - идентификатор запроса на подпись;\nsign - подпись (идентификатор файла подписи в формате string);\nМетод добавляет подпись (идентификатор файла подписи в формате string) к запросу.\nSetPublicKeyOid\nISignatureModifier SetPublicKeyOid (Guid id, string publicKeyOid);\nгде:\nid - идентификатор запроса на подпись;\npublicKeyOid - идентификатор криптоалгоритма;\nМетод заполняет идентификатор криптоалгоритма, которым была создана подпись.\nSetLastSignCadesType\nISignatureModifier SetLastSignCadesType (Guid id, CadesType cadesType);\nгде:\nid - идентификатор запроса на подпись;\ncadesType - CadesType последней подписи в запросе;\nМетод заполняет CadesType последней подписи в запросе.\nSetIsAdvancementRequired\nISignatureModifier SetIsAdvancementRequired (Guid id, bool isAdvancementRequired);\nгде:\nid - идентификатор запроса на подпись;\nisAdvancementRequired - определяет, нужно ли подписи усовершенствование;\nМетод заполняет поле в запросе, определяющее нужно ли подписи усовершенствование;","keywords":[]},"pages/client/ice/dataconstructor/IObjectModifier.html":{"title":"Интерфейс IObjectModifier","content":"Интерфейс предназначен для создания, изменения и удаление элементов. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIObjectModifier.Create\nМетод позволяет создать новый элемент заданного типа.\nIObjectBuilder IObjectModifier. Create (IDataObject parent, IType type);\nгде:\nparent - родительский элемент, в котором создается новый элемент.\ntype - тип создаваемого элемента.\nМетод возвращает объект типа IObjectBuilder, который позволяет заполнить элемент атрибутами и задать дополнительные свойства. Подробнее смотри интерфейс IObjectBuilder\nIObjectModifier.Edit\nМетод позволяет отредактировать заданный элемент.\nIObjectBuilder IObjectModifier. Edit (IDataObject object);\nгде:\nobject - редактируемые элемент.\nМетод возвращает объект типа IObjectBuilder, который позволяет заполнить элемент атрибутами и задать дополнительные свойства. Подробнее смотри интерфейс IObjectBuilder\nIObjectModifier.Move\nМетод позволяет переместить элемент из текущего родительского элемента в другой.\nvoid IObjectModifier. Move (IDataObject object, IDataObject newParent);\nгде:\nobject - текущий элемент, который надо переместить;\nnewParent - новый родительский элемент.\nIObjectModifier.Delete\nМетод позволяет удалить элемент в корзину.\nvoid IObjectModifier. Delete (IDataObject object);\nгде:\nobject - элемент, который надо удалить.\nIObjectModifier.DeleteById\nМетод позволяет удалить элемент в корзину.\nvoid IObjectModifier. DeleteById (Guid objectId);\nгде:\nobjectId - идентификатор элемента, который надо удалить.\nIObjectModifier.ChangeState\nМетод позволяет изменить статус элемента.\nvoid IObjectModifier. ChangeState (IDataObject @object, ObjectState state);\nгде:\nobject - элемент, статус которого нужно изменить\nstate - новый статус элемента.\nIObjectModifier.CreateLink\nМетод позволяет связать два элемента выбранной связью.\nvoid IObjectModifier. CreateLink (IRelation relation1, IRelation relation2);\nгде:\nrelation1 - описание связи для первого объекта\nrelation2 - описание связи для второго объекта\nПример:\nusing Ascon.Pilot.SDK; class ObjectsSample { private IObjectModifier _modifier; {...} private void CreateSourceFileLink (ObjectsViewContext context) { var object1 = context.SelectedObjects. First (); var object2 = context.SelectedObjects. Last (); //Create relations var relationId = Guid. NewGuid (); var relationName = \"RelationName\"; var relationType = ObjectRelationType.Custom; var relation1 = new Relation { Id = relationId, Type = relationType, Name = relationName, TargetId = object 2. Id }; var relation2 = new Relation { Id = relationId, Type = relationType, Name = relationName, TargetId = object 1. Id }; _modifier. CreateLink (relation1, relation2); _modifier. Apply (); } {...}\n}\nIObjectModifier.RemoveLink\nМетод позволяет удалить связь между объектами.\nvoid IObjectModifier. RemoveLink (IDataObject obj, IRelation relation);\nгде:\nobj - объект, из которого будет удалена связь\nrelation - удаляемая связь\nПример:\nusing Ascon.Pilot.SDK; class ObjectsSample { private IObjectModifier _modifier; {...} private void RemoveSourceFileLink (ObjectsViewContext context) { var selected = context.SelectedObjects. First (); foreach (var relation in selected.Relations. Where (x => x.Type == ObjectRelationType.SourceFiles)) { _modifier. RemoveLink (selected, relation); } _modifier. Apply (); } {...}\n}\nIObjectModifier.Apply\nПрименить все сделанные над элементами изменения. Без вызова этого метода изменения не будут применены.\nvoid IObjectModifier. Apply ();\nIObjectModifier.Clear\nОчистить все изменения, сделанные над элементами, без применения. Возвращает объект modifier к своему изначальному состоянию.\nvoid IObjectModifier. Clear ();","keywords":[]},"pages/client/ice/dataconstructor/ISignatureBuilder.html":{"title":"Интерфейс ISignatureBuilder","content":"Интерфейс предназначен для изменения запроса на подпись.\nМетоды\nМетод изменяет идентификатор базы данных.\nWithPositionId\nISignatureBuilder WithPositionId ( int positionId);\nгде:\npositionId - идентификатор должности.\nМетод изменяет должность у запроса на подпись.\nWithRole\nISignatureBuilder WithRole (string role);\nгде:\nrole - роль подписанта.\nМетод изменяет роль подписанта.\nWithSign\nISignatureBuilder WithSign (string sign);\nгде:\nsign - цифровая подпись в формате Base64.\nМетод добавляет информацию о подписи в запрос (sign будет добавлен в коллекцию ISignatureRequest.Signs).\nWithRequestSigner\nISignatureBuilder WithRequestSigner (string requestSigner);\nгде:\nrequestSigner - отображаемое имя должности.\nМетод изменяет отображаемое имя должности подписанта.\nWithIsAdditional\nISignatureBuilder WithIsAdditional ( bool value);\nгде:\nvalue - значение.\nМетод изменяет флаг, указывающий на то, является ли запрос на подпись виртуальным.\nWithObjectId\nISignatureBuilder WithObjectId (Guid objectId);\nгде:\nobjectId - идентификатор объекта.\nМетод изменяет идентификатор объекта.","keywords":[]},"pages/client/ice/automation/IAutomationEventContext.html":{"title":"Интерфейс IAutomationEventContext","content":"Интерфейс описывает контекст события автоматизации.\nСвойства\nIDataObject Source { get; }\nСвойство возвращает инициирующий событие элемент.\nIEnumerable<IChange> Changes { get; }\nСвойство возвращает все изменения, произошедшие в процессе изменения инициирующего элемента.\nIPerson InitiatingPerson { get; }\nСвойство возвращает пользователя инициирующего изменения.\nDateTime EventDate { get; }\nСвойство возвращает время начала изменения. Дата указа в UTC.","keywords":[]},"pages/client/ice/dataconstructor/IPilotStorageListener.html":{"title":"Интерфейс <code class=\"yfm-clipboard-inline-code\" role=\"button\" aria-label=\"Блок кода\" aria-description=\"Чтобы скопировать текст внутри блока нажмите на блок\" tabindex='0' id=\"inline-code-id-e8gze2jp\">IPilotStorageListener</code>","content":"Интерфейс позволяет отслеживать изменения состава папок и состояний файлов и папок на Pilot-Storage. Данный интерфейc должен быть реализован классом на стороне расширения, и класс должен быть помечен атрибутом [Export(typeof(IPilotStorageListener))]. Данный интерфейc содержит методы:\nIPilotStorageListener.FileAdded\nМетод будет вызван при добавлении/появлении файла на Pilot-Storage\nvoid FileAdded (Guid id, string path, StorageObjectState state, NotificationTrigger trigger);\nгде:\nid - идентификатор объекта, связанного с файлом на Pilot-Storage.\npath - полный путь к добавленному файлу.\nstate - текущее состояние файла.\ntrigger - определяет, был ли файл добавлен на Pilot-Storage вследствие изменения (добавления текущим или другим пользователем) или загрузки структуры файлов и папок при монтировании проекта (в том числе, при старте приложения).\nIPilotStorageListener.FileRemoved\nМетод будет вызван, если по каким-то причинам (удаление/перемещение/права доступа и т.д.) файл больше не существует на Pilot-Storage\nvoid FileRemoved (Guid id, string path, NotificationTrigger trigger);\nгде:\nid - идентификатор объекта, связанного с файлом на Pilot-Storage.\npath - полный путь к удаленному файлу.\ntrigger - не имеет практического смысла в случае FileRemoved, оставлен для возможности дальнейшего расширения.\nIPilotStorageListener.FileEdited\nМетод будет вызван при редактировании содержимого файла на Pilot-Storage. Метод FileEdited может быть вызван несколько раз при однократном редактировании файла инструментом, т.к. запись в файл, как правило, ведется блоками фиксированного размера, зависящего от инструмента, редактирующего файл. Метод будет вызван при записи каждого такого блока.\nvoid FileEdited (Guid id, string path, StorageObjectState state, NotificationTrigger trigger);\nгде:\nid - идентификатор объекта, связанного с файлом на Pilot-Storage.\npath - полный путь к изменяемому файлу.\nstate - текущее состояние файла.\ntrigger - не имеет практического смысла в случае FileEdited, оставлен для возможности дальнейшего расширения.\nIPilotStorageListener.DirectoryAdded\nМетод будет вызван при добавлении/появлении папки на Pilot-Storage\nvoid DirectoryAdded (Guid id, string path, StorageObjectState state, NotificationTrigger trigger);\nгде:\nid - идентификатор объекта, связанного с папкой на Pilot-Storage.\npath - полный путь к добавленной папке.\nstate - текущее состояние папки.\ntrigger - определяет, была ли папка добавлена на Pilot-Storage вследствие изменения (добавления текущим или другим пользователем) или загрузки структуры файлов и папок при монтировании проекта (в том числе, при старте приложения).\nIPilotStorageListener.DirectoryRemoved\nМетод будет вызван, если по каким-то причинам (удаление/перемещение/права доступа и т.д.) папка больше не существует на Pilot-Storage\nvoid DirectoryRemoved (Guid id, string path, NotificationTrigger trigger);\nгде:\nid - идентификатор объекта, связанного с папкой на Pilot-Storage.\npath - полный путь к удаленной папке.\ntrigger - не имеет практического смысла в случае DirectoryRemoved, оставлен для возможности дальнейшего расширения.\nIPilotStorageListener.FileStateChanged\nМетод будет вызван при изменении состояния файла на Pilot-Storage\nvoid FileStateChanged (Guid id, string path, StorageObjectState state, NotificationTrigger trigger);\nгде:\nid - идентификатор объекта, связанного с файлом на Pilot-Storage.\npath - полный путь к измененному файлу.\nstate - новое состояние файла.\ntrigger - определяет, произошло ли изменение состояния файла на Pilot-Storage вследствие изменения данных или загрузки структуры файлов и папок при монтировании проекта (в том числе, при старте приложения).\nIPilotStorageListener.DirectoryStateChanged\nМетод будет вызван при изменении состояния папки на Pilot-Storage\nvoid DirectoryStateChanged (Guid id, string path, StorageObjectState state, NotificationTrigger trigger);\nгде:\nid - идентификатор объекта, связанного с папкой на Pilot-Storage.\npath - полный путь к измененной папке.\nstate - новое состояние папки.\ntrigger - определяет, произошло ли изменение состояния папки на Pilot-Storage вследствие изменения данных или загрузки структуры файлов и папок при монтировании проекта (в том числе, при старте приложения).","keywords":[]},"pages/client/ice/dataconstructor/IMessagesRepository.html":{"title":"Интерфейс IMessagesRepository","content":"Интерфейс позволяет получить доступ к сообщениям и чатам\nIMessagesRepository.LoadMessagesAsync\nЗагрузка списка сообщений по чату. Перед вызовом этого метода для нового чата, неоходимо вызвать метод LoadChatAsync для этого чата.\nTask<List<IChatMessage>> LoadMessagesAsync (Guid chatId, DateTime dateFromUtc, DateTime dateToUtc, int maxNumber);\nгде:\nchatId - идентификатор чата\ndateFromUtc - минимальная серверная дата создания сообщения, попадающего в выборку\ndateToUtc - максимальная серверная дата создания сообщения, попадающего в выборку\nmaxNumber - максимальное количество сообщений, попадающих в выборку\nIMessagesRepository.LoadChatMembersAsync\nЗагрузка участников чата\nTask<IReadOnlyCollection<IChatMember>> LoadChatMembersAsync (Guid chatId, DateTime dateFromUtc);\nгде:\nchatId - идентификатор чата\ndateFromUtc - минимальная серверная дата создания сообщения, попадающего в выборку\nIMessagesRepository.SendMessageAsync\nОтправка сообщения\nTask SendMessageAsync (IChatMessage message);\nгде:\nIChatMessage - объект сообщения, полученный из IMessageBuilder\nIMessagesRepository.LoadChatAsync\nПолучение чата по идентифкатору\nTask<IChat> LoadChatAsync (Guid id);\nгде:\nIChat - объект чата\nIMessagesRepository.LoadChatsAsync\nПолучение чата по идентифкатору\nTask<IReadOnlyList<IChatInfo>> LoadChatsAsync (DateTime next, int count, bool skipObjectRelated = true );\nгде:\nIChatInfo - объект сведений о чате\nnext - дата, после которой нужно загрузить чаты\ncount - максимальное количество возвращаемых чатов\nskipObjectRelated - Флаг пропуска чатов, связанных с объектами\nIMessagesRepository.SubscribeChats\nПодписка на обновления чатов\nIObservable<IChatInfo> SubscribeChats ();\nгде:\nIChatInfo - объект сведений о чате\nIMessagesRepository.SubscribeChatMessages\nПодписка на сообщения в чатах\nIObservable<IChatMessage> SubscribeChatMessages ();\nгде:\nIChatMessage - объект сведений о сообщении в чате","keywords":[]},"pages/client/ice/dataconstructor/IFileProvider.html":{"title":"Интерфейс IFileProvider","content":"Интерфейс обеспечивает работу с телами файлов. Получить интерфейс можно через конструктор, помеченный атрибутом [ImportingConstructor].\nIFileProvider.Exists\nМетод показывает, существует-ли тело файла с заданным идентификатором файла.\nbool IFileProvider. Exists (Guid fileId);\nгде:\nfileId - идентификатор файла.\nIFileProvider.IsFull\nМетод показывает, полностью-ли загружен файл с сервера.\nbool IFileProvider. IsFull (Guid fileId);\nгде:\nfileId - идентификатор файла.\nIFileProvider.OpenRead\nМетод открывает заданный файл на чтение. Сигнатура метода:\nStream IFileProvider. OpenRead (IFile file);\nгде:\nfile - открываемый файл.\nПолучение результирующего Stream не запускает скачивание тела файла с сервера, а возвращает \"ленивый\" поток. Рассмотрим на примере:\nПредположим, что у нас на клиенте ранее не запрашивался file длиной 100 байт.\nvar stream = fileProvider. OpenRead (file1); // возвращается \"ленивый\" поток, с сервера ничего не запрашивается var buffer = new byte[ 50 ];\nstream. Read (buffer, 0, buffer.Length); // поток понимает, что этих 50 байт у него нет, скачивает их с сервера и кэширует, буффер заполняется данными. Если нет соединения с сервером, будет сгенерировано исключение. stream. Read (buffer, 0, buffer.Length); // поток перед этим вызовом уже на 50 позиции, так что будут скачаны следующие 50 байт, и они также будут закэшированы. Теперь файл прочитан и закэширован полностью (все 100 байт), и вызов IsFull после этого вернет true.\nIFileProvider.GetRemoteFileChunk\nПолучает фрагмент файла напрямую с сервера без промежуточного кэширования.\nbyte[] IFileProvider. GetRemoteFileChunk (Guid fileId, long pos, int count)\nгде:\nfileId - идентификатор файла.\npos - позиция в файле, с которой начинается считывание.\ncount - количество байтов, которое должно быть считано.\nIFileProvider.GetFileSizeOnDisk\nlong IFileProvider. GetFileSizeOnDisk (Guid fileId)\nПолучает объем занимаемого файлом места на диске в локальном файловом хранилище. Не обязательно соответствует размеру файла на сервере, т.к. файл на клиенте может быть не загружен совсем или загружен частично.\nIFileProvider.DeleteLocalFile\nvoid IFileProvider. DeleteLocalFile (Guid fileId)\nУдаляет содержимое файла из локального файлового хранилища. Файл на сервере при этом остается, и при следующем обращении к файлу на клиенте с помощью метода IFileProvider.OpenRead файл будет загружен на клиент повторно.\nДанный метод может быть использован для очистки занимаемого файлом места в локальном файловом хранилище.","keywords":[]},"pages/client/ice/dataconstructor/IPilotStorageCommandController.html":{"title":"Интерфейс IPilotStorageCommandController","content":"Интерфейс позволяет вызывать команды Pilot-Storage. Получить интерфейс можно через конструктор, помеченный атрибутом [ImportingConstructor].\nIPilotStorageCommandController.Execute\nВызов команды Pilot-Storage\nvoid Execute (PilotStorageCommand command, params string[] paths);\nгде:\ncommand - вызываемая команда.\npaths - список полных путей к файлам или папкам, для которых будет вызвана команда.\nIPilotStorageCommandController.CanExecute\nПроверяет возможность вызова команды Pilot-Storage для указанных файлов и папок.\nvoid CanExecute (PilotStorageCommand command, params string[] paths);\nгде:\ncommand - команда.\npaths - список полных путей к файлам или папкам, для которых будет проверена возможность вызова команды.","keywords":[]},"pages/client/ice/dataconstructor/IClientInfo.html":{"title":"Интерфейс IClientInfo","content":"Интерфейс позволяет получить различную информацию о клиенте. Получить интерфейс можно через конструктор, помеченный атрибутом [ImportingConstructor].\nМетоды\nClientType GetClientType ();\nМетод позволяет получить тип клиента. Подробнее см. Перечисление IClientInfo\nСвойства\nstring AutoimportDirectory { get; set; }\nПолучить путь до папки автоимпорта.\nUri ConnectionString { get; }\nПолучить адрес подключения к серверу Pilot-Server.","keywords":[]},"pages/client/ice/dataconstructor/CommandList.html":{"title":"Список доступных команд","content":"Список доступных команд описан перечислением PilotStorageCommand.\nCommit - отправка изменений по файлу(или файлам в папке) на сервер\nDownload - загрузка содержимого файла (или файлов в папке) с сервера\nGetLatestVersion - обновление содержимого файла (или файлов в папке) на самую свежую версию\nRevert - отмена изменений по файлу (или файлам в папке).\nSubsribe - подписка на изменения по файлу/папке.\nUnsubsribe - отписка от изменений по файлу/папке.\nUnmount - размонтирование. Работает только для папок верхнего уровня.\nLock - блокировка файла.\nUnlock - разблокировка файла.\nFreeze - заморозка файла/папки.\nUnfreeze - разморозка файла/папки.\nPublish - публикация файла в ECM документ.\nPublishAndCommit - публикация файла в ECM документ с последующей отправкой изменений по файлу на сервер.\nAppendPublish - публикация файла добавлением новых страниц в ECM документ.\nAppendPublishAndCommit - публикация файла добавлением новых страниц в ECM документ с последующей отправкой изменений по файлу на сервер.\nUpdateFilesAttributes - заполнение полей в файле значениями атрибутов ECM документа.\nDiscard - отмена непринятых сервером изменений по файлу/папке.","keywords":[]},"pages/client/ice/xps/IXpsViewer.html":{"title":"Интерфейс IXpsViewer","content":"Интерфейс позволяет получить номер текущей страницы просмотрщика документов и произвести увеличение/уменьшение масштаба на элементе графического слоя или аннотации. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIXpsViewer.CurrentPageNumber\nСвойство возвращает номер открытой в просмотрщике страницы (от 0 до N-1)\nIXpsViewer.ZoomToElement\nМетод производит увеличение/уменьшение масштаба на элементе графического слоя или аннотации по его идентификатору\nvoid ZoomToElement (Guid id, double scale = 1 );\nгде:\nid - Guid графического элемента или аннотации.\nscale - изменение масштаба (от 0 до 1). 1 - максимальный масштаб\nIXpsViewer.SubscribeLeftMouseClick\nМетод позволяет добавить обработчик клика левой кнопки мыши.\nvoid SubscribeLeftMouseClick (IMouseLeftClickListener leftMouseClickListener);\nгде:\nleftMouseClickListener - объект реализующий интерфейс IMouseLeftClickListener\nIXpsViewer.UnsubscribeLeftMouseClick\nМетод позволяет удалить обработчик клика левой кнопки мыши.\nIXpsViewer.SetGraphicLayerElementsVisibility\nМетод позволяет скрыть или показать указанные по идентификатору графические элементы.\nvoid SetGraphicLayerElementsVisibility (IList<Guid> elementIds, bool hidden);\nгде:\nelementIds - Guid'ы графических элементов.\nhidden - true - скрывать, false - показывать","keywords":[]},"pages/client/ice/xps/IGraphicLayerElement.html":{"title":"IGraphicLayerElement","content":"Интерфейс представляет элемент графического слоя на XPS документах. Каждый графический элемент представлен в виде 2 файлов, хранящихся в объекте.\nПервый файл содержит описательную часть графического элемента, а именно xml-сериализованный объект, унаследованный от IGraphicLayerElement. Имя первого файла должно быть создано по правилу GraphicLayerElementConstants.GRAPHIC_LAYER_ELEMENT + ElementId, где\nElementId - идентификатор графического элемента,\nВторой файл представляет содержимое графического элемента (XAML или BITMAP). Имя второго файла должно быть создано по правилу GraphicLayerElementConstants.GRAPHIC_LAYER_ELEMENT_CONTENT + ContentId, где\nContentId - идентификатор содержимого графического элемента\nСвойства\nGuid ElementId { get; }\nИдентификатор графического элемента\nGuid ContentId { get; }\nИдентификатор содержимого графического элемента\ndouble OffsetY { get; }\nОтступ по вертикали в точках\ndouble OffsetX { get; }\nОтступ по горизонтали в точках\nPoint Scale { get; }\nМасштаб по X и Y, по-умолчанию (1,1)\ndouble Angle { get; }\nУгол поворота\nint PositionId { get; }\nИдентификатор пользователя, у которого есть права на редактирования элемента (если 0, то редактировать могут все)\nint PageNumber { get; }\nНомер страницы, на которую наложен графический элемент (от 0)\nVerticalAlignment VerticalAlignment { get; set; }\nВертикальное выравнивание\nHorizontalAlignment HorizontalAlignment { get; set; }\nГоризонтальное выравнивание\nstring ContentType { get; set; }\nТип содержимого графического элемента ( GraphicLayerElementConstants.XAML или GraphicLayerElementConstants.BITMAP )\nbool IsFloating { get; set; }\nОпределяет, является ли графический элемент плавающим (будет ли он встраиваться в документ при создании запроса на подпись или отправке на диск). Если true, то графический элемент никогда не будет вшит и всегда будет доступен для перемещения и удаления.","keywords":[]},"pages/client/ice/xps/IFileSaver.html":{"title":"Интерфейс <code class=\"yfm-clipboard-inline-code\" role=\"button\" aria-label=\"Блок кода\" aria-description=\"Чтобы скопировать текст внутри блока нажмите на блок\" tabindex='0' id=\"inline-code-id-wrwhis3a\">IFileSaver</code>","content":"Интерфейс позволяет сохранять документы (повторяет логику работы команды \"Отправить -> На диск\"). Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIFileSaver.SaveFileAsync\nМетод сохраняет файлы документа по указанному пути.\nTask<IList<string>> IFileSaver. SaveFileAsync (IDataObject dataObject, string outputFilePath, FileSaverOptions options = null);\nгде:\ndataObject - документ с файлами.\noutputFilePath - путь сохранения файлов.\noptions - дополнительные параметры для IFileSaver.\nIFileSaver.SaveFileVersionAsync\nМетод сохраняет файлы документа выбранной версии по указанному пути.\nTask<IList<string>> IFileSaver. SaveFileVersionAsync (IDataObject dataObject, DateTime snapshot, string outputFilePath, FileSaverOptions options = null);\nгде:\ndataObject - документ с файлами.\nsnapshot - Created timestamp версии IFilesSnapshot для сохранения.\noutputFilePath - путь сохранения файлов.\noptions - дополнительные параметры для IFileSaver.\nClass FileSaverOptions\nДополнительные параметры для IFileSaver.\nСвойства\nGraphicLayerOption GraphicLayerOption { get; set; }\nОпределяет, как вшивать элементы в XPS файл при сохранении.\nGraphicLayerOption Enum\nОпределяет, как вшить графические слои, метки и штрихкоды в XPS файл при сохранении.\nПоля\nInjectFloatingRelatable\nВшить в зависимости от параметра IsFloating у элементов.\nForceInject\nВшить все элементы.\nKeepAllAsFloating\nДобавить к файлу все элементы как плавающие.\nLoseGraphicLayers\nНичего не вшивать и не добавлять к документу, кроме подписей.","keywords":[]},"pages/client/ice/xps/IXpsMerger.html":{"title":"Интерфейс IXpsMerger","content":"Интерфейс позволяет сохранять скомпонованный XPS документ по указанному пути. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIXpsMerger.SaveMergedXps\nМетод сохраняет скомпонованный документ по пути и производит подписку на событие завершения сохранения\nvoid SaveMergedXps (string filepath, IXpsMergerSaveListener saveListener);\nгде:\nfilepath - путь для сохранения.\nsaveListener - обработчик события завершения сохранения документа","keywords":[]},"pages/client/ice/xps/GraphicLayerElementConstants.html":{"title":"GraphicLayerElementConstants","content":"Класс с константами для работы с графическим слоем\nСвойства\npublic const string GRAPHIC_LAYER_ELEMENT = \"PILOT_GRAPHIC_LAYER_ELEMENT_\";\nКонстанта для обозначения графического элемента\npublic const string GRAPHIC_LAYER_ELEMENT_CONTENT = \"PILOT_CONTENT_GRAPHIC_LAYER_ELEMENT_\";\nКонстанта для обозначения содержимого графического элемента.\npublic const string XAML = \"xaml\";\nКонстанта для обозначения содержимого XAML.\npublic const string BITMAP = \"bitmap\";\nКонстанта для обозначения содержимого растровой графики.\npublic static string Version = \"2\";\nКонстанта для обозначения версии описания графического элемента.","keywords":[]},"pages/client/ice/xps/IXpsMergerSaveListener.html":{"title":"Интерфейс IXpsMergerSaveListener","content":"Интерфейс позволяет обработать завершение сохранения скомпонованного XPS документа. Для использования необходимо создать класс, унаследованный от абстрактного XpsMergerSaveListener, и передать его аргументом в метод IXpsMerger.SaveMergedXps\nIXpsMergerSaveListener.OnSaveCompleted\nМетод вызывается при завершении сохранения документа\nvoid OnSaveCompleted (string filepath);\nгде:\nfilepath - путь до сохраненного документа.","keywords":[]},"pages/client/ice/ux/ux.html":{"title":"Интерфейсы управления","content":"Для получения доступа к интерфейсам их необходимо передать в конструктор. Можно передавать любые из перечисленных ниже интерфейсов. При этом конструктор необходимо пометить атрибутом [ImportingConstructor].\n[ Export ( typeof (IObjectContextMenu))] public class ModifyObjectsPlugin: IObjectContextMenu\n{ private readonly ITabServiceProvider _ viceProvider; [ImportingConstructor] public ModifyObjectsPlugin (ITabServiceProvider tabServiceProvider) { _tabServiceProvider = tabServiceProvider; }\n}","keywords":[]},"pages/client/ice/dataconstructor/IMessagesBuilder.html":{"title":"Интерфейс IMessagesBuilder","content":"Интерфейс обеспечивает возможность создания и наполнения дополнительными данными сообщений.\nМетоды IChatMessage Message\nIChatMessage Message { get; }\nВовзвращает полученное в результате создания сообщение\nCreateChatMessage\nIMessageBuilder CreateChatMessage (MessageType type, Guid chatId);\nСоздает сообщение\nгде:\ntype - тип сообщения.\nchatId - идентификатор чата.\nAddText\nIMessageBuilder AddText (string text);\nЗаполняет Message.Data для текстового сообщения\nгде:\ntext - текст сообщения.\nIMessageBuilder AddText (string text, bool isReadOnly);\nЗаполняет Message.Data для текстового сообщения\nгде:\ntext - текст сообщения.\nisReadOnly - определяет, будет ли текстовое сообщение доступно для редактирования.\nAddChatCreationData\nIMessageBuilder AddChatCreationData (string name, string description, ChatKind type);\nЗаполняет Message.Data данными для создания чата\nгде:\nname - имя чата.\ndescription - описание чата\ntype - тип чата\nAddChatRelation\nIMessageBuilder AddChatRelation (ChatRelationType relationType, Guid objectId);\nЗаполняет Message.Data данными для создания связи чата с объектом\nгде:\nrelationType - тип связи.\nobjectId - идентификатор связываемого объекта.\nAddChatMemberData\nIMessageBuilder AddChatMemberData ( int personId, bool isNotifiable, bool isAdmin)\nЗаполняет Message.Data данными для добавляения и изменения параметров участника чата\nгде:\npersonId - идентификатор участника чата.\nisNotifiable - >признак получения участником уведомлений по чату\nisAdmin -признак администратора чата.\nDeleteChatMember\nIMessageBuilder DeleteChatMember ( int personId);\nЗаполняет Message.Data данными для удаления участника чата\nгде:\npersonId - идентификатор участника чата.\nСвойства IDataObject DataObject\nIDataObject DataObject { get; }\nСвойство возвращает пустую болванку редактируемого элемента с заполненным идентификатором элемента и идентификатором родительского элемента.","keywords":[]},"pages/client/ice/dataconstructor/IObjectBuilder.html":{"title":"Интерфейс IObjectBuilder","content":"Интерфейс обеспечивает возможность наполнения или редактирования элементов атрибутами и дополнительными свойствами.\nМетоды SetAttribute\nIObjectBuilder SetAttribute (string name, string value);\nМетод задает или изменяет атрибут с заданным именем.\nгде:\nname - имя атрибута.\nvalue - новое значение атрибута.\nМетод имеет несколько перегрузок:\nIObjectBuilder SetAttribute(string name, string value); - для установки строкового значения атрибута.\nIObjectBuilder SetAttribute(string name, int value); - для установки целочисленного значения атрибута.\nIObjectBuilder SetAttribute(string name, long value); - для установки целочисленного 64-разрядного значения атрибута.\nIObjectBuilder SetAttribute(string name, DateTime value); - для установки значения атрибута времени.\nIObjectBuilder SetAttribute(string name, double value); - для установки цифрового значения атрибута с плавающей точкой.\nIObjectBuilder SetAttribute(string name, decimal value); - для установки денежного значения атрибута.\nIObjectBuilder SetAttribute(string name, Guid value); - для установки значения атрибута идентификатора Guid.\nIObjectBuilder SetAttribute(string name, int[] value); - для установки значения атрибута список идентификаторов типа int.\nIObjectBuilder SetAttribute(string name, string[] value); - для установки значения атрибута список идентификаторов типа string.\nRemoveAttribute\nIObjectBuilder RemoveAttribute (string name);\nМетод удаляет атрибут с заданным именем.\nгде:\nname - имя атрибута.\nAddRelation\nIObjectBuilder AddRelation (string name, ObjectRelationType type, Guid sourceId, Guid targetId, DateTime versionId);\nМетод добавляет новую связь к актуальной версии объекта.\nгде:\nname - имя связи.\ntype - тип связи.\nsourceId - идентификатор первого объекта.\ntargetId - идентификатор второго объекта.\nversionId - идентификатор версии второго объекта.\nAddOrReplaceFile\nIObjectBuilder AddOrReplaceFile (string name, Stream stream, IFile file, DateTime creationTime, DateTime lastAccessTime, DateTime lastWriteTime);\nМетод добавляет или заменяет файл к заданному элементу.\nгде:\nname - имя файла.\nstream - поток файла.\nfile - описание файла.\ncreationTime - дата создания файла.\nlastAccessTime - дата последнего чтения из файла.\nlastWriteTime - дата последнего изменения файла.\nReplaceFileInSnapshot\nIObjectBuilder ReplaceFileInSnapshot (DateTime snapshotCreated, Guid fileToReplace, string name, Stream stream, DateTime creationTime, DateTime lastAccessTime, DateTime lastWriteTime);\nМетод заменяет файл в заданном снимке файлов (данное действие доступно только пользователю с правами администратора).\nгде:\nsnapshotCreated - временная метка снимка файлов.\nfileToReplace - идентификатор заменяемого файла.\nname - имя файла.\nstream - поток файла.\ncreationTime - дата создания файла.\nlastAccessTime - дата последнего чтения из файла.\nlastWriteTime - дата последнего изменения файла.\nAddFile\nIObjectBuilder AddFile (string path);\nМетод добавляет файл к заданному элементу.\nгде:\npath - путь до файла, который надо добавить.\nIObjectBuilder AddFile (string name, Stream stream, DateTime creationTime, DateTime lastAccessTime, DateTime lastWriteTime);\nгде:\nname - имя добавляемого файла.\nstream - поток добавляемого файла.\ncreationTime - дата создания файла.\nlastAccessTime - дата последнего доступа к файлу.\nlastWriteTime - дата последнего доступа на запись в файл.\nRemoveFile\nIObjectBuilder RemoveFile (Guid fileId);\nМетод-расширение интерфейса IObjectBuilder. удаляет файл из ActualFilesSnapshot элемента.\nгде:\nfileId - идентификатор файла, который надо удалить.\nAddAccessRecords\nIObjectBuilder AddAccessRecords ( int orgUnitId, AccessLevel level, DateTime validThrough, AccessInheritance inheritance, AccessType type);\nМетод добавляет права доступа на элемент.\nгде:\norgUnitId - идентификатор должности или подразделения, на которое будет добавлено право доступа.\nlevel - уровень доступа к элементу.\nvalidThrough - срок действия права.\ninheritance - уровень наследования прав доступа.\nAccessInheritance.None - без наследования\nAccessInheritance.InheritUntilSecret - наследование для общедоступных (скрытые элементы прерывают цепочку наследования прав доступа)\nAccessInheritance.InheritWholeSubtree - наследование для всех (запись прав доступа будет наследоваться для всех дочерних элементов, в том числе скрытых). Добавление или удаление прав доступа с этой опцией доступно только администратору базы данных.\ntype - тип записи прав доступа. Доступные значения:\nAccessType.Allow - разрешительное право доступа\nAccessType.Deny - запретительное право доступа. Добавление или удаление запретительных прав доступа доступно только администратору базы данных.\nIObjectBuilder AddAccessRecords ( int orgUnitId, AccessLevel level, DateTime validThrough, AccessInheritance inheritance, AccessType type, int [] typeIds);\nМетод добавляет права доступа на элемент.\nгде:\norgUnitId - идентификатор должности или подразделения, на которое будет добавлено право доступа.\nlevel - уровень доступа к элементу.\nvalidThrough - срок действия права.\ninheritance - уровень наследования прав доступа.\nAccessInheritance.None - без наследования\nAccessInheritance.InheritUntilSecret - наследование для общедоступных (скрытые элементы прерывают цепочку наследования прав доступа)\nAccessInheritance.InheritWholeSubtree - наследование для всех (запись прав доступа будет наследоваться для всех дочерних элементов, в том числе скрытых). Добавление или удаление прав доступа с этой опцией доступно только администратору базы данных.\ntype - тип записи прав доступа. Доступные значения:\nAccessType.Allow - разрешительное право доступа\nAccessType.Deny - запретительное право доступа. Добавление или удаление запретительных прав доступа доступно только администратору базы данных.\ntypeIds - идентификаторы типов для которых будет добавлено право доступа, null - значит все типы.\nRemoveAccessRecords\nIObjectBuilder RemoveAccessRecords (Func<IAccessRecord, bool > predicate);\nМетод удаляет права доступа на элемент по предикату.\nгде:\npredicate - предикат, соответствующие которому права доступа будут удалены из элемента.\nMakeSecret\nIObjectBuilder MakeSecret ();\nМетод позволяет сделать элемент скрытым.\nMakePublic\nIObjectBuilder MakePublic ();\nМетод позволяет сделать элемент общедоступным.\nCreateFileSnapshot\nIObjectBuilder CreateFileSnapshot (string reason);\nМетод позволяет создать снимок файлов и указать причину. Текущие файлы будут перемещены в историю.\nгде:\nreason - причина создания снимка файлов.\nMakeSnapshotActual\nIObjectBuilder MakeSnapshotActual (string reason, IFilesSnapshot snapshot);\nМетод позволяет сделать выбранный снимок файлов текущим.\nгде:\nreason - причина создания снимка файлов.\nsnapshot - снимок, который надо сделать текущим (актуальным).\nAddSubscriber\nIObjectBuilder AddSubscriber ( int personId);\nМетод позволяет подписаться на изменения элемента.\nгде:\npersonId - идентификатор пользователя.\nRemoveSubscriber\nIObjectBuilder RemoveSubscriber ( int personId);\nМетод позволяет отписаться от изменений элемента.\nгде:\npersonId - идентификатор пользователя.\nSetIsDeleted\nIObjectBuilder SetIsDeleted ( bool isDeleted);\nМетод позволяет задать элементу состояние удалено безвозвратно.\nгде:\nisDeleted - флаг указывающий удалить объект или нет.\nSetIsInRecycleBin\nIObjectBuilder SetIsInRecycleBin ( bool isInRecycleBin);\nМетод позволяет задать элементу состояние удалено корзину.\nгде:\nisInRecycleBin - флаг указывающий удалить объект в корзину или нет.\nSetParent\nIObjectBuilder SetParent (Guid parentId);\nМетод позволяет задать элементу нового родителя.\nгде:\nparentId - идентификатор нового родителя.\nSetType\nIObjectBuilder SetType (IType type);\nМетод позволяет задать элементу тип.\nгде:\ntype - тип элемента.\nВажно\nРекомендуется использовать этот метод только для восстановления безвозвратно удаленных объектов. В остальных случаях это может привести к неработоспособности системы.\nSetCreator\nIObjectBuilder SetCreator ( int creatorId);\nМетод позволяет задать создателя элемента.\nгде:\ncreatorId - идентификатор пользователя (не должности).\nSetCreationDate\nIObjectBuilder SetCreationDate (DateTime dateTime);\nМетод позволяет задать дату создания элемента (доступно только при создании нового элемента).\nгде:\ndateTime - дата/время создания в UTC.\nLock\nIObjectBuilder Lock ();\nМетод позволяет заблокировать объект для изменений текущим пользователем.\nUnlock\nIObjectBuilder Unlock ();\nМетод позволяет разблокировать объект.\nSaveHistoryItem\nIObjectBuilder SaveHistoryItem ();\nЕсли метод SaveHistoryItem был вызван в процессе конструирования изменения, при применении изменения предыдущее состояние объекта будет сохранено в IDataObject.HistoryItems.\nSetFileState\nIObjectBuilder SetFileState (Guid fileId, Guid toStateId, DateTime snapshotCreated);\nМетод позволяет перевести файл в заданное состояние, если переход для него доступен по группе состояний и правам доступа.\nгде:\nfileId - идентификатор файла;\ntoStateId - идентификатор состояния, в которое необходимо перевести файл;\nsnapshotCreated - дата создания версии.\nISignatureModifier SetSignatures\nISignatureModifier SetSignatures (Predicate<IFile> selectFilesPredicate);\nМетод позволяет задать новые запросы на подпись к выбранным файлам.\nгде:\nselectFilesPredicate - функция выбора набора файлов.\nВозвращает объект типа ISignatureModifier с помощью, которого можно изменить набор запросов на подпись.","keywords":[]},"pages/client/ice/ui/IToolbarButtonItemBuilder.html":{"title":"Интерфейс IToolbarButtonItemBuilder","content":"Интерфейс позволяет добавить свойства к элементу панели инструменотов.\nIToolbarButtonItemBuilder.WithHeader\nМетод позволяет добавить отображаемое в UI название.\nIToolbarButtonItemBuilder WithHeader (string header);\nгде:\nheader - отображаемое в UI название элемента.\nIToolbarButtonItemBuilder.WithIcon\nМетод позволяет добавить иконку элементу панели инструментов. Обратите внимание, иконка должна быть в формате SVG\nIToolbarButtonItemBuilder WithIcon (byte[] svgIcon);\nгде:\nsvgIcon - иконка в формате SVG.\nIToolbarButtonItemBuilder.WithIsEnabled\nМетод позволяет задать значение доступности элемента.\nIToolbarButtonItemBuilder WithIsEnabled ( bool value);\nIToolbarButtonItemBuilder.WithShowHeader\nМетод позваляет спрятать или показать заголовок элемента. Чтобы показать элемент только в виде иконки необходимо в метод WithShowHeader передать параметр false\nIToolbarButtonItemBuilder WithShowHeader ( bool value);\nIToolbarButtonItemBuilder.WithHint\nМетод позволяет добавить подсказку к элементу панели инструментов.\nIToolbarButtonItemBuilder WithHint (string hint);\nгде:\nhint - текст подсказки.","keywords":[]},"pages/client/ice/ux/ITabStateHandler.html":{"title":"ITabStateHandler","content":"Интерфейс используется для сохранения состояния вкладок, принадлежащих модулю расширения, при выходе из приложения Pilot, а так же восстановления вкладок расширения и их состояния при последующем запуске приложения Pilot. Для примера реализации функционала сохранения и восстановления открытых вкладок расширения смотри пример OpenSpacePlugin из состава модулей SDK.\nМетоды\nbool TrySaveTabState (Guid tabId, out Guid extensionId, out string state, out string tabTitle);\nМетод, позволяющий сохранить состояние вкладки, если она принадлежит модулю расширения. Вызывается клиентом Pilot непосредственно перед закрытием. В этот момент модуль расширения может проверить, принадлежит ли ему вкладка с указанным идентификатором, и если да, передать информацию, которая может быть использована для восстановления данной вкладки расширения после перезапуска. Должен возвращать true в случае, если вкладка с указанным идентификатором принадлежит данному модулю расширения (если он её ранее создавал), и если данную вкладку необходимо будет автоматически открыть заново, когда клиент Pilot будет запущен вновь. В случае, если вкладка с указанным идентификатором не принадлежит модулю расширения, либо не должна быть сохранена для последующего восстановления, метод должен вернуть начение false.\nгде:\ntabId - идентификатор вкладки, которая открыта на момент выхода из приложения. Используется для утсановления факта принадлежности данной вкладки текущему модулю расширения;\nextensionId - идентификатор модуля расширения, который необходимо вернуть в клиент Pilot. С помощью данного идентификатора возможно будет принять решение, принадлежит ли сохраненное состояние вкладки данному модулю расширения на этапе запуска клиента Pilot;\nstate - сериализованное в виде строки состояние вкладки, которое необходимо вернуть в клиент Pilot. Эта строка будет передана модулю расширения в момент запуска приложения для восстановлния состояния вкладки расширения;\ntabTitle - сзаголовок вкладки, который необходимо вернуть в клиент Pilot. Это заголовок будет использоваться при восстановлении вклдаки после запуска приложения до тех пор, пока модуль расширения не обновит его в соответсвии с внутренней логикой восстановления состояния;\nbool TryAddTabAndRestoreState (Guid extensionId, string state, Guid tabId);\nМетод, который вызывается клиентом Pilot при запуске и восстановлении набора сохраненных ранее вкладок. В этот момент модуль расширения должен проверить, совпадает ли идентификатор расширения, с которым модуль сохраняет состояниес своих вкладок, с идентификатором, который передан из клиента Pilot. Если идентификаторы совпадают и модуль успешно восстановил состояние вкладки, метод должен вернуть значение true. Если же информация о состоянии вкладки не принадлежит данному модулю, либо логика не позволяет восстановить данную вкладу, модуль должен вернуть занчение false.\nextensionId - идентификатор расширения, который был использован при сохранении состояния вкладки;\nstate - сериализованная в виде строки информация, которая позволяет восстановить состояние вкладки;\ntabId - идентификатор пустой вкладки, которая подготовлена системой Pilot, для замещения восстановленной версией вкладки модуля расширения. Метод ITabServiceProvider.UpdateTabPageContent должен быть использован для того, чтобы показать вновь созданную модулем расширения вкладку взамен текущей пустой вкладки с переданным идентификатором.","keywords":[]},"pages/client/ice/ux/IPilotDialogService.html":{"title":"IPilotDialogService","content":"Интерфейс предоставляет работу со встроенными диалоговыми и всплывающими окнами клиента Pilot-ICE/ECM. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nСвойства\ntring AccentColor { get; }\nВозвращает текущий главный (акцентный) цвет приложения.\nThemeNames Theme { get; }\nВозвращает текущую схему приложения.\nМетоды\nvoid ShowSharingSettingsDialog (IEnumerable<Guid> objectIds);\nМетод показывает диалог управления общим доступом к элементам.\nгде:\nobjectIds - список выбранных идентификаторов элементов.\nIEnumerable<IOrganisationUnit> ShowPositionSelectorDialog (IPilotDialogOptions options = null);\nМетод показывает диалог выбора пользователей и должностей.\nгде:\noptions - настройки диалога.\nДиалог возвращает список выбранных должностей и пользователей.\nIEnumerable<IDataObject> ShowDocumentsSelectorDialog (IPilotDialogOptions options = null);\nМетод показывает диалог выбора элементов из обозревателя проектов.\nгде:\noptions - настройки диалога.\nМетод возвращает список выбранных элементов.\nIEnumerable<IDataObject> ShowDocumentsSelectorDialogAndNavigate (Guid parentId, IPilotDialogOptions options = null);\nМетод показывает диалог выбора элементов из обозревателя проектов (с навигацией в указанную параметром папку).\nгде:\nparentId - идентификатор родительского элемента, навигация в который будет выполнена при открытии диалога.\noptions - настройки диалога.\nМетод возвращает список выбранных элементов.\nIEnumerable<IDataObject> ShowDocumentsSelectorByObjectTypeDialog (IEnumerable< int > objectTypeIds, IPilotDialogOptions options = null);\nМетод показывает диалог выбора элементов указанного типа из обозревателя проектов.\nгде:\nobjectTypeIds - Id типов, которые могут быть выбраны\noptions - настройки диалога.\nМетод возвращает список выбранных элементов.\nIEnumerable<IDataObject> ShowDocumentsSelectorByObjectTypeDialogAndNavigate (IEnumerable< int > objectTypeIds, Guid parentId, IPilotDialogOptions options = null);\nМетод показывает диалог выбора элементов указанного типа из обозревателя проектов (с навигацией в указанную параметром папку).\nгде:\nobjectTypeIds - Id типов, которые могут быть выбраны\nparentId - идентификатор родительского элемента, навигация в который будет выполнена при открытии диалога.\noptions - настройки диалога.\nМетод возвращает список выбранных элементов.\nIEnumerable<IDataObject> ShowTasksSelectorDialog2 (IPilotDialogOptions options = null);\nМетод показывает диалог выбора заданий.\nгде:\noptions - настройки диалога.\nМетод возвращает список выбранных объектов заданий.\nIEnumerable<IDataObject> IPilotDialogService. ShowReferenceBookDialog (string referenceBookConfiguration, string serializationId = null, IPilotDialogOptions options = null);\nМетод показывает диалог выбора элементов из строкового справочика\nгде:\nreferenceBookConfiguration - строка конфигурации справочника (может быть получена из дополнительных параметров соответсвующего атрибута);\nserializationId - идентификатор, использующийся для сохранения и восстановления состояния диалога (список развернутых узлов дерева);\noptions - дополнительные параметры показа диалога;\nIEnumerable<IDataObject> IPilotDialogService. ShowElementBookDialog (string elementBookConfiguration, string serializationId = null, IPilotDialogOptions options = null);\nМетод показывает диалог выбора элементов для атрибута Справочник элементов\nгде:\nelementBookConfiguration - строка конфигурации справочника элементов (может быть получена из дополнительных параметров соответсвующего атрибута);\nserializationId - идентификатор, использующийся для сохранения и восстановления состояния диалога (список развернутых узлов дерева);\noptions - дополнительные параметры показа диалога;\nvoid ShowTaskDialog ( int taskTypeId, IObjectModifier modifier, IPilotDialogOptions options = null);\nМетод показывает диалог задания с предустановленными изменениями из modifier.\nгде:\ntaskId - идентификатор объекта задания для которого нужно показать диалог;\nmodifier - объект модификатора, с помощью которого можно вносить изменения в объект;\noptions - дополнительные параметры показа диалога;\nvoid ShowEditTaskDialog (Guid taskId, bool isReadonly, DialogOptions options = null);\nМетод показывает диалог редактирования задания\nгде:\ntaskId - идентификатор объекта задания для которого нужно показать диалог редактирования;\nisReadonly - флаг, который определяет, должна ли карточка задания быть показана в режиме только для чтения;\noptions - дополнительные параметры показа диалога;\nvoid ShowObjectDialog (Guid parentId, int objectTypeId, IReadOnlyDictionary<Guid, INChange> changes, bool showDocumentPreview);\nМетод показывает диалог создания нового объекта\nгде:\nparentId - идентификатор родительского объекта, в детях которого должен быть создан новый объект;\nobjectTypeId - тип создаваемого объекта;\nchanges - предзаполненные изменения объекта. Поддерживается только предзаполнение атрибутов значниями, которые будут показаны в карточке объекта;\nshowDocumentPreview - флаг, который указывает, показывать ли в диалоге создания объекта панель для добавлния документов;\nvoid ShowEditObjectDialog (Guid id, bool showDocumentPreview);\nМетод показывает диалог редактирования карточки существующего объекта\nгде:\nid - идентификатор объекта;\nshowDocumentPreview - флаг, который указывает, показывать ли в диалоге создания объекта панель для добавлния документов;\nvoid ShowBalloon (string title, string message, PilotBalloonIcon icon);\nМетод показывает всплывающее окно с заданным заголовком, текстом и иконкой.\nгде:\ntitle - заголовок всплывающего окна;\nmessage - текст всплывающего окна;\nicon - иконка всплывающего окна;\nIPilotDialogOptions NewOptions ();\nСоздает параметры диалога по умолчанию.","keywords":[]},"pages/client/ice/ux/IChatControlsOptions.html":{"title":"Интерфейс IChatControlsOptions","content":"Интерфейс обеспечивает возможность настроить отображение элемента \"Чаты\".\nМетоды\nМетод позволяет задать видимость инофрмационной панели элемента \"Чаты\"\nIChatControlsOptions WithShowChatInfo ( bool value );\nМетод позволяет задать видимость заголовка объекта по которому создан чат\nIChatControlsOptions WithShowObjectCaption ( bool value );","keywords":[]},"pages/client/ice/ux/IChatControlsProvider.html":{"title":"Интерфейс IChatControlsProvider","content":"Интерфейс обеспечивает возможность встроить элемент пользовательского интерфейса \"Чаты\" в интерфейс расширений. Получить этот интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nМетоды\nМетод позволяет получить элемент пользовательского интерфеса отвечающий за работу чатов привязанных к заданному элементу,\nChatControl GetObjectChatsControl ( Guid objectId, IChatControlsOptions options = null );\nгде:\nobjectId - идентификатор элемента, к которому привязана переписка (чат).\noptions - дополнительные настройки элемента \"Чаты\".\nВозвращает объект типа ChatControl, который предоставляет два свойства: объект типа FrameworkElement, который отображает элемент интерфейса \"Чаты\" и интерфейс IChatControlsInteraction, который используется для взаимодействия с с ним.\nМетод создания дополнительных настроек элемента \"Чаты\".\nIChatControlsOptions NewChatControlOptions ();","keywords":[]},"pages/client/ice/ux/IObjectCardControlInteraction.html":{"title":"Интерфейс IObjectCardControlInteraction","content":"Служит для взаимодействия расширения с карточкой объекта, которая была встроена с помощью метода GetObjectCardControl интерфейса IObjectCardControlProvider.\nМетоды\nOnObjectCardUpdated Событие, которое позволяет отслеживать момент изменения значения атрибутов в карточки объекта.\nevent EventHandler OnObjectCardUpdated\nGetIsChildDialogOpen Возвращает true, если в настоящий момент остаётся открытым дочерний диалог, который был вызван из карточки объекта. Например, диалог выбора организационных единиц.\nbool GetIsChildDialogOpen ();\nGetIsValidInput Позволяет узнать, являются ли все введеные значения атрибутов в карточке валидными.\nbool GetIsValidInput ();\nGetIsDataChanged Возвращает true, если значение хотя бы одного атрибута было изменено.\nbool GetIsDataChanged ();\nGetValues Используется для получения текущих значений атрибутов в карточке объекта.\nIDictionary< string, ObjectCardValue> GetValues ();\nSetIsReadOnly Устанавливает значение фалага, который определяет, находится ли карточка объекта в режиме только для чтения.\nvoid SetIsReadOnly ( bool value );\nHideCreatedByInfo Скрывает строку в интерфейсе карточки, которая отображает автора и время создания объекта.\nvoid HideCreatedByInfo ();\nUseCompactScrollbar Переключает карточку в режим использования компактного вертикального скроллбара.\nvoid UseCompactScrollbar ();","keywords":[]},"pages/client/ice/ux/IConnectionStateProvider.html":{"title":"Интерфейс IConnectionStateProvider","content":"Интерфейс для получения информации о состоянии подключения к Pilot-Server\nIConnectionStateProvider.IsOnline\nМетод, определяющий, установлено ли соединение клиента с Pilot-Server\nbool IsOnline ();\nIConnectionStateProvider.Subscribe\nПодписка на изменение состояния подключения клиента с Pilot-Server\nIObservable< bool > Subscribe ();","keywords":[]},"pages/client/ice/ux/IObjectCardControlProvider.html":{"title":"Интерфейс IObjectCardControlProvider","content":"Интерфейс служит для встраивания карточки объекта Pilot в интерфейс расширений. Может использоваться как для отображения карточки уже существующего объекта, так и для того, чтобы показать карточку создания нового объекта заданного типа. Получить этот интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nМетоды\nGetObjectCardControl Метод используется для получения элементов отображения и управления карточкой объекта. Возвращает объект типа ObjectCardControl, который предоставляет два свойства: котрол типа FrameworkElement, который при встраивании в визуальное дерева расширения отображает карточку объекта; и объект типа IObjectCardControlInteraction, который используется для управления карточкой: получение введеных пользователем значений атрибутов, переход в режим только для чтения, и других возможностей.\nМетод имеет два варианта перегрузки для встраивания карточки либо в режиме создания нового объекта, либо в режиме редактирования существующего объекта. Встраивание карточки в режиме создания нового объекта осуществляется при помощи следующего варианта метода:\nObjectCardControl GetObjectCardControl ( Guid newObjectId, IType newObjectType, Guid parentObjectId, IDictionary< string, object > initAttributes );\nгде:\nnewObjectId - идентификатор, который будет назначен новому объекту после создания;\nnewObjectType - тип нового объекта;\nparentObjectId - идентификатор родительского объекта, в детях которого будет создан новый объект;\ninitAttributes - список предопределенных значений атрибутов, которыми будет инициализирована карточка нового объекта;\nВстраивание карточки в режиме редактирования существующего объекта осуществляется другим вариантом метода:\nObjectCardControl GetObjectCardControl ( Guid objectId, bool isReadonly );\nгде:\nobjectId - идентификатор объекта, для которого будет показана карточка;\nisReadonly - флаг, который управляет тем, будет ли карточка показана в режиме только для чтения.;","keywords":[]},"pages/client/ice/ux/IPilotServiceProvider.html":{"title":"Интерфейс IPilotServiceProvider","content":"Интерфейс обеспечивает возможность зарегистрировать и получить сервисы определенного типа (включая зарегистрированные другими модулями). Получить этот интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIPilotServiceProvider.GetServices\nМетод позволяет получить сервисы заданного типа.\nIEnumerable < TService > GetServices < TService >();\nгде:\nTService - тип сервиса.\nIPilotServiceProvider.Register\nМетод позволяет зарегистрировать экземпляр сервиса заданного типа.\nvoid Register < TService >( TService service );\nгде:\nTService - тип сервиса;\nservice - экземпляр сервиса заданного типа.","keywords":[]},"pages/client/ice/ux/IEventAggregator.html":{"title":"Интерфейс IEventAggregator","content":"Интерфейс обеспечивает возможность подписываться на разные события возникающие в клиенте Pilot-ICE/ECM. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIEventAggregator.Subscribe\nМетод подписывает заданного подписчика на события.\nvoid IEventAggregator. Subscribe (object subscriber);\nгде:\nsubscriber - подписчик. Должен реализовывать один или несколько интерфейсов событий\nПример:\nusing Ascon.Pilot.SDK; namespace EventSample\n{ class EventSubscriber: IHandle<UnloadedEventArgs>, IHandle<LoadedEventArgs> { private readonly IEventAggregator _eventAggregator; public EventSubscriber (IEventAggregator eventAggregator) { _eventAggregator = eventAggregator; _eventAggregator. Subscribe ( this ); } public void Handle (UnloadedEventArgs message) { //TODO do something when unloading extension } public void Handle (LoadedEventArgs message) { //TODO do something when loading extension } }\n}\nВ примере показано как можно подписаться на события загрузки и выгрузки расширения.\nIEventAggregator.Unsubscribe\nМетод отписывается от ранее подписанных событий;\nvoid IEventAggregator. Unsubscribe (object subscriber);\nгде:\nsubscriber - подписчик. Должен реализовывать один или несколько интерфейсов событий.","keywords":[]},"pages/client/ice/conf/IReferenceBookConfiguration.html":{"title":"Интерфейс IReferenceBookConfiguration","content":"Конфигурация справочника, которая описывает его тип, поведение и правила формирования списка его элементов.\nRefBookKind Kind\nСвойство типа RefBookKind, определяет тип справочника.\nIEnumerable<string> Values\nСвойство, которое определяет коллекцию элементов справочника, если свойство Kind имеет значение RefBookKind.Enum.\nGuid Source\nИдентификатор объекта базы данных, дочерние объкты которого являются элементами справочника, если свойство Kind имеет значение RefBookKind.Object.\nIEnumerable<string> ElementsTypes\nСписок имен типов, из объектов которого должны формироваться элементы справочника, если свойство Kind имеет значение RefBookKind.Object. Если имен список пуст, то в формировании элементов справочника учавствуют дочерние элементы любого типа.\nbool IsEditable\nОпределяет, имеет ли пользователь возможность вручную отредактировать значение выбранного из элементов справочника. Если свойство имеет значение false, то редактор атрибута не допускает ручной ввод значений, и значение атрибута может быть лишь выбрано из списка. В противном случае, пользователь может вводить значение атрибута вручную, а список элементов справочника используется как список значений для быстрого заполнения.\nbool CreateLink\nОпределяет, добавлять ли связь нового объекта с выбранным из справочника элементом. Если свойство имеет значение false, то при выборе элемента из справочника задается значение атрибута объекта, при этом свзяь между объектом и элементом справочника не создается. В противном случае наряду с заданием значения атрибута будет создана связь между объектом и выбранным элементом справочика.\nstring StringFormat\nСтрока форматирования, которая должна использоваться для формирования значения атрибута, при выборе элемента справочника.\nbool AllowMultiSelect\nФлаг, определяет доступен ли мультивыбор в диалоге выбора справочника или нет.\nПеречисление RefBookKind\nУказывает тип справочника, то есть один из возможных вариантов заполнения списка возможных значений справочника.\nRefBookKind.Enum;\nСправочник, элементами которого является предопределенный набор строковых значений. Смотри свойство Values интерфеса IReferenceBookConfiguration.\nRefBookKind.Object;\nСправочник, элементами которого являются дочерние элементы определенного объекта в базе данных. Этот объект определяется идентификатором, значение которого возвращается свойством Source интерфеса IReferenceBookConfiguration.\nRefBookKind.OrgUnit;\nСправочник, который предоставляет выбор элементов оргструктуры базы данных.\nRefBookKind.Type;\nСправочник, который предоставляет выбор типов из базы данных.\nПеречисление RefBookEditorType\nУказывает тип редактора, который должен использоваться для редактирования значения атрибута, для которого назначен справочник.\nRefBookEditorType.Dialog;\nРедактор атрибута должен представлять собой поле ввода с кнопкой, которая вызывает новый диалог для выбора значений из элементов справочника.\nRefBookEditorType.ComboBox;\nВ качестве редактора значения атрибута должен использоваться комбобокс, выпадающий список которого состоит из элементов справочника.","keywords":[]},"pages/client/ice/ux/IDocumentExplorer.html":{"title":"Интерфейс IDocumentExplorer","content":"Интерфейс позволяет управлять влкадкой с просмотрщиком документов. Получить интерфейс можно через конструктор помеченный атрибутом [ImportingConstructor].\nIDocumentExplorer.UpdateDocumentPreview\nМетод обновляет текущую вкладку с просмотрщиком документов.\nvoid UpdateDocumentPreview ();","keywords":[]},"pages/client/ice/conf/IAttributeFormatParser.html":{"title":"Интерфейс <code class=\"yfm-clipboard-inline-code\" role=\"button\" aria-label=\"Блок кода\" aria-description=\"Чтобы скопировать текст внутри блока нажмите на блок\" tabindex='0' id=\"inline-code-id-g2uzwejm\">IAttributeFormatParser</code>","content":"Позволяет работать с конфигурайией атрибутов: получать формат отображения атрибутов, а так же десериализованное описание нумераторов и справочников.\nДля получения доступа к интерфейсу поиска его необходимо передать в конструктор. При этом конструктор необходимо пометить атрибутом [ImportingConstructor].\nstring AttributesFormat(string format, Dictionary<string, object> attributes)\nОсуществляет форматирование значениий атрибутов объекта в соответсвии с указанным форматом. Например, используется для получения отображаемого имени объекта. Строка форматирования может быть получена с помощью метода GetAttributeFormat, который описан ниже.\nstring objAttributesDisplayString = _parser. AttributesFormat (format, objectAttributes);\nгде:\nobjAttributesDisplayString - значение, полученное при применении приведенной строки форматирования к текущему состоянию объекта;\n_parser - экземляр объекта, реализующего интерфейс IAttributeFormatParser;\nformat - приведенная строка форматирования атрибутов;\nobjectAttributes - текущее состояние объекта: коллекция пар <ИмяАтрибута, ЗначениеАтрибута>;\nstring GetAttributeFormat(string configuration)\nВозвращает строку форматирования атрибута на основе конфигурации атрибута.\nstring format = _parser. GetAttributeFormat (configuration);\nгде:\nformat - строка форматирования атрибутов объекта;\n_parser - экземляр объекта, реализующего интерфейс IAttributeFormatParser;\nconfiguration - строка конфигурации атрибута;\nstring GetAttributeFormatCulture(string configuration)\nВозвращает имя культуры, которая должна использоваться, при форматировании значения атрибута.\nstring culture = _parser. GetAttributeFormatCulture (configuration);\nгде:\nculture - строка культуры форматирования арибутов объекта;\n_parser - экземляр объекта, реализующего интерфейс IAttributeFormatParser;\nconfiguration - строка конфигурации атрибута;\nbool TryParseNumeratorDeclaration(string declaration, out IEnumerable numeratorInfo)\nМетод для получения десериализованного описания нумераторов из строки конфигурации атрибута. Возвращает true, если строка конфигурации содержит описание нумераторов и его удалось успешно десериализовать; false в обратном случае.\nIEnumerable<INumeratorInfo> numeratorsCollection; bool success = _parser. TryParseNumeratorDeclaration (configuration, out numeratorsCollection);\nгде:\nsuccess - результат успешной десериализации описания нумераторов из приведенной строки конфигурации атрибута;\n_parser - экземляр объекта, реализующего интерфейс IAttributeFormatParser;\nconfiguration - строка конфигурации атрибута;\nnumeratorsCollection - коллекция десериализованных описаний нумераторов, содержавшихся в приведенной строке конфигурации;\nstring PreviewNumeratorFormat(string configuration, Dictionary<string, string> values);\nПрименяет нумератор к текущему состоянию объекта и возвращает строку, которая может использоваться для предпросмотра значения атрибута, которое будет назначено сервером при создании объекта и применения к нему нумератора. Используется для визуализации значения атрибута в карточке создания нового объекта, которое будет назначено сервером.\nstring attributeValuePreview = _parser. PreviewNumeratorFormat (configuration, objectAttributes);\nгде:\nattributeValuePreview - значение атрибута, которое будет получено на стороне сервера, при применении нумератора к текущему состоянию;\nобъекта;\nconfiguration - строка конфигурации нумератора;\nobjectAttributes - текущее состояние объекта: коллекция пар <ИмяАтрибута, ЗначениеАтрибута>;\nbool TryParseReferenceBookConfiguration(string configuration, out IReferenceBookConfiguration referenceBookConfiguration);\nМетод для получения десериализованного описания справочника из строки конфигурации атрибута. Возвращает true, если строка конфигурации содержит описание справочника и его удалось успешно десериализовать; false в обратном случае.\nIReferenceBookConfiguration referenceBookConfiguration; bool success = _parser. TryParseReferenceBookConfiguration (configuration, out referenceBookConfiguration);\nгде:\nsuccess - результат успешной десериализации описания справочника из приведенной строки конфигурации атрибута;\n_parser - экземляр объекта, реализующего интерфейс IAttributeFormatParser;\nconfiguration - строка конфигурации атрибута;\nreferenceBookConfiguration - десериализованное описание справочника, содержавшееся в приведенной строке конфигурации;\nbool TryParseElementBookConfiguration(string configuration, out IElementBookConfiguration elementBookConfiguration);\nМетод для получения десериализованного описания атрибута Справочник элементов. Возвращает true, если строка конфигурации содержит описание справочника и его удалось успешно десериализовать; false в обратном случае.\nIElementBookConfiguration elementBookConfiguration; bool success = _parser. TryParseElementBookConfiguration (configuration, out elementBookConfiguration);\nгде:\nsuccess - результат успешной десериализации описания справочника из приведенной строки конфигурации атрибута;\n_parser - экземляр объекта, реализующего интерфейс IAttributeFormatParser;\nconfiguration - строка конфигурации атрибута;\nelementBookConfiguration - десериализованное описание справочника, содержавшееся в приведенной строке конфигурации. Интерфейфс IElementBookConfiguration;\nbool TryParseUserStateConfiguration(string configuration, out IUserStateConfiguration userStateConfiguration);\nМетод для получения десериализованного описания состояния из строки конфигурации атрибута. Возвращает true, если строка конфигурации содержит описание состояния и его удалось успешно десериализовать; false в обратном случае.\nIUserStateConfiguration userStateConfiguration bool success = _parser. TryParseUserStateConfiguration (configuration, out userStateConfiguration);\nгде:\nsuccess - результат успешной десериализации описания состояния из приведенной строки конфигурации атрибута;\n_parser - экземляр объекта, реализующего интерфейс IAttributeFormatParser;\nconfiguration - строка конфигурации атрибута;\nuserStateConfiguration - десериализованное описание состояния, содержавшееся в приведенной строке конфигурации;\nbool DeferredNumeratorAttributeValuePrefix { get };\nСвойство для получаения префикса, указывающего, что значение данного атрибута нумератора требует отложенной регистрации.","keywords":[]},"pages/client/ice/conf/IElementBookConfiguration.html":{"title":"Интерфейс IElementBookConfiguration","content":"Конфигурация атрибута Справочник элементов\nIElementBookDescription Description\nИнтерфейс IElementBookDescription с основными свойствами атрибута Справочник элементов.\nIElementBookAutoFill AutoFill\nИнтерфейс IElementBookAutoFill с описанием автозаполнения атрибута Справочник элементов.\nИнтерфейс IElementBookDescription\nКонтейнер с основными свойствами атрибута Справочник элементов.\nGuid Source\nИдентификатор объекта базы данных, дочерние объкты которого являются элементами справочника.\nIEnumerable<string> ElementsTypes\nСписок имен типов, из объектов которого должны формироваться элементы справочника. Если имен список пуст, то в формировании элементов справочника учавствуют дочерние элементы любого типа.\nbool AllowMultiSelect\nОпределяет, доступен ли мультивыбор в диалоге выбора справочника или нет.\nstring StringFormat\nСтрока форматирования, которая должна использоваться для формирования значения атрибута, при выборе элемента справочника.\nbool ShowInListView\nОпределяет, будет ли показан атрибут в списке элементов.\nbool EnablePopupCommands\nОпределяет, будет ли активен атрибут в списке элементов.\nbool CreateLink\nОпределяет, добавлять ли связь к объекту с выбранным элементом из справочника.\nbool AutoFill\nОпределяет, следует ли заполнять поля атрибутов, совпадающих по имени с указанными в справочнике.\nИнтерфейс IElementBookAutoFill\nКонтейнер с описанием автозаполнения атрибута Справочник элементов. Для получения результата автозаполнения используйте интерфейс IElementBookAutoFillWorker.\nAutoFillTriggerType TriggerType\nОпределяет, на какое событие срабатывает автозаполнение.\nAutoFillValueSource ValueSource\nОпределяет, откуда будет взято значение для автозаполнения.\nList<string> ParentTypeNames\nЕсли в ValueSource указано AutoFillValueSource.Parent, то значение для заполнения будет взято у первого родителя вложения, соответствующего типу из списка.\nПеречисление AutoFillValueSource Self\nОпределяет, откуда будет взято значение для автозаполнения атрибута Справочник элементов\nParent\nЗначением атрибута будет один из родителей вложения (по умолчанию).","keywords":[]},"pages/client/ice/conf/IUserStateConfiguration.html":{"title":"Интерфейс IUserStateConfiguration","content":"Конфигурация состояния.\nGuid StateMachineId\nИдентификатор машины состояний, к которой относится атрибут.","keywords":[]},"pages/client/ice/conf/ITransitionManager.html":{"title":"Интерфейс ITransitionManager","content":"Интерфейс для работы с атрибутом типа Состояние.\nIEnumerable GetAvailableTransitions(IAttribute attribute, IDictionary<string, object> attributes, IPerson person)\nМетод для получения доступных переходов машины состояний.\nIEnumerable<INumeratorInfo> transitions = _transitionManager. GetAvailableTransitions (attribute, attributes, person);\nгде:\ntransitions - список доступных переходов машины состояний;\nattribute - тип атрибута Состояние;\nattributes - значение атрибута Состояние;\nperson - пользователь, для которого будут посчитаны доступные переходы;\nGuid GetStartingState(IAttribute attribute)\nМетод для получения начального положения машины состояний.\nGuid stateId = _transitionManager. GetStartingState (attribute);\nгде:\nstateId - идентификатор состояния;\nattribute - тип атрибута Состояние;\nbool IsTransitionAvailable(ITransition transition, IDictionary<string, object> attributes, IPerson person)\nВычисляет, доступен ли переход в состояние.\nbool result = _transitionManager. IsTransitionAvailable (transition, attributes, person);\nгде:\nresult - результат;\ntransition - объект типа ITransition;\nattributes - значение атрибута Состояние;\nperson - пользователь, для которого будут посчитаны доступные переходы;","keywords":[]},"pages/client/ice/conf/IElementBookAutoFillWorker.html":{"title":"Интерфейс IElementBookAutoFillWorker","content":"Интерфейс содержит логику автозаполнения атрибута Справочник элементов. Описание настройки автозаполнения – IElementBookAutoFill.\nДля получения доступа к интерфейсу его необходимо добавить как параметр в конструктор класса плагина. При этом конструктор необходимо пометить атрибутом [ImportingConstructor].\nTask<string[]> ComputeElementBookValueAsync(string configuration, Guid triggerObjectId);\nВычисляет значение атрибута Справочник элементов с помощью настройки автозаполнения.\nstring[] result = await _autoFill. ComputeElementBookValueAsync (configuration, triggerObjectId);\nгде:\nconfiguration - конфигурация атрибута;\ntriggerObjectId - идентификатор вложения;","keywords":[]},"pages/client/ice/conf/INumeratorInfo.html":{"title":"Интерфейс INumeratorInfo","content":"Описание нумератора.\nstring DisplayName\nОтображаемое имя нумератора.\nstring Configuration\nКонфигурация нумератора, используется как параметр метода PreviewNumeratorFormat, для получения предпросмотра значния атрибута, к которому применяется нумератор.\nПример создания объекта с нумератором\nДля заполнения атрибута типа нумератор при создании объекта необходимо:\nПолучить метаданные атрибута создаваемого объекта. IDataObject.Type.Attributes -> найти по имени (или другому признаку) нужный атрибут;\nПолучить значение поля IAttribute.Configuration и распарсить его. Поле должно содержать описание возможных строк формата данного атрибута. Ниже приведен наиболее сложный пример такого описания:\nВходящий документ, ВХ-{Counterc11cbdead2d047399127798d2d1ea07f:d5}-{CurrentDate:yyyy}\nИсходящий документ, ИС-{Counterc11cbdead2d047399127798d2d1ea07f:d5}-{CurrentDate:yyyy}\nСтроками разделены различные возможные описания нумератора. Таких строк может быть 1 или более. Каждая строка содержит следующие данные, разделенные между собой знаком \",\":\nНазвание описания (может быть пропущено)\nСтрока форматирования описания\nИз распарсенных данных из пункта 2 выбираем нужное нам описание (если оно одно, то без выбора) и получаем значение его строки форматирования. Например, из вышеприведенного примера мы выберем\nИС-{Counterc11cbdead2d047399127798d2d1ea07f:d5}-{CurrentDate:yyyy}\nПрисваиваем значению атрибута создаваемого объекта значение строки форматирования из пункта 3. Описание нумератора также содержит флаг IsDeferredRegistration, который указывает на то, является ли нумертор отложенным. В таком случае, чтобы создать объект со отложенной регистрацией нумератора, нужно присвоить значению атрибута значние строки форматирования из пункта 3. с префиксом отложенной регистрации. Значение этого префикса можно получить используя свойство IAttributeFormatParser.DeferredNumeratorAttributeValuePrefix\nСоздаем объект, после прохождения объекта через сервер атрибут будет заполен согласно выбранной строке форматирования.\nПример:\nusing System.Linq; using System.Text; using Ascon.Pilot.SDK; using Ascon.Pilot.SDK.DataObjectWrappers; using Ascon.Pilot.SDK.Menu; using NumeratorPlugin.Wrappers; namespace NumeratorPlugin\n{ [ Export ( typeof (IMenu<ObjectsViewContext>))] public class MainModule: IMenu<ObjectsViewContext> { private readonly IObjectsRepository _repository; private readonly IObjectModifier _modifier; private readonly IAttributeFormatParser _attributeFormatParser; private const string CREATE_COMMAND = \"CreateCommand\"; [ImportingConstructor] public MainModule (IObjectsRepository repository, IObjectModifier modifier, IAttributeFormatParser attributeFormatParser) { _repository = repository; _modifier = modifier; _attributeFormatParser = attributeFormatParser; } public void Build (IMenuBuilder builder, ObjectsViewContext context) { builder. AddItem (CREATE_COMMAND, 0 ). WithHeader ( \"Create element with numerator\" ); } public void OnMenuItemClick (string name, ObjectsViewContext context) { const string typeName = \"DocumentTypeWithNumerator\"; const string attributeName = \"NumeratorAttribute\"; var type = _repository. GetType (typeName); var numberAttribute = type.Attributes. First (att => att.Name == attributeName); if (_attributeFormatParser. TryParseNumeratorDeclaration (numberAttribute. Configuration2 (), out var numInfos)) { var parent = context.SelectedObjects. FirstOrDefault (); foreach (var ni in numInfos) { var value = ni.IsDeferredRegistration? $ \"{_attributeFormatParser.DeferredNumeratorAttributeValuePrefix}{ni.Configuration}\": ni.Configuration; _modifier. Create (parent, type). SetAttribute (attributeName, value); } } _modifier. Apply (); } }\n}","keywords":[]},"pages/client/ice/conf/ITypeConfigurationParser.html":{"title":"Интерфейс ITypeConfigurationParser","content":"Каждый из пользовательских типов может быть дополнен конфигурацией. Конфигурация представляет собой текстовое поле, с помощью которого могут быть заданы специальные настройки типа.\nДля работы с конфигурацией типа можно использовать интерфейс ITypeConfigurationParser, который предоставляет методы для десериализации настроек, хранящихся в конфигурации типа.\nИнтерфейс ITypeConfigurationParser позволяет работать с конфигурайией типов. Для получения доступа к интерфейсу его необходимо передать в конструктор. При этом конструктор необходимо пометить атрибутом [ImportingConstructor].\nbool TryParseRemarksConfiguration(string configuration, out IRemarksConfiguration remarksConfiguration);\nМетод для получения десериализованного описания видов замечаний из конфигурации типа. Возвращает true, если строка конфигурации содержит описание видов замечаний и его удалось успешно десериализовать; false в обратном случае.\nIRemarksConfiguration remarksConfiguration; bool success = parser.TryParseRemarksConfiguration(configuration, out remarksConfiguration);\nгде:\nsuccess - результат успешной десериализации;\nparser - экземляр объекта, реализующего интерфейс ITypeConfigurationParser;\nconfiguration - конфигурация типа;\nremarksConfiguration - объект описывающий виды замечаний из конфигурации типа;","keywords":[]},"pages/client/ice/conf/IRemarksConfiguration.html":{"title":"Интерфейс IRemarksConfiguration","content":"Конфигурация видов замечаний\nIList<RemarkKind> Kinds { get; }\nСвойство, которе содержит список видов замечаний у заданного типа замечания. См. RemarkKind.\nТип RemarkKind\nТип содержит описание видов замечаний из конфигурации типа.\nКонструкторы\npublic RemarkKind ( string colorHex, string kind )\nгде:\ncolorHex - цвет замечания в HEX (например #FFFFDABA );\nkind - вид замечания;\nСвойства\npublic string ColorHex { get; }\nСвойство возвращает цвет замечания в ** HEX **;\npublic string Kind { get; }\nСвойство возвращает вид замечания.","keywords":[]},"pages/client/ice/settings/settings.html":{"title":"Управление общими настройками","content":"Общие настройки представляют собой персонифицированное хранилище типа \"ключ-значение\", где ключ - название настройки, а значение - ее значение. Список ключей системных настроек описан в классе SystemSettingsKeys. Данные хранилища общих настроек синхронизируются с сервером. Значения настроек могут быть записаны как для конкретного пользователя, так и для элемента организационной структуры, причем настройки, записанные для конкретного пользователя, имеют приоритет перед настройками для элемента организационной структуры, в который входит должность, на которой состоит пользователь.","keywords":[]},"pages/client/ice/settings/SystemSettingsKeys.html":{"title":"Класс SystemSettingsKeys","content":"Класс SystemSettingsKeys описывает ключи системных общих настроек.\nstring FavoritesFeatureKey\nСписок избранного в обозревавателе документов.\nstring PilotStorageDriveLetter\nПредпочтительная буква монтирования диска Pilot-Storage.\nstring AgreementRolesFeatureKey\nСписок ролей для согласования.\nstring MountedItemsList\nСписок смонтированных проектов.\nstring AutoBlockingFileExtensionsFeatureKey\nСписок расширений файлов на Pilot-Storage, для которых будет работать функционал автоблокировки.\nstring DocsAutoFillFeatureKey\nНастройки автозаполнения полей файлов.","keywords":[]},"pages/client/ice/settings/ISettingsFeature.html":{"title":"Интерфейс ISettingsFeature","content":"Интерфейс ISettingsFeature позволяет зарегистрировать в диалоге общих настроек новый ключ. Класс, реализующий данный интерфейс, должен быть помечен атрибутом [Export(typeof(ISettingsFeature))].\nstring Key\nКлюч настройки.\nstring Title\nОтображаемое имя настройки.\nFrameworkElement Editor\nВизуальный элемент, используемый для редактирования настроек данного типа.\nvoid SetValueProvider(ISettingValueProvider settingValueProvider)\nДанный метод вызывается со стороны приложения перед показом Editor и позволяет получить объект ISettingValueProvider для редактирования значения настройки.\nbool IsValid(string settingsItemValue)\nгде:\nsettingsItemValue - значение настройки;\nДанный метод валидации вызывается со стороны приложения после клика по кнопке \"Ок\" в диалоге добавления/редактирования общей настройки, в случае возвращения true настройка сохраняется, в противном случае диалог остается открытым.","keywords":[]},"pages/client/ice/settings/ISettingValueProvider.html":{"title":"Интерфейс ISettingValueProvider","content":"Позволяет получать и устанавливать значение настройки для диалога общих настроек.\nstring GetValue()\nПолучение текущего значения настройки.\nvoid SetValue(string value)\nУстановка значения настройки.","keywords":[]},"pages/client/ice/search/IAnnotationQueryBuilder.html":{"title":"Интерфейс IAnnotationQueryBuilder","content":"Интерфейс создания поискового запроса по замечаниям.\nIAnnotationQueryBuilder.WithKeyword\nЗадает ключевое слово для поиска\nIAnnotationQueryBuilder WithKeyword (string keyword);\nгде:\nkeyword - ключевое слово.\nIAnnotationQueryBuilder.WithQuotedKeyword\nЗадает ключевое слово для точного поиска.\nIAnnotationQueryBuilder WithQuotedKeyword (string keyword);\nгде:\nkeyword - ключевое слово.\nIAnnotationQueryBuilder.WithType\nЗадает тип элемента для поиска.\nIAnnotationQueryBuilder WithType ( int typeId);\nгде:\ntypeId - идентификатор типа.\nIAnnotationQueryBuilder.WithTypes\nЗадает список типов элементов для поиска.\nIAnnotationQueryBuilder WithTypes (IEnumerable< int > typeIds);\nгде:\ntypeIds - список идентификаторов типов.\nIAnnotationQueryBuilder.WithCurrentVersion\nЗадаёт поиск замечаний только по текущий версии документа (по умолчанию - поиск по всем версиям).\nIAnnotationQueryBuilder WithCurrentVersion ();","keywords":[]},"pages/client/ice/search/ISmartFolderQueryBuilder.html":{"title":"Интерфейс ISmartFolderQueryBuilder","content":"Интерфейс создания поискового запроса умной папки.\nISmartFolderQueryBuilder.WithSearchMode\nЗадает режим поиска (по атрибутам или по файлам)\nISmartFolderQueryBuilder WithSearchMode (SearchMode searchMode);\nгде:\nsearchMode - режим поиска.\nISmartFolderQueryBuilder.WithKeyword\nЗадает ключевое слово для поиска\nISmartFolderQueryBuilder WithKeyword (string keyword);\nгде:\nkeyword - ключевое слово.\nISmartFolderQueryBuilder.WithQuotedKeyword\nЗадает ключевое слово для точного поиска.\nISmartFolderQueryBuilder WithQuotedKeyword (string keyword);\nгде:\nkeyword - ключевое слово.\nISmartFolderQueryBuilder.WithType\nЗадает тип элемента для поиска.\nISmartFolderQueryBuilder WithType ( int typeId);\nгде:\ntypeId - идентификатор типа.\nISmartFolderQueryBuilder.WithTypes\nЗадает список типов элементов для поиска.\nISmartFolderQueryBuilder WithTypes (IEnumerable< int > typeIds);\nгде:\ntypeIds - список идентификаторов типов.\nISmartFolderQueryBuilder.WithState\nЗадает состояние элементов для поиска.\nISmartFolderQueryBuilder WithState (ObjectState state);\nгде:\nstate - состояние объекта.\nISmartFolderQueryBuilder.WithAuthor\nЗадает автора (создателя) элемента для поиска.\nISmartFolderQueryBuilder WithAuthor ( int authorId);\nгде:\nauthorId - идентификатор пользователя.\nISmartFolderQueryBuilder.WithAuthors\nЗадает авторов (создателей) элементов для поиска.\nISmartFolderQueryBuilder WithAuthors (IEnumerable< int > authorIds);\nгде:\nauthorIds - список идентификаторов пользователя.\nISmartFolderQueryBuilder.WithCreatedToday\nЗадает время создания элементов \"сегодня\" для поиска.\nISmartFolderQueryBuilder WithCreatedToday ();\nISmartFolderQueryBuilder.WithCreatedYesterday\nЗадает время создания элементов \"вчера\" для поиска.\nISmartFolderQueryBuilder WithCreatedYesterday ();\nISmartFolderQueryBuilder.WithCreatedThisWeek\nЗадает время создания элементов \"на этой неделе\" для поиска.\nISmartFolderQueryBuilder WithCreatedThisWeek ();\nISmartFolderQueryBuilder.WithCreatedLastWeek\nЗадает время создания элементов \"на прошлой неделе\" для поиска.\nISmartFolderQueryBuilder WithCreatedLastWeek ();\nISmartFolderQueryBuilder.WithCreatedThisMonth\nЗадает время создания элементов \"в этом месяце\" для поиска.\nISmartFolderQueryBuilder WithCreatedThisMonth ();\nISmartFolderQueryBuilder.WithCreatedLastMonth\nЗадает время создания элементов \"в прошлом месяце\" для поиска.\nISmartFolderQueryBuilder WithCreatedLastMonth ();\nISmartFolderQueryBuilder.WithCreatedThisYear\nЗадает время создания элементов \"в этом году\" для поиска.\nISmartFolderQueryBuilder WithCreatedLastYear ();\nISmartFolderQueryBuilder.WithCreatedLastYear\nЗадает время создания элементов \"в прошлом году\" для поиска.\nISmartFolderQueryBuilder WithCreatedThisYear ();\nISmartFolderQueryBuilder.WithCreatedInRange\nЗадает диапазон дат создания элементов для поиска.\nISmartFolderQueryBuilder WithCreatedInRange (DateTime fromUtc, DateTime toUtc);\nгде:\nfromUtc - начальная дата в UTC.\ntoUtc - конечная дата в UTC.\nISmartFolderQueryBuilder.ToString\nПреобразует поисковый запрос в строку для последующего сохранения ее в соответствующем атрибуте умной папки\nstring ToString ();","keywords":[]},"pages/client/ice/search/ISearchService.html":{"title":"Интерфейс ISearchService","content":"Интерфейс работы с поисковыми запросами.\nДля получения доступа к интерфейсу поиска его необходимо добавить как параметр в конструктор класса плагина. При этом конструктор необходимо пометить атрибутом [ImportingConstructor].\nЧтобы осуществить поиск объектов необходимо предварительно составить поисковый запрос с помощью выбранного конструктора запроса. После задания условий в конструкторе запросов с помощью условий поиска, его необходимо передать как параметр в метод Search. Существуют следующие типы конструкторов поисковых запросов:\nконструктор запросов для объектов \"Обозревателя документов\" (см GetObjectQueryBuilder );\nуниверсальный конструктор запросов (см GetEmptyQueryBuilder );\nконструктор поисковой строки для \"умной папки\" (см GetSmartFolderQueryBuilder );\nконструктор запросов для заданий.\nIObservable<ISearchResult> Search(IQueryBuilder query)\nС помощью этого метода осуществляется поиск объектов по заданным критериям в конструкторе запросов. Результатом вызова этого метода является поставщик push-уведомлений результатов поиска cм. ISearchResult.\nIObservable<ISearchResult> Search (IQueryBuilder query);\nIQueryBuilder GetObjectQueryBuilder()\nМетод получения предварительно сконфигурированного конструктора запросов для пользовательских объектов.\nВ результат поисковой выдачи не попадают:\nобъекты системных и сервисных типов;\nудаленные объекты.\nIQueryBuilder ISearchService. GetObjectQueryBuilder ();\nIQueryBuilder GetEmptyQueryBuilder()\nМетод получения простого конструктора запросов. Это универсальный конструктор запросов без предварительных условий. Этот конструктор можно использовать для поиска любых объектов в базе, включая объекты системных типов, например файл или папка на Pilot-Storage.\nIQueryBuilder ISearchService. GetEmptyQueryBuilder ();\nIObservable<ISearchResult> RunRefreshableSearch(IQueryBuilder query)\nМетод запускает обновляемый поиск. По обновляемому поиску будут приходить нотификации каждый раз, когда будет изменяться результат поисковой выборки. Результатом вызова этого метода является поставщик push-уведомлений результатов поиска cм. ISearchResult.\nВажно\nОбновляемые поисковые запросы создают дополнительную нагрузку на сервер, должны использоваться только при необходимости и в случае потери интереса к результатам обновляемого поиска требуется выполнить отписку через Dispose Observable коллекции.\nIObservable<ISearchResult> RunRefreshableSearch (IQueryBuilder query);\nISearchService.GetSmartFolderQueryBuilder\nМетод получения конструктора строки запроса для умной папки.\nISmartFolderQueryBuilder ISearchService. GetSmartFolderQueryBuilder ();\nISearchService.GetAnnotationQueryBuilder\nМетод получения конструктора строки запроса для поиска по замечаниям.\nIAnnotationQueryBuilder ISearchService. GetAnnotationQueryBuilder ();\nISearchService.GetQueryBuilderFromTaskSearchExpression\nМетод получения поискового запроса с помощью синтаксиса поисковой грамматики поиска по заданиям.\nIQueryBuilder ISearchService. GetQueryBuilderFromTaskSearchExpression (string expression, bool invariantCulture, bool nonPersonalFilter);\nгде:\nexpression - поисковое выражение в синтаксисе поисковой грамматики поиска по заданиям.\ninvariantCulture - флаг, определяющий, будет ли использоваться инвариантная культура при парсинге поискового выражения (true для сериализованных выражений, например, фильтров по заданиям из общих настроек).\nnonPersonalFilter - флаг, определяющий, будет ли поиск ограничиваться результатами, относящимися к заданиям текущего пользователя\nISearchService.GetQueryBuilderFromDocumentExplorerSearchExpression\nМетод получения поискового запроса с помощью синтаксиса поисковой грамматики поиска в обозревателе документов.\nIQueryBuilder ISearchService. GetQueryBuilderFromDocumentExplorerSearchExpression (string expression, bool invariantCulture);\nгде:\nexpression - поисковое выражение в синтаксисе поисковой грамматики поиска по обозревателю документов.\ninvariantCulture - флаг, определяющий, будет ли использоваться инвариантная культура при парсинге поискового выражения (true для сериализованных выражений, например, выражений умных папок).","keywords":[]},"pages/client/ice/search/IQueryBuilder.html":{"title":"Интерфейс IQueryBuilder","content":"Универсальный интерфейс конструктора поисковых запросов.\nIQueryBuilder GetObjectQueryBuilder()\nМетод получения предварительно сконфигурированного конструктора запросов для пользовательских объектов.\nВ результат поисковой выдачи не попадают:\nобъекты системных и сервисных типов;\nудаленные объекты.\nIQueryBuilder ISearchService. GetObjectQueryBuilder ();\nIQueryBuilder GetEmptyQueryBuilder()\nМетод получения простого конструктора запросов. Это универсальный конструктор запросов без предварительных условий. Этот конструктор можно использовать для поиска любых объектов в базе, включая объекты системных типов, например файл или папка на Pilot-Storage.\nIQueryBuilder ISearchService. GetEmptyQueryBuilder ();\nIQueryBuilder.Must\nИспользуйте этот метод для условий поиска, которые ДОЛЖНЫ быть в объектах.\nIQueryBuilder Must (ISearchTerm term);\nгде:\nterm - условие поиска. (например: ObjectFields.AllText.Be(\"Hello*\"))\nIQueryBuilder.MustAnyOf\nИспользуйте этот метод, если какое-либо из указанных условий поиска ДОЛЖНО быть в объектах.\nIQueryBuilder MustAnyOf (params ISearchTerm[] terms);\nгде:\nterms - условия поиска. (например: ObjectFields.TypeId.BeAnyOf(new[] {1, 2, 3})).\nIQueryBuilder.MustNot\nИспользуйте этот метод, если условие поиска НЕ ДОЛЖНО быть в объектах.\nIQueryBuilder MustNot (ISearchTerm term);\nгде:\nterms - условие поиска. (например: TaskFields.State.Be(State.None)).\nIQueryBuilder.SortBy\nИспользуйте этот метод для того, чтобы установить поле и направление сортировки результатов поиска.\nIQueryBuilder SortBy (INamedField field, ListSortDirection direction);\nгде:\nfield - поле, по которому необходимо отсортировать результаты поиска (Например: ObjectFields.TypeId).\ndirection - направление сортировки.\nIQueryBuilder.MaxResults\nИспользуйте этот метод для того, чтобы ограничить количество результатов. Значение по умолчанию 250.\nIQueryBuilder MaxResults ( int result);\nгде:\nresult - максимальное количество результатов поиска.\nIQueryBuilder.InContext\nИспользуйте этот метод для того, чтобы установить контекст поиска.\nIQueryBuilder InContext (Guid id);\nгде:\nid - идентификатор объекта.","keywords":[]},"pages/client/ice/search/SmartFolder.html":{"title":"Пример создания \"умной папки\"","content":"using Ascon.Pilot.SDK; namespace SmartFolderSample\n{ [ Export ( typeof (IDataPlugin))] public class SmartFolderSample: IDataPlugin { private readonly ISearchService _searchService; private readonly IObjectsRepository _repository; private readonly IObjectModifier _modifier; [ImportingConstructor] public SmartFolderSample (ISearchService searchService, IObjectsRepository repository, IObjectModifier modifier) { _searchService = searchService; _repository = repository; _modifier = modifier; } public void CreateSmartFolder (IDataObject parent) { _modifier. Create (parent, GetSmartFolderType ()). SetAttribute (SystemAttributeNames.SMART_FOLDER_TITLE, \"title\" ). SetAttribute (SystemAttributeNames.SEARCH_CRITERIA, GetSmartFolderSearchString ()). SetAttribute (SystemAttributeNames.SEARCH_CONTEXT_OBJECT_ID, parent.Id. ToString ()); _modifier. Apply (); } private string GetSmartFolderSearchString () { var searchString = string.Empty; var type = _repository. GetType ( \"Project\" ); if (type == null) return searchString; var builder = _searchService. GetSmartFolderQueryBuilder (); builder. WithSearchMode (SearchMode.Attributes). WithType (type.Id). WithKeyword ( \"5000\" ). ToString (); searchString = builder. ToString (); return searchString; } private IType GetSmartFolderType () { return _repository. GetType (SystemTypeNames.SMART_FOLDER); } }\n}","keywords":[]},"pages/client/ice/search/ObjectFields.html":{"title":"Условия поиска для объектов ObjectFields","content":"ObjectFields.Id\nИспользуйте это условие, чтобы задать поиск по определенному идентификатору объекта.\nНапример:\nvar id = new Guid( \"01A1028B-79BC-45C7-8A59-6191E8ADFE39\" ); var builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.Id.Be(id));\nObjectFields.ParentId\nИспользуйте это условие, чтобы задать поиск по определенному идентификатору родительского объекта.\nНапример:\nvar id = new Guid( \"01A1028B-79BC-45C7-8A59-6191E8ADFE39\" ); var builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.ParentId.Be(id));\nObjectFields.TypeId\nИспользуйте это условие, чтобы задать поиск по типу объекта.\nНапример: зададим условие поиска для объектов типа 16 ИЛИ 17\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.TypeId.BeAnyOf( 16, 17 ));\nObjectFields.ObjectState\nИспользуйте это условие, чтобы задать поиск по состоянию объекта.\nНапример: зададим условие поиска для объектов в состоянии заморозка\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.ObjectState.BeAnyOf(ObjectState.Frozen));\nДргугой пример, поиск объектов, находящихся в корзине:\nvar builder = _searchService.GetEmptyQueryBuilder();\nbuilder.Must(ObjectFields.ObjectState.BeAnyOf(ObjectState.InRecycleBin));\nИли наоборот: фильтрация объектов, помещенных в корзину, которые не должны отображаться в результатах поиска:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.ObjectState.BeAnyOf(ObjectState.Frozen, ObjectState.Alive));\nДргугой пример: поиск заблокированных объектов\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.ObjectState.BeAnyOf(ObjectState.LockRequested, ObjectState.LockAccepted));\nObjectFields.CreatorId\nИспользуйте это условие, чтобы задать поиск по создателю объекта.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.CreatorId.Be( 25 ));\nObjectFields.CreatedDate\nИспользуйте это условие, чтобы задать поиск по дате создания объектов. Дату и время необходимо задавать в формате UTC.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder(); var fromDate = new DateTime( 2016, 5, 5 ).ToUniversalTime(); var toDate = DateTime.Today.ToUniversalTime();\nbuilder.Must(ObjectFields.CreatedDate.BeInRange(fromDate, toDate));\nObjectFields.IsSecret\nИспользуйте это условие, чтобы искать скрытые или общедоступные объекты.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.IsSecret.Be( true ));\nObjectFields.AllText\nИспользуйте это условие, чтобы искать объекты по слову или части слова. Поиск осуществляется по атрибутам объекта.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.AllText.Be( \"Проект*\" ));\nObjectFields.SnapshotsCreated\nИспользуйте это условие, чтобы искать объекты по дате создания версии файла (например, XPS документа или файла на Pilot-Storage).\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.SnapshotsCreated.BeInRange( from,to));\nObjectFields.AllSnapshotsReason\nИспользуйте это условие, чтобы искать документы по причине создания версии (как актуальной, так и любой из предыдущих).\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.AllSnapshotsReason.Be( \"Обновлен*\" ));\nObjectFields.SignatureAwaitingBy\nИспользуйте это условие, чтобы искать документы, ожидающие подписания от одной или нескольких должностей.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.SignatureAwaitingBy.Be(gipPositionId));\nObjectFields.SignedBy\nИспользуйте это условие, чтобы искать документы, подписанные каким-либо пользователем.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.SignedBy.Be(gipPositionId));\nObjectFields.StateChangedPersonId\nИспользуйте это условие, чтобы искать объекты, заблокированные каким-либо пользователем.\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(ObjectFields.ObjectState.BeAnyOf(ObjectState.LockRequested, ObjectState.LockAccepted));\nbuilder.Must(ObjectFields.StateChangedPersonId.Be(gipPersonId));","keywords":[]},"pages/client/ice/search/ISearchResult.html":{"title":"Интерфейс ISearchResult","content":"Интерфейс предоставляет доступ к результатам поиска.\nISearchResult.Result\nСписок идентификаторов найденных объектов.\nIEnumerable<Guid> Result { get; }\nISearchResult.Total\nОбщее количество найденных объектов. Так как поисковая выдача ограничена с помощью IQueryBuilder.MaxResults, в общем случае значение Total может быть больше количества результатов Result. Если требуется найти больше объектов, установите большее значение IQueryBuilder.MaxResults и перезапустите поиск.\nlong Total { get; }\nISearchResult.Kind\nИсточник результата поиска.\nSearchResultKind Kind { get; }\nПеречисление SearchResultKind\nИсточник результата поиска.\nРезультаты были получены из локального хранилища клиента.\nSearchResultKind.Local\nРезультаты были получены с удаленного сервера.\nSearchResultKind.Remote","keywords":[]},"pages/client/ice/search/fields.html":{"title":"Предустановленные условия поиска","content":"Условия поиска для объектов ObjectFields\nУсловия поиска по произвольным атрибутам AttributeFields\nОбщие условия поиска","keywords":[]},"pages/client/ice/search/AttributeFields.html":{"title":"Условия поиска по произвольным атрибутам AttributeFields","content":"AttributeFields.String\nИспользуйте это условие, чтобы искать объекты по атрибуту типа строка.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(AttributeFields.String( \"AttributeName\" ).Be( \"Искать*\" ));\nAttributeFields.DateTime\nИспользуйте это условие, чтобы искать объекты по атрибуту типа дата. Дату и время необходимо задавать в формате UTC.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder(); var fromDate = new DateTime( 2016, 5, 5 ).ToUniversalTime(); var toDate = DateTime.Today.ToUniversalTime();\nbuilder.Must(AttributeFields.DateTime( \"AttributeName\" ).BeInRange(fromDate, toDate));\nAttributeFields.Double\nИспользуйте это условие, чтобы искать объекты по атрибуту типа вещественное число.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(AttributeFields.Double( \"AttributeName\" ).Be( 2.2 ));\nAttributeFields.Integer\nИспользуйте это условие, чтобы искать объекты по атрибуту типа целое число.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(AttributeFields.Integer( \"AttributeName\" ).Be( 2 ));\nAttributeFields.Bool\nИспользуйте это условие, чтобы искать объекты по атрибуту типа булевое значение.\nНапример:\nvar builder = _searchService.GetObjectQueryBuilder();\nbuilder.Must(AttributeFields.Bool( \"AttributeName\" ).Be( true ));","keywords":[]},"pages/client/ice/search/CommonFields.html":{"title":"Общие условия поиска","content":"Условие Be\nИспользуйте это условие для точного поиска значения.\nISearchTerm Be ( T value );\nНапример:\nvar builder = _searchService.GetTaskQueryBuilder();\nbuilder.Must(TaskFields.ExecutorPositionId.Be( 42 ));\nУсловие BeAnyOf\nПоиск значений удовлетворяющих одному из условий.\nISearchTerm BeAnyOf ( params T[] values );\nНапример:\nvar builder = _searchService.GetTaskQueryBuilder();\nbuilder.Must(TaskFields.ExecutorPositionId.BeAnyOf( 45, 42, 15 ));\nУсловие BeInRange\nПоиск значений находящихся в заданном диапазоне значений.\nISearchTerm BeInRange ( T from, T to );\nНапример:\nvar builder = _searchService.GetTaskQueryBuilder(); var fromDate = new DateTime( 2016, 5, 5 ).ToUniversalTime(); var toDate = DateTime.Today.ToUniversalTime();\nbuilder.Must(TaskFields.DateOfCompletion.BeInRange(fromDate, toDate));\nУсловие ContainsAll\nПоиск значений соответствующих всем заданным условиям.\nISearchTerm ContainsAll ( params T[] values );\nНапример:\nvar builder = _searchService.GetTaskQueryBuilder();\nbuilder.Must(TaskFields.AllText.ContainsAll( \"задание\", \"согласование\" ));","keywords":[]},"pages/client/ice/extensions/ICommandInvoker.html":{"title":"ICommandInvoker","content":"Интерфейс предназначен для получения информации о доступных командах в системе и вызове их.\nДля получения доступа к интерфейсу вызова команд его необходимо добавить как параметр в конструктор класса плагина. При этом конструктор необходимо пометить атрибутом [ImportingConstructor].\nМетоды\nIEnumerable<CommandDescription> GetAvailableCommands ();\nМетод возвращает описания доступных команд в системе.\nbyte [] Invoke ( Guid commandId, byte [] args );\nгде:\ncommandId - уникальный идентификатор команды\nargs - параметры вызова команды.\nМетод позволяет вызвать команду из другого расширения. В случае отсутствия команды будет выброшено исключение типа CommandHandlerNotFoundException\nОписание и результат выполнения команды смотрите спрашивайте у разработчиков расширений. Мы рекомендуем описывать команды и параметры в свойстве Description обработчика команды.","keywords":[]},"pages/client/ice/extensions/CommandDescription.html":{"title":"CommandDescription","content":"Тип описания команды расширения.\nКонструкторы\npublic CommandDescription ( Guid commandId, string description )\nгде:\ncommandId - уникальный идентификатор команды\ndescription - подробное описание команды команды.\nСвойства\npublic Guid CommandId { get; }\nСвойство получает уникальный идентификатор команды\npublic string Description { get; }\nСвойство получает подробное описание команды.","keywords":[]},"pages/client/ice/data/data.html":{"title":"Типы данных Pilot","content":"К данным интерфейсам относятся объекты, которые содержат информацию об элементах, пользователях, заданиях и т.п.","keywords":[]},"pages/client/ice/extensions/ICommandHandler.html":{"title":"ICommandHandler","content":"Интерфейс предназначен для реализации обработчика команды в расширении.\nСвойства\nGuid CommandId { get; }\nСвойство возвращает уникальный идентификатор команды.\nstring Description { get; }\nСвойство возвращает описание команды.\nЧтобы разработчики сторонних расширений смогли воспользоваться вашими командами в описании команды необходимо описать формат входящих параметров и формат результата работы команды.\nМетоды\nbyte [] Handle ( byte [] args );\nгде:\nargs - параметры команды\nМетод выполняет команду.","keywords":[]},"pages/client/ice/data/IType.html":{"title":"Интерфейс IType","content":"Интерфейс предназначен для просмотра информации о типе элемента.\nIType.Id\nПоле Id содержит идентификатор типа элемента.\nGuid IType.Id { get; }\nIType.Name\nПоле Name содержит внутренне имя типа элемента.\nstring IType.Name { get; }\nIType.Title\nПоле Title содержит локализованное имя типа элемента.\nstring IType.Title { get; }\nIType.Sort\nПоле Sort содержит порядковый номер сортировки.\nint IType.Sort { get; }\nIType.HasFiles\nПоле HasFiles показывает может ли данный тип содержать файлы.\nbool IType.HasFiles { get; }\nIType.Children\nПоле Children содержит идентификаторы дочерних типов.\nReadOnlyCollection< int > IType.Children { get; }\nIType.Attributes\nПоле Attributes содержит информацию об атрибутах, которые может содержать элемент данного типа.\nReadOnlyCollection<IAttribute> IType.Attributes { get; }\nIType.DisplayAttributes\nПоле DisplayAttributes содержит информацию об отображаемых в Обозревателе проектов атрибутах.\nReadOnlyCollection<IAttribute> IType.DisplayAttributes { get; }\nIType.SvgIcon\nПоле SvgIcon содержит массив байт иконки типа в формате svg.\nbyte[] IType.SvgIcon { get; }\nIType.IsMountable\nФлаг IsMountable указывает может ли элемент данного типа монтироваться на диск (Pilot - Storage).\nbool IType.IsMountable { get; }\nIType.Kind\nПоле Kind содержит вид типа элемента.\nTypeKind IType.Kind { get; }\nIType.IsDeleted\nПоле IsDeleted указывает удален ли текущий тип. В системе Pilot типы не удаляются из базы данных, а только помечаются как удаленные.\nbool IType.IsDeleted { get; }\nIType.IsService\nПоле IsService указывает является ли текущий тип сервисным. Если данное свойство установлено в true, то элементы такого типа не будут отображаться в Обозревателе проектов. Доступ к элементам такого типа можно получить только из кода.\nbool IType.IsService { get; }\nIType.StateMachineId\nПоле StateMachineId - идентификатор группы состояний, которая используется для расчета состояния ревизий документов и их фильтрации в обозревателе документов.\nGuid IType.StateMachineId { get; }","keywords":[]},"pages/client/ice/data/IFile.html":{"title":"Интерфейс IFile","content":"Интерфейс предназначен для просмотра информации о файлах, которые содержит элемент.\nIFile.Id\nПоле Id содержит идентификатор файла\nGuid IFile.Id { get; }\nIFile.Size\nПоле Size содержит информацию о размере файла.\nlong IFile.Size { get; }\nIFile.Md5\nПоле Md5 содержит хеш-код файла, вычисленный по алгоритму хеширования md5\nstring IFile.Md5 { get; }\nIFile.Name\nПоле Name содержит имя файла с расширением.\nstring IFile.Name { get; }\nIFile.Modified\nПоле Modified содержит время последнего изменения файла.\nDateTime IFile.Modified { get; }\nIFile.Created\nПоле Created содержит время создания файла.\nDateTime IFile.Created { get; }\nIFile.Accessed\nПоле Accessed содержит время последнего доступа к файлу.\nDateTime IFile.Accessed { get; }\nIFile.Signatures\nПоле Signatures содержит список цифровых подписей, поставленных на файл.\nReadOnlyCollection<ISignatureRequest> IFile.SignaturesRequests { get; }\nIFile.StateId\nПоле StateId содержит идентификатор состояния файла.\nGuid IFile.StateId { get; }","keywords":[]},"pages/client/ice/data/IDataObject.html":{"title":"Интерфейс IDataObject","content":"Интерфейс предназначен для просмотра информации об элементе.\nIDataObject.Id\nПоле Id содержит идентификатор элемента.\nGuid IDataObject.Id { get; }\nIDataObject.ParentId\nПоле ParentId содержит идентификатор родительского элемента.\nGuid IDataObject.ParentIdId { get; }\nIDataObject.Created\nПоле Created содержит дату создания элемента.\nDateTime IDataObject.Created { get; }\nIDataObject.Attributes\nПоле Attributes содержит словарь атрибутов элемента. Где значением атрибута могут быть следующие типы: string, int, DateTime и double.\nIDictionary<string, object> IDataObject.Attributes { get; }\nIDataObject.DisplayName\nПоле DisplayName содержит отображаемое имя элемента, собранное из доступных атрибутов по определенному правилу.\nstring IDataObject.DisplayName { get; }\nIDataObject.Type\nПоле Type содержит тип элемента.\nIType IDataObject.Type { get; }\nIDataObject.Creator\nПоле Creator содержит информацию о пользователе, создавшем текущий элемент.\nIPerson IDataObject.Creator { get; }\nIDataObject.Children\nПоле Children содержит список идентификаторов дочерних элементов.\nReadOnlyCollection<Guid> IDataObject.Children { get; }\nIDataObject.Relations\nПоле Relations содержит список всех связей элемента с другими элементами.\nReadOnlyCollection<IRelation> IDataObject.Relations { get; }\nIDataObject.RelatedSourceFiles\nПоле RelatedSourceFiles содержит список идентификаторов элементов, связанных с текущим связью типа \"Исходный файл\"\nReadOnlyCollection<Guid> IDataObject.RelatedSourceFiles { get; }\nIDataObject.RelatedTaskInitiatorAttachments\nПоле RelatedTaskInitiatorAttachments содержит список идентификаторов элементов, связанных с текущим связью типа \"Вложение в задание от инициатора\"\nReadOnlyCollection<Guid> IDataObject.RelatedTaskInitiatorAttachments { get; }\nIDataObject.RelatedTaskMessageAttachments\nПоле RelatedTaskMessageAttachments содержит список идентификаторов элементов, связанных с текущим связью типа \"Вложение в сообщение по заданию\"\nReadOnlyCollection<Guid> IDataObject.RelatedTaskMessageAttachments { get; }\nIDataObject.TypesByChildren\nС помощью поле TypesByChildren можно определить тип ребенка элемента не загружая его.\nIDictionary<Guid, int > IDataObject.TypesByChildren { get; }\nIDataObject.State\nПоле State содержит информацию о текущем статусе элемента. Загружен элемент в кеш клиента или нет. Подробнее см. DataState\nDataState IDataObject.State { get; }\nIDataObject.ObjectStateInfo\nПоле ObjectStateInfo содержит информацию о текущем статусе ObjectState объекта и информацию о том, кто и когда совершил последнее изменения статуса. Подробнее см. DataState.\nDataState IDataObject.State { get; }\nIDataObject.SynchronizationState\nПоле SynchronizationState содержит информацию о текущем статусе синхронизации элемента с сервером. Подробнее см. SynchronizationState\nSynchronizationState IDataObject.SynchronizationState { get; }\nIDataObject.Files\nПоле Files содержит список доступных файлов элемента. Содержит только информацию о файле. Тело файла необходимо загружать отдельно. Подробнее см. IFileProvider\nReadOnlyCollection<IFile> IDataObject.Files { get; }\nIDataObject.Access2\nПоле Access2 содержит информацию о текущих правах доступа к этому элементу. Подробнее см IAccessRecord.\nReadOnlyCollection<IAccessRecord> IDataObject.Access2 { get; }\nIDataObject.IsSecret\nПоле IsSecret содержит значение указывающее является ли этот элемент скрытым.\nbool IDataObject.IsSecret { get; }\nIDataObject.ActualFileSnapshot\nПоле ActualFileSnapshot содержит информацию о текущих фалах элемента. Подробнее см. IFilesSnapshot.\nIFilesSnapshot IDataObject.ActualFileSnapshot { get; }\nIDataObject.PreviousFileSnapshots\nПоле PreviousFileSnapshots содержит информацию об изменениях файлов элемента. Это история изменения файлов элемента. Подробнее см. IFilesSnapshot.\nReadOnlyCollection<IFilesSnapshot> IDataObject.PreviousFileSnapshots { get; }\nIDataObject.Subscribers\nПоле Subscribers содержит список пользователей, которые подписаны на изменения этого элемента.\nReadOnlyCollection< int > IDataObject.Subscribers { get; }\nIDataObject.LastChange\nМетод расширения LastChange позволяет получить инкрементальный идентификатор набора изменений, последним изменившего данный элемент. Может быть использован для ожидания загрузки новой версии элемента при получении нотификации.\npublic static long LastChange ( this IDataObject dataObject);","keywords":[]},"pages/client/ice/data/IPosition.html":{"title":"Интерфейс IPosition","content":"Интерфейс предназначен для просмотра информации о должности пользователя.\nIPosition.Order\nПоле Order содержит порядковый номер должности пользователя. Основная должность имеет наименьший порядковый номер.\nint IPosition.Order { get; }\nIPosition.Position\nПоле Position содержит идентификатор должности пользователя.\nint IPosition.Position { get; }","keywords":[]},"pages/client/ice/data/IOrganisationUnit.html":{"title":"Интерфейс IOrganisationUnit","content":"Интерфейс предназначен для просмотра информации о должностях и структурных подразделениях организации.\nIOrganisationUnit.Id\nПоле Id содержит идентификатор должности или структурного подразделения.\nint IOrganisationUnit.Id { get; }\nIOrganisationUnit.Kind\nПоле Kind возвращает тип элемента организационной структуры.\nOrganisationUnitKind IOrganisationUnit.Kind { get; }\nIOrganisationUnit.Title\nПоле Title содержит локализованное наименование должности или структурного подразделения.\nstring IOrganisationUnit.Title { get; }\nIOrganisationUnit.IsDeleted\nПоле IsDeleted показывает удалена ли должность или структурное подразделение. В системе Pilot организационные единицы не удаляются из базы данных, а только помечаются как удаленные.\nbool IOrganisationUnit.IsDeleted { get; }\nIOrganisationUnit.IsChief\nМетод расширения IsChief показывает, является ли должность руководящей.\nbool IOrganisationUnit.IsChief { get; }\nIOrganisationUnit.Children\nПоле Children содержит идентификаторы дочерних должностей или структурных подразделений.\nReadOnlyCollection< int > IOrganisationUnit.Children { get; }\nIOrganisationUnit.Person\nМетод расширения Person возвращает идентификатор пользователя, занимающего должность. Если должность вакантна, значение будет -1.\nIOrganisationUnit.VicePersons\nМетод расширения VicePersons возвращает список идентификаторов пользователей-заместителей на должности. Порядок идентификаторов в списке определяет порядок вступления заместителей в должность при неактивном состоянии пользователя.\nIOrganisationUnit.GroupPerson\nМетод расширения GroupPersons возвращает список идентификаторов пользователей в группе.\nIOrganisationUnit.PermanentVicePersons\nМетод расширения PermanentVicePersons возвращает список идентификаторов пользователей постоянных заместителей на должности. Порядок идентификаторов в списке определяет порядок вступления заместителей в должность при неактивном состоянии пользователя.","keywords":[]},"pages/client/ice/data/IAttribute.html":{"title":"Интерфейс IAttribute","content":"Интерфейс предназначен для просмотра информации об атрибутах типа элемента.\nIAttribute.Name\nПоле Name содержит внутреннее название атрибута типа.\nstring IAttribute.Name { get; }\nIAttribute.Title\nПоле Title содержит локализованное название атрибута типа.\nstring IAttribute.Title { get; }\nIAttribute.IsObligatory\nПоле IsObligatory показывает является ли данный атрибут обязательным для заполнения при создании нового элемента.\nbool IAttribute.IsObligatory { get; }\nIAttribute.DisplaySortOrder\nПоле DisplaySortOrder содержит порядковый номер сортировки атрибута типа.\nint IAttribute.DisplaySortOrder { get; }\nIAttribute.ShowInObjectsExplorer\nПоле ShowInObjectsExplorer показывает будет ли данный атрибут виден в Обозревателе проектов.\nbool IAttribute.ShowInObjectsExplorer { get; }\nIAttribute.JoinWithPrevious\nФлаг JoinWithPrevious управляет отображением атрибута в карточке объекта. При наличии свободного места атрибут с установленным флагом JoinWithPrevious будет объединен с предыдущим в одну строку.\nbool IAttribute.JoinWithPrevious { get; }\nIAttribute.IsService\nПоле IsService показывает является ли данный атрибут сервисным.\nbool IAttribute.IsService { get; }\nIAttribute.Configuration\nПоле Configuration содержит дополнительную информацию типа. Например этот атрибут используется для описания меток штрих-кода или описания справочников.\nstring IAttribute.Configuration { get; }\nIAttribute.DisplayHeight\nПоле DisplayHeight содержит высоту атрибута, которую занимает атрибут в карточке редактирования и просмотра свойств элемента в Обозревателе проектов. По умолчанию атрибуты занимают одну строку.\nint IAttribute.DisplayHeight { get; }\nIAttribute.Obligatory\nПоле Obligatory содержит значение показывающее, является ли атрибут обязательным к заполнению при создании.\nbool Obligatory { get; }\nIAttribute.GroupTitle\nПоле GroupTitle содержит название группы, в которую будет сгруппирован данный атрибут при отображении в карточке объекта.\nstring IAttribute.GroupTitle { get; }","keywords":[]},"pages/client/ice/data/ISignatureRequest.html":{"title":"ISignatureRequest","content":"Интерфейс предназначен для просмотра информации о запросах на подпись и цифровых подписях, поставленных на файл.\nСвойства\nGuid Id { get; }\nСвойство содержит идентификатор цифровой подписи.\nGuid ObjectId { get; }\nСвойство содержит идентификатор задания на согласование.\nint PositionId { get; }\nСвойство содержит идентификатор должности пользователя, который подписал или должен подписать документ.\nstring Role { get; }\nСвойство содержит информацию о роли пользователя, который подписал или должен подписать документ.\nIReadOnlyList< string > Signs { get; }\nСвойство содержит список подписей, связанных с запросом.\nstring RequestedSigner { get; }\nСвойство содержит информацию о должности пользователя, который должен подписать документ.\nМетоды расширения\npublic static bool IsAdditional ( this ISignatureRequest signature )\nМетод возвращает значение, указывающее виртуальный запрос на подпись или нет.","keywords":[]},"pages/client/ice/data/IPerson.html":{"title":"Интерфейс IPerson","content":"Интерфейс предназначен для просмотра информации о пользователе системы Pilot.\nIPerson.Id\nПоле Id содержит уникальный идентификатор пользователя.\nint IPerson.Id { get; }\nIPerson.Login\nПоле Login содержит имя пользователя (login).\nstring IPerson.Login { get; }\nIPerson.DisplayName\nПоле DisplayName содержит отображаемое имя пользователя. Например ФИО.\nstring IPerson.DisplayName { get; }\nIPerson.Email\nМетод расширения Email возвращает электронную почту пользователя\nstatic string Email ( this IPerson person)\nIPerson.Phone\nМетод расширения Phone возвращает телефон пользователя\nstatic string Phone ( this IPerson person)\nIPerson.Positions\nПоле Positions содержит список должностей, которые в данный момент занимает пользователь.\nReadOnlyCollection<IPosition> IPerson.Positions { get; }\nIPerson.MainPosition\nПоле MainPosition содержит основную должность пользователя.\nIPosition IPerson.MainPosition { get; }\nIPerson.Comment\nПоле Comment содержит дополнительные сведения о пользователе.\nstring IPerson.Comment { get; }\nIPerson.IsInactive\nМетод расширения IsInactive возвращает true, если статус пользователя \"Недоступен\".\nIPerson.Sid\nПоле Sid содержит уникальный идентификатор доменной учетной записи пользователя.\nstring IPerson.Sid { get; }\nIPerson.IsDeleted\nПоле IsDeleted показывает удален пользователь или нет. В системе Pilot информация пользователях не удаляется из базы данных. Пользователи помечаются как удаленные.\nbool IPerson.IsDeleted { get; }\nIPerson.IsAdmin\nПоле IsAdmin показывает является ли текущий пользователь администратором.\nbool IPerson.IsAdmin { get; }\nIPerson.ActualName\nПоле ActualName содержит актуальное имя пользователя. По умолчанию это поле выводит информацию из поля DisplayName. Если поле DisplayName не заполнено, то данное поле выводит информацию из поля Login.\nstring IPerson.ActualName { get; }\nIPerson.Groups\nМетод расширения Groups возвращает список идентификаторов групп, в которых состоит пользователь\nIPerson.AllOrgUnits\nМетод расширения AllOrgUnits возвращает список идентификаторов всех должностей, подразделений и групп, в которых состоит пользователь.","keywords":[]},"pages/client/ice/data/IAccess.html":{"title":"Интерфейс IAccess","content":"Интерфейс предназначен для просмотра информации об уровне доступа.\nIAccess.AccessLevel\nСодержит уровень доступа к элементу.\nAccessLevel IAccess.AccessLevel { get; }\nIAccess.ValidThrough\nСодержит дату, до которой действует право доступа.\nDateTime IAccess.ValidThrough { get; }\nIAccess.IsInheritable\nФлаг, указывающий будут ли наследовать дочерние элементы текущее право доступа.\nbool IAccess.IsInheritable { get; }\nIAccess.IsInherited\nФлаг, указывающий унаследовано право от родительского элемента или нет.\nbool IAccess.IsInherited { get; }","keywords":[]},"pages/client/ice/data/IStorageDataObject.html":{"title":"Интерфейс IStorageDataObject","content":"Интерфейс предназначен для просмотра информации об элементе Pilot-Storage.\nIStorageDataObject.DataObject\nПоле DataObject содержит полную информацию об элементе.\nIDataObject IStorageDataObject.DataObject { get; }\nIStorageDataObject.Path\nПоле Path содержит абсолютный путь до элемента на Pilot-Storage.\nstring IStorageDataObject.Path { get; }\nIStorageDataObject.State\nПоле State содержит текущее состояние элемента.\nStorageObjectState IStorageDataObject.State { get; }\nIStorageDataObject.IsDirectory\nПоле IsDirectory показывает является ли текущий элемент папкой.\nbool IStorageDataObject.IsDirectory { get; }","keywords":[]},"pages/client/ice/data/IAccessRecord.html":{"title":"Интерфейс IAccessRecord","content":"Интерфейс предназначен для просмотра информации о правах доступа на элемент.\nIAccessRecord.OrgUnitId\nСодержит идентификатор должности для которого действует указанный уровень доступа.\nint IAccessRecord.OrgUnitId { get; }\nIAccessRecord.Access\nСодержит информацию об уровене доступа. Подробнее см. IAccess\nIAccess IAccessRecord.Access { get; }\nIAccessRecord.RecordOwner\nСодержит информацию о должности, которая установила указанный уровень доступа.\nint IAccessRecord.RecordOwner { get; }\nIAccessRecord.InheritanceSource\nСодержит идентификатор элемента, с которого текущий элемент получил унаследованное право доступа.\nGuid IAccessRecord.InheritanceSource { get; }","keywords":[]},"pages/client/ice/data/IStateInfo.html":{"title":"Интерфейс IStateInfo","content":"Интерфейс предназначен для просмотра информации о состоянии объекта.\nIStateInfo.State\nПоле State содержит ифнормацию о состоянии объекта.\nObjectState IStateInfo.State { get; }\nIStateInfo.Date\nПоле Date содержит ифнормацию дате последнего изменения состояния объекта.\nDateTime IStateInfo.Date { get; }\nIStateInfo.PersonId\nПоле PersonId содержит идентификатор пользователя, изменившего состояние объекта последним.\nint IStateInfo.PersonId { get; }\nIStateInfo.PositionId\nПоле PositionId содержит идентификатор позиции пользователя, изменившего состояние объекта последним.\nint IStateInfo.PositionId { get; }","keywords":[]},"pages/client/ice/data/IFilesSnapshot.html":{"title":"Интерфейс IFilesSnapshot","content":"Интерфейс содержит информацию о файлах элемента.\nIFilesSnapshot.Created\nПоле Created содержит дату создания снимка файлов.\nDateTime IFilesSnapshot.Created { get; }\nIFilesSnapshot.CreatorId\nПоле CreatorId содержит идентификатор пользователя сделавшего снимок файлов.\nint IFilesSnapshot.CreatorId { get; }\nIFilesSnapshot.Reason\nПоле Reason содержит информацию о причине создания снимка файлов.\nstring IFilesSnapshot.Reason { get; }\nIFilesSnapshot.Files\nПоле Files содержит список файлов снимка.\nReadOnlyCollection<IFile> IFilesSnapshot.Files { get; }","keywords":[]},"pages/client/ice/data/IRelation.html":{"title":"Интерфейс IRelation","content":"Интерфейс предоставляет доступ к свойствам связи элемента.\nIRelation.Id\nПоле Id содержит идентификатор связи. У двух связанных между собой объектов должны быть связи с одинаковым идентификатором.\nGuid IRelation.Id { get; }\nIRelation.TargetId\nПоле TargetId содержит идентификатор элемента, с которым связан текущий объект.\nGuid IRelation.TargetId { get; }\nIRelation.Type\nПоле Type содержит тип связи. Подробнее см ObjectRelationType\nObjectRelationType IRelation.Type { get; }\nIRelation.Name\nПоле Name содержит имя связи.\nstring IRelation.Name { get; }\nIRelation.VersionId\nПоле VersionId содержит дату создания версии документа.\nDateTime IRelation.VersionId { get; }\nIRelation.SourceRelationId\nПоле SourceRelationId содержит идентификатор связи, с которой данная связь скопирована.\nGuid IRelation.SourceRelationId { get; }","keywords":[]},"pages/client/ice/data/IHistoryItem.html":{"title":"Интерфейс IHistoryItem","content":"Интерфейс описывает элемент истории изменения объекта.\nIHistoryItem.Id\nПоле Id содержит идентификатор элемента.\nGuid Id { get; }\nIHistoryItem.ObjectId\nПоле ObjectId содержит идентификатор объекта.\nGuid ObjectId { get; }\nIHistoryItem.Reason\nПоле Reason содержит причину изменения объекта.\nstring Reason { get; }\nIHistoryItem.Created\nПоле Created содержит дату и время создания изменения объекта.\nDateTime Created { get; }\nIHistoryItem.CreatorId\nПоле CreatorId содержит идентификатор пользователя, создавшего изменение.\nint CreatorId { get; }\nIHistoryItem.Object\nПоле Object содержит состояние объекта на момент изменения.\nIDataObject Object { get; }","keywords":[]},"pages/client/ice/data/ILicenseInfo.html":{"title":"Интерфейс ILicenseInfo","content":"Интерфейс содержит информацию о лицензии для определенного продукта.\nILicenseInfo.ProductId\nПоле ProductId содержит номер продукта.\nint ILicenseInfo.ProductId { get; }\nILicenseInfo.IsExpired\nПоле IsExpired содержит информацию просрочена ли лицензия.\nbool ILicenseInfo.IsExpired { get; }\nILicenseInfo.IsCheated\nПоле IsCheated содержит информацию о корректности файла лицензии.\nbool ILicenseInfo.IsCheated { get; }\nILicenseInfo.ExpirationDate\nПоле ExpirationDate дату истечения лицензии.\nDateTime ILicenseInfo.ExpirationDate { get; }\nILicenseInfo.MaxLicensesCount\nПоле MaxLicensesCount содержит количество рабочих мест, выделенных для данного продукта.\nint ILicenseInfo.MaxLicensesCount { get; }","keywords":[]},"pages/client/ice/data/IReportItem.html":{"title":"Интерфейс IReportItem","content":"Интерфейс IReportItem описывает объект типа отчет.\nIReportItem.Id\nПоле Id содержит уникальный идентификатор объекта.\nGuid IReportItem.Id { get; }\nIReportItem.Name\nПоле Name содержит текущее имя отчета.\nstring IReportItem.Name { get; }\nIReportItem.Type\nПоле Type возвращает тип отчета.\nIType IReportItem.Type { get; }\nIReportItem.SourceTypesNames\nПоле SourceTypesNames возвращает список имен типов объектов, для которых данный отчет может быть построен. То есть список допустимых типов объектов, которые могут использоваться как параметр отчета.\nHashSet<string> IReportItem.SourceTypesNames { get; }","keywords":[]},"pages/client/ice/data/IUserStateMachine.html":{"title":"Интерфейс IUserStateMachine","content":"Интерфейс IUserStateMachine описывает машину состояний.\nIUserStateMachine.Id\nПоле Id содержит уникальный идентификатор машины состояния. Данный идентификатор в виде строки записывается в IAttribute.Configuration для связи атрибута типа \"Состояние\" с машиной состояний.\nGuid IUserStateMachine.Id { get; }\nIUserStateMachine.Title\nПоле Title содержит имя машины состояний.\nstring IUserStateMachine.Title { get; }\nIUserStateMachine.StateTransitions\nПоле StateTransitions содержит список переходов машины состояний. Ключом словаря является идентификатор состояния, значением - список переходов, доступных для данного состояния.\nIDictionary<Guid, IEnumerable<ITransition>> IUserStateMachine.StateTransitions { get; }","keywords":[]},"pages/client/ice/data/IUserState.html":{"title":"Интерфейс IUserState","content":"Интерфейс IUserState описывает пользовательское состояние\nIUserState.Id\nПоле Id содержит уникальный идентификатор пользовательского состояния. Данный идентификатор в виде строки записывается как значение атрибута в объект, находящийся в данном состоянии.\nGuid IUserState.Id { get; }\nIUserState.Name\nПоле Name содержит уникальное внутреннее имя пользовательского состояния.\nstring IUserState.Name { get; }\nIUserState.Title\nПоле Title содержит отображаемое имя пользовательского состояния.\nstring IUserState.Title { get; }\nIUserState.Icon\nПоле Icon содержит иконку пользовательского состояния в формате SVG.\nbyte[] IUserState.Icon { get; }\nIUserState.Color\nПоле Color содержит цвет пользовательского состояния из перечисления возможных цветов.\nUserStateColors IUserState.Color { get; }\nIUserState.IsDeleted\nПоле IsDeleted показывает, было ли удалено пользовательское состояние.\nbool IUserState.IsDeleted { get; }","keywords":[]},"pages/client/ice/data/ICertificate.html":{"title":"ICertificate","content":"Описывает сертификат\nstring Thumbprint\nУникальный идентификатор сертификата\nDataTime ValidToDate\nДата окончания действия сертификата\nDataTime ValidFromDate\nДата начала действия сертификата\nstring Issuer\nЦентр сертификации, выпустивший сертификат\nstring Subject\nСубъект сертификата\nstring PublicKeyOid\nИдентификатор алгоритма публичного ключа сертификата","keywords":[]},"pages/client/ice/data/IMouseLeftClickListener.html":{"title":"Интерфейс IMouseLeftClickListener","content":"Интерфейс обработчика клика левой кнопки мыши по документу.\nIMouseLeftClickListener.OnLeftMouseButtonClick\nМетод вызывается при клике левой кнопки мыши.\nvoid OnLeftMouseButtonClick (XpsRenderClickPointContext pointContext);\nгде pointContext - XpsRenderClickPointContext\nIMouseLeftClickListener.OnLeftMouseButtonClick\nМетод вызывается при клике левой кнопки мыши.\nvoid OnLeftMouseButtonClick (XpsRenderClickPointContext pointContext);\nгде pointContext - XpsRenderClickPointContext","keywords":[]},"pages/client/ice/data/ITransition.html":{"title":"Интерфейс ITransition","content":"Интерфейс ITransition описывает переход в машине состояний\nITransition.StateTo\nПоле StateTo содержит идентификатор состояния, в которое доступен переход.\nGuid ITransition.StateTo { get; }\nITransition.DisplayName\nПоле DisplayName содержит название команды в пользовательском интерфейcе, которая осуществляет данный переход.\nstring ITransition.DisplayName { get; }\nITransition.AvailableForPositionsSource\nПоле AvailableForPositionsSource определяет права доступа на данный переход. По умолчанию (при значении null ), данный переход доступен всем пользователям, у которых есть права на редактирование объекта. Значения, отличные от null, позволяют наложить дополнительные ограничения на доступность перехода. В данный массив строк могут быть записаны значения двух типов:\nЛокальные роли. Локальные роли начинаются с символа & и указывают на атрибут типа \"Организационная единица\", в котором будут записаны идентификаторы должностей и подразделений, имеющих права доступа на данный переход.\nИдентификаторы элементов организационной структуры. Выглядят как целое число и указывают, какие должности или подразделения будут иметь права доступа на данный переход.\nstring[] ITransition.AvailableForPositionsSource { get; }","keywords":[]},"pages/client/ice/data/TypeKind.html":{"title":"Перечисление TypeKind","content":"Перечисление видов типа элемента.\nTypeKind.User\nТип элемента является пользовательским и элементы данного типа могут отображаться в Обозревателе элементов.\nTypeKind.User;\nTypeKind.System\nТип элемента является системным и элементы данного типа не отображаются в Обозревателе элементов.\nTypeKind.System;","keywords":[]},"pages/client/ice/data/DataState.html":{"title":"Перечисление DataState","content":"Перечисление состояний элемента.\nDataState.Unknown\nНе известное состояние элемента. Все создаваемые элементы получают данное состояние.\nDataState.Unknown;\nDataState.NoData\nЭлемент существует, но не загружен в память клиента.\nDataState.NoData;\nDataState.Loaded\nЭлемент существует и загружен в память клиента.\nDataState.Loaded;\nDataState.NonExistent\nЭлемента не существует.\nDataState.NonExistent;","keywords":[]},"pages/client/ice/data/AccessLevel.html":{"title":"Перечисление AccessLevel","content":"Перечисление возможных уровней доступа к элементам.\nAccessLevel.None\nНет доступа к элементу.\nAccessLevel.None;\nAccessLevel.View\nУровень доступа, позволяющий просматривать свойства текущего элемента.\nAccessLevel.View;\nAccessLevel.Create\nУровень доступа, позволяющий создавать дочерние элементы.\nAccessLevel.Create;\nAccessLevel.Edit\nУровень доступа, позволяющий редактировать текущий элемент.\nAccessLevel.Edit;\nAccessLevel.Agreement\nУровень доступа, отвечающий за возможность аннотирования/подписания документов.\nAccessLevel.Agreement;\nAccessLevel.Freeze\nУровень доступа, позволяющий замораживать/размораживать текущий элемент.\nAccessLevel.Freeze;\nAccessLevel.Share\nУровень доступа, позволяющий делегировать права доступа для текущего элемента.\nAccessLevel.Share;\nAccessLevel.ViewCreate\nУровень доступа, позволяющий просматривать свойства текущего элемента и создавать дочерние элементы. Это комбинация двух уровней доступа Create и View.\nAccessLevel.ViewCreate;\nAccessLevel.ViewEdit\nПолный доступ к элементу. Уровень доступа, позволяющий просматривать, редактировать свойства текущего элемента и создавать дочерние элементы. Это комбинация уровней доступа Create, View и Edit.\nAccessLevel.ViewEdit;","keywords":[]},"pages/client/ice/data/State.html":{"title":"Перечисление State","content":"Перечисление состояний элемента задания.\nState.None\nЧерновик\nState.None;\nState.Assigned\nЗадание выдано\nState.Assigned;\nState.InProgress\nЗадание взято в работу\nState.InProgress;\nState.Revoked\nЗадание отозвано\nState.Revoked;\nState.OnValidation\nЗадание находится на проверке\nState.OnValidation;\nState.Completed\nЗадание выполнено\nState.Completed;","keywords":[]},"pages/client/ice/data/ObjectState.html":{"title":"Перечисление ObjectState","content":"Перечисление состояний элемента.\nObjectState.Alive\nСостояние по умолчанию. Элемент \"живой\".\nObjectState.Alive;\nObjectState.InRecycleBin\nЭлемент удален в корзину\nObjectState.InRecycleBin;\nObjectState.DeletedPermanently\nЭлемент удален безвозвратно\nObjectState.DeletedPermanently;\nObjectState.Frozen\nЭлемент заморожен\nObjectState.Frozen;\nObjectState.LockRequested\nЗапрошено разрешение на блокировку\nObjectState.LockRequested;\nObjectState.LockAccepted\nЭлемент заблокирован\nObjectState.LockAccepted;","keywords":[]},"pages/client/ice/data/StorageObjectState.html":{"title":"Перечисление StorageObjectState","content":"Перечисление состояний элемента Pilot-Storage.\nStorageObjectState.None = 0;\nНеизвестное состояние элемента.\nStorageObjectState.NotLoaded = 1;\nЭлемент не загружен.\nStorageObjectState.Loaded = 2;\nЭлемент загружен.\nStorageObjectState.Outdated = 4;\nЭлемент скачан с сервера. Но на сервере есть более новая версия.\nStorageObjectState.NotSent = 8;\nЭлемент еще не был отправлен на сервер.\nStorageObjectState.Edited = 16;\nЕсть локальные изменения, которые не отправлены на сервер.\nStorageObjectState.Aborted = 32;\nИзменения не принятые сервером.\nStorageObjectState.Temp = 64;\nВременный элемент, который никогда не будет отправлен на сервер.\nStorageObjectState.Locked = 128;\nЭлемент заблокирован.\nStorageObjectState.Downloading = 256;\nЭлемент в процессе загрузки.\nStorageObjectState.Conflicted = 512;\nЭлемент в состоянии конфликта.","keywords":[]},"pages/client/ice/data/ObjectRelationType.html":{"title":"Перечисление ObjectRelationType","content":"ObjectRelationType.SourceFiles\nТип связи с исходным файлом\nObjectRelationType.SourceFiles;\nObjectRelationType.TaskInitiatorAttachments\nТип связи, описывающий вложения в задание документов или файлов инициатором задания.\nObjectRelationType.TaskInitiatorAttachments;\nObjectRelationType.MessageAttachments\nТип связи, описывающий вложения в переписку по заданию документов или файлов.\nObjectRelationType.MessageAttachments;\nObjectRelationType.Custom\nПользовательский тип связи. Этот тип связи отображается во вкладке \"Связи\" в клиенте Pilot.\nObjectRelationType.Custom;","keywords":[]},"pages/client/ice/data/OrganisationUnitKind.html":{"title":"Перечисление OrganisationUnitKind","content":"Перечисление типов элементов организационной структуры.\nOrganisationUnitKind.Department\nПодразделение организационной структуры. Может включать дочерние подразделения и должности. Пользователь не может быть назначен на подразделение.\nOrganisationUnitKind.Department;\nOrganisationUnitKind.Position\nДолжность организационной структуры. Не может иметь дочерних элементов. На должность может быть назначен пользователь и список заместителей.\nOrganisationUnitKind.Position;\nOrganisationUnitKind.Group\nГруппа организационной структуры. Может быть создана только на первом уровне организационной структуры, не может содержать дочерних элементов и иметь назначенного пользователя. Используется для объединения пользователей в группы.\nOrganisationUnitKind.Group;","keywords":[]},"pages/client/ice/data/ChatKind.html":{"title":"ChatKind Enum","content":"Задает значения, которые определяют тип чата.\nPersonal\nЧат для личной переписки.\nGroup\nГрупповой чат.\nObjectRelated\nЧат по элементу.","keywords":[]},"pages/client/ice/data/ThemeNames.html":{"title":"ThemeNames Enum","content":"Задает значения, которые управляют схемой приложения.\nПоля\nJedi\nСветлая схема приложения.\nSith\nТемная схема приложения.","keywords":[]},"pages/client/ice/data/IClientInfo.html":{"title":"Перечисление IClientInfo","content":"Перечисление видов клиентов\nIClientInfo.Ice = 0,\nPilot-ICE клиент\nIClientInfo.IceEnterprise = 1,\nPilot-ICE Enterprise клиент\nIClientInfo.ThreeDStorage = 2,\n3D-Storage клиент\nIClientInfo.Ecm = 3,\nPilot-ECM клиент\nIClientInfo.Bim = 4,\nPilot-BIM клиент","keywords":[]},"pages/client/ice/data/CadesType.html":{"title":"CadesType Enum","content":"Unknown\nНеизвестная подпись.\nNotCades\nНе являющаяся Cades подпись.\nCadesBes\nБазовая подпись без штампов времени и ссылок на сертификаты.\nCadesEpes\nДобавляется политика подписи.\nCadesT\nДобавляется штамп времени.\nCadesC\nДобавляется полные значения сертификатов и CRL для самодостаточной проверки.\nCadesXLT1\nДобавляются ссылки на сертификаты и CRL, а также архивный штамп времени.\nCadesXLT2\nДобавляются полные значения сертификатов и CRL(как в CADES-C).\nCadesA\nАрхивная подпись, включающая все необходимые данные для долговременной проверки подписи.","keywords":[]},"pages/client/ice/data/ChatRelationType.html":{"title":"ChatRelationType Enum","content":"Задает значения, которые определяют тип связи чата с объектом.\nRelation\nСвязь\nAttach\nВложение","keywords":[]},"pages/client/ice/data/OnlineEventArgs.html":{"title":"Событие OnlineEventArgs","content":"Аргументы события OnlineEventArgs присылаются расширению когда возникает событие перехода клиентского приложения Pilot в режим автономной работы в сети.\npublic class OnlineEventArgs: MarshalByRefObject { }","keywords":[]},"pages/client/ice/data/PilotBalloonIcon.html":{"title":"PilotBalloonIcon Enum","content":"Задает значения, которые определяют иконку всплывающего окна.\nПоля\nNone\nИконка отсутствует.\nInfo\nИконка, которая характеризует вывод информационного сообщения во всплывающем окне.\nWarning\nИконка, которая характеризует вывод предупреждения во всплывающем окне.\nError\nИконка, которая характеризует вывод ошибки во всплывающем окне.","keywords":[]},"pages/client/ice/data/OfflineEventArgs.html":{"title":"Событие OfflineEventArgs","content":"Аргументы события OfflineEventArgs присылаются расширению когда возникает событие перехода клиентского приложения Pilot в режим автономной работы.\npublic class OfflineEventArgs: MarshalByRefObject { }","keywords":[]},"pages/client/ice/data/PdfStamperMode.html":{"title":"Перечисление PdfStamperMode","content":"Перечисление режимов при наложении штампов на pdf-документы\nPdfStamperMode.Preview = 0,\nОтображение в просмотрщике документов\nPdfStamperMode.Print = 1,\nВывод на печать\nPdfStamperMode.Export = 2\nЭкспорт проекта","keywords":[]},"pages/client/ice/data/SynchronizationState.html":{"title":"Перечисление SynchronizationState","content":"Перечисление состояний синхронизации элемента с сервером.\nSynchronizationState.Synchronized\nЭлемент синхронизирован с сервером. Элемент на сервере идентичен элементу в кеше клиента.\nSynchronizationState.Synchronized;\nSynchronizationState.AwaitingForSynchronization\nЭлемент в ожидании синхронизации с сервером.\nSynchronizationState.AwaitingForSynchronization;\nSynchronizationState.SynchronizationAborted\nИзменения внесенные в элемент по каким-то причинам были отклонены сервером. Например отсутствие прав на изменение атрибутов элемента.\nSynchronizationState.SynchronizationAborted;","keywords":[]},"pages/client/ice/data/OpenTabEventArgs.html":{"title":"Событие OpenTabEventArgs","content":"Аргументы события OpenTabEventArgs присылаются расширению перед открытием новой вкладки.\npublic class OpenTabEventArgs: MarshalByRefObject { }\nЗаголовок открываемой вкладки.\npublic string OpenTabEventArgs.TabTitle { get; }\nИдентификатор открываемой вкладки.\npublic Guid OpenTabEventArgs.TabId { get; }","keywords":[]},"pages/client/ice/data/TabUndockedEventArgs.html":{"title":"Событие TabUndockedEventArgs","content":"Аргументы события TabUndockedEventArgs присылаются расширению при перемещении вкладки в отдельное окно.\npublic class TabUndockedEventArgs: MarshalByRefObject { }\nКласс TabUndockedEventArgs содержит поле с идентификатором вкладки.\npublic Guid TabUndockedEventArgs.TabId { get; }\nКласс TabUndockedEventArgs содержит поле с дескриптором окна.\npublic IntPtr TabUndockedEventArgs.Handle { get; }","keywords":[]},"pages/client/ice/data/CloseTabEventArgs.html":{"title":"Событие CloseTabEventArgs","content":"Аргументы события CloseTabEventArgs присылаются расширению перед закрытием вкладки.\npublic class CloseTabEventArgs: MarshalByRefObject { }\nИдентификатор закрываемой вкладки.\npublic Guid CloseTabEventArgs.TabId { get; }\nЗаголовок закрываемой вкладки.\npublic string CloseTabEventArgs.TabTitle { get; }","keywords":[]},"pages/client/ice/data/ActiveTabChangedEventArgs.html":{"title":"Событие ActiveTabChangedEventArgs","content":"Аргументы события ActiveTabChangedEventArgs присылаются расширению при изменении активной вкладки.\npublic class ActiveTabChangedEventArgs: MarshalByRefObject { }\nКласс ActiveTabChangedEventArgs содержит поле с идентификатором активной вкладки.\npublic Guid ActiveTabChangedEventArgs.ActiveTabId { get; }","keywords":[]},"pages/client/ice/automation/IAutomationBackend.html":{"title":"Интерфейс IAutomationBackend","content":"Интерфейс описывает объект доступа к данным доступным для действий.\nМетоды\nGuid GetDatabaseId ();\nМетод возвращает идентификатор базы данных.\nIDictionary< int, IType> GetTypes ();\nМетод возвращает словарь с описанием доступных типов элементов\nIPerson CurrentPerson ();\nМетод возвращает текущего пользователя\nIDictionary< int, IPerson> GetPeople ();\nМетод возвращает словарь с описанием доступных пользователей\nIDictionary< int, IOrganisationUnit> GetOrganisationUnits ();\nМетод возвращает словарь с описанием доступных организационных единиц\nIDataObject GetObject (Guid id);\nМетод возвращает запрошенный элемент.","keywords":[]},"pages/client/ice/data/LoadedEventArgs.html":{"title":"Событие LoadedEventArgs","content":"Аргументы события LoadedEventArgs присылаются расширению после загрузки клиентского приложения Pilot данного расширения.\npublic class LoadedEventArgs: MarshalByRefObject { }","keywords":[]},"pages/client/ice/data/SystemTypeNames.html":{"title":"SystemTypeNames","content":"PROJECT_FOLDER\nИмя системного типа папка для Pilot-Storage.\npublic const string PROJECT_FOLDER = \"Project_folder\";\nPROJECT_FILE\nИмя системного типа файл для Pilot-Storage.\npublic const string PROJECT_FILE = \"File\";\nEXTENSION\nИмя системного типа расширение.\npublic const string EXTENSION = \"Extension\";\nEXTENSION_FOLDER\nИмя системного типа папка расширений.\npublic const string EXTENSION_FOLDER = \"Extension_folder\";\nSHORTCUT\nИмя системного типа ярлык.\npublic const string SHORTCUT = \"Shortcut_E67517F1-93F5-4756-B651-133B816D43C8\";\nREPORT\nИмя системного типа Отчет.\npublic const string REPORT = \"Report_6088AF81-061E-456E-9225-CF65B7B25368\";\nREPORT_FOLDER\nИмя системного типа Папка отчетов.\npublic const string REPORT_FOLDER = \"Report_Folder_F2CC6F1D-70E1-4E9B-B32F-BEB3E991318F\";\nSMART_FOLDER\nИмя системного типа Умная папка.\npublic const string SMART_FOLDER = \"Smart_folder_type\";\nTASK_TEMPLATE_FOLDER\nИмя системного типа Папка шаблонов заданий.\npublic const string TASK_TEMPLATE_FOLDER = \"Task_template_folder_A0A09765-E6FB-4272-87EE-37793283DBC5\";\nTASK_TEMPLATE\nИмя системного типа Шаблон задания.\npublic const string TASK_TEMPLATE = \"Task_template_05339782-CCBA-4786-80C3-0F6C7E0EF3C5\";\nDOCUMENT_TEMPLATE_FOLDER\nИмя системного типа Папка шаблонов документов.\npublic const string DOCUMENT_TEMPLATE_FOLDER = \"Document_template_folder_793D0CE8-65E6-484E-AAF9-7E095AF9DBD2\";\nDOCUMENT_TEMPLATE\nИмя системного типа Шаблон документов.\npublic const string DOCUMENT_TEMPLATE = \"Document_template_89B9E233-A6F9-4B9C-B970-55B3B3A77CED\";\nGLOBAL_ROOT_TYPE_NAME\nИмя системного типа Глобальный корень документов.\npublic const string GLOBAL_ROOT_TYPE_NAME = \"Root_object_type\";\nWORKFLOW_PREFIX\nПрефикс для типа Процесс.\npublic const string WORKFLOW_PREFIX = \"workflow_\";\nSTAGE_PREFIX\nПрефикс для типа Этап задания.\npublic const string STAGE_PREFIX = \"stage_\";\nTASK_PREFIX\nПрефикс для типа Задание.\npublic const string TASK_PREFIX = \"task_\";\nBIM_PREFIX\nПрефикс для типов системы BIM BIM типы.\npublic const string BIM_PREFIX = \"bim_\";","keywords":[]},"pages/client/ice/data/TabDockedEventArgs.html":{"title":"Событие TabDockedEventArgs","content":"Аргументы события TabDockedEventArgs присылаются расширению при перемещении вкладки из отдельного окна в панель вкладок.\npublic class TabDockedEventArgs: MarshalByRefObject { }\nКласс TabDockedEventArgs содержит поле с идентификатором вкладки.\npublic Guid TabDockedEventArgs.TabId { get; }","keywords":[]},"pages/client/ice/data/SystemStates.html":{"title":"SystemStates","content":"Константы для системных состояний.\nTASK_REVOKED_STATE_ID\nИдентификатор состояния Отозвано\npublic static Guid TASK_REVOKED_STATE_ID = Guid.Parse( \"abdbe49a-7094-4084-9673-eb5fb3f95262\" );\nTASK_NONE_STATE_ID\nИдентификатор состояния Нет\npublic static Guid TASK_NONE_STATE_ID = Guid.Parse( \"d8ae8c3a-6f46-45d2-835b-563fe2b47acd\" );\nTASK_NO_EXECUTOR_ASSIGNED_STATE_NAME\nКонстанта Исполнитель не назначен\npublic static string TASK_NO_EXECUTOR_ASSIGNED_STATE_NAME = \"noExecutorAssigned\";","keywords":[]},"pages/client/ice/data/SystemFileNames.html":{"title":"SystemFileNames","content":"Константы имен системных файлов. Эти константы можно использовать при фильтрации файлов элемента или добавлении нового.\nПример добавления миниатюры к элементу:\nIObjectBuilder.AddFile(Path.GetFileName(filename) + SystemFileNames.THUMBNAIL_FILE_NAME_POSTFIX, bitmapStream, DateTime.UtcNow, DateTime.UtcNow, DateTime.UtcNow);\n[Obsolete]\nANNOTATIONS_DEFINITION\nИмя файла с описанием замечания\npublic const string ANNOTATIONS_DEFINITION = \"Annotation\";\nGRAPHIC_LAYER_ELEMENT_DEFINITION\nПрефикс имени файла с описанием графического элемента\npublic const string GRAPHIC_LAYER_ELEMENT_DEFINITION = \"PILOT_GRAPHIC_LAYER_ELEMENT_\";\nGRAPHIC_LAYER_ELEMENT_CONTENT\nПрефикс имени файла с содержимым графического элемента\npublic const string GRAPHIC_LAYER_ELEMENT_CONTENT = \"PILOT_CONTENT_GRAPHIC_LAYER_ELEMENT_\";\n[Obsolete]\nANNOTATION_CHAT_MESSAGE\nИмя файла с содержимым сообщения к замечанию\npublic const string ANNOTATION_CHAT_MESSAGE = \"Note_Chat_Message\";\nDIGITAL_SIGNATURE\nИмя файла с цифроврой подписью\npublic const string DIGITAL_SIGNATURE = \"PilotDigitalSignature\";\nTHUMBNAIL_FILE_NAME_POSTFIX\nИмя файла с миниатюрой для файла на Pilot-Storage\npublic const string THUMBNAIL_FILE_NAME_POSTFIX = \"PilotThumbnail\";\nTEXT_LABELS_DEFINITION\nИмя файла с описанием текстовых меток\npublic const string TEXT_LABELS_DEFINITION = \"PilotTextLabels\";\nBARCODE_DEFINITION\nИмя файла с описанием штрих-кода\npublic const string BARCODE_DEFINITION = \"PilotBarcode\";","keywords":[]},"pages/client/ice/data/IChatMessage.html":{"title":"Интерфейс IChatMessage","content":"Интерфейс предназначен для просмотра информации о сообщении.\nIChatMessage.Id\nПоле Id содержит идентификатор сообщения.\nGuid IChatMessage.Id { get; }\nIChatMessage.Data\nПоле Data содержит специфичные для определенного типа сообщения данные.\nbyte[] IChatMessage.Data { get; }\nIChatMessage.CreatorId\nПоле CreatorId содержит идентификатор пользователя создавшего сообщение.\nint IChatMessage.CreatorId { get; }\nIChatMessage.ServerDate\nПоле ServerDate содержит содержит серверную дату-время создания собщения в формате UTC.\nDateTime? IChatMessage.ServerDate { get; }\nIChatMessage.ClientDateUtc\nПоле ClientDateUtc содержит клиентскую дату-время создания сообщения в формате UTC.\nDateTime IChatMessage.ClientDateUtc { get; }\nIChatMessage.ChatId\nПоле ChatId содержит идентификатор чата.\nGuid IChatMessage.ChatId { get; }\nIChatMessage.RelatedMessageId\nПоле RelatedMessageId содержит идентификатор сообщения, с которым связано данное сообщение. Например: отредактированное, отвеченное, прочитанное сообщение.\nGuid IChatMessage.RelatedMessageId { get; }\nIChatMessage.Type\nПоле Type содержит тип сообщения. Подробнее см. MessageType\nGuid IChatMessage.RelatedMessageId { get; }\nIChatMessage.RelatedMessages\nПоле RelatedMessages содержит сообщения, которые ссылаются на данное сообщение.\nList<IChatMessage> IChatMessage.RelatedMessages{ get; }\nIChatMessage.GetData();\nДанные текстового сообщения.\nT GetData <T>();\nГде T один из типов из списка:\nITextMessageData для текстового сообщения","keywords":[]},"pages/client/ice/data/SystemAttributeNames.html":{"title":"SystemAttributeNames","content":"Константы для системных атрибутов.\nDELETE_DATE\nИмя атрибута с датой удаления элемента.\npublic const string DELETE_DATE = \"DeleteDate 9349ED7C-C2D7-4B8B-852A-83140F158611\";\nDELETE_INITIATOR_PERSON\nИмя атрибута с идентификатором пользователя, удалившего элемент.\npublic const string DELETE_INITIATOR_PERSON = \"DeleteInitiatorPerson BE56ECD1-F4C5-40E2-A83C-274EAE4D02A9\";\nDELETE_INITIATOR_POSITION\nИмя атрибута с идентификатором должности пользователя, удалившего элемент.\npublic const string DELETE_INITIATOR_POSITION = \"DeleteInitiatorPosition 35E355AC-97B3-40FC-9636-1648402040D4\";\nSEARCH_CRITERIA\nИмя атрибута с критерием поиска для умной папки\npublic const string SEARCH_CRITERIA = \"SearchCriteria 52F6E73A-D736-49CD-8807-5AD955506A37\";\nSMART_FOLDER_TITLE\nИмя атрибута с именем для умной папки\npublic const string SMART_FOLDER_TITLE = \"SmartFolderTitle 3AE3FFC8-A776-4E61-87D0-FFD8B50CBBA8\";\nSEARCH_CONTEXT_OBJECT_ID\nИмя атрибута с идентификатором объекта-контекста поиска для умной папки\npublic const string SEARCH_CONTEXT_OBJECT_ID = \"SearchContextObjectId 257E6DB2-F3A3-4231-83D4-DB57C3FF059E\";\nIS_HIDDEN\nИмя атрибута, значение которого указывает на то, спрятана ли папка или файл на Pilot-Storage\npublic const string IS_HIDDEN = \"IsHidden FDF5475C-93FA-41F3-8243-F1810854DEBD\";\nPROJECT_ITEM_NAME\nИмя атрибута с именем файла или папки на Pilot-Storage\npublic const string PROJECT_ITEM_NAME = \"Title 4C281306-E329-423A-AF45-7B39EC30273F\";\nEXTENSION_FOLDER_NAME\nИмя атрибута с именем папки для расширений\npublic const string EXTENSION_FOLDER_NAME = \"Extension_folder_name EE4DE4B7-FFB7-455E-8E15-C185CFDB34FA\";\nEXTENSION_NAME\nИмя атрибута с именем расширения\npublic const string EXTENSION_NAME = \"Extension_name 53522556-0749-46DE-913E-EDA195AD1299\";\nEXTENSION_ADDITIONAL\nИмя атрибута с описанием расширения\npublic const string EXTENSION_ADDITIONAL = \"Extension_additional 9A428222-2031-4F5E-A367-C5BAA18DFCA5\";\nSHORTCUT_OBJECT_ID\nИмя атрибута с идентификатором объекта, на который ссылается ярлык\npublic const string SHORTCUT_OBJECT_ID = \"Shortcut_object_id_CF11FD82-3D56-4DBC-B7F8-DF91CA1F9885\";\nREPORT_FOLDER_NAME\nИмя атрибута с именем папки отчетов\npublic const string REPORT_FOLDER_NAME = \"Report_folder_name_BDBDEDD1-BFCB-4E2C-BE44-3E4BEBBB58F9\";\nREPORT_NAME\nИмя атрибута с именем элемента отчет\npublic const string REPORT_NAME = \"Report_name_D745D627-E7CD-4E3A-B30E-F9EDC1A09D77\";\nREPORT_SOURCE_TYPES_NAMES\nИмя атрибута с типами элементов с данными для отчета\npublic const string REPORT_SOURCE_TYPES_NAMES = \"Report_source_types_names_76e09b65-9785-40cc-986e-b35cd6c3a4fe\";\nTASK_TEMPLATE_NAME\nИмя атрибута с именем шаблона задания\npublic const string TASK_TEMPLATE_NAME = \"Task_template_name_CE25F101-E758-4A68-9F16-E73B72F39FBC\";\nTASK_TEMPLATE_VALUE\nИмя атрибута с объектом шаблона задания\npublic const string TASK_TEMPLATE_VALUE = \"Task_template_value_3C190DF3-3644-47F4-AF64-45C140207054\";\nTASK_TEMPLATE_FOLDER_NAME\nИмя атрибута с именем папки шаблонов заданий\npublic const string TASK_TEMPLATE_FOLDER_NAME = \"Task_template_folder_name_DC250687-50D3-40E9-8B9A-71ACD01D50F7\";\nTAGS\nИмя атрибута с тегами\npublic const string TAGS = \"Tags_BCA19031-E5A1-49D3-A55F-47B30A8F7243\";\nDEFAULT_PUBLISH_FILE_ID\nИмя атрибута с идентификатором файла для публикации по умолчанию\npublic const string DEFAULT_PUBLISH_FILE_ID = \"Default_publish_file_id_BA9EA041-93E8-4AE9-9E09-0C40221DE75D\";\nDOCUMENT_TEMPLATE_NAME\nИмя атрибута с именем шаблона документов\npublic const string DEFAULT_PUBLISH_FILE_ID = \"Default_publish_file_id_BA9EA041-93E8-4AE9-9E09-0C40221DE75D\";\nDOCUMENT_TEMPLATE_TYPE_ID\nИмя атрибута с идентификатором типа шаблона документов\npublic const string DOCUMENT_TEMPLATE_TYPE_ID = \"Document_template_type_id_0D8595C0-45CF-4C98-8AB2-EE5C9276DE3E\";\nDOCUMENT_TEMPLATE_FOLDER_NAME\nИмя атрибута с именем папки шаблонов документов\npublic const string DOCUMENT_TEMPLATE_FOLDER_NAME = \"Document_template_folder_name_D6C7CC9A-0850-47B7-88D0-1045F8D5561D\";","keywords":[]},"pages/client/ice/data/SystemObjectIds.html":{"title":"SystemObjectIds","content":"Идентификаторы системных объектов.\nRootObjectId\nИдентификатор корневого объекта элеметов\npublic static readonly Guid RootObjectId = new Guid( \"00000001-0001-0001-0001-000000000001\" );\nExtensionRootObjectId\nИдентификатор корневого объекта расширений\npublic static readonly Guid ExtensionRootObjectId = new Guid( \"E6519D37-1984-407E-96A0-1CD371F68F16\" );\nReportRootObjectId\nИдентификатор корневого объекта отчетов\npublic static readonly Guid ReportRootObjectId = new Guid( \"7DAB217D-6E06-4C2C-AB77-B5EC9361415D\" );\nTaskTemplateRootObjectId\nИдентификатор корневого объекта шаблонов заданий\npublic static readonly Guid TaskTemplateRootObjectId = new Guid( \"DB4AB44C-B3D1-4F5A-B049-13CDF0C2EFE7\" );\nDocumentTemplateRootId\nИдентификатор корневого объекта шаблонов документов\npublic static readonly Guid DocumentTemplateRootId = new Guid( \"109DA1F5-7E1A-4DF4-95BD-1FD5AA023DD6\" );","keywords":[]},"pages/client/ice/data/IChat.html":{"title":"Интерфейс IChat","content":"Интерфейс описывает чат.\nIChat.Id\nИдентификатор чата.\nGuid Id { get; }\nIChat.Name\nНазвание чата.\nstring Name { get; }\nIChat.Description\nОписание чата.\nstring Description { get; }\nIChat.CreatorId\nИдентификатор создателя чата.\nint CreatorId { get; }\nIChat.Type\nТип чата.\nChatKind Type { get; }\nIChat.LastMessageId\nИдентификатор последнего сообщения в чате.\nGuid? LastMessageId { get; }\nIChat.CreationDateUtc\nДата сощдания чата в UTC.\nDateTime CreationDateUtc { get; }","keywords":[]},"pages/client/ice/data/ITextMessageData.html":{"title":"Интерфейс ITextMessageData","content":"Интерфейс описывает данные текстового сообщения.\nITextMessageData.Text\nТекст сообщения.\nstring Text { get; }\nITextMessageData.Attachments\nВложения в сообщения.\nList<IChatRelation> Attachments { get; }\nITextMessageData.IsReadOnly\nОпределяет, доступно ли редактирование для сообщения.\nstring IsReadOnly { get; }","keywords":[]},"pages/client/ice/data/UnloadedEventArgs.html":{"title":"Событие UnloadedEventArgs","content":"Аргументы события LoadedEventArgs присылаются расширению перед выгрузкой клиентского приложения Pilot данного расширения.\npublic class UnloadedEventArgs: MarshalByRefObject { }","keywords":[]},"pages/client/ice/data/IChatRelation.html":{"title":"Интерфейс IChatRelation","content":"Интерфейс описывает данные связи сообщения с объектом.\nITextMessageData.ObjectId\nИдентификатор объекта.\nGuid ObjectId { get; set; }\nITextMessageData.Type\nТип связи.\nChatRelationType Type { get; set; }\nITextMessageData.MessageId\nИдентификатор сообщения, создавшего связь.\nGuid? MessageId { get; set; }\nITextMessageData.IsDeleted\nПризнак удаленной связи.\nbool IsDeleted { get; set; }","keywords":[]},"pages/client/ice/data/MessageType.html":{"title":"MessageType Enum","content":"Задает значения, которые определяют тип сообщения.\nTextMessage\nТекстовое сообщение.\nChatCreation\nСообщение создания чата.\nChatMembers\nСообщение редактирования участников чата: добавление/удаление/редактирование.\nMessageRead\nСообщение о прочтении другого сообщения.\nMessageAnswer\nСообщение-ответ на другое сообщение.\nChatChanged\nСообщение редактирования чата.\nChatRelation\nСообщение о добавлении связи.\nMessageDropUnreadCounter\nСообщение сбросе счетчика непрочитанных сообщений.\nEditTextMessage\nСообщение о редактировании другого сообщения.","keywords":[]},"pages/client/ice/search/SearchExample.html":{"title":"Пример создания поискового запроса","content":"using Ascon.Pilot.SDK; namespace SearchSample\n{ [ Export ( typeof (IDataPlugin))] public class SearchSamplePlugin: IDataPlugin, IObserver<ISearchResult> { private readonly IObjectsRepository _repository; private long _total; [ImportingConstructor] public SearchSamplePlugin (ISearchService searchService, IObjectsRepository repository) { _repository = repository; var currentPerson = repository. GetCurrentPerson (); var fromDate = new DateTime ( 2016, 1, 1 ). ToUniversalTime (); var to = new DateTime ( 2016, 12, 31 ). ToUniversalTime (); //Построим запрос на поиск объектов: // - созданные текущим пользователем // - объекты только типа \"Project\" // - созданные в 2016 году // - сортировать результаты по дате создания. По возрастанию. // - вывести только 50 результатов var qBuilder = searchService. GetObjectQueryBuilder (); qBuilder. Must (ObjectFields.CreatorId. Be (currentPerson.Id)). Must (ObjectFields.TypeId. Be ( GetProjectTypeId ())). Must (ObjectFields.CreatedDate. BeInRange (fromDate, to)). SortBy (ObjectFields.CreatedDate, ListSortDirection.Ascending). MaxResults ( 50 ); searchService. Search (qBuilder). Subscribe ( this ); } public void OnNext (ISearchResult value) { var items = value.Result; _total = value.Total; _repository. SubscribeObjects (items). Subscribe (SomeObjectsLoader); } public void OnError (Exception error) { } public void OnCompleted () { } private int GetProjectTypeId () { //Сработает только если в конфигурации базы данных присутствует тип с именем Project var type = _repository. GetType ( \"Project\" ); if (type == null) throw new Exception ( \"Type Project not found\" ); return type.Id; } }\n}","keywords":[]},"pages/server/serverapi/serverapi.html":{"title":"Ascon Pilot Server SDK","content":"Для получения серверных интерфейсов используется объект HttpPilotClient, у которого предварительно необходимо вызвать метод Connect(bool isCheckClientVersion = true).","keywords":[]},"pages/server/extensions/IMetricsEvents.html":{"title":"Интерфейс IMetricsEvents","content":"Данный интерфейс предоставляет события для отслеживания метрик Pilot-Server.\nevent EventHandler<ConnectionCountChangedEventArgs> ConnectionCountChanged;\nСобытие об изменении количества клиентских подключений к Pilot-Server. Учитываются подключения от всех клиентов, в т.ч. Pilot-myAdmin и сторонние сервисы.\nevent EventHandler<AuthEventArgs> OnUserAuth;\nСобытие уведомляет о аутентификации пользователя. В случае неуспешной аутентификации в аргументах события свойство IsSuccess будет установлено в false и заполнено свойство Exception.\nevent EventHandler<AuthEventArgs> OnAdministratorAuth;\nСобытие уведомляет о аутентификации администратора Pilot-Server. В случае неуспешной аутентификации в аргументах события свойство IsSuccess будет установлено в false и заполнено свойство Exception.\nevent EventHandler<SessionEventArgs> OnSessionClosed;\nСобытие уведомляет о завершении пользовательской сессии. Дальшейшая работа пользователя или администратора будет возможна только после повторной аутентификации.\nevent EventHandler<ChangesetEventArgs> OnChangeset;\nСобытие уведомляет о новом статусе набора изменений. Наборы изменений используются для изменения объектов Pilot и являются атомарными (либо все изменения набора будут приняты сервером, либо весь набор изменений будет отклонен).\nЧлены класса аргументов события ChangesetEventArgs:\nGuid ChangesetIdentity { get; }\nИдентификатор набора изменений\nChangesetStatus Status { get; }\nСтатус набора изменений. Enqueued - добавлен в очередь на обработку, Completed - успешно обработан, Error - не принят сервером (см. ошибку в ChangesetEventArgs.Error).\nException Error { get; }\nОшибка при применении набора изменений. Заполнена только в случае, если статус набора изменений Error.\nevent EventHandler<LicenseEventArgs> LicenseConsumed;\nСобытие уведомляет об успешном взятии лицензии пользователем.\nevent EventHandler<LicenseConsumeErrorEventArgs> LicenseConsumeError;\nСобытие уведомляет об ошибке при взятии лицензии пользователем.\nevent EventHandler<LicenseEventArgs> LicenseReleased;\nСобытие уведомляет о том, что взятая ранее лицензия была освобождена.","keywords":[]},"pages/server/extensions/IAutomationSearchService.html":{"title":"Интерфейс IAutomationSearchService","content":"var searchService = serverActivityContext. GetService <IAutomationSearchService>();\nСервис IAutomationSearchService служит для поиска объектов. Порядок работы с интерфейсом IQueryBuilder описан в документации Ascon Pilot Server SDK\nМетод поиска объектов.\nIEnumerable<Guid> Search (IQueryBuilder queryBuilder, int maxResults = int.MaxValue);\nгде:\nqueryBuilder - конструктор запроса;\nmaxResults - ограничение на количество возвращаемых результатов;\nПример использования:\nusing System; using System.Linq; using System.Collections; using System.Threading.Tasks; using System.Collections.Generic; using System.ComponentModel.Composition; using Ascon.Pilot.ClientCore.Search;... namespace SearchActivitySample\n{ [ Export ( typeof (IServerActivity))] public class SearchActivity: IServerActivity { public string Name => \"SearchActivity\";... public Task RunAsync (IModifierBase modifier, IModifierBackend backend, IServerActivityContext serverActivityContext, IAutomationEventContext automationEventContext) { var searchService = serverActivityContext. GetService <IAutomationSearchService>(); var queryBuilder = QueryBuilderFactory. CreateEmptyQueryBuilder (); // пример поиска проектов, где указан контрагент queryBuilder. Must (AttributeFields. String ( \"Contractor_name\" ). Exists ()); IEnumerable<Guid> objectsWithContractors = searchService. Search (queryBuilder);... return Task.CompletedTask; } }\n}","keywords":[]},"pages/server/extensions/IServerApiFactory.html":{"title":"Интерфейс \u0016IServerApiFactory","content":"Интерфейс IServerApiFactory предназначен для регистрации дополнительных контрактов для клиент-серверного взаимодействия. Принцип работы с IServerApiFactory демонстрируется в примере Server\\Extensions\\Samples\\ServerApiFactory.ServerExtension.","keywords":[]},"pages/server/serverapi/fields/LicenseDataEx.html":{"title":"Список полей LicenseDataEx","content":"IsExpired\nСодержит признак окончания срока лицензии.\nbool IsExpired { get; }\nIsCheated\nСодержит признак того, что лицензия невалидна.\nbool IsCheated { get; }\nLicenseData\nСодержит данные лицензии.\nLicenseData? LicenseData { get; }","keywords":[]},"pages/server/serverapi/IAuthenticationApi.html":{"title":"Интерфейс IAuthenticationApi","content":"Интерфейс авторизации. Авторизоваться необходимо перед использованием интерфейсов IMessagesApi, IServerApi и IFileArchiveApi, IEventsApi.\nДля получения IAuthenticationApi необходимо вызвать метод HttpPilotClient.GetAuthenticationApi().\nIAuthenticationApi.Login\nМетод авторизации пользователя.\nvoid IAuthenticationApi. Login (string databaseName, string login, string protectedPassword, bool useWindowsAuth, int licenseType);\nгде:\ndatabaseName - имя базы данных.\nlogin - логин пользователя.\nprotectedPassword - пароль, зашифрованный с помощью Advanced Encryption Standard.\nuseWindowsAut - признак использования windows авторизации.\nlicenseType - тип лицензии.\nIAuthenticationApi.GetLicenseInformation\nМетод возвращает сериализованную в XML информацию о лицензии LicenseDataEx.\nbyte[] GetLicenseInformation ()\nIAuthenticationApi.ConsumeLicense\nЗахватывает одну лицензию на сервере.\nvoid ConsumeLicense ( int licenseType);\nгде - licenseType - тип лицензии.\nIAuthenticationApi.ReleaseLicense\nОтпускает одну лицензию на сервере.\nvoid ReleaseLicense ( int licenseType);\nгде - licenseType - тип лицензии.\nСписок используемых типов лицензий\npublic const int PILOT_ICE = 100; public const int PILOT_ECM = 101; public const int PILOT_STORAGE = 102; public const int PILOT_ENTERPRISE = 103; public const int RENGA_ARCHITECTURE = 104; public const int RENGA_STRUCTURE = 105; public const int _8D = 106; public const int _8D_PROF = 107; public const int RENGA_MEP = 108;","keywords":[]},"pages/server/serverapi/IMessagesApi.html":{"title":"Интерфейс IMessagesApi","content":"Интерфейс для работы с сообщениями и чатами.\nIMessagesApi.Open\nМетод, возвращающий через методы обратного вызова уведомления для сообщений, которые были отправлены, пока залогиненый пользователь был оффлайн.\nvoid Open ( int maxNotificationCount, DateTime selectFromDate);\nгде:\nmaxNotificationCount - максимальное число уведомлений. Если это число превышено, будет отправлено агрегирующее уведомление.\nselectFromDate - дата создания сообщения, начиная с которой сообщения будут отправлены как нотификация.\nIMessagesApi.SendMessage\nОтправляет сообщение. Возвращает время создания сообщения на сервере.\nDateTime SendMessage (DMessage message);\nгде:\nmessage - сообщение.\nIMessagesApi.GetNotifiableChats\nВозвращает первые N чатов, отсортированные по дате последнего сообщения.\nList<NotifiableDChatInfo> GetNotifiableChats ( int personId, DateTime fromDateTimeServer, DateTime toDateTimeServer, int topN, bool skipObjectRelated = true );\nгде:\npersonId - идентификатор пользователя. Должен совпадать с залогиненым пользователем.\nfromDateTimeServer - начало временного промежутка.\ntoDateTimeServer - окончание временного промежутка.\ntopN - количество чатов.\nskipObjectRelated - указывает на необходимость пропускать чаты типа ObjectRelated.\nIMessagesApi.GetChats\nВозвращает первые N чатов, отсортированные по дате последнего сообщения.\nList<DChatInfo> GetChats ( int personId, DateTime fromDateTimeServer, DateTime toDateTimeServer, int topN, bool skipObjectRelated = true );\nгде:\npersonId - идентификатор пользователя. Должен совпадать с залогиненым пользователем.\nfromDateTimeServer - начало временного промежутка.\ntoDateTimeServer - окончание временного промежутка.\ntopN - количество чатов.\nskipObjectRelated - указывает на необходимость пропускать чаты типа ObjectRelated.\nIMessagesApi.GetNotifiableChat\nПолучить информацию о чате.\nNotifiableDChatInfo GetNotifiableChat (Guid chatId);\nгде:\nchatId - идентификатор чата.\nIMessagesApi.GetChat\nПолучить информацию о чате.\nDChatInfo GetChat (Guid chatId);\nгде:\nchatId - идентификатор чата.\nIMessagesApi.CheckIsOnline\nПроверяет пользователя на онлайн.\nbool CheckIsOnline ( int personId);\nгде:\npersonId - идентификатор пользователя.\nIMessagesApi.GetPersonalChat\nПолучить информацию о персональном чате залогиненого пользователя c другим участником.\nDChatInfo GetPersonalChat ( int personId);\nгде:\npersonId - идентификатор пользователя.\nIMessagesApi.GetNotifiablePersonalChat\nПолучить информацию о персональном чате залогиненого пользователя c другим участником.\nDChatInfo GetNotifiablePersonalChat ( int personId);\nгде:\npersonId - идентификатор пользователя.\nIMessagesApi.GetChatCreationMessage\nПолучить сообщение о создании чата.\nDMessage GetChatCreationMessage (Guid chatId);\nгде:\nchatId - идентификатор чата.\nIMessagesApi.GetChatMembers\nПолучить список участников чата, измененный после fromDateUtc.\nList<DChatMember> GetChatMembers (Guid chatId, DateTime fromDateUtc);\nгде:\nchatId - идентификатор чата.\nfromDateUtc - да, после которой должны быть добавлены или отредактированы возвращаемые участники.\nIMessagesApi.GetMessages\nВозвращает список сообщений в количестве не большем maxNumber\nИ общее число сообщений, удовлетворяющих условиям.\nTuple<List<DMessage>, int > GetMessages (Guid chatId, DateTime dateFromUtc, DateTime dateToUtc, int maxNumber, bool descendingOrder);\nгде:\nchatId - идентификатор чата.\ndateFromUtc - дата, после которой должны быть соданы возвращаемые сообщения.\ndateToUtc - дата, до которой должны быть соданы возвращаемые сообщения.\nmaxNumber - максимальное число возвращаемых сообщений.\ndescendingOrder - порядок сортировки сообщений. True -- в порядке убывания серверной даты. False -- в порядке возрастания.\nIMessagesApi.GetLastUnreadMessage\nВозвращает самое ранее непрочитанное сообщения в чате.\nDMessage GetLastUnreadMessage (Guid chatId);\nгде:\nchatId - идентификатор чата.\nIMessagesApi.TypingMessage\nПользователь печатает сообщение в чат.\nvoid TypingMessage (Guid chatId);\nгде:\nchatId - идентификатор чата.\nIMessagesApi.GetMessagesWithAttachments\nВозвращает сообщения, содержащие вложения.\nList<DMessage> GetMessagesWithAttachments (Guid chatId, DateTime fromServerDateUtc, DateTime toServerDateUtc, int pageSize);\nгде:\nchatId - идентификатор чата\nfromServerDateUtc - дата, после которой должны быть соданы возвращаемые сообщения.\ntoServerDateUtc - дата, до которой должны быть соданы возвращаемые сообщения.\npageSize - максимальное количество возвращаемых сообщений.\nIMessagesApi.GetRelatedChats\nВозвращает чаты связанные с объектом.\nList<NotifiableDChatInfo> GetRelatedChats ( int personId, Guid objectId, ChatRelationType type);\nгде:\npersonId - идентификатор пользователя.\nobjectId - идентификатор объекта.\ntype - тип связи.\nIMessagesApi.GetThirdPartyMessage\nВозвращает сообщение, созданное в third party приложении.\nDMessage GetThirdPartyMessage (string thirdPartyInfo);\nгде:\nthirdPartyInfo - дополнительная информация, которую можно заполнить при создании сообщения.\nIMessagesApi.GetMessage\nВозвращает сообщение по его идентификатору.\nDMessage GetMessage (Guid messageId);\nгде:\nmessageId - идентификатор сообщения.","keywords":[]},"pages/server/serverapi/IServerCallback.html":{"title":"Интерфейс IServerCallback","content":"Интерфейс обратного вызова ServerApi.\nIServerCallback.NotifyChangeset\nМетод обратного вызова изменения объектов.\nvoid IServerCallback. NotifyChangeset (DChangeset changeset);\nгде:\nchangeset - изменения над объектами.\nIServerCallback.NotifyOrganisationUnitChangeset\nМетод обратного вызова изменения организационных единиц.\nvoid IServerCallback. NotifyOrganisationUnitChangeset (OrganisationUnitChangeset changeset);\nгде:\nchangeset - изменения над орг. единицами.\nIServerCallback.NotifyPersonChangeset\nМетод обратного вызова изменения пользователей\nvoid IServerCallback. NotifyPersonChangeset (PersonChangeset changeset);\nгде:\nchangeset - изменения над пользователями.\nIServerCallback.NotifyDMetadataChangeset\nМетод обратного вызова изменения метаданных\nvoid IServerCallback. NotifyDMetadataChangeset (DMetadataChangeset changeset);\nгде:\nchangeset - изменения метаданных.\nIServerCallback.NotifySearchResult\nМетод обратного вызова поискового запроса\nvoid IServerCallback. NotifySearchResult (DSearchResult searchResult);\nгде:\nsearchResult - результаты поиска.\nIServerCallback.NotifyGeometrySearchResult\nМетод обратного вызова поискового запроса по геометрии.\nvoid IServerCallback. NotifyGeometrySearchResult (DGeometrySearchResult searchResult);\nгде:\nsearchResult - результаты поиска.\nIServerCallback.NotifyDNotificationChangeset\nМетод обратного вызова нотификации об изменениях.\nvoid IServerCallback. NotifyDNotificationChangeset (DNotificationChangeset changeset);\nгде:\nchangeset - Changeset со списоком сообщений.\nIServerCallback.NotifyCommandResult\nМетод обратного вызова результатов выполнения пользовательской команды.\nvoid IServerCallback. NotifyCommandResult (Guid requestId, byte[] data, ServerCommandResult result);\nгде:\nrequestId - id запроса.\ndata - результат выполнения команды.\nresult - тип результата выполнения команды.","keywords":[]},"pages/server/serverapi/IEventsApi.html":{"title":"Интерфейс IEventsApi","content":"Интерфейс подписки на события и изменения.\nIEventsApi.SubscribeChanges\nМетод подписки на изменения по переданному набору правил.\nvoid IEventsApi. SubscribeChanges (IEnumerable<DRule> rules);\nгде:\nrules - список правил.\nIEventsApi.GetMissedChanges\nМетод получения пропущенных событий, сгруппированных по правилам, которым они удовлетворяют.\nList<Tuple<Guid, DChangesetData[]>> IEventsApi. GetMissedChanges ();\nIEventsApi.AcceptChange\nМетод подтверждения получения изменения от клиента.\nvoid AcceptChange (Guid changeId, Guid ruleId);\nгде:\nchangeId - идентификатор изменения.\nchangeId - идентификатор правила, по которому изменение получено.","keywords":[]},"pages/server/serverapi/IServerCommandApi.html":{"title":"Интерфейс IServerCommandApi","content":"Интерфейс пользовательских команд.\nIServerCommandApi.RegisterCommandHandler\nРегистрация клиента как обработчика команд с указанным именем.\nvoid RegisterCommandHandler (string commandName);\nгде:\ncommandName - имя команды.\nIServerCommandApi.PublishCommandResult\nПубликация результата выполнения команды обработчиком.\nvoid PublishCommandResult (Guid requestId, byte[] data, ServerCommandResult result);\nгде:\nrequestId - идентификатор запроса.\ndata - результат выполнения команды.\nresult - тип результата выполнения команды.","keywords":[]},"pages/server/serverapi/IServerApi.html":{"title":"Работа с объектами и метаданными (IServerApi )","content":"Для получения IServerApi необходимо вызвать метод HttpPilotClient.GetServerApi(IServerCallback callback).\nIServerApi.OpenDatabase\nОткрывает базу данных, регистрирует методы обратного вызова и возвращает описание базы данных DDatabaseInfo.\nDDatabaseInfo OpenDatabase ();\nIServerApi.GetDatabase\nМетод возвращает описание базы данных.\nDDatabaseInfo GetDatabase (string database)\nгде:\ndatabase - имя базы данных.\nIServerApi.GetMetadata\nПолучить текущие метаданные.\nDMetadata GetMetadata ( long localVersion)\nгде:\nlocalVersion - текущая версия метаданных на клиенте.\nIServerApi.GetSettings\nПолучение значений настроек. Если параметр loadAll равен true, будут получены настройки всех пользователей. Требуются права администратора.\nDSettings GetSettings ( long loadAll)\nгде:\nloadAll - признак необходимости получения настроек всех пользователей.\nIServerApi.ChangeSettings\nИзменение значений настроек. Для изменения значений обобщенных настроек требуются права администратора.\nvoid ChangeSettings (DSettingsChange change);\nгде:\nchange - изменение.\nIServerApi.GetObjects\nПолучить объекты.\nList<DObject> GetObjects (Guid[] ids);\nгде:\nids - список идентификаторов объектов.\nIServerApi.GetChangesets\nПолучить изменения.\nList<DChangeset> GetChangesets ( long first, long last);\nгде:\nfirst - начало возвращаемого промежутка идентификаторов изменений.\nsecond - окончание возвращаемого промежутка идентификаторов изменений.\nIServerApi.Change\nПрименить изменения объектов.\nВовзращает изменения, слитые с изменениями от других клиентов.\nDChangeset Change (DChangesetData changes);\nгде:\nchanges - изменения.\nIServerApi.LoadPeople\nЗагрузить всех пользователей базы данных.\nList<DPerson> LoadPeople ();\nIServerApi.LoadPeopleByIds\nПолучить список пользователей по идентификаторам.\nList<DPerson> LoadPeopleByIds ( int [] ids);\nгде:\nids - идентификаторы пользователей.\nIServerApi.LoadOrganisationUnits\nПолучить список организационных единиц.\nList<DOrganisationUnit> LoadOrganisationUnits ();\nIServerApi.LoadOrganisationUnitsByIds\nПолучить список организационных единиц по идентификаторам.\nList<DOrganisationUnit> LoadOrganisationUnitsByIds ( int [] ids);\nгде:\nids - идентификаторы организационных единиц.\nIServerApi.AddSearch\nДобавить условие поиска.\nvoid AddSearch (DSearchDefinition searchDefinition);\nгде:\nsearchDefinition - условия поиска.\nIServerApi.RemoveSearch\nУдалить условие поиска.\nvoid RemoveSearch (Guid searchDefinitionId);\nгде:\nsearchDefinitionId - идентификатор условий поиска.\nIServerApi.GeometrySearch\nЗапустить поиск по геометрии.\nvoid GeometrySearch (DGeometrySearchDefinition searchDefinition);\nгде:\nsearchDefinition - условия поиска.\nIServerApi.ContentSearch\nЗапустить поиск по файлам.\nvoid ContentSearch (DSearchDefinition searchDefinition);\nгде:\nsearchDefinition - условия поиска.\nIServerApi.UpdatePerson\nОбновить информацию о пользователе.\nvoid UpdatePerson (DPersonUpdateInfo updateInfo);\nгде:\nupdateInfo - изменения\nIServerApi.UpdateOrganisationUnit\nОбновить информацию о должности.\nvoid UpdateOrganisationUnit (DOrganisationUnitUpdateInfo updateInfo);\nгде:\nupdateInfo - изменения.","keywords":[]},"pages/server/serverapi/IMessageCallback.html":{"title":"Интерфейс IMessageCallback","content":"Интерфейс обратного вызова API сообщений.\nIMessageCallback.NotifyMessageCreated\nМетод обратного вызова добавляения сообщения.\nvoid NotifyMessageCreated (NotifiableDMessage message);\nгде:\nmessage - сообщение.\nIMessageCallback.NotifyTypingMessage\nФункция обратного вызова \"пользователь Х печатает сообщение.\nvoid NotifyTypingMessage (Guid chatId, int personId);\nгде:\nchatId - идентификатор чата.\npersonId - идентификатор пользователя, печатающего сообщение.\nIMessageCallback.CreateNotification\nФункция обратного вызова создания уведомления.\nvoid CreateNotification (DNotification notification);\nгде:\nnotification - уведомление.\nIMessageCallback.NotifyOnline\nУведомление о выходе пользователя онлайн.\nvoid NotifyOnline ( int personId);\nгде:\npersonId - идентификатор пользователя.\nIMessageCallback.NotifyOffline\nУведомление об отключении пользователя.\nvoid NotifyOffline ( int personId);\nгде:\npersonId - идентификатор пользователя.\nIMessageCallback.UpdateLastMessageDate\nУведомление о дате последнего полученного сообщения.\nvoid UpdateLastMessageDate (DateTime maxDate);\nгде:\nmaxDate - дата создания сообщения.","keywords":[]},"pages/server/serverapi/IQueryBuilder.html":{"title":"Интерфейс IQueryBuilder","content":"Интерфейс формирования поисковых запросов.\nПостроение запросов осуществляется с помощью конструкторов запросов IQueryBuilder. Основными элементами языка запросов являются так называемые “условия поиска“. Чтобы осуществить поиск необходимо:\nполучить конструктор поисковых запросов с помощью одного из статических методов класса QueryBuilderFactory: CreateEmptyQueryBuilder, CreateFilesQueryBuilder или CreateObjectQueryBuilder.\nпостроить запрос с помощью полученного конструктора с использованием “условий поиска”.\nвыполнить поиск вызвав метод IServerApi.AddSearch() передав в качестве параметра экземпляр класса DSearchDefinition.\nПодробное описание формирования “условий поиска” см. в разделе Поиск документации Client Pilot SDK.\nQueryBuilderFactory.CreateEmptyQueryBuilder()\nМетод получения простого конструктора запросов. Это универсальный конструктор запросов без предварительных условий. Этот конструктор можно использовать для поиска любых объектов в базе, включая объекты системных типов.\nQueryBuilderFactory.CreateFilesQueryBuilder()\nМетод получения предварительно сконфигурированного конструктора запросов для пользовательских объектов. В результат поисковой выдачи не попадают oбъекты системных и сервисных типов.\nQueryBuilderFactory.CreateObjectQueryBuilder()\nМетод получения предварительно сконфигурированного конструктора запросов для объектов в состоянии ObjectState.Alive или ObjectState.Frozen.","keywords":[]},"pages/server/serverapi/fields/OrganisationInfo.html":{"title":"Список полей OrganizationInfo","content":"Name\nНаименование организации.\nstring Name { get; }\nInn\nИНН.\nstring Inn { get; }\nAddress\nАдрес.\nstring Address { get; }\nContactInfo\nКонтактная информация.\nstring ContactInfo { get; }","keywords":[]},"pages/server/serverapi/fields/LicenseData.html":{"title":"Список полей LicenseData","content":"Id\nИдентификатор лицензии.\nGuid Id { get; }\nOrganizationInfo\nИнформация об организации, на которую выдана лицензия.\nOrganizationInfo OrganizationInfo { get; }\nNonCommercialUsage\nСодержит признак того, что лицензия выдана для некоммерческого использования.\nbool? NonCommercialUsage { get; }\nLicense\nЛицензия.\nLicense License { get; }\nRequest\nЗапрос лицензии.\nRequest Request { get; }\nProduct\nНаименование продукта.\nstring Product { get; }","keywords":[]},"pages/server/serverapi/fields/License.html":{"title":"Список полей License","content":"Products\nСписок приложений.\nProduct[] Products { get; }\nValidTo\nДля комерческой и некомерческой дата окончания получения обновлений.\nДля опытной эксплуатации дата окончания действия продукта.\nDateTime ValidTo{ get; }\nIsTrial\nПризнак лицензии для опытной эксплуатации.\nbool IsTrial{ get; }","keywords":[]},"pages/server/serverapi/fields/Request.html":{"title":"Список полей Request","content":"Products\nСписок запрашиваемых приложений.\nProduct[] Products { get; }\nRequestedMonths\nЧисло месяцев, на которое запрашивается лицензия.\nint RequestedMonths { get; }\nIsTrial\nПризнак лицензии для опытной эксплуатации.\nbool IsTrial { get; }","keywords":[]},"pages/server/serverapi/fields/Product.html":{"title":"Список полей Product","content":"LicenseCode\nКод лицензии.\nint LicenseCode { get; }\nProductName\nНаименование приложения.\nstring ProductName { get; }\nWorkplaces\nКоличество экземпляров приложения разрешенных лицензией.\nint Workplaces { get; }","keywords":[]},"pages/server/serverapi/fields/DDatabaseInfo.html":{"title":"Список полей DDatabaseInfo","content":"MetadataVersion\nНомер версии метаданных.\nlong MetadataVersion { get; }\nLastChangeset\nПоследний changeset.\nDChangeset LastChangeset { get; }\nPerson\nТекущий залогиненый пользователь.\nDPerson Person { get; }\nDatabaseId\nИдентификатор базы данных.\nGuid DatabaseId { get; }\nDatabaseVersion\nВерсия базы данных.\nlong DatabaseVersion { get; }\nPeople\nВерсии пользователей.\nDictionary< int, ushort> People { get; }\nOrganisationUnits\nВерсии элементов организационной структуры.\nDictionary< int, ushort> OrganisationUnits { get; }","keywords":[]},"pages/server/serverapi/fields/DChangeset.html":{"title":"Список полей DChangeset","content":"Id\nИнкрементальный идентификатор изменения.\nНеправильно:\nlong Id { get; }\nПравильно?:\nlong Id { get; set;}\nChanged\nСписок идентификаторов измененных объектов.\nHashSet<Guid> Changed{ get; }\nIdentity\nИдентификатор изменения.\nGuid Identity { get; set;}","keywords":[]},"pages/server/serverapi/fields/DPerson.html":{"title":"Список полей DPerson","content":"Id\nПоле Id содержит уникальный идентификатор пользователя.\nint Id { get; }\nLogin\nИмя пользователя (login).\nstring Login { get; }\nDisplayName\nОтображаемое имя пользователя. Например ФИО.\nstring DisplayName { get; }\nComment\nКомментарий к статусу пользователя.\nstring Comment { get; }\nSid\nуникальный идентификатор доменной учетной записи пользователя.\nstring Sid { get; }\nIsDeleted\nПоказывает удален пользователь или нет. В системе Pilot информация пользователях не удаляется из базы данных. Пользователи помечаются как удаленные.\nbool IsDeleted { get; }\nIsAdmin\nПоказывает является ли текущий пользователь администратором.\nbool IsAdmin { get; }\nUidDn\nИдентификатор пользователя из LDAP.\nstring UidDn { get; }\nEmail\nEmail пользователя.\nstring Email { get; }\nVersion\nПорядковый номер изменения пользователя.\nushort Version { get; }\nIsInactive\nСтатус активности пользователя.\nbool IsInactive { get; }\nPositions\nСписок идентификаторов должностей, которые в данный момент занимает пользователь.\nList< int > Positions { get; }\nBossOf\nСписок идентификаторов организационных элементов, на которых пользователь в данный момент является руководителем.\nList< int > BossOf { get; }\nAllOrgUnits\nСписок идентификаторов организационных элементов, на которые назначен пользователь.\nHashSet< int > AllOrgUnits { get; }","keywords":[]},"pages/server/serverapi/fields/DMetadata.html":{"title":"Список полей DMetadata","content":"Version\nНомер версии метаданных.\nlong Version { get; set; }\nTypes\nСписок типов.\nList<MType> Types { get; }\nUserStates\nСписок состояйние пользователей.\nList<MUserState> UserStates { get; }","keywords":[]},"pages/server/serverapi/fields/DSettings.html":{"title":"Список полей DSettings","content":"PersonalSettings\nПерсональные настройки.\nDictionary< int, DSettingsCollection> PersonalSettings { get; private set; }\nCommonSettings\nОбщие настройки.\nDictionary< int, DSettingsCollection> CommonSettings { get; private set; }","keywords":[]},"pages/server/serverapi/fields/DObject.html":{"title":"Список полей DObject","content":"Id\nИдентификатор объекта.\nGuid Id { get; set; }\nTypeId\nТип объекта.\nint TypeId { get; set; }\nParentId\nИдентификатор родительского объекта.\nGuid ParentId { get; set; }\nLastChange\nИдентификатор последнего изменения объекта.\nlong LastChange { get; set; }\nLastChange\nИдентификатор последнего изменения объекта.\nlong LastChange { get; set; }","keywords":[]},"pages/server/serverapi/fields/DRule.html":{"title":"Список полей DRule","content":"Id\nИдентификатор правила.\nGuid Id { get; set; }\nChangeType\nТип изменения.\nChangeType ChangeType { get; set; }\nFileExtension\nРасширение файла.\nstring FileExtension { get; set; }\nСписок типов изменений\nCreate = 1 Update = 2 Delete = 3\nРезультат выполениния пользовательской команды\nSuccess, Error","keywords":[]},"pages/server/serverapi/fields/DChatInfo.html":{"title":"Список полей DChatInfo","content":"Chat\nЧат.\npublic DChat Chat { get; set; }\nLastMessage\nПсоледнее сообщение в чате.\npublic DMessage LastMessage { get; set; }\nUnreadMessagesNumber\nЧисло не проитанных пользователем сообщений.\npublic int UnreadMessagesNumber { get; set; }\nRelations\nСвязи.\npublic List<DChatRelation> Relations { get; set; }","keywords":[]},"pages/server/serverapi/fields/DMessage.html":{"title":"Список полей DMessage","content":"Id\nИдентификатор сообщения.\nGuid Id { get; set; }\nData\nСериализованные протобаф данные сообщения.\npublic byte[] Data { get; set; }\nCreatorId\nСоздатель сообщения.\npublic int CreatorId { get; set; }\nServerDate\nСерверная дата создания сообщения в UTC.\npublic DateTime? ServerDate { get; set; }\nLocalDate\nКлиентская дата создания сообщения в UTC.\npublic DateTime LocalDate { get; set; }\nChatId\nИдентификатор чата.\npublic Guid ChatId { get; set; }\nRelatedMessageId\nИдентифкатор сообщения, к которому привязано данное.\npublic Guid? RelatedMessageId { get; set; }\nType\nТип сообщения.\npublic MessageType Type { get; set; }\nRelatedMessages\nСписок сообщения, связанных с данным.\npublic List<DMessage> RelatedMessages { get; set; }","keywords":[]},"pages/server/serverapi/fields/NotifiableDChatInfo.html":{"title":"Список полей NotifiableDChatInfo","content":"IsNotifiable\nПризнак подписки пользователя на уведомления по чату.\npublic bool IsNotifiable { get; set; }\nDChatInfo\nЧат.\npublic DChatInfo DChatInfo { get; set; }","keywords":[]},"pages/server/serverapi/fields/DSettingsChange.html":{"title":"Список полей DSettingsChange","content":"Identity\nИдентификатор настройки.\nGuid Identity { get; set; }\nOrgUnitId\nИдентификатор организационной единицы, на которую распространяется настройка. Если значение -1, значит распространяется на конкретного пользователя.\nint OrgUnitId { get; set; }\nPersonId\nИдентификатор пользователя, на которого распространяется настройка. Если значение -1, значит распространяется на организационную единицу.\nint PersonId { get; set; }\nKey\nНаименование настройки.\nstring Key { get; set; }\nValue\nзначение настройки.\nstring Value { get; set; }","keywords":[]},"pages/server/serverapi/fields/DChatMember.html":{"title":"Список полей DChatMember","content":"ChatId\nИдентификатор чата.\npublic Guid ChatId { get; set; }\nPersonId\nИдентификатор участника.\npublic int PersonId { get; set; }\nIsAdmin\nПризнак администратора.\npublic bool IsAdmin { get; set; }\nIsDeleted\nУдаленный участник.\npublic bool IsDeleted { get; set; }\nIsNotifiable\nУчастник подписан на уведомления.\npublic bool IsNotifiable { get; set; }\nDateUpdatedUtc\nДата изменения участника в UTC.\npublic DateTime DateUpdatedUtc { get; set; }\nIsViewerOnly\nПризнак того, что участник просматривает чат по объекту, но не участвует в нем.\npublic bool IsViewerOnly { get; set; }","keywords":[]},"pages/server/serverapi/fields/DChatRelation.html":{"title":"Список полей DChatRelation","content":"ObjectId\nИдентификатор объекта, с которым установлена связь.\npublic Guid ObjectId { get; set; }\nType\nТип связи.\npublic ChatRelationType Type { get; set; }\nMessageId\nСообщение, создавшее связь.\npublic Guid? MessageId { get; set; }\nIsDeleted\nПризнак удаленной связи.\npublic bool IsDeleted { get; set; }","keywords":[]},"pages/server/serverapi/fields/DSearchDefinition.html":{"title":"Список полей DSearchDefinition","content":"Id\nИдентификатор поискового запроса.\npublic Guid Id { get; set; }\nRequest\nЗапрос поиска.\npublic DSearchRequest Request { get; }","keywords":[]},"pages/server/serverapi/fields/DSearchRequest.html":{"title":"Список полей DSearchRequest","content":"SearchString\n“Условие поиска” в виде строки.\npublic string SearchString { get; set; }\nSearchKind\nТип поиска\npublic SearchKind SearchKind { get; set; }\nИспользуйте SearchKind.Custom для формирования запросов поиска.\nMaxResults\nОграничение количества результатов поиска.\npublic int MaxResults { get; set; }\nSortDefinitions\nПозволяет установить поля и направления сортировки результатов поиска.\npublic List<DSortDefinition> SortDefinitions { get; }","keywords":[]},"pages/3d-storage/nautilus-install.html":{"title":"3DStorage.NautilusExtension","content":"Пример демонстрирует взаимодействие файлового менеджера Nautilus с виртуальным диском 3D–Storage:\nОтображает иконку состояния на смонтированных файлах;\nДобавляет команды контекстного меню для взаимодействия с 3D-Storage.\nУстановка собранного расширения\nСкопировать файл libnautilus-3DStorage.so из папки:\n./bin/Astra Linux 1.7 для системы Astra Linux 1.7\n./bin/Ubuntu 22.04 для системы Ubuntu 22.04.5\nв папку расширений файлового менеджера Nautilus.\nПуть по умолчанию: /usr/lib/x86_64-linux-gnu/nautilus/extensions-3.0\nЗадать права для скопированного файла libnautilus-3DStorage.so\n# chmod 755 /usr/lib/x86_64-linux-gnu/nautilus/extensions-3.0/libnautilus-3DStorage.so\nВыполнить update и установить samba\n# apt-get update; apt install samba\nДля отоброжения состояния файлов, необходимо установить иконки состояний. (См. пункт \"Установка иконок\")\nПерезапустить проводник Nautilus завершив запущенные процессы проводника\n$ killall nautilus\nСборка и установка\nНеобходимо установить следующий набор ПО\nglib2.0\nlibnautilus-extension\nfuse3\nsamba\nCmake (https://cmake.org/download/)\n# apt install libnautilus-extension-dev libglib2.0-dev fuse3 samba cmake\nProtobuf-c (https://github.com/protobuf-c/protobuf-c )\nСобрать и установить расширение выполнив bash-скрипт из папки scripts:\n#sh build.sh\nДля отоброжения состояния файлов, необходимо установить иконки состояний. (См. пункт \"Установка иконок\")\nПерезапустить проводник Nautilus завершив запущенные процессы проводника\n$ killall nautilus\nУстановка иконок\nДля установки иконок состояний файлов, необходимо выполнить bash-скрипт:\n# sh icons_install.sh\nВыполнить перезагрузку операционной системы","keywords":[]}}