﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Ascon.Pilot.DataModifier;
using ServerApiFactory.Contracts;

namespace ServerApiFactory.ServerExtension
{
    internal class ServerSession : ICustomServerContract, IDisposable
    {
        private readonly IModifierBackend _backend;
        private readonly MessagesStorage _storage;
        private readonly ICustomServerCallback _callback;
        private readonly Action<ServerSession> _onCloseSession;

        public ServerSession(IModifierBackend backend, MessagesStorage storage, ICustomServerCallback callback, Action<ServerSession> onCloseSession)
        {
            _backend = backend;
            _storage = storage;
            _callback = callback;
            _onCloseSession = onCloseSession;
        }

        public Task AddMessageAsync(string text)
        {
            var person = _backend.CurrentPerson();
            var message = new Message
            {
                Author = person.DisplayName,
                Text = text
            };
            _storage.AddMessage(message);
            _callback.OnMessageAdded(message);
            return Task.CompletedTask;
        }

        public Task<List<Message>> GetMessagesAsync()
        {
            return Task.FromResult(_storage.GetMessages().ToList());
        }

        public void Dispose()
        {
            _onCloseSession(this);
        }
    }
}