/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Ascon.Pilot.Common.DataProtection;
using Ascon.Pilot.DataClasses;
using Ascon.Pilot.DataModifier;
using Ascon.Pilot.Server.Api;

namespace ModifierSample
{
    class Program
    {
        static void Main(string[] args)
        {
            var remoteProvider = new RemoteApiProvider();
            var credentials = ConnectionCredentials.GetConnectionCredentials("http://localhost:5545/pilot-ice_ru", "sedov", "123456".ConvertToSecureString());
            remoteProvider.ConnectToPilotServer(credentials);

            var backend = remoteProvider.GetBackend();
            var root = backend.GetObject(DObject.RootId);
            var folderType = backend.GetType("projectfolder");
            var modifier = remoteProvider.GetNewModifier();
            var folderBuilder = modifier.CreateObject(Guid.NewGuid(), root.Id, folderType.Id)
                .SetAttribute("name", Guid.NewGuid().ToString());

            var newFolderObject = folderBuilder.GetNewObject();
            var projectType = backend.GetType("project");
            var projectBuilder = modifier.CreateObject(Guid.NewGuid(), newFolderObject.Id, projectType.Id)
                .SetAttribute("project_name", "New Project Name");

            var projectObject = projectBuilder.GetNewObject();
            var sectionType = backend.GetType("main_set");
            var sectionBuilder = modifier.CreateObject(Guid.NewGuid(), projectObject.Id, sectionType.Id)
                .SetAttribute("name", "Section name");

            var storageProvider = remoteProvider.GetStorage();

            var documentInfo = new DocumentInfo(DirectoryHelper.GetLocalFile());
            var sectionObject = sectionBuilder.GetNewObject();
            var documentType = backend.GetType("document");
            modifier.CreateObject(Guid.NewGuid(), sectionObject.Id, documentType.Id)
                .SetAttribute("name", "Document")
                .AddFile(documentInfo, storageProvider);

            if (modifier.AnyChanges())
                modifier.Apply();
        }
    }
}
