/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
namespace Pilot.Xps.Domain
{
    class Constants
    {
        public const string PROJECT_TITLE_ATTRIBUTES_DELIMITER = " - ";
        public const int MAX_PROJECT_ITEM_FOLDER_NAME_LENGTH = 40;
        public const string TRUNCATED_NAME_MARK = "~";
        public const string ANNOTATIONS_DEFINITION = "Annotation";
        public const string GRAPHIC_LAYER_ELEMENT_DEFINITION = "PILOT_GRAPHIC_LAYER_ELEMENT_";
        public const string GRAPHIC_LAYER_ELEMENT_CONTENT = "PILOT_CONTENT_GRAPHIC_LAYER_ELEMENT_";
        public const string ANNOTATION_CHAT_MESSAGE = "Note_Chat_Message";
        public const string DIGITAL_SIGNATURE = "PilotDigitalSignature";
        public const string THUMBNAIL_FILE_NAME_POSTFIX = "PilotThumbnail";
        public const string TEXT_LABELS_DEFINITION = "PilotTextLabels";
        public const string BARCODE_DEFINITION = "PilotBarcode";
        public static readonly char[] Separators = { ' ', '.', ',', '"', '\'', '!', '?', ':', ';' };
        public const int MAX_ITEMS_LOAD_PER_PAGE = 250;
        public const int MAX_TASKS_LOAD_PER_PAGE = 1000;
        public const int NEXT_TASKS_LOAD_PER_PAGE = 300;
        public const string TASK_FILE_ATTACHMENTS_PATH_SERIALIZATION_ID = "TaskFileAttachmentsDialogPath";
        public const string TASK_DIRECTORY_ATTACHMENTS_PATH_SERIALIZATION_ID = "TaskDirectoryAttachmentsDialogPath";
        public const string LINKED_OBJECTS_ATTACHMENTS_PATH_SERIALIZATION_ID = "LinkedObjectsAttachmentsDialogPath";
        public const string LINKED_TO_CHAT_OBJECTS_PATH_SERIALIZATION_ID = "LinkedToChatDialogPath";
        public const string SOURCE_FILE_PATH_SERIALIZATION_ID = "SourceFileDialogPath";
        public const int CHATS_PAGE_COUNT = 30;
        public const int MESSAGES_PAGE_COUNT = 30;
        public const int CHAT_MEMBERS_PAGE_COUNT = 30;
        public const int MAX_TEXT_MESSAGE_LENGTH = 2500;
        public const int SERVER_ADMINISTRATOR_PERSON_ID = -1;
        public const int SERVER_ACTION_PERSON_ID = -2;
    }
}
