/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.IO;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using Pilot.Xps.Domain.IO;

namespace Pilot.Xps.Domain.GraphicLayer
{
    class RasterGraphicLayerElementContent : IGraphicLayerElementContent
    {
        private readonly Stream _stream;

        public RasterGraphicLayerElementContent(ImageSource bitmap, Stream stream)
        {
            _stream = IoUtils.CreateMemoryStream(stream);
            var image = new Image
            {
                Source = bitmap,
                Width = bitmap.Width,
                Height = bitmap.Height
            };
            Element = image;
        }

        public FrameworkElement Element { get; private set; }

        public void SetBitmap(ImageSource bitmap)
        {
            var image = new Image { Source = bitmap };
            Element = image;
        }

        public Stream GetStream()
        {
            return _stream;
            //var image = Element as Image;
            //var stream = (image.Source as BitmapImage).StreamSource;
            //stream.Position = 0;
            //return stream;
        }
    }
}
