/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.IO;
using System.Windows;
using System.Windows.Markup;

namespace Pilot.Xps.Domain.GraphicLayer
{
    class XamlGraphicLayerElementContent : IGraphicLayerElementContent
    {
        public XamlGraphicLayerElementContent(FrameworkElement uiElement)
        {
            Element = uiElement;
        }

        public FrameworkElement Element { get; private set; }

        public Stream GetStream()
        {
            var stringRepresentation = XamlWriter.Save(Element);
            var frameworkElementStream = new MemoryStream();
            var writer = new StreamWriter(frameworkElementStream);
            writer.Write(stringRepresentation);
            writer.Flush();
            frameworkElementStream.Position = 0;
            return frameworkElementStream;
        }
    }
}
