/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO.Packaging;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Xps.Packaging;

namespace Pilot.Xps.Domain.Signatures
{
    class SignatureAndCertificateChecker
    {
        public bool CheckCertificate(X509Certificate certificate)
        {
            var x5092Cert = new X509Certificate2(certificate);
            var chain = new X509Chain
            {
                ChainPolicy =
                {
                    RevocationMode = X509RevocationMode.NoCheck,
                    VerificationFlags = X509VerificationFlags.AllowUnknownCertificateAuthority | X509VerificationFlags.IgnoreNotTimeValid
                }
            };
            var isSoftCertificateValidation = chain.Build(x5092Cert);
            var isCertificateValid = false;
            if (isSoftCertificateValidation)
            {
                chain.Reset();
                chain.ChainPolicy.RevocationMode = X509RevocationMode.Online;
                chain.ChainPolicy.VerificationFlags = X509VerificationFlags.NoFlag;
                isCertificateValid = chain.Build(x5092Cert);
            }
            return isSoftCertificateValidation && isCertificateValid;
        }

        public bool CheckSignature(XpsDigitalSignature signature)
        {
            if (signature.SignerCertificate != null)
            {
                var certificate2 = new X509Certificate2(signature.SignerCertificate);
                return signature.Verify(certificate2) == VerifyResult.Success;
            }
            return signature.Verify() == VerifyResult.Success;
        }
    }
}
