/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Media;

namespace Pilot.Xps.Domain.Tools
{
    static class CheckCoordinatesForAdorners
    {
        public static double CheckX(double leftTopX, double leftTopY, Size desiredSize, Size pageSize, double rotationAngle)
        {
            var leftTop = new Point(leftTopX, leftTopY);
            var leftBottom = new Point(leftTopX, leftTopY + desiredSize.Height);
            var rightTop = new Point(leftTopX + desiredSize.Width, leftTopY);
            var rightBottom = new Point(leftTopX + desiredSize.Width, leftTopY + desiredSize.Height);
            var matrix = Matrix.Identity;
            matrix.RotateAtPrepend(rotationAngle, leftTopX, leftTopY);
            var newLeftBottom = matrix.Transform(leftBottom);
            var newRightTop = matrix.Transform(rightTop);
            var newRightBottom = matrix.Transform(rightBottom);
            //GET THE FAREST X
            var farestXPoint = new Point();
            if ((leftTop.X < 0 || leftTop.X > pageSize.Width) && Math.Abs(farestXPoint.X) < Math.Abs(leftTop.X))
                farestXPoint = leftTop;
            if ((newLeftBottom.X < 0 || newLeftBottom.X > pageSize.Width) && Math.Abs(farestXPoint.X) < Math.Abs(newLeftBottom.X))
                farestXPoint = newLeftBottom;
            if ((newRightTop.X < 0 || newRightTop.X > pageSize.Width) && Math.Abs(farestXPoint.X) < Math.Abs(newRightTop.X))
                farestXPoint = newRightTop;
            if ((newRightBottom.X < 0 || newRightBottom.X > pageSize.Width) && Math.Abs(farestXPoint.X) < Math.Abs(newRightBottom.X))
                farestXPoint = newRightBottom;

            if (farestXPoint.X > pageSize.Width)
                leftTopX = pageSize.Width - Math.Abs(farestXPoint.X - leftTop.X);
            if (farestXPoint.X < 0)
                leftTopX = leftTop.X - farestXPoint.X;
            return leftTopX;
        }

        public static double CheckY(double leftTopX, double leftTopY, Size desiredSize, Size pageSize, double rotationAngle)
        {
            var leftTop = new Point(leftTopX, leftTopY);
            var leftBottom = new Point(leftTopX, leftTopY + desiredSize.Height);
            var rightTop = new Point(leftTopX + desiredSize.Width, leftTopY);
            var rightBottom = new Point(leftTopX + desiredSize.Width, leftTopY + desiredSize.Height);
            var matrix = Matrix.Identity;
            matrix.RotateAtPrepend(rotationAngle, leftTopX, leftTopY);
            var newLeftBottom = matrix.Transform(leftBottom);
            var newRightTop = matrix.Transform(rightTop);
            var newRightBottom = matrix.Transform(rightBottom);
            //GET THE FAREST Y
            var farestYPoint = new Point();
            if ((leftTop.Y < 0 || leftTop.Y > pageSize.Height) && Math.Abs(farestYPoint.Y) < Math.Abs(leftTop.Y))
                farestYPoint = leftTop;
            if ((newLeftBottom.Y < 0 || newLeftBottom.Y > pageSize.Height) && Math.Abs(farestYPoint.Y) < Math.Abs(newLeftBottom.Y))
                farestYPoint = newLeftBottom;
            if ((newRightTop.Y < 0 || newRightTop.Y > pageSize.Height) && Math.Abs(farestYPoint.Y) < Math.Abs(newRightTop.Y))
                farestYPoint = newRightTop;
            if ((newRightBottom.Y < 0 || newRightBottom.Y > pageSize.Height) && Math.Abs(farestYPoint.Y) < Math.Abs(newRightBottom.Y))
                farestYPoint = newRightBottom;

            if (farestYPoint.Y > pageSize.Height)
                leftTopY = pageSize.Height - Math.Abs(farestYPoint.Y - leftTop.Y);
            if (farestYPoint.Y < 0)
                leftTopY = leftTop.Y - farestYPoint.Y;
            return leftTopY;
        }
    }
}
